/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.producer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.os.HandlerThread;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Rotation;
import com.tencent.liteav.base.util.TimeUtil;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.base.TakeSnapshotListener;
import com.tencent.liteav.videobase.common.SnapshotSourceType;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.e;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videoconsumer.renderer.VideoRenderListener;
import com.tencent.liteav.videoproducer.capture.CameraCaptureParams;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.capture.ScreenCapturer;
import com.tencent.liteav.videoproducer.capture.VirtualCamera;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.liteav.videoproducer.preprocessor.BeautyProcessor;
import com.tencent.liteav.videoproducer.preprocessor.VideoPreprocessor;
import com.tencent.liteav.videoproducer.producer.CustomVideoProcessListener;
import com.tencent.liteav.videoproducer.producer.ServerVideoProducerConfig;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;
import com.tencent.liteav.videoproducer.producer.aa;
import com.tencent.liteav.videoproducer.producer.ab;
import com.tencent.liteav.videoproducer.producer.ac;
import com.tencent.liteav.videoproducer.producer.ad;
import com.tencent.liteav.videoproducer.producer.ae;
import com.tencent.liteav.videoproducer.producer.af;
import com.tencent.liteav.videoproducer.producer.ag;
import com.tencent.liteav.videoproducer.producer.ah;
import com.tencent.liteav.videoproducer.producer.ai;
import com.tencent.liteav.videoproducer.producer.aj;
import com.tencent.liteav.videoproducer.producer.ak;
import com.tencent.liteav.videoproducer.producer.al;
import com.tencent.liteav.videoproducer.producer.aq;
import com.tencent.liteav.videoproducer.producer.av;
import com.tencent.liteav.videoproducer.producer.aw;
import com.tencent.liteav.videoproducer.producer.ax;
import com.tencent.liteav.videoproducer.producer.ay;
import com.tencent.liteav.videoproducer.producer.az;
import com.tencent.liteav.videoproducer.producer.i;
import com.tencent.liteav.videoproducer.producer.j;
import com.tencent.liteav.videoproducer.producer.k;
import com.tencent.liteav.videoproducer.producer.l;
import com.tencent.liteav.videoproducer.producer.m;
import com.tencent.liteav.videoproducer.producer.n;
import com.tencent.liteav.videoproducer.producer.o;
import com.tencent.liteav.videoproducer.producer.p;
import com.tencent.liteav.videoproducer.producer.q;
import com.tencent.liteav.videoproducer.producer.r;
import com.tencent.liteav.videoproducer.producer.s;
import com.tencent.liteav.videoproducer.producer.t;
import com.tencent.liteav.videoproducer.producer.u;
import com.tencent.liteav.videoproducer.producer.v;
import com.tencent.liteav.videoproducer.producer.w;
import com.tencent.liteav.videoproducer.producer.x;
import com.tencent.liteav.videoproducer.producer.y;
import com.tencent.liteav.videoproducer.producer.z;
import java.util.List;

@JNINamespace(value="liteav::video")
public class VideoProducerProxy {
    private final i mProducer;

    @CalledByNative
    public VideoProducerProxy(boolean isEnterpriseProEnabled, @NonNull IVideoReporter reporter) {
        this(ContextUtils.getApplicationContext(), isEnterpriseProEnabled, reporter);
    }

    public VideoProducerProxy(@NonNull Context context, boolean isEnterpriseProEnabled, @NonNull IVideoReporter reporter) {
        this.mProducer = new i(context, isEnterpriseProEnabled, reporter);
    }

    @CalledByNative
    public static VideoEncoderDef.EncodeAbility getEncodeAbility() {
        return i.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void initialize() {
        i i2;
        i i3 = i2 = this.mProducer;
        synchronized (i2) {
            if (i2.f) {
                LiteavLog.w(i2.a, "videoproducer already initialized.");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            HandlerThread handlerThread = new HandlerThread("videoProducer_" + i2.hashCode());
            handlerThread.start();
            i2.e = new CustomHandler(handlerThread.getLooper());
            i2.f = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            i2.e.runAndWaitDone(j.a(i2));
            return;
        }
    }

    @CalledByNative
    public void uninitialize() {
        i i2 = this.mProducer;
        i2.a(u.a(i2));
    }

    @CalledByNative
    public BeautyProcessor getBeautyProcessor() {
        return this.mProducer.d;
    }

    @CalledByNative
    public void setServerConfig(ServerVideoProducerConfig serverConfig) {
        i i2 = this.mProducer;
        ServerVideoProducerConfig serverVideoProducerConfig = serverConfig;
        i2.a(af.a(i2, serverVideoProducerConfig));
    }

    @CalledByNative
    public void startCapture(CaptureSourceInterface.SourceType sourceType, VideoProducerDef.CameraCaptureMode mode, CaptureSourceInterface.CaptureParams captureParams) {
        CaptureSourceInterface.CaptureParams captureParams2 = captureParams;
        VideoProducerDef.CameraCaptureMode cameraCaptureMode = mode;
        CaptureSourceInterface.SourceType sourceType2 = sourceType;
        i i2 = this.mProducer;
        if (sourceType2 != CaptureSourceInterface.SourceType.b && sourceType2 != CaptureSourceInterface.SourceType.c && sourceType2 != CaptureSourceInterface.SourceType.d) {
            throw new IllegalArgumentException("type: ".concat(String.valueOf((Object)sourceType2)));
        }
        if (sourceType2 == CaptureSourceInterface.SourceType.b && !(captureParams2 instanceof CameraCaptureParams)) {
            throw new IllegalArgumentException("CaptureParams is not CameraCaptureParams");
        }
        if (sourceType2 == CaptureSourceInterface.SourceType.c) {
            if (!(captureParams2 instanceof ScreenCapturer.ScreenCaptureParams)) {
                throw new IllegalArgumentException("CaptureParams is not ScreenCaptureParams");
            }
            if (LiteavSystemInfo.getSystemOSVersionInt() < 21) {
                i2.b.notifyError(h.a.h, "not support screen capture");
            }
        }
        if (sourceType2 == CaptureSourceInterface.SourceType.d && !(captureParams2 instanceof VirtualCamera.VirtualCameraParams)) {
            throw new IllegalArgumentException("CaptureParams is not VirtualCameraParams");
        }
        i i3 = i2;
        i3.a(aq.a(i3, sourceType2, cameraCaptureMode, captureParams2));
    }

    @CalledByNative
    public void stopCapture(int waitingTimeMs) {
        i i2 = this.mProducer;
        i2.a(av.a(i2), waitingTimeMs);
    }

    @CalledByNative
    public void setCaptureParams(CaptureSourceInterface.SourceType sourceType, VideoProducerDef.CameraCaptureMode mode, CaptureSourceInterface.CaptureParams captureParams) {
        i i2 = this.mProducer;
        CaptureSourceInterface.CaptureParams captureParams2 = captureParams;
        VideoProducerDef.CameraCaptureMode cameraCaptureMode = mode;
        CaptureSourceInterface.SourceType sourceType2 = sourceType;
        i2.a(aw.a(i2, sourceType2, cameraCaptureMode, captureParams2));
    }

    @CalledByNative
    public void setPausedImage(Bitmap bitmap, int framerate) {
        i i2 = this.mProducer;
        Bitmap bitmap2 = bitmap;
        i2.a(ax.a(i2, bitmap2, framerate));
    }

    @CalledByNative
    public void pauseCapture() {
        i i2 = this.mProducer;
        i2.a(ay.a(i2));
    }

    @CalledByNative
    public void resumeCapture() {
        i i2 = this.mProducer;
        i2.a(az.a(i2));
    }

    @CalledByNative
    public void setDisplayView(DisplayTarget displayTarget) {
        i i2 = this.mProducer;
        DisplayTarget displayTarget2 = displayTarget;
        i2.a(k.a(i2, displayTarget2));
    }

    @CalledByNative
    public void startEncodeStream(VideoProducerDef.StreamType streamType, VideoEncodeParams params, VideoEncoderDef.VideoEncoderDataListener listener) {
        i i2 = this.mProducer;
        VideoEncoderDef.VideoEncoderDataListener videoEncoderDataListener = listener;
        VideoEncodeParams videoEncodeParams = params;
        VideoProducerDef.StreamType streamType2 = streamType;
        i2.a(l.a(i2, streamType2, videoEncodeParams, videoEncoderDataListener));
    }

    @CalledByNative
    public void stopEncodeStream(VideoProducerDef.StreamType streamType) {
        i i2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        i2.a(m.a(i2, streamType2), 2000L);
    }

    @CalledByNative
    public VideoPreprocessor getVideoPreprocessor() {
        return this.mProducer.c;
    }

    @CalledByNative
    public void setEncodeStrategy(VideoProducerDef.StreamType streamType, VideoEncoderDef.EncodeStrategy encodeStrategy) {
        i i2 = this.mProducer;
        VideoEncoderDef.EncodeStrategy encodeStrategy2 = encodeStrategy;
        VideoProducerDef.StreamType streamType2 = streamType;
        i2.a(n.a(i2, streamType2, encodeStrategy2));
    }

    @CalledByNative
    public void setEncodeMirrorEnabled(boolean enable) {
        i i2 = this.mProducer;
        i2.a(o.a(i2, enable));
    }

    @CalledByNative
    public void setEncodeRotation(Rotation rotation) {
        i i2 = this.mProducer;
        Rotation rotation2 = rotation;
        i2.a(p.a(i2, rotation2));
    }

    @CalledByNative
    public void setHWEncoderDeviceRelatedParams(String params) {
        String string = params;
        i i2 = this.mProducer;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            i i3 = i2;
            i3.a(q.a(i3, string));
        }
    }

    @CalledByNative
    public int setCameraFocusPosition(int x2, int y2) {
        i i2 = this.mProducer;
        i2.a(r.a(i2, x2, y2));
        return 0;
    }

    @CalledByNative
    public void setGSensorMode(VideoProducerDef.GSensorMode mode) {
        i i2 = this.mProducer;
        VideoProducerDef.GSensorMode gSensorMode = mode;
        i2.a(s.a(i2, gSensorMode));
    }

    @CalledByNative
    public void setHomeOrientation(VideoProducerDef.HomeOrientation mode) {
        i i2 = this.mProducer;
        VideoProducerDef.HomeOrientation homeOrientation = mode;
        i2.a(t.a(i2, homeOrientation));
    }

    @CalledByNative
    public void setEncodeParams(VideoProducerDef.StreamType streamType, VideoEncodeParams params, GLConstants.ResolutionMode orientation) {
        i i2 = this.mProducer;
        GLConstants.ResolutionMode resolutionMode = orientation;
        VideoEncodeParams videoEncodeParams = params;
        VideoProducerDef.StreamType streamType2 = streamType;
        i2.a(v.a(i2, streamType2, videoEncodeParams, resolutionMode));
    }

    @CalledByNative
    public void setRPSIFrameFPS(VideoProducerDef.StreamType streamType, int fps) {
        i i2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        i2.a(x.a(i2, fps, streamType2));
    }

    @CalledByNative
    public void setRPSNearestREFSize(VideoProducerDef.StreamType streamType, int referenceSize) {
        i i2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        i2.a(y.a(i2, referenceSize, streamType2));
    }

    @CalledByNative
    public void ackRPSRecvFrameIndex(VideoProducerDef.StreamType streamType, int ackedFrameId, int bitmap) {
        i i2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        i2.a(z.a(i2, streamType2, ackedFrameId, bitmap));
    }

    @CalledByNative
    public void requestKeyFrame(VideoProducerDef.StreamType streamType) {
        i i2 = this.mProducer;
        VideoProducerDef.StreamType streamType2 = streamType;
        i2.a(aa.a(i2, streamType2));
    }

    @CalledByNative
    public void setRenderMirrorMode(GLConstants.MirrorMode mirrorMode) {
        i i2 = this.mProducer;
        GLConstants.MirrorMode mirrorMode2 = mirrorMode;
        i2.a(ab.a(i2, mirrorMode2));
    }

    @CalledByNative
    public void setRenderScaleType(GLConstants.GLScaleType scaleType) {
        i i2 = this.mProducer;
        GLConstants.GLScaleType gLScaleType = scaleType;
        i2.a(ac.a(i2, gLScaleType));
    }

    @CalledByNative
    public void setRenderRotation(Rotation rotation) {
        i i2 = this.mProducer;
        Rotation rotation2 = rotation;
        i2.a(ad.a(i2, rotation2));
    }

    @CalledByNative
    public void takeSnapshot(SnapshotSourceType sourceType, TakeSnapshotListener listener) {
        i i2 = this.mProducer;
        TakeSnapshotListener takeSnapshotListener = listener;
        SnapshotSourceType snapshotSourceType = sourceType;
        i2.a(ae.a(i2, snapshotSourceType, takeSnapshotListener));
    }

    @CalledByNative
    public void startCustomCapture() {
        i i2 = this.mProducer;
        i2.a(ag.a(i2));
    }

    @CalledByNative
    public void appendCustomCaptureFrame(PixelFrame frame) {
        PixelFrame pixelFrame = frame;
        i i2 = this.mProducer;
        if (pixelFrame == null || !pixelFrame.isFrameDataValid()) {
            LiteavLog.w(i2.a, "appendCustomCaptureFrame: frame is not valid.");
            return;
        }
        pixelFrame.getProducerChainTimestamp().setCaptureTimestamp(TimeUtil.a());
        pixelFrame.retain();
        i i3 = i2;
        if (!i3.a(ah.a(i3, pixelFrame))) {
            pixelFrame.release();
        }
    }

    @CalledByNative
    public void stopCustomCapture() {
        i i2 = this.mProducer;
        i2.a(ai.a(i2));
    }

    @CalledByNative
    public void setCustomRenderListener(GLConstants.PixelFormatType pixelFormat, GLConstants.PixelBufferType bufferType, VideoRenderListener listener) {
        i i2 = this.mProducer;
        VideoRenderListener videoRenderListener = listener;
        GLConstants.PixelBufferType pixelBufferType = bufferType;
        GLConstants.PixelFormatType pixelFormatType = pixelFormat;
        i2.a(aj.a(i2, pixelFormatType, pixelBufferType, videoRenderListener));
    }

    @CalledByNative
    public void setWatermark(Bitmap watermark, float xOffsetRatio, float yOffsetRatio, float widthRatio) {
        i i2 = this.mProducer;
        Bitmap bitmap = watermark;
        i2.a(ak.a(i2, bitmap, xOffsetRatio, yOffsetRatio, widthRatio));
    }

    @CalledByNative
    public void setCustomVideoProcessListener(GLConstants.PixelFormatType pixelFormat, GLConstants.PixelBufferType bufferType, CustomVideoProcessListener listener) {
        i i2 = this.mProducer;
        CustomVideoProcessListener customVideoProcessListener = listener;
        GLConstants.PixelBufferType pixelBufferType = bufferType;
        GLConstants.PixelFormatType pixelFormatType = pixelFormat;
        i2.a(al.a(i2, pixelFormatType, pixelBufferType, customVideoProcessListener));
    }

    @CalledByNative
    public void setPerspectiveCorrectionPoints(float[] srcPoints, float[] dstPoints) {
        i i2 = this.mProducer;
        List<PointF> list = e.a(dstPoints);
        List<PointF> list2 = e.a(srcPoints);
        i2.a(w.a(i2, list2, list));
    }
}

