/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.utils;

import android.graphics.Bitmap;
import android.media.projection.MediaProjection;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.Rotation;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.SnapshotSourceType;
import com.tencent.liteav.videoproducer.capture.CameraCaptureParams;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;
import com.tencent.liteav.videoproducer.capture.ScreenCapturer;
import com.tencent.liteav.videoproducer.capture.VirtualCamera;
import com.tencent.liteav.videoproducer.encoder.NativeEncoderDataListener;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;

@JNINamespace(value="liteav::video")
public class NativeProducerParamCreator {
    private static final String TAG = "CaptureParamsHelper";

    @CalledByNative
    public static NativeEncoderDataListener createNativeEncoderDataListener(long nativeClient, int streamType) {
        return new NativeEncoderDataListener(nativeClient, streamType);
    }

    @CalledByNative
    public static CaptureSourceInterface.SourceType createSourceType(int type) {
        return CaptureSourceInterface.SourceType.a(type);
    }

    @CalledByNative
    public static VideoProducerDef.StreamType createStreamType(int streamType) {
        return VideoProducerDef.StreamType.a(streamType);
    }

    @CalledByNative
    public static Rotation createRotation(int rotation) {
        return Rotation.a(rotation);
    }

    @CalledByNative
    public static VideoEncoderDef.EncodeStrategy createEncoderStrategy(int strategy) {
        return VideoEncoderDef.EncodeStrategy.a(strategy);
    }

    @CalledByNative
    public static VideoProducerDef.GSensorMode createGSensorMode(int value) {
        return VideoProducerDef.GSensorMode.a(value);
    }

    @CalledByNative
    public static VideoProducerDef.HomeOrientation createHomeOrientation(int value) {
        return VideoProducerDef.HomeOrientation.a(value);
    }

    @CalledByNative
    public static GLConstants.ResolutionMode createResolutionMode(int value) {
        return GLConstants.ResolutionMode.a(value);
    }

    @CalledByNative
    public static GLConstants.PixelBufferType createPixelBufferType(int pixelBufferType) {
        return GLConstants.PixelBufferType.a(pixelBufferType);
    }

    @CalledByNative
    public static GLConstants.PixelFormatType createPixelFormatType(int formatType) {
        return GLConstants.PixelFormatType.a(formatType);
    }

    @CalledByNative
    public static GLConstants.GLScaleType createScaleType(int scaleType) {
        return GLConstants.GLScaleType.a(scaleType);
    }

    @CalledByNative
    public static GLConstants.MirrorMode createMirrorMode(int mirrorMode) {
        return GLConstants.MirrorMode.a(mirrorMode);
    }

    @CalledByNative
    public static Boolean createBooleanWithValue(boolean value) {
        return value;
    }

    @CalledByNative
    public static CameraCaptureParams createCameraParams(Boolean frontCamera, int fps, int width, int height) {
        CameraCaptureParams cameraCaptureParams = new CameraCaptureParams();
        new CameraCaptureParams().a = frontCamera;
        cameraCaptureParams.b = fps;
        cameraCaptureParams.c = width;
        cameraCaptureParams.d = height;
        return cameraCaptureParams;
    }

    @CalledByNative
    public static VirtualCamera.VirtualCameraParams createVirtualParams(Bitmap bitmap, int fps, int width, int height) {
        VirtualCamera.VirtualCameraParams virtualCameraParams = new VirtualCamera.VirtualCameraParams();
        new VirtualCamera.VirtualCameraParams().a = bitmap;
        virtualCameraParams.b = fps;
        virtualCameraParams.c = width;
        virtualCameraParams.d = height;
        return virtualCameraParams;
    }

    @CalledByNative
    public static ScreenCapturer.ScreenCaptureParams createScreenParams(boolean autoRotate, int fps, int width, int height, MediaProjection mediaProjection, boolean enableForegroundService) {
        ScreenCapturer.ScreenCaptureParams screenCaptureParams = new ScreenCapturer.ScreenCaptureParams();
        new ScreenCapturer.ScreenCaptureParams().a = autoRotate;
        screenCaptureParams.b = fps;
        screenCaptureParams.c = width;
        screenCaptureParams.d = height;
        screenCaptureParams.f = mediaProjection;
        screenCaptureParams.g = enableForegroundService;
        return screenCaptureParams;
    }

    @CalledByNative
    public static VideoProducerDef.CameraCaptureMode createCameraCaptureMode(int mode) {
        return VideoProducerDef.CameraCaptureMode.a(mode);
    }

    @CalledByNative
    public static SnapshotSourceType createSnapshotSourceType(int type) {
        return SnapshotSourceType.a(type);
    }
}

