/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.util;

import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.a;
import com.tencent.liteav.base.util.b;
import com.tencent.liteav.base.util.c;
import com.tencent.liteav.base.util.d;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@JNINamespace(value="liteav")
public class CustomHandler
extends Handler {
    private final String mTAG;
    private static final long TIMEOUT_QUIT_LOOPER = TimeUnit.SECONDS.toMillis(30L);
    private final Handler mUIHandler = new Handler(Looper.getMainLooper());
    private Runnable mQuitLooperTimeoutRunnable = new Runnable(){

        @Override
        public final void run() {
            LiteavLog.e(CustomHandler.this.mTAG, "quit looper failed.");
        }
    };

    public CustomHandler(Looper looper) {
        this(looper, null);
    }

    public CustomHandler(Looper looper, Handler.Callback callback) {
        super(looper, callback);
        this.mTAG = "TXCHandler_" + ((Object)((Object)this)).hashCode();
        LiteavLog.i(this.mTAG, "[" + Thread.currentThread().getName() + "]");
    }

    public boolean runAndWaitDone(Runnable runnable) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        boolean bl = this.post(a.a(runnable, countDownLatch));
        if (bl) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        return bl;
    }

    public boolean runAndWaitDone(Runnable runnable, long timeout) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Runnable runnable2 = b.a(runnable, countDownLatch);
        boolean bl = this.post(runnable2);
        if (bl) {
            try {
                countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        return bl;
    }

    public boolean runOrPost(Runnable runnable) {
        return this.runOrPost(runnable, 0);
    }

    public boolean postTask(Runnable runnable) {
        return this.post(runnable);
    }

    public boolean postDelayedTask(Runnable runnable, long delayMillis) {
        return this.postDelayed(runnable, delayMillis);
    }

    public boolean runOrPost(Runnable runnable, int delayTime) {
        if (!this.getLooper().getThread().isAlive()) {
            return false;
        }
        if (Looper.myLooper() == this.getLooper() && delayTime == 0) {
            runnable.run();
            return true;
        }
        if (delayTime == 0) {
            return this.post(runnable);
        }
        return this.postDelayed(runnable, delayTime);
    }

    public void quitLooper() {
        MessageQueue.IdleHandler idleHandler = c.a(this);
        CustomHandler customHandler = this;
        customHandler.post(d.a(customHandler, idleHandler));
        this.mUIHandler.postDelayed(this.mQuitLooperTimeoutRunnable, TIMEOUT_QUIT_LOOPER);
    }

    public void quitLooperAndWaitDone() {
        this.quitLooper();
        try {
            this.getLooper().getThread().join();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public boolean isCurrentThread() {
        return Looper.myLooper() != null && Looper.myLooper() == this.getLooper();
    }

    static /* synthetic */ void lambda$quitLooper$3(CustomHandler this_, MessageQueue.IdleHandler idleHandler) {
        if (this_.getLooper() == Looper.getMainLooper()) {
            LiteavLog.e(this_.mTAG, "try to quitLooper main looper!");
            return;
        }
        LiteavLog.i(this_.mTAG, "add idle handle.");
        Looper.myQueue().addIdleHandler(idleHandler);
    }

    static /* synthetic */ boolean lambda$quitLooper$2(CustomHandler this_) {
        LiteavLog.i(this_.mTAG, "queue idle handle.");
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 18) {
            this_.getLooper().quitSafely();
        } else {
            this_.getLooper().quit();
        }
        this_.mUIHandler.removeCallbacks(this_.mQuitLooperTimeoutRunnable);
        return false;
    }

    static /* synthetic */ void lambda$runAndWaitDone$1(Runnable runnable, CountDownLatch countDownLatch) {
        runnable.run();
        countDownLatch.countDown();
    }

    static /* synthetic */ void lambda$runAndWaitDone$0(Runnable runnable, CountDownLatch countDownLatch) {
        runnable.run();
        countDownLatch.countDown();
    }
}

