/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.common;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.b;
import com.tencent.liteav.videobase.common.d;
import com.tencent.liteav.videobase.common.e;
import com.tencent.liteav.videobase.utils.ConsumerChainTimestamp;
import com.tencent.liteav.videobase.utils.ProducerChainTimestamp;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::video")
public class EncodedVideoFrame {
    private static final String TAG = "EncodedVideoFrame";
    public final ProducerChainTimestamp producerChainTimestamp = new ProducerChainTimestamp();
    public final ConsumerChainTimestamp consumerChainTimestamp = new ConsumerChainTimestamp();
    public ByteBuffer data;
    public long nativePtr = 0L;
    public d nalType = d.a;
    public e profileType = e.a;
    public CodecType codecType = CodecType.b;
    public int rotation;
    public long dts;
    public long pts;
    public int width;
    public int height;
    public long gopIndex = 0L;
    public long gopFrameIndex = 0L;
    public long frameIndex = 0L;
    public long refFrameIndex = 0L;
    public MediaFormat videoFormat;
    public Integer svcInfo = null;
    public boolean isEosFrame = false;
    public b hdrType = b.a;
    public MediaCodec.BufferInfo info = null;

    public void release() {
        if (this.nativePtr != 0L) {
            EncodedVideoFrame encodedVideoFrame = this;
            encodedVideoFrame.nativeRelease(encodedVideoFrame.nativePtr);
            this.nativePtr = 0L;
        }
    }

    private native void nativeRelease(long var1);

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.nativePtr != 0L) {
            LiteavLog.w(TAG, "nativePtr != 0, must call release before finalize ");
            this.release();
        }
    }

    public static long resetEncodedVideoFrame(EncodedVideoFrame videoFrame) {
        long l2 = 0L;
        if (videoFrame.nativePtr != 0L && videoFrame.data != null) {
            videoFrame.data = null;
            l2 = videoFrame.nativePtr;
            videoFrame.nativePtr = 0L;
        }
        return l2;
    }

    public static EncodedVideoFrame createEncodedVideoFrame(ByteBuffer data, int nalType, int profileType, int rotation, long dts, long pts, long gopIndex, long gopFrameIndex, long frameIndex, long refFrameIndex, int codecType, long nativePtr, int width, int height, boolean hasSVCInfo, int svcInfo, int hdrType) {
        EncodedVideoFrame encodedVideoFrame = new EncodedVideoFrame();
        new EncodedVideoFrame().data = data;
        encodedVideoFrame.nativePtr = nativePtr;
        encodedVideoFrame.nalType = d.a(nalType);
        encodedVideoFrame.profileType = e.a(profileType);
        encodedVideoFrame.codecType = CodecType.a(codecType);
        encodedVideoFrame.rotation = rotation;
        encodedVideoFrame.dts = dts;
        encodedVideoFrame.pts = pts;
        encodedVideoFrame.gopIndex = gopIndex;
        encodedVideoFrame.gopFrameIndex = gopFrameIndex;
        encodedVideoFrame.frameIndex = frameIndex;
        encodedVideoFrame.refFrameIndex = refFrameIndex;
        encodedVideoFrame.info = null;
        encodedVideoFrame.width = width;
        encodedVideoFrame.height = height;
        encodedVideoFrame.svcInfo = hasSVCInfo ? Integer.valueOf(svcInfo) : null;
        encodedVideoFrame.hdrType = b.a(hdrType);
        return encodedVideoFrame;
    }

    public boolean isIDRFrame() {
        return this.nalType != null && this.nalType == d.b;
    }

    public boolean isRPSEnable() {
        return this.profileType == e.e || this.profileType == e.f || this.profileType == e.g;
    }

    public boolean isSVCEnable() {
        return this.svcInfo != null;
    }

    public boolean isH265() {
        return this.codecType == CodecType.c;
    }

    public boolean isHDRFrame() {
        return this.hdrType != null && this.hdrType != b.a;
    }

    public void updateNALTypeAccordingNALHeader() {
        if (this.data == null || this.nalType != null && this.nalType != d.a) {
            return;
        }
        int n2 = 0;
        while ((n2 = EncodedVideoFrame.getNextNALHeaderPos(n2, this.data)) != -1 && n2 < this.data.remaining()) {
            d d2;
            if (this.isH265()) {
                EncodedVideoFrame encodedVideoFrame = this;
                d2 = encodedVideoFrame.getNalTypeFromH265NALHeader(encodedVideoFrame.data, n2);
            } else {
                EncodedVideoFrame encodedVideoFrame = this;
                d2 = encodedVideoFrame.getNalTypeFromH264NALHeader(encodedVideoFrame.data, n2);
            }
            if (this.nalType == null || this.nalType == d.a || d2 == d.b) {
                this.nalType = d2;
            }
            if (this.nalType == d.h || this.nalType == d.i || this.nalType == d.j || this.nalType == d.g) continue;
        }
    }

    public boolean isValidFrame() {
        return this.data != null && this.data.remaining() > 0 && this.nalType != null && this.codecType != null && this.width > 0 && this.height > 0;
    }

    private d getNalTypeFromH264NALHeader(ByteBuffer data, int firstNALHeaderPos) {
        switch (data.get(firstNALHeaderPos) & 0x1F) {
            case 5: {
                return d.b;
            }
            case 6: {
                return d.g;
            }
            case 7: {
                return d.h;
            }
            case 8: {
                return d.i;
            }
        }
        return d.a;
    }

    private d getNalTypeFromH265NALHeader(ByteBuffer data, int firstNALHeaderPos) {
        switch ((data.get(firstNALHeaderPos) & 0x7E) >> 1) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return d.b;
            }
            case 32: {
                return d.j;
            }
            case 33: {
                return d.h;
            }
            case 34: {
                return d.i;
            }
            case 39: {
                return d.g;
            }
        }
        return d.a;
    }

    public static int getNextNALHeaderPos(int startPos, ByteBuffer data) {
        int n2 = startPos;
        while (n2 + 3 < data.remaining()) {
            if (data.get(n2) == 0 && data.get(n2 + 1) == 0 && data.get(n2 + 2) == 0 && data.get(n2 + 3) == 1) {
                return n2 + 4;
            }
            if (data.get(n2) == 0 && data.get(n2 + 1) == 0 && data.get(n2 + 2) == 1) {
                return n2 + 3;
            }
            ++n2;
        }
        return -1;
    }

    public String toString() {
        return "nalType = " + (Object)((Object)this.nalType) + ", profiletype=" + (Object)((Object)this.profileType) + ", rotation=" + this.rotation + ", codecType=" + (Object)((Object)this.codecType) + ", dts=" + this.dts + ", pts=" + this.pts + ", gopIndex=" + this.gopIndex + ", gopFrameIndex=" + this.gopFrameIndex + ", frameIndex=" + this.frameIndex;
    }
}

