/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer2;

import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.view.Surface;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.common.MediaCodecAbility;
import com.tencent.liteav.videobase.utils.c;
import com.tencent.liteav.videobase.videobase.e;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

@JNINamespace(value="liteav::video")
public class HardwareVideoDecoder2
implements SurfaceTexture.OnFrameAvailableListener {
    private final String mTAG;
    private static final int DRAIN_ERROR = -1;
    private static final int DRAIN_SUCCESS = 0;
    private static final int DRAIN_SUCCESS_MEET_END_OF_STREAM = 1;
    private final b mThrottlers = new b();
    private long mNativeVideoDecoderImplAndroid;
    private boolean mIsRealTime;
    private boolean mIsStarted;
    private boolean mUseSoftwareDecoder = false;
    private MediaCodec mMediaCodec = null;
    private final c mDecoderMediaFormatBuilder;
    private final MediaCodec.BufferInfo mBufferInfo = new MediaCodec.BufferInfo();
    private SurfaceTexture mSurfaceTexture;
    private Surface mOutputSurface;
    private boolean mEnableLimitMaxDecFrameBufferingInH264Sps = true;
    private final com.tencent.liteav.videoconsumer.a.a mSPSModifier = new com.tencent.liteav.videoconsumer.a.a();

    HardwareVideoDecoder2(String traceId, boolean isRealTime, boolean isHEVC, int width, int height, boolean useSoftwareDecoder, long nativeVideoDecoderJni) {
        this.mTAG = traceId + "HardwareVideoDecoder2";
        this.mIsRealTime = isRealTime;
        this.mUseSoftwareDecoder = useSoftwareDecoder;
        this.mNativeVideoDecoderImplAndroid = nativeVideoDecoderJni;
        String string = isHEVC ? "video/hevc" : "video/avc";
        c c2 = new c();
        new c().c = string;
        c2.a = width;
        c2.b = height;
        this.mDecoderMediaFormatBuilder = c2;
    }

    public boolean start(int textureId) {
        if (this.mIsStarted) {
            return true;
        }
        LiteavLog.i(this.mTAG, "Start");
        if (!this.initializeSurface(textureId)) {
            return false;
        }
        a a2 = new a(0);
        if (this.configureDecoder(a2, this.mIsRealTime) || this.configureDecoder(a2, false)) {
            this.mMediaCodec = a2.a;
            this.mIsStarted = true;
            LiteavLog.i(this.mTAG, "Start succeed");
            return true;
        }
        this.handleDecoderError(a2.b, "decoder config fail, message:" + a2.c + " exception:" + a2.d.getMessage(), new Object[0]);
        return false;
    }

    public void stop() {
        LiteavLog.i(this.mTAG, "stop");
        if (!this.mIsStarted) {
            return;
        }
        HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
        hardwareVideoDecoder2.destroyMediaCodec(hardwareVideoDecoder2.mMediaCodec);
        this.mMediaCodec = null;
        this.uninitializeSurface();
        this.mIsStarted = false;
    }

    public int drainDecodedFrame() {
        try {
            return this.drainDecodedFrameInternal();
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mTAG, "decode failed.", throwable);
            this.handleDecoderError(e.c.n, "VideoDecode: decode error, restart decoder message:" + throwable.getMessage(), new Object[0]);
            return -1;
        }
    }

    public boolean decodeFrame(EncodedVideoFrame frame) {
        if (this.mMediaCodec == null) {
            LiteavLog.w(this.mTAG, "MediaCodec is stopped.");
            return false;
        }
        if (frame == null) {
            return true;
        }
        try {
            if (!this.feedDataToMediaCodec(frame)) {
                frame.release();
                return false;
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mTAG, "decode failed.", throwable);
            this.handleDecoderError(e.c.n, "VideoDecode: decode error, restart decoder message:" + throwable.getMessage(), new Object[0]);
        }
        frame.release();
        return true;
    }

    public void setEnableVui(boolean enableVui) {
        this.mEnableLimitMaxDecFrameBufferingInH264Sps = enableVui;
    }

    public float[] updateTexImage() {
        if (this.mSurfaceTexture == null) {
            return null;
        }
        try {
            float[] fArray = new float[16];
            this.mSurfaceTexture.updateTexImage();
            this.mSurfaceTexture.getTransformMatrix(fArray);
            return fArray;
        }
        catch (Throwable throwable) {
            LiteavLog.w(this.mThrottlers.a("updateImage"), this.mTAG, "updateTexImage exception: ".concat(String.valueOf(throwable)), new Object[0]);
            return null;
        }
    }

    private boolean feedDataToMediaCodec(EncodedVideoFrame frame) {
        ByteBuffer[] byteBufferArray;
        if (this.mMediaCodec == null) {
            LiteavLog.w(this.mTAG, "MediaCodec is stopped.");
            return false;
        }
        if (frame == null || !frame.isEosFrame && (frame.data == null || frame.data.remaining() == 0)) {
            LiteavLog.w(this.mTAG, "receive empty buffer.");
            return true;
        }
        ByteBuffer[] byteBufferArray2 = byteBufferArray = this.mMediaCodec.getInputBuffers();
        if (byteBufferArray == null || byteBufferArray2.length == 0) {
            LiteavLog.e(this.mTAG, "get invalid input buffers.");
            return false;
        }
        int n2 = this.mMediaCodec.dequeueInputBuffer(10000L);
        if (n2 < 0) {
            return false;
        }
        if (!frame.isEosFrame) {
            this.limitMaxDecFrameBufferingInH264Sps(frame);
            int n3 = frame.data.remaining();
            byteBufferArray[n2].put(frame.data);
            this.mMediaCodec.queueInputBuffer(n2, 0, n3, TimeUnit.MILLISECONDS.toMicros(frame.pts), 0);
        } else {
            LiteavLog.i(this.mTAG, "feedDataToMediaCodec BUFFER_FLAG_END_OF_STREAM");
            this.mMediaCodec.queueInputBuffer(n2, 0, 0, 0L, 4);
        }
        return true;
    }

    private int drainDecodedFrameInternal() {
        for (int i2 = 0; i2 < 3; ++i2) {
            int n2 = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, TimeUnit.MILLISECONDS.toMicros(10L));
            if (n2 == -1) {
                return -1;
            }
            if (n2 == -3) {
                LiteavLog.i(this.mTAG, "on output buffers changed");
                continue;
            }
            if (n2 == -2) {
                this.outputFormatChange();
                continue;
            }
            if (n2 >= 0) {
                this.mMediaCodec.releaseOutputBuffer(n2, true);
                if ((this.mBufferInfo.flags & 4) != 0) {
                    LiteavLog.i(this.mTAG, "meet end of stream.");
                    return 1;
                }
                return 0;
            }
            LiteavLog.d(this.mTAG, "dequeueOutputBuffer get invalid index: %d", n2);
            return -1;
        }
        return -1;
    }

    private void limitMaxDecFrameBufferingInH264Sps(EncodedVideoFrame frame) {
        if (!(frame.isIDRFrame() && frame.codecType == CodecType.b && this.mEnableLimitMaxDecFrameBufferingInH264Sps && this.mIsRealTime)) {
            return;
        }
        byte[] byArray = com.tencent.liteav.videobase.utils.e.a(frame.data.remaining());
        if (byArray == null) {
            return;
        }
        frame.data.get(byArray);
        frame.data.rewind();
        int[] nArray = new int[]{-1};
        byte[] byArray2 = this.getSpsData(byArray, nArray);
        if (byArray2 == null || nArray[0] < 0) {
            return;
        }
        byte[] byArray3 = null;
        try {
            byte[] byArray4;
            byte[] byArray5;
            Object object = this;
            com.tencent.liteav.videoconsumer2.a a2 = new com.tencent.liteav.videoconsumer2.a((HardwareVideoDecoder2)object);
            byte[] byArray6 = byArray2;
            object = this.mSPSModifier;
            boolean bl = false;
            byte[] byArray7 = byArray6;
            byte[] byArray8 = new byte[byArray6.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < byArray7.length) {
                if (n3 < byArray7.length - 3 && byArray7[n3] == 0 && byArray7[n3 + 1] == 0 && byArray7[n3 + 2] == 3 && byArray7[n3 + 3] <= 3) {
                    byArray8[n2++] = byArray7[n3];
                    byArray8[n2++] = byArray7[n3 + 1];
                    n3 += 3;
                    continue;
                }
                byArray8[n2++] = byArray7[n3];
                ++n3;
            }
            if (n2 != byArray7.length) {
                byte[] byArray9 = new byte[n2];
                System.arraycopy(byArray8, 0, byArray9, 0, n2);
                byArray5 = byArray9;
            } else {
                byArray5 = byArray4 = null;
            }
            if (byArray5 != null) {
                bl = true;
            } else {
                byArray4 = byArray6;
            }
            byArray4 = ((com.tencent.liteav.videoconsumer.a.a)object).a(new ByteArrayInputStream(byArray4), a2);
            if (byArray4 != null && bl) {
                byArray4 = com.tencent.liteav.videoconsumer.a.a.a(byArray4);
            }
            byArray3 = byArray4;
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mTAG, "modify dec buffer error ", throwable);
        }
        if (byArray3 == null) {
            return;
        }
        ByteBuffer byteBuffer = com.tencent.liteav.videobase.utils.e.b(byArray.length - byArray2.length + byArray3.length);
        if (byteBuffer == null) {
            return;
        }
        frame.data = byteBuffer;
        if (nArray[0] > 0) {
            frame.data.put(byArray, 0, nArray[0]);
        }
        frame.data.put(byArray3);
        frame.data.put(byArray, nArray[0] + byArray2.length, byArray.length - nArray[0] - byArray2.length);
        frame.data.rewind();
    }

    private byte[] getSpsData(byte[] data, int[] spsPosition) {
        int n2 = 0;
        while (n2 + 4 < data.length && (n2 = EncodedVideoFrame.getNextNALHeaderPos(n2, ByteBuffer.wrap(data))) >= 0) {
            if ((data[n2] & 0x1F) != 7) continue;
            spsPosition[0] = n2;
            break;
        }
        if (spsPosition[0] < 0) {
            return null;
        }
        n2 = data.length - spsPosition[0];
        int n3 = spsPosition[0];
        while (n3 + 3 < data.length) {
            if (data[n3] == 0 && data[n3 + 1] == 0 && data[n3 + 2] == 1 || data[n3] == 0 && data[n3 + 1] == 0 && data[n3 + 2] == 0 && data[n3 + 3] == 1) {
                n2 = n3 - spsPosition[0];
                break;
            }
            ++n3;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(data, spsPosition[0], byArray, 0, byArray.length);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeSurface(int textureId) {
        LiteavLog.i(this.mTAG, "initialize surface");
        HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
        synchronized (hardwareVideoDecoder2) {
            try {
                this.mSurfaceTexture = new SurfaceTexture(textureId);
                this.mOutputSurface = new Surface(this.mSurfaceTexture);
                this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            }
            catch (Surface.OutOfResourcesException outOfResourcesException) {
                LiteavLog.e(this.mThrottlers.a("surface"), this.mTAG, "create SurfaceTexture failed.", outOfResourcesException);
                this.handleDecoderError(e.c.k, "VideoDecode: insufficient resource, Start decoder failed:" + outOfResourcesException.getMessage(), new Object[0]);
                return false;
            }
        }
        LiteavLog.i(this.mThrottlers.a("initializeSurface"), this.mTAG, "initializeSurface", new Object[0]);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninitializeSurface() {
        LiteavLog.i(this.mTAG, "uninitialize surface");
        HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
        synchronized (hardwareVideoDecoder2) {
            if (this.mOutputSurface != null) {
                this.mOutputSurface.release();
                this.mOutputSurface = null;
            }
            if (this.mSurfaceTexture != null) {
                this.mSurfaceTexture.release();
                this.mSurfaceTexture = null;
            }
            return;
        }
    }

    private boolean configureDecoder(a configureResult, boolean setLowLatency) {
        this.mDecoderMediaFormatBuilder.d = setLowLatency;
        MediaFormat mediaFormat = this.mDecoderMediaFormatBuilder.a();
        LiteavLog.i(this.mTAG, "mediaFormat:".concat(String.valueOf(mediaFormat)));
        try {
            String string = mediaFormat.getString("mime");
            HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
            configureResult.a = hardwareVideoDecoder2.createMediaCodecInternal(hardwareVideoDecoder2.mUseSoftwareDecoder, string);
            configureResult.a.configure(mediaFormat, this.mOutputSurface, null, 0);
            configureResult.a.setVideoScalingMode(1);
            configureResult.a.start();
            LiteavLog.i(this.mTAG, "Start MediaCodec(%s) success.", configureResult.a.getName());
            return true;
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mTAG, "Start MediaCodec failed.", throwable);
            this.destroyMediaCodec(configureResult.a);
            configureResult.a = null;
            e.c c2 = e.c.m;
            String string = "VideoDecode: Start decoder failed";
            if (throwable instanceof IllegalArgumentException) {
                c2 = e.c.i;
                string = "VideoDecode: illegal argument, Start decoder failed";
            } else if (throwable instanceof IllegalStateException) {
                c2 = e.c.j;
                string = "VideoDecode: illegal state, Start decoder failed";
            }
            configureResult.b = c2;
            configureResult.c = string;
            configureResult.d = throwable;
            return false;
        }
    }

    /*
     * Loose catch block
     */
    private void destroyMediaCodec(MediaCodec mediaCodec) {
        if (mediaCodec != null) {
            LiteavLog.i(this.mTAG, "mediaCodec stop");
            mediaCodec.stop();
            try {
                LiteavLog.i(this.mTAG, "mediaCodec release");
                mediaCodec.release();
                return;
            }
            catch (Throwable throwable) {
                LiteavLog.e(this.mTAG, "release MediaCodec failed.", throwable);
                return;
            }
            catch (Throwable throwable) {
                try {
                    LiteavLog.e(this.mTAG, "Stop MediaCodec failed." + throwable.getMessage());
                }
                catch (Throwable throwable2) {
                    try {
                        LiteavLog.i(this.mTAG, "mediaCodec release");
                        mediaCodec.release();
                    }
                    catch (Throwable throwable3) {
                        LiteavLog.e(this.mTAG, "release MediaCodec failed.", throwable3);
                    }
                    throw throwable2;
                }
                try {
                    LiteavLog.i(this.mTAG, "mediaCodec release");
                    mediaCodec.release();
                    return;
                }
                catch (Throwable throwable4) {
                    LiteavLog.e(this.mTAG, "release MediaCodec failed.", throwable4);
                    return;
                }
            }
        }
    }

    private void handleDecoderError(e.c code, String format, Object ... args) {
        LiteavLog.e(this.mTAG, format, args);
        HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
        hardwareVideoDecoder2.nativeOnDecodedFrameFailed(hardwareVideoDecoder2.mNativeVideoDecoderImplAndroid, e.a(code));
    }

    private void outputFormatChange() {
        MediaFormat mediaFormat = this.mMediaCodec.getOutputFormat();
        LiteavLog.i(this.mTAG, "decode output format changed: ".concat(String.valueOf(mediaFormat)));
        int n2 = Math.abs(mediaFormat.getInteger("crop-right") - mediaFormat.getInteger("crop-left")) + 1;
        int n3 = Math.abs(mediaFormat.getInteger("crop-bottom") - mediaFormat.getInteger("crop-top")) + 1;
        int n4 = mediaFormat.getInteger("width");
        int n5 = mediaFormat.getInteger("height");
        LiteavLog.i(this.mTAG, "cropWidth: %d, cropHeight: %d, frameWidth: %d, frameHeight: %d", n2, n3, n4, n5);
    }

    public MediaCodec createMediaCodecInternal(boolean forceSoftware, String mimeType) throws IOException {
        if (!forceSoftware) {
            return MediaCodec.createDecoderByType((String)mimeType);
        }
        for (MediaCodecInfo mediaCodecInfo : new MediaCodecList(0).getCodecInfos()) {
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            if (mediaCodecInfo.isEncoder()) continue;
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!stringArray2[i2].contains(mimeType) || !MediaCodecAbility.isSoftOnlyDecoder(mediaCodecInfo)) continue;
                LiteavLog.i(this.mTAG, "Use soft only decoder:%s", mediaCodecInfo.getName());
                return MediaCodec.createByCodecName((String)mediaCodecInfo.getName());
            }
        }
        return MediaCodec.createDecoderByType((String)mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        long l2;
        HardwareVideoDecoder2 hardwareVideoDecoder2 = this;
        synchronized (hardwareVideoDecoder2) {
            if (this.mSurfaceTexture == null || this.mSurfaceTexture != surfaceTexture) {
                return;
            }
            l2 = TimeUnit.NANOSECONDS.toMillis(surfaceTexture.getTimestamp());
            if (l2 == 0L) {
                l2 = TimeUnit.MICROSECONDS.toMillis(this.mBufferInfo.presentationTimeUs);
            }
        }
        HardwareVideoDecoder2 hardwareVideoDecoder22 = this;
        hardwareVideoDecoder22.nativeOnFrameAvailable(hardwareVideoDecoder22.mNativeVideoDecoderImplAndroid, l2);
    }

    private native void nativeOnFrameFlagCropExist(long var1, int var3, int var4, int var5, int var6);

    private native void nativeOnDecodedFrameFailed(long var1, int var3);

    private native void nativeOnFrameAvailable(long var1, long var3);

    static /* synthetic */ boolean lambda$limitMaxDecFrameBufferingInH264Sps$0(HardwareVideoDecoder2 this_, int left, int right, int top, int bottom) {
        LiteavLog.e(this_.mTAG, "frame cropping flag exist, crop[l:" + left + ",r:" + right + ",t:" + top + ",b:" + bottom + "]");
        this_.mEnableLimitMaxDecFrameBufferingInH264Sps = false;
        HardwareVideoDecoder2 hardwareVideoDecoder2 = this_;
        hardwareVideoDecoder2.nativeOnFrameFlagCropExist(hardwareVideoDecoder2.mNativeVideoDecoderImplAndroid, left, right, top, bottom);
        return false;
    }

    static final class a {
        public MediaCodec a = null;
        public e.c b = null;
        public String c = null;
        public Throwable d = null;

        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

