/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtc;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.trtc.TRTCCloudDef;

@JNINamespace(value="liteav::trtc")
public class AudioVodTrackJni {
    private long mNativeAudioVodTrackJni = AudioVodTrackJni.nativeCreateAudioVodTrackJni(this);

    public synchronized void enablePlayout(boolean enable) {
        if (this.mNativeAudioVodTrackJni != 0L) {
            AudioVodTrackJni.nativeEnablePlayout(this.mNativeAudioVodTrackJni, enable);
        }
    }

    public synchronized int writeData(TRTCCloudDef.TRTCAudioFrame frame) {
        if (this.mNativeAudioVodTrackJni != 0L) {
            return AudioVodTrackJni.nativeWriteData(this.mNativeAudioVodTrackJni, new AudioFrame(frame));
        }
        return -1;
    }

    public synchronized void setPlayoutVolume(int playoutVolume) {
        if (this.mNativeAudioVodTrackJni != 0L) {
            AudioVodTrackJni.nativeSetPlayoutVolume(this.mNativeAudioVodTrackJni, playoutVolume);
        }
    }

    public synchronized void pause() {
        if (this.mNativeAudioVodTrackJni != 0L) {
            AudioVodTrackJni.nativePause(this.mNativeAudioVodTrackJni);
        }
    }

    public synchronized void resume() {
        if (this.mNativeAudioVodTrackJni != 0L) {
            AudioVodTrackJni.nativeResume(this.mNativeAudioVodTrackJni);
        }
    }

    public synchronized void seek() {
        if (this.mNativeAudioVodTrackJni != 0L) {
            AudioVodTrackJni.nativeSeek(this.mNativeAudioVodTrackJni);
        }
    }

    public synchronized void clean() {
        if (this.mNativeAudioVodTrackJni != 0L) {
            AudioVodTrackJni.nativeClean(this.mNativeAudioVodTrackJni);
        }
    }

    private static native long nativeCreateAudioVodTrackJni(AudioVodTrackJni var0);

    private static native void nativeEnablePlayout(long var0, boolean var2);

    private static native int nativeWriteData(long var0, AudioFrame var2);

    private static native void nativeSetPlayoutVolume(long var0, int var2);

    private static native void nativePause(long var0);

    private static native void nativeResume(long var0);

    private static native void nativeSeek(long var0);

    private static native void nativeClean(long var0);

    static class AudioFrame {
        private TRTCCloudDef.TRTCAudioFrame a;

        public AudioFrame(TRTCCloudDef.TRTCAudioFrame frame) {
            this.a = frame;
        }

        public byte[] getData() {
            return this.a.data;
        }

        public int getSampleRate() {
            return this.a.sampleRate;
        }

        public int getChannel() {
            return this.a.channel;
        }

        public long getTimestamp() {
            return this.a.timestamp;
        }
    }
}

