/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.frame;

import android.graphics.Bitmap;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.k;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.frame.FrameMetaData;
import com.tencent.liteav.videobase.frame.g;
import com.tencent.liteav.videobase.frame.i;
import com.tencent.liteav.videobase.utils.ConsumerChainTimestamp;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.ProducerChainTimestamp;
import com.tencent.liteav.videobase.utils.e;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collection;

@JNINamespace(value="liteav::video")
public class PixelFrame
extends i {
    private long mTimestamp = 0L;
    protected int mWidth = -1;
    protected int mHeight = -1;
    protected GLConstants.a mPixelBufferType;
    protected GLConstants.PixelFormatType mPixelFormatType;
    private GLConstants.ColorRange mColorRange = GLConstants.ColorRange.a;
    private GLConstants.ColorSpace mColorSpace = GLConstants.ColorSpace.a;
    private k mRotation = k.a;
    private boolean mIsMirrorHorizontal = false;
    private boolean mIsMirrorVertical = false;
    private float[] mMatrix = null;
    protected byte[] mData = null;
    protected ByteBuffer mBuffer = null;
    protected int mTextureId = -1;
    protected Object mGLContext = null;
    protected FrameMetaData mMetaData;
    protected ProducerChainTimestamp mProducerChainTimestamp = new ProducerChainTimestamp();
    protected ConsumerChainTimestamp mConsumerChainTimestamp = new ConsumerChainTimestamp();

    public PixelFrame() {
        super(null);
    }

    public PixelFrame(PixelFrame copyFrom) {
        super(null);
        this.copy(copyFrom);
    }

    public PixelFrame(int width, int height, int size, int bufferType, int formatType) {
        this(null, width, height, size, GLConstants.a.a(bufferType), GLConstants.PixelFormatType.a(formatType));
    }

    public PixelFrame(g<PixelFrame> recycler, int width, int height, GLConstants.a bufferType, GLConstants.PixelFormatType formatType) {
        this(recycler, width, height, formatType == GLConstants.PixelFormatType.f ? width * height * 4 : width * height * 3 / 2, bufferType, formatType);
    }

    public PixelFrame(g<PixelFrame> recycler, int width, int height, int size, GLConstants.a bufferType, GLConstants.PixelFormatType formatType) {
        super(recycler);
        this.mWidth = width;
        this.mHeight = height;
        this.mPixelFormatType = formatType;
        this.mPixelBufferType = bufferType;
        if (this.mPixelBufferType == GLConstants.a.d) {
            this.mData = e.a(size);
            return;
        }
        this.mBuffer = e.b(size);
    }

    @Override
    public int retain() {
        return super.retain();
    }

    @Override
    public void release() {
        super.release();
    }

    public void copy(PixelFrame copyFrom) {
        this.mTimestamp = copyFrom.mTimestamp;
        this.mWidth = copyFrom.mWidth;
        this.mHeight = copyFrom.mHeight;
        this.mPixelBufferType = copyFrom.mPixelBufferType;
        this.mPixelFormatType = copyFrom.mPixelFormatType;
        this.mRotation = copyFrom.mRotation;
        this.mIsMirrorHorizontal = copyFrom.mIsMirrorHorizontal;
        this.mIsMirrorVertical = copyFrom.mIsMirrorVertical;
        if (copyFrom.mMatrix != null) {
            this.mMatrix = new float[16];
            System.arraycopy(copyFrom.getMatrix(), 0, this.mMatrix, 0, this.mMatrix.length);
        }
        this.mMatrix = copyFrom.mMatrix;
        this.mData = copyFrom.mData;
        this.mBuffer = copyFrom.mBuffer;
        this.mTextureId = copyFrom.mTextureId;
        this.mGLContext = copyFrom.mGLContext;
        this.mMetaData = copyFrom.mMetaData;
        this.mConsumerChainTimestamp = copyFrom.mConsumerChainTimestamp;
        this.mProducerChainTimestamp = copyFrom.mProducerChainTimestamp;
        this.mColorSpace = copyFrom.mColorSpace;
        this.mColorRange = copyFrom.mColorRange;
    }

    protected PixelFrame(g<? extends PixelFrame> recycler) {
        super(recycler);
    }

    protected void reset() {
        this.mTimestamp = 0L;
        this.mRotation = k.a;
        this.mIsMirrorHorizontal = false;
        this.mIsMirrorVertical = false;
        this.mMatrix = null;
        this.mTextureId = -1;
        this.mGLContext = null;
        this.mMetaData = null;
        this.mProducerChainTimestamp = null;
        this.mConsumerChainTimestamp = null;
        this.mColorRange = GLConstants.ColorRange.a;
        this.mColorSpace = GLConstants.ColorSpace.a;
    }

    public void setColorRange(GLConstants.ColorRange colorRange) {
        this.mColorRange = colorRange;
    }

    public GLConstants.ColorRange getColorRange() {
        return this.mColorRange;
    }

    public void setColorSpace(GLConstants.ColorSpace colorSpace) {
        this.mColorSpace = colorSpace;
    }

    public GLConstants.ColorSpace getColorSpace() {
        return this.mColorSpace;
    }

    private int getColorRangeValue() {
        return this.mColorRange.getValue();
    }

    private int getColorSpaceValue() {
        return this.mColorSpace.getValue();
    }

    public void setPixelBufferType(GLConstants.a pixelBufferType) {
        this.mPixelBufferType = pixelBufferType;
    }

    public GLConstants.a getPixelBufferType() {
        return this.mPixelBufferType;
    }

    public void setPixelFormatType(GLConstants.PixelFormatType pixelFormatType) {
        this.mPixelFormatType = pixelFormatType;
    }

    public GLConstants.PixelFormatType getPixelFormatType() {
        return this.mPixelFormatType;
    }

    private int getPixelFormatTypeValue() {
        return this.mPixelFormatType.getValue();
    }

    private int getPixelBufferTypeValue() {
        return this.mPixelBufferType.mValue;
    }

    public void setData(byte[] data) {
        this.mData = data;
    }

    public byte[] getData() {
        return this.mData;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.mBuffer = buffer;
    }

    public ByteBuffer getBuffer() {
        return this.mBuffer;
    }

    public void setTextureId(int textureId) {
        this.mTextureId = textureId;
    }

    public int getTextureId() {
        return this.mTextureId;
    }

    public void setWidth(int width) {
        this.mWidth = width;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setHeight(int height) {
        this.mHeight = height;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setRotation(k rotation) {
        this.mRotation = rotation;
    }

    public k getRotation() {
        return this.mRotation;
    }

    private int getRotationValue() {
        return this.mRotation.mValue;
    }

    public void setMirrorHorizontal(boolean mirror) {
        this.mIsMirrorHorizontal = mirror;
    }

    public boolean isMirrorHorizontal() {
        return this.mIsMirrorHorizontal;
    }

    public void setMirrorVertical(boolean mirror) {
        this.mIsMirrorVertical = mirror;
    }

    public boolean isMirrorVertical() {
        return this.mIsMirrorVertical;
    }

    public void setMatrix(float[] matrix) {
        this.mMatrix = matrix;
    }

    public float[] getMatrix() {
        return this.mMatrix;
    }

    public void setTimestamp(long timestamp) {
        this.mTimestamp = timestamp;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public void setMetaData(FrameMetaData metaData) {
        this.mMetaData = metaData;
    }

    public FrameMetaData getMetaData() {
        return this.mMetaData;
    }

    public void setConsumerChainTimestamp(ConsumerChainTimestamp consumerChainTimestamp) {
        this.mConsumerChainTimestamp = consumerChainTimestamp;
    }

    public ConsumerChainTimestamp getConsumerChainTimestamp() {
        if (this.mConsumerChainTimestamp == null) {
            this.mConsumerChainTimestamp = new ConsumerChainTimestamp();
        }
        return this.mConsumerChainTimestamp;
    }

    public void setProducerChainTimestamp(ProducerChainTimestamp producerChainTimestamp) {
        this.mProducerChainTimestamp = producerChainTimestamp;
    }

    public ProducerChainTimestamp getProducerChainTimestamp() {
        if (this.mProducerChainTimestamp == null) {
            this.mProducerChainTimestamp = new ProducerChainTimestamp();
        }
        return this.mProducerChainTimestamp;
    }

    public void setGLContext(Object glContext) {
        this.mGLContext = glContext;
    }

    public Object getGLContext() {
        return this.mGLContext;
    }

    public long getGLContextNativeHandle() {
        return OpenGlUtils.getGLContextNativeHandle(this.mGLContext);
    }

    public void swapWidthHeight() {
        int n2 = this.mWidth;
        this.mWidth = this.mHeight;
        this.mHeight = n2;
    }

    public boolean hasTransformParams() {
        return this.mRotation != k.a || this.mIsMirrorHorizontal || this.mIsMirrorVertical || this.mMatrix != null;
    }

    public void postRotate(k rotation) {
        if (rotation == k.b || rotation == k.d) {
            this.swapWidthHeight();
        }
        PixelFrame pixelFrame = this;
        pixelFrame.setRotation(k.a((pixelFrame.mRotation.mValue + rotation.mValue) % 360));
    }

    public boolean isFrameDataValid() {
        return !(this.mPixelBufferType == GLConstants.a.b && this.mTextureId == -1 || this.mPixelBufferType == GLConstants.a.a && this.mBuffer == null || this.mPixelBufferType == GLConstants.a.d && this.mData == null);
    }

    public static void releasePixelFrames(Collection<PixelFrame> pixelFrameList) {
        if (pixelFrameList == null) {
            return;
        }
        for (PixelFrame pixelFrame : pixelFrameList) {
            if (pixelFrame == null) continue;
            pixelFrame.release();
        }
        pixelFrameList.clear();
    }

    public static PixelFrame createFromBitmap(Bitmap bitmap) {
        ByteBuffer byteBuffer;
        int n2 = bitmap.getWidth() / 2 * 2;
        int n3 = bitmap.getHeight() / 2 * 2;
        if (n2 != 0 && n3 != 0 && (bitmap.getWidth() % 2 != 0 || bitmap.getHeight() % 2 != 0)) {
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n2, (int)n3);
        }
        if ((byteBuffer = e.b(4 * bitmap.getWidth() * bitmap.getHeight())) == null) {
            return null;
        }
        bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
        byteBuffer.position(0);
        PixelFrame pixelFrame = new PixelFrame();
        pixelFrame.setBuffer(byteBuffer);
        pixelFrame.setWidth(bitmap.getWidth());
        pixelFrame.setHeight(bitmap.getHeight());
        pixelFrame.setPixelBufferType(GLConstants.a.a);
        pixelFrame.setPixelFormatType(GLConstants.PixelFormatType.f);
        return pixelFrame;
    }
}

