/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.ui;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.g;
import com.tencent.rtmp.ui.Dashboard;
import com.tencent.rtmp.ui.FocusIndicatorView;
import com.tencent.rtmp.ui.OnTapListener;
import com.tencent.rtmp.ui.OnZoomListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class TXCloudVideoView
extends FrameLayout
implements ScaleGestureDetector.OnScaleGestureListener {
    private final String mTAG = "TXCloudVideoView_" + ((Object)((Object)this)).hashCode();
    private static final int FOCUS_AREA_SIZE_IN_DP = 70;
    private final Dashboard mDashboard;
    private final Rect mDashMargin = new Rect();
    private final HashSet<TextureView> mDeprecatedTextureViewSet = new HashSet();
    private final WeakReference<SurfaceView> mSurfaceView;
    private WeakReference<Surface> mSurface;
    private TextureView mVideoViewSetByUser;
    private TextureView mTopTextureView;
    protected Object mGLContext;
    private FocusIndicatorView mFocusIndicatorView;
    private boolean mEnableTouchToFocus = false;
    private final a mDelayedTapRunnable = new a(0);
    private OnTapListener mTapListener;
    private ScaleGestureDetector mScaleGestureDetector;
    private boolean mEnableZoom = false;
    private OnZoomListener mZoomListener;
    private float mLastScaleFactor;
    private float mScaleFactor;
    private String mUserId = "";
    private WeakReference<b> mCallback;
    private boolean mEnableShowLog;
    private final Runnable mHideIndicatorViewRunnable = com.tencent.rtmp.ui.a.a(this);

    public TXCloudVideoView(Context context) {
        this(context, null, null);
    }

    public TXCloudVideoView(SurfaceView surfaceView) {
        this(surfaceView.getContext(), null, surfaceView);
    }

    public TXCloudVideoView(Context context, Surface surface) {
        this(context, null, null);
        this.mSurface = surface != null ? new WeakReference<Surface>(surface) : null;
    }

    public TXCloudVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, null);
    }

    public TXCloudVideoView(Context context, AttributeSet attrs, SurfaceView surfaceView) {
        super(context, attrs);
        this.mDashboard = new Dashboard(context);
        this.mSurfaceView = surfaceView != null ? new WeakReference<SurfaceView>(surfaceView) : null;
    }

    public void addVideoView(TextureView view) {
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.removeViewInternal(tXCloudVideoView.mVideoViewSetByUser, true);
        this.addViewInternal(view);
        this.mVideoViewSetByUser = view;
        this.repositionDashBoard();
    }

    public void removeVideoView() {
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.removeViewInternal(tXCloudVideoView.mVideoViewSetByUser, true);
        this.mVideoViewSetByUser = null;
    }

    @Deprecated
    public TextureView getVideoView() {
        if (this.mVideoViewSetByUser != null) {
            return this.mVideoViewSetByUser;
        }
        return this.mTopTextureView;
    }

    private void setBackgroundColorForInternalView(int color) {
        LiteavLog.i(this.mTAG, "setBackgroundColorForInternalView color:".concat(String.valueOf(color)));
        if (this.mSurface != null || this.mSurfaceView != null) {
            return;
        }
        int n2 = color & 0xFF;
        int n3 = color >> 8 & 0xFF;
        int n4 = color >> 16 & 0xFF;
        int n5 = color >> 24 & 0xFF;
        super.setBackgroundColor(Color.argb((int)n2, (int)n5, (int)n4, (int)n3));
    }

    @Deprecated
    public TextureView getHWVideoView() {
        return this.getVideoView();
    }

    private TextureView getTextureViewSetByUser() {
        return this.mVideoViewSetByUser;
    }

    private void updateTopTextureView() {
        TextureView textureView = null;
        for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
            View view = this.getChildAt(i2);
            if (!(view instanceof TextureView)) continue;
            textureView = (TextureView)view;
            break;
        }
        if (this.mTopTextureView != textureView) {
            this.mTopTextureView = textureView;
        }
    }

    private void addViewInternal(TextureView view) {
        if (view == null) {
            LiteavLog.w(this.mTAG, "addViewInternal,TextureView is null.");
            return;
        }
        if (view.getParent() == null) {
            this.addView((View)view);
            this.updateTopTextureView();
        } else if (view.getParent() == this) {
            LiteavLog.i(this.mTAG, "view has been added.");
        } else {
            LiteavLog.w(this.mTAG, "view has been added to other parent view. parent=" + view.getParent());
        }
        this.mDeprecatedTextureViewSet.remove(view);
    }

    private void removeViewInternal(TextureView view, boolean clearLastImage) {
        if (view == null) {
            return;
        }
        if (clearLastImage) {
            try {
                this.removeView((View)view);
            }
            catch (Exception exception) {
                LiteavLog.e(this.mTAG, "removeView view error: ", exception);
            }
            this.updateTopTextureView();
            this.mDeprecatedTextureViewSet.remove(view);
            return;
        }
        if (view.getParent() == this) {
            this.removeDeprecatedViews(view);
            this.mDeprecatedTextureViewSet.add(view);
            return;
        }
        if (view.getParent() == null) {
            LiteavLog.i(this.mTAG, "current view has been removed from the parent view. view=".concat(String.valueOf(view)));
            return;
        }
        if (view.getParent() != this) {
            LiteavLog.w(this.mTAG, "current view is not a child view of this view. parent=" + view.getParent());
        }
    }

    private void removeDeprecatedViews(TextureView excludeView) {
        Iterator<TextureView> iterator = this.mDeprecatedTextureViewSet.iterator();
        while (iterator.hasNext()) {
            TextureView textureView = iterator.next();
            if (textureView == null || textureView == excludeView) continue;
            try {
                this.removeView((View)textureView);
            }
            catch (Exception exception) {
                LiteavLog.e(this.mTAG, "removeView view error: ", exception);
            }
            iterator.remove();
        }
        this.updateTopTextureView();
    }

    private void setTouchToFocusEnabled(boolean enabled, OnTapListener listener) {
        this.mEnableTouchToFocus = enabled;
        this.mTapListener = listener;
    }

    private void setZoomEnabled(boolean enabled, OnZoomListener listener) {
        LiteavLog.i(this.mTAG, "setZoomEnabled: ".concat(String.valueOf(enabled)));
        this.mEnableZoom = enabled;
        this.mZoomListener = listener;
    }

    public SurfaceView getSurfaceView() {
        if (this.mSurfaceView == null) {
            return null;
        }
        SurfaceView surfaceView = (SurfaceView)this.mSurfaceView.get();
        if (surfaceView == null) {
            LiteavLog.w(this.mTAG, "surfaceView is null.");
        }
        return surfaceView;
    }

    public Surface getSurface() {
        if (this.mSurface == null) {
            return null;
        }
        Surface surface = (Surface)this.mSurface.get();
        if (surface == null) {
            LiteavLog.w(this.mTAG, "surface is null.");
        }
        return surface;
    }

    public void setOpenGLContext(Object glContext) {
        this.mGLContext = glContext;
    }

    public Object getOpenGLContext() {
        return this.mGLContext;
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onDestroy() {
    }

    public void clearLastFrame(boolean clear) {
        if (clear) {
            this.setVisibility(8);
        }
    }

    public void setUserId(String userId) {
        this.mUserId = userId;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getPointerCount() == 1 && event.getAction() == 0) {
            if (this.mEnableTouchToFocus) {
                int n2 = this.getHeight();
                int n3 = this.getWidth();
                int n4 = (int)event.getY();
                int n5 = (int)event.getX();
                a a2 = this.mDelayedTapRunnable;
                this.mDelayedTapRunnable.a.x = n5;
                a2.a.y = n4;
                a2.b = n3;
                a2.c = n2;
                TXCloudVideoView tXCloudVideoView = this;
                tXCloudVideoView.removeCallbacks(tXCloudVideoView.mDelayedTapRunnable);
                TXCloudVideoView tXCloudVideoView2 = this;
                tXCloudVideoView2.postDelayed(tXCloudVideoView2.mDelayedTapRunnable, 100L);
            }
        } else if (event.getPointerCount() > 1 && event.getAction() == 2 && this.mEnableZoom) {
            TXCloudVideoView tXCloudVideoView = this;
            tXCloudVideoView.removeCallbacks(tXCloudVideoView.mDelayedTapRunnable);
            this.hideIndicatorView();
            if (this.mScaleGestureDetector == null) {
                this.mScaleGestureDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)this);
            }
            this.mScaleGestureDetector.onTouchEvent(event);
        }
        if (this.mEnableZoom) {
            if (event.getAction() == 0) {
                this.performClick();
            }
            return true;
        }
        return super.onTouchEvent(event);
    }

    private void showFocusView(int x, int y, int width, int height) {
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.post(com.tencent.rtmp.ui.b.a(tXCloudVideoView, x, y, width, height));
    }

    private void showFocusViewInternal(int x, int y, int width, int height) {
        int n2;
        if (width != 0 && width != this.getWidth() || height != 0 && height != this.getHeight()) {
            LiteavLog.i(this.mTAG, "ignore show indicator view when view size changed");
            return;
        }
        LiteavLog.v(this.mTAG, "show indicator view at (%d,%d)", x, y);
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.removeCallbacks(tXCloudVideoView.mHideIndicatorViewRunnable);
        int n3 = n2 = (int)(70.0f * this.getResources().getDisplayMetrics().density + 0.5f);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n3);
        new FrameLayout.LayoutParams(n3, n3).leftMargin = g.a(x - n2 / 2, 0, this.getWidth() - n2);
        layoutParams.topMargin = g.a(y - n2 / 2, 0, this.getHeight() - n2);
        if (this.mFocusIndicatorView == null) {
            this.mFocusIndicatorView = new FocusIndicatorView(this.getContext());
            TXCloudVideoView tXCloudVideoView2 = this;
            tXCloudVideoView2.addView(tXCloudVideoView2.mFocusIndicatorView, (ViewGroup.LayoutParams)layoutParams);
        } else {
            TXCloudVideoView tXCloudVideoView3 = this;
            if (tXCloudVideoView3.indexOfChild(tXCloudVideoView3.mFocusIndicatorView) != this.getChildCount() - 1) {
                try {
                    TXCloudVideoView tXCloudVideoView4 = this;
                    tXCloudVideoView4.removeView(tXCloudVideoView4.mFocusIndicatorView);
                }
                catch (Exception exception) {
                    LiteavLog.e(this.mTAG, "removeView focus indicator view error: ", exception);
                }
                TXCloudVideoView tXCloudVideoView5 = this;
                tXCloudVideoView5.addView(tXCloudVideoView5.mFocusIndicatorView, (ViewGroup.LayoutParams)layoutParams);
            } else {
                this.mFocusIndicatorView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
        this.mFocusIndicatorView.setVisibility(0);
        FocusIndicatorView focusIndicatorView = this.mFocusIndicatorView;
        focusIndicatorView.startAnimation((Animation)focusIndicatorView.a);
        TXCloudVideoView tXCloudVideoView6 = this;
        tXCloudVideoView6.postDelayed(tXCloudVideoView6.mHideIndicatorViewRunnable, TimeUnit.SECONDS.toMillis(1L));
    }

    private void hideIndicatorView() {
        if (this.mFocusIndicatorView != null) {
            this.mFocusIndicatorView.setVisibility(8);
        }
    }

    public boolean onScale(ScaleGestureDetector detector) {
        if (!this.mEnableZoom) {
            return false;
        }
        float f2 = detector.getScaleFactor() - this.mLastScaleFactor;
        this.mLastScaleFactor = detector.getScaleFactor();
        this.mScaleFactor = g.a(this.mScaleFactor + f2, 0.0f);
        if (this.mZoomListener != null) {
            this.mZoomListener.onZoom(this.mScaleFactor);
        }
        return false;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        this.mLastScaleFactor = detector.getScaleFactor();
        return this.mEnableZoom;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
    }

    public void setLogMargin(float leftMarginInDp, float rightMarginInDp, float topMarginInDp, float bottomMarginInDp) {
        this.setDashBoardMarginInPx((int)leftMarginInDp, (int)rightMarginInDp, (int)topMarginInDp, (int)bottomMarginInDp);
    }

    public void setDashBoardMarginInPx(int left, int right, int top, int bottom) {
        this.mDashMargin.left = left;
        this.mDashMargin.right = right;
        this.mDashMargin.top = top;
        this.mDashMargin.bottom = bottom;
        this.mDashboard.a(left, top, right, bottom);
    }

    public void setDashBoardMarginInRatio(final float leftRatio, final float rightRatio, final float topRatio, final float bottomRatio) {
        this.postDelayed(new Runnable(){

            @Override
            public final void run() {
                TXCloudVideoView.this.setDashBoardMarginInPx((int)((float)TXCloudVideoView.this.getWidth() * leftRatio), (int)((float)TXCloudVideoView.this.getWidth() * rightRatio), (int)((float)TXCloudVideoView.this.getHeight() * topRatio), (int)((float)TXCloudVideoView.this.getHeight() * bottomRatio));
            }
        }, 100L);
    }

    public void disableLog(boolean enable) {
    }

    public void showLog(boolean enable) {
        this.mEnableShowLog = enable;
        b b2 = this.mCallback == null ? null : (b)this.mCallback.get();
        if (b2 != null) {
            b2.onShowLog(enable);
        }
    }

    public void clearLog() {
        if (this.mDashboard != null) {
            Dashboard dashboard = this.mDashboard;
            dashboard.a.setLength(0);
            if (dashboard.b != null) {
                dashboard.b.setText((CharSequence)"");
            }
            if (dashboard.c != null) {
                dashboard.c.setText((CharSequence)"");
            }
        }
    }

    private void repositionDashBoard() {
        try {
            TXCloudVideoView tXCloudVideoView = this;
            tXCloudVideoView.removeView((View)tXCloudVideoView.mDashboard);
        }
        catch (Exception exception) {
            LiteavLog.e(this.mTAG, "removeView dashboard view error: ", exception);
        }
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.addView((View)tXCloudVideoView.mDashboard);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mDashboard.a(this.mDashMargin.left, this.mDashMargin.top, this.mDashMargin.right, this.mDashMargin.bottom);
        this.mDashboard.setStatusTextSize((float)((double)TXCloudVideoView.px2dip(this.getContext(), this.getWidth()) / 30.0));
        this.mDashboard.setEventTextSize((float)((double)TXCloudVideoView.px2dip(this.getContext(), this.getWidth()) / 25.0));
    }

    private static int px2dip(Context context, float pxValue) {
        float f2 = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / f2 + 0.5f);
    }

    private void setShowLogCallback(WeakReference<b> callback) {
        this.mCallback = callback;
    }

    private boolean isShowLogEnabled() {
        return this.mEnableShowLog;
    }

    static /* synthetic */ void lambda$showFocusView$0(TXCloudVideoView this_, int x, int y, int width, int height) {
        this_.showFocusViewInternal(x, y, width, height);
    }

    static /* synthetic */ void access$lambda$0(TXCloudVideoView tXCloudVideoView) {
        tXCloudVideoView.hideIndicatorView();
    }

    public static interface b {
        public void onShowLog(boolean var1);
    }

    final class a
    implements Runnable {
        final Point a = new Point();
        int b = 0;
        int c = 0;

        private a() {
        }

        @Override
        public final void run() {
            if (TXCloudVideoView.this.mTapListener != null) {
                TXCloudVideoView.this.mTapListener.onTap(this.a.x, this.a.y, this.b, this.c);
            }
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

