/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.storage;

import android.content.SharedPreferences;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

@JNINamespace(value="liteav")
public class PersistStorage {
    public static final String GLOBAL_DOMAIN = "com.liteav.storage.global";
    private final SharedPreferences mSharedPreferences;
    private final SharedPreferences.Editor mEditor;
    private static final String LITEAV_PERSIST_STORAGE_SP_NAME = "com.liteav.persist.storage";
    private String mDomain;

    public PersistStorage(String domain) {
        this(domain, false);
    }

    public PersistStorage(String domain, boolean isIndependence) {
        this.initializeDomain(domain, isIndependence);
        this.mSharedPreferences = ContextUtils.getApplicationContext().getSharedPreferences(isIndependence ? domain : LITEAV_PERSIST_STORAGE_SP_NAME, 0);
        this.mEditor = this.mSharedPreferences.edit();
    }

    private void initializeDomain(String domain, boolean isIndependence) {
        if (!isIndependence) {
            if (domain == null || domain.isEmpty()) {
                this.mDomain = "null|";
                return;
            }
            this.mDomain = domain + "|";
            return;
        }
        this.mDomain = "";
    }

    public void put(String key, int value) {
        this.mEditor.putInt(this.mDomain + key, value);
    }

    public void put(String key, long value) {
        this.mEditor.putLong(this.mDomain + key, value);
    }

    public void put(String key, String value) {
        this.mEditor.putString(this.mDomain + key, value);
    }

    public void clear(String key) {
        this.mEditor.remove(this.mDomain + key);
    }

    public void commit() {
        this.mEditor.apply();
    }

    public Integer getInt(String key) {
        Integer n2;
        if (!this.mSharedPreferences.contains(this.mDomain + key)) {
            return null;
        }
        try {
            n2 = this.mSharedPreferences.getInt(this.mDomain + key, -1);
        }
        catch (Throwable throwable) {
            return null;
        }
        return n2;
    }

    public Long getLong(String key) {
        Long l2;
        if (!this.mSharedPreferences.contains(this.mDomain + key)) {
            return null;
        }
        try {
            l2 = this.mSharedPreferences.getLong(this.mDomain + key, -1L);
        }
        catch (Throwable throwable) {
            return null;
        }
        return l2;
    }

    public String getString(String key) {
        String string;
        if (!this.mSharedPreferences.contains(this.mDomain + key)) {
            return null;
        }
        try {
            string = this.mSharedPreferences.getString(this.mDomain + key, null);
        }
        catch (Throwable throwable) {
            return null;
        }
        return string;
    }

    private String[] filterSet(Set<String> inputSet, String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            String[] stringArray = new String[inputSet.size()];
            return inputSet.toArray(stringArray);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : inputSet) {
            if (!string.startsWith(prefix)) continue;
            String string2 = string.substring(prefix.length());
            arrayList.add(string2);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getAllKeys() {
        Map map = this.mSharedPreferences.getAll();
        if (map == null || map.isEmpty()) {
            return new String[0];
        }
        return this.filterSet(map.keySet(), this.mDomain);
    }

    public static int integerToBase(Integer in) {
        return in;
    }

    public static long longToBase(Long in) {
        return in;
    }
}

