/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.producer;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.k;

@JNINamespace(value="liteav::video")
public class ServerVideoProducerConfig {
    private final String mTAG = "ServerVideoProducerConfig_" + this.hashCode();
    private int hardwareEncodeType = 2;
    private boolean hardwareEncoderHighProfileEnable = true;
    private boolean hardwareEncoderHighProfileSupport = true;
    private int camera2SupportMinApiLevel = Integer.MAX_VALUE;
    private int cameraRotationCorrection = 0;
    private Boolean hardwareEncoderBitrateModeCBRSupported;
    private k gsensorRotationCorrection;
    private boolean mEnableCameraFpsCorrectionLogic = true;

    public static boolean isHWHevcEncodeAllowed() {
        return ServerVideoProducerConfig.nativeIsHardwareHevcEncodeAllowed();
    }

    public void setHardwareEncodeType(int value) {
        this.hardwareEncodeType = value;
    }

    public void setCamera2SupportMinApiLevel(int value) {
        this.camera2SupportMinApiLevel = value;
    }

    public void setHardwareEncoderHighProfileEnable(boolean value) {
        this.hardwareEncoderHighProfileEnable = value;
    }

    public void setHardwareEncoderHighProfileSupport(boolean value) {
        this.hardwareEncoderHighProfileSupport = value;
    }

    public void setHardwareEncoderBitrateModeCBRSupported(boolean supported) {
        this.hardwareEncoderBitrateModeCBRSupported = supported;
    }

    public void setCameraRotationCorrection(int value) {
        this.cameraRotationCorrection = value;
        LiteavLog.i(this.mTAG, "set camera rotation correction raw value is %#x.", value);
    }

    public void setGSensorRotationCorrection(int value) {
        if (value < 0 || value > 3) {
            return;
        }
        this.gsensorRotationCorrection = k.a(value * 90);
    }

    public void setCameraFpsCorrectionLogicEnabled(boolean value) {
        this.mEnableCameraFpsCorrectionLogic = value;
        LiteavLog.i(this.mTAG, "set camera fps correction logic enabled value is ".concat(String.valueOf(value)));
    }

    public int getCamera2SupportMinApiLevel() {
        return this.camera2SupportMinApiLevel;
    }

    public boolean isHardwareEncoderAllowed() {
        return this.hardwareEncodeType != 0;
    }

    public k getCameraV1FrontRotationCorrection() {
        int n2 = this.cameraRotationCorrection & 0xFF;
        return this.cameraCloudConfigEnumToRotation(n2);
    }

    public k getCameraV1BackRotationCorrection() {
        int n2 = this.cameraRotationCorrection >> 8 & 0xFF;
        return this.cameraCloudConfigEnumToRotation(n2);
    }

    public k getCameraV2FrontRotationCorrection() {
        int n2 = this.cameraRotationCorrection >> 16 & 0xFF;
        return this.cameraCloudConfigEnumToRotation(n2);
    }

    public k getCameraV2BackRotationCorrection() {
        int n2 = this.cameraRotationCorrection >> 24 & 0xFF;
        return this.cameraCloudConfigEnumToRotation(n2);
    }

    public boolean isCameraFpsCorrectionLogicEnabled() {
        return this.mEnableCameraFpsCorrectionLogic;
    }

    private k cameraCloudConfigEnumToRotation(int cameraCloudConfigEnumValue) {
        switch (cameraCloudConfigEnumValue) {
            case 1: {
                return k.a;
            }
            case 2: {
                return k.b;
            }
            case 3: {
                return k.c;
            }
            case 4: {
                return k.d;
            }
        }
        return null;
    }

    public String getCameraRotationCorrectionInfo() {
        return "[CameraV1Front:" + (Object)((Object)this.getCameraV1FrontRotationCorrection()) + ", CameraV1Back:" + (Object)((Object)this.getCameraV1BackRotationCorrection()) + ", CameraV2Front:" + (Object)((Object)this.getCameraV2FrontRotationCorrection()) + ", CameraV2Back:" + (Object)((Object)this.getCameraV2BackRotationCorrection()) + "]";
    }

    public boolean isHardwareEncoderHighProfileAllowed() {
        return this.hardwareEncodeType == 2 && this.hardwareEncoderHighProfileEnable && this.hardwareEncoderHighProfileSupport;
    }

    public Boolean isHardwareEncoderBitrateModeCBRSupported() {
        return this.hardwareEncoderBitrateModeCBRSupported;
    }

    public k getGsensorRotationCorrection() {
        return this.gsensorRotationCorrection;
    }

    private static native boolean nativeIsHardwareHevcEncodeAllowed();

    public String toString() {
        return "hardwareEncodeType: " + this.hardwareEncodeType + ", hardwareEncoderHighProfileEnable: " + this.hardwareEncoderHighProfileEnable + ", hardwareEncoderHighProfileSupport: " + this.hardwareEncoderHighProfileSupport + ", camera2SupportMinApiLevel: " + this.camera2SupportMinApiLevel + ", hardwareEncoderBitrateModeCBRSupported: " + this.hardwareEncoderBitrateModeCBRSupported + ", gsensorRotationCorrection: " + (Object)((Object)this.gsensorRotationCorrection) + ", cameraRotationCorrection: " + this.getCameraRotationCorrectionInfo();
    }
}

