/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.multimedia.liteav.audiokit.interfaces;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.huawei.multimedia.liteav.audioengine.IHwAudioEngine;
import com.huawei.multimedia.liteav.audiokit.interfaces.AudioFeaturesKit;
import com.huawei.multimedia.liteav.audiokit.interfaces.FeatureKitManager;
import com.huawei.multimedia.liteav.audiokit.interfaces.IAudioKitCallback;
import com.tencent.liteav.basic.log.TXCLog;
import java.util.ArrayList;
import java.util.List;

public class HwAudioKit {
    private static final String TAG = "HwAudioKit.HwAudioKit";
    private static final String ENGINE_CLASS_NAME = "com.huawei.multimedia.audioengine.HwAudioEngineService";
    private static final List<Integer> DEFAULT_FEATURE_LIST = new ArrayList<Integer>(0);
    private Context mContext = null;
    private IHwAudioEngine mIHwAudioEngine = null;
    private boolean mIsServiceConnected = false;
    private FeatureKitManager mFeatureKitManager;
    private IBinder mService = null;
    private ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            HwAudioKit.this.mIHwAudioEngine = IHwAudioEngine.Stub.asInterface(service);
            TXCLog.i(HwAudioKit.TAG, "onServiceConnected");
            if (HwAudioKit.this.mIHwAudioEngine != null) {
                HwAudioKit.this.mIsServiceConnected = true;
                TXCLog.i(HwAudioKit.TAG, "onServiceConnected, mIHwAudioEngine is not null");
                HwAudioKit.this.mFeatureKitManager.onCallBack(0);
                HwAudioKit.this.serviceInit(HwAudioKit.this.mContext.getPackageName(), "1.0.1");
                HwAudioKit.this.serviceLinkToDeath(service);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            TXCLog.i(HwAudioKit.TAG, "onServiceDisconnected");
            HwAudioKit.this.mIHwAudioEngine = null;
            HwAudioKit.this.mIsServiceConnected = false;
            HwAudioKit.this.mFeatureKitManager.onCallBack(4);
        }
    };
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public void binderDied() {
            HwAudioKit.this.mService.unlinkToDeath(HwAudioKit.this.mDeathRecipient, 0);
            HwAudioKit.this.mFeatureKitManager.onCallBack(6);
            TXCLog.e(HwAudioKit.TAG, "service binder died");
            HwAudioKit.this.mService = null;
        }
    };

    public HwAudioKit(Context context, IAudioKitCallback callback) {
        this.mFeatureKitManager = FeatureKitManager.getInstance();
        this.mFeatureKitManager.setCallBack(callback);
        this.mContext = context;
    }

    private void serviceLinkToDeath(IBinder service) {
        this.mService = service;
        try {
            if (this.mService != null) {
                this.mService.linkToDeath(this.mDeathRecipient, 0);
            }
        }
        catch (RemoteException remoteException) {
            this.mFeatureKitManager.onCallBack(5);
            TXCLog.e(TAG, "serviceLinkToDeath, RemoteException");
        }
    }

    public void initialize() {
        TXCLog.i(TAG, "initialize");
        if (this.mContext == null) {
            TXCLog.i(TAG, "mContext is null");
            this.mFeatureKitManager.onCallBack(7);
            return;
        }
        if (!this.mFeatureKitManager.isAudioKitSupport(this.mContext)) {
            TXCLog.i(TAG, "not install AudioKitEngine");
            this.mFeatureKitManager.onCallBack(2);
            return;
        }
        this.bindService(this.mContext);
    }

    private void bindService(Context context) {
        TXCLog.i(TAG, "bindService, mIsServiceConnected = %b", this.mIsServiceConnected);
        if (this.mFeatureKitManager != null && !this.mIsServiceConnected) {
            this.mFeatureKitManager.bindService(context, this.mConnection, ENGINE_CLASS_NAME);
        }
    }

    public void destroy() {
        TXCLog.i(TAG, "destroy, mIsServiceConnected = %b", this.mIsServiceConnected);
        if (this.mIsServiceConnected) {
            this.mIsServiceConnected = false;
            this.mFeatureKitManager.unbindService(this.mContext, this.mConnection);
        }
    }

    public List<Integer> getSupportedFeatures() {
        TXCLog.i(TAG, "getSupportedFeatures");
        try {
            if (this.mIHwAudioEngine != null && this.mIsServiceConnected) {
                return this.mIHwAudioEngine.getSupportedFeatures();
            }
        }
        catch (RemoteException remoteException) {
            TXCLog.e(TAG, "getSupportedFeatures, createFeature,wait bind service fail");
        }
        TXCLog.i(TAG, "getSupportedFeatures, service not bind");
        return DEFAULT_FEATURE_LIST;
    }

    public boolean isFeatureSupported(FeatureType type) {
        if (type == null) {
            return false;
        }
        TXCLog.i(TAG, "isFeatureSupported, type = %d", type.getFeatureType());
        try {
            if (this.mIHwAudioEngine != null && this.mIsServiceConnected) {
                return this.mIHwAudioEngine.isFeatureSupported(type.getFeatureType());
            }
        }
        catch (RemoteException remoteException) {
            TXCLog.e(TAG, "isFeatureSupported,RemoteException ex : %s", remoteException.getMessage());
        }
        return false;
    }

    public <T extends AudioFeaturesKit> T createFeature(FeatureType type) {
        if (this.mFeatureKitManager != null && type != null) {
            return this.mFeatureKitManager.createFeatureKit(type.getFeatureType(), this.mContext);
        }
        return null;
    }

    private void serviceInit(String packageName, String sdkVersion) {
        TXCLog.i(TAG, "serviceInit");
        try {
            if (this.mIHwAudioEngine != null && this.mIsServiceConnected) {
                this.mIHwAudioEngine.init(packageName, sdkVersion);
            }
        }
        catch (RemoteException remoteException) {
            TXCLog.e(TAG, "isFeatureSupported,RemoteException ex : %s", remoteException.getMessage());
        }
    }

    public static enum FeatureType {
        HWAUDIO_FEATURE_KARAOKE(1);

        private int mFeatureType;

        private FeatureType(int type) {
            this.mFeatureType = type;
        }

        public int getFeatureType() {
            return this.mFeatureType;
        }
    }
}

