/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.impl;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.media.AudioManager;
import com.tencent.liteav.audio.TXCAudioEncoderConfig;
import com.tencent.liteav.audio.TXCAudioEngine;
import com.tencent.liteav.audio.e;
import com.tencent.liteav.audio.g;
import com.tencent.liteav.audio.impl.earmonitor.TXSystemAudioKit;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.module.StatusBucket;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.basic.util.i;
import java.io.File;
import java.lang.ref.WeakReference;

public class TXCAudioEngineJNI {
    private static final String TAG = "TXCAudioEngineJNI";
    private static AudioManager sAudioManager = null;
    public static final int kInvalidCacheSize = Integer.MAX_VALUE;
    private static a mAudioDumpingListener;
    private static WeakReference<g> mAudioCaptureDataListener;
    private static WeakReference<e> mMixedAllDataListener;

    public static void setAudioCaptureDataListener(WeakReference<g> listener) {
        mAudioCaptureDataListener = listener;
        TXCAudioEngineJNI.nativeSetAudioEngineCaptureDataCallback(null != mAudioCaptureDataListener);
        TXCAudioEngineJNI.nativeSetAudioEngineCaptureRawDataCallback(null != mAudioCaptureDataListener);
        TXCAudioEngineJNI.nativeSetAudioEngineEncodedDataCallback(null != mAudioCaptureDataListener);
    }

    public static void onRecordRawPcmData(byte[] data, long ts, int sampleRate, int channels, int bits) {
        if (mAudioCaptureDataListener != null && mAudioCaptureDataListener.get() != null) {
            ((g)mAudioCaptureDataListener.get()).onRecordRawPcmData(data, ts, sampleRate, channels, bits, false);
        }
    }

    public static void onRecordPcmData(byte[] data, long ts, int sampleRate, int channels, int bits) {
        if (mAudioCaptureDataListener != null && mAudioCaptureDataListener.get() != null) {
            ((g)mAudioCaptureDataListener.get()).onRecordPcmData(data, ts, sampleRate, channels, bits);
        }
    }

    public static void onRecordEncData(byte[] aacData, long ts, int sampleRate, int channels) {
        if (mAudioCaptureDataListener != null && mAudioCaptureDataListener.get() != null) {
            ((g)mAudioCaptureDataListener.get()).onRecordEncData(aacData, ts, sampleRate, channels, 16);
        }
    }

    public static void onRecordError(int errNo, String errInfo) {
        TXCLog.e(TAG, "onRecordError: " + errNo + ", " + errInfo);
        if (mAudioCaptureDataListener != null && mAudioCaptureDataListener.get() != null) {
            ((g)mAudioCaptureDataListener.get()).onRecordError(errNo, errInfo);
        }
    }

    public static void onEvent(String id, int code, String msg, String params) {
        TXCAudioEngine.getInstance().onEvent(id, code, msg, params);
    }

    public static void onWarning(String id, int code, String msg, String params) {
        TXCAudioEngine.getInstance().onWarning(id, code, msg, params);
    }

    public static void onError(String id, int code, String msg, String params) {
        TXCAudioEngine.getInstance().onError(id, code, msg, params);
    }

    public static void setMixedAllDataListener(e listener) {
        mMixedAllDataListener = new WeakReference<e>(listener);
        TXCAudioEngineJNI.nativeSetAudioEngineMixedAllDataCallback(null != listener);
    }

    public static void onMixedAllData(byte[] data, int sampleRate, int channels) {
        e e2 = (e)mMixedAllDataListener.get();
        if (null != e2) {
            e2.onMixedAllData(data, sampleRate, channels);
        }
    }

    public static void onLocalAudioWriteFail() {
        if (mAudioDumpingListener != null) {
            mAudioDumpingListener.onLocalAudioWriteFailed();
        }
    }

    public static void SetAudioDumpingListener(a listenner) {
        mAudioDumpingListener = listenner;
    }

    public static void InitTraeEngineLibrary(Context context) {
        if (context == null) {
            TXCLog.e(TAG, "InitTraeEngineLibrary failed, context is null!");
            return;
        }
        try {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            String string = applicationInfo.nativeLibraryDir;
            String string2 = applicationInfo.dataDir + "/lib";
            String string3 = "/data/data/" + applicationInfo.packageName + "/lib";
            String string4 = i.e();
            if (string4 == null) {
                string4 = "";
            }
            TXCAudioEngineJNI.nativeAppendLibraryPath("add_libpath:" + string);
            TXCAudioEngineJNI.nativeAppendLibraryPath("add_libpath:" + string2);
            TXCAudioEngineJNI.nativeAppendLibraryPath("add_libpath:" + string3);
            TXCAudioEngineJNI.nativeAppendLibraryPath("add_libpath:" + string4);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            TXCLog.e(TAG, "init trae engine library failed.", unsatisfiedLinkError);
        }
    }

    public static boolean nativeCheckTraeEngine(Context context) {
        if (context == null) {
            TXCLog.e(TAG, "nativeCheckTraeEngine failed, context is null!");
            return false;
        }
        if (i.a("traeimp-rtmp")) {
            TXCLog.e(TAG, "link traeimp-rtmp success !");
            return true;
        }
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        String string = applicationInfo.nativeLibraryDir;
        String string2 = applicationInfo.dataDir + "/lib";
        String string3 = "/data/data/" + applicationInfo.packageName + "/lib";
        String string4 = i.e();
        if (string4 == null) {
            string4 = "";
        }
        String string5 = "/libTRAECodec-rtmp.so";
        String string6 = "/libtraeimp-rtmp.so";
        File file = null;
        boolean bl = false;
        boolean bl2 = false;
        file = new File(string + string6);
        if (file.exists()) {
            bl2 = true;
        } else {
            TXCLog.w(TAG, "nativeCheckTraeEngine load so error " + string + string6);
            file = new File(string2 + string6);
            if (file.exists()) {
                bl2 = true;
            } else {
                TXCLog.w(TAG, "nativeCheckTraeEngine load so error " + string2 + string6);
                file = new File(string3 + string6);
                if (file.exists()) {
                    bl2 = true;
                } else {
                    TXCLog.w(TAG, "nativeCheckTraeEngine load so error " + string3 + string6);
                    file = new File(string4 + string6);
                    if (file.exists()) {
                        bl2 = true;
                    } else {
                        TXCLog.w(TAG, "nativeCheckTraeEngine load so error " + string4 + string6);
                    }
                }
            }
        }
        if (bl2) {
            return true;
        }
        TXCLog.e(TAG, "nativeCheckTraeEngine failed, can not find trae libs !");
        return false;
    }

    public static void pauseAudioCapture(boolean bSendMuteData) {
        TXCAudioEngineJNI.nativePauseAudioCapture(bSendMuteData);
    }

    public static void resumeAudioCapture() {
        TXCAudioEngineJNI.nativeResumeAudioCapture();
    }

    public static void sendCustomPCMData(byte[] pcmBuffer, int samplerate, int channels) {
        TXCAudioEngineJNI.nativeSendCustomPCMData(pcmBuffer, pcmBuffer.length, TXCTimeUtil.generatePtsMS(), samplerate, channels);
    }

    public static void sendCustomPCMData(com.tencent.liteav.basic.structs.a packet) {
        TXCAudioEngineJNI.nativeSendCustomPCMData(packet.f, packet.f.length, packet.e, packet.a, packet.b);
    }

    public static StatusBucket getStatus(int periodTime) {
        return TXCAudioEngineJNI.nativeGetStatus(periodTime);
    }

    public static boolean isAppInBackground() {
        return i.a(TXCAudioEngine.getInstance().getAppContext());
    }

    public static int getAudioMode() {
        try {
            AudioManager audioManager = TXCAudioEngineJNI.getAudioManager();
            if (audioManager != null) {
                return audioManager.getMode();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static int getSystemVolume() {
        try {
            int n2 = TXCAudioEngineJNI.getAudioMode();
            int n3 = n2 == 0 ? 3 : 0;
            AudioManager audioManager = TXCAudioEngineJNI.getAudioManager();
            if (audioManager != null) {
                return audioManager.getStreamVolume(n3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private static AudioManager getAudioManager() {
        if (sAudioManager == null) {
            Context context = TXCAudioEngine.getInstance().getAppContext();
            sAudioManager = (AudioManager)context.getSystemService("audio");
        }
        return sAudioManager;
    }

    public static native void nativeSetAudioFrameExtraData(byte[] var0);

    public static native void nativeSendCustomPCMData(byte[] var0, int var1, long var2, int var4, int var5);

    public static native void nativeAppendLibraryPath(String var0);

    public static native void nativeCacheClassForNative();

    public static native void nativeSetAudioQuality(int var0, int var1);

    public static native void nativeSetAudioQualityEx(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native void nativeStartLocalAudio(int var0, boolean var1);

    public static native void nativeStopLocalAudio();

    public static native void nativePauseLocalAudio();

    public static native void nativeResumeLocalAudio();

    public static native void nativeEnableMixMode(boolean var0);

    public static native void nativeEnableEncodedDataPackWithTRAEHeaderCallback(boolean var0);

    public static native void nativeEnableEncodedDataCallback(boolean var0);

    public static native void nativeMuteLocalAudio(boolean var0);

    public static native void nativeSetRecordReverb(int var0);

    public static native void nativeSetRecordReverbParam(int var0, float var1);

    public static native void nativeSetSoftwareCaptureVolume(float var0);

    public static native void nativeSetCaptureVoiceChanger(int var0);

    public static native void nativeEnableAudioVolumeEvaluation(boolean var0, int var1);

    public static native void nativeEnableCaptureEOSMode(boolean var0);

    public static native int nativeGetSoftwareCaptureVolumeLevel();

    public static native void nativeSetAudioRoute(int var0);

    public static native void nativeSetMixingPlayoutVolume(float var0);

    public static native void nativeSetSoftAEC(int var0);

    public static native void nativeSetSoftANS(int var0);

    public static native void nativeSetSoftAGC(int var0);

    public static native void nativeSetAudioEncoderParam(int var0, int var1);

    public static native void nativeSetEncoderFECPercent(float var0);

    public static native boolean nativeIsAudioDeviceCapturing();

    public static native boolean nativeIsAudioDevicePlaying();

    public static native void nativePauseAudioCapture(boolean var0);

    public static native void nativeResumeAudioCapture();

    public static native void nativeSetSystemVolumeType(int var0);

    public static native void nativeSetPlayoutDevice(int var0);

    public static native void nativeInitBeforeEngineCreate(Context var0, String var1);

    public static native void nativeSetAudioEngineCaptureDataCallback(boolean var0);

    public static native void nativeSetAudioEngineCaptureRawDataCallback(boolean var0);

    public static native void nativeSetAudioEngineEncodedDataCallback(boolean var0);

    public static native void nativeSetAudioEngineMixedAllDataCallback(boolean var0);

    public static native void nativeNewAudioSessionDuplicate(Context var0);

    public static native void nativeDeleteAudioSessionDuplicate();

    public static native void nativeSetEventCallbackEnabled(boolean var0);

    public static native StatusBucket nativeGetStatus(int var0);

    public static native void nativeEnableAudioEarMonitoring(boolean var0);

    public static native void nativeSetAudioEarMonitoringVolume(int var0);

    public static native String nativeStartRemoteAudio(TXCAudioEngine var0, boolean var1, String var2);

    public static native void nativeStopRemoteAudio(String var0);

    public static native void nativeSetRemoteAudioCacheParams(String var0, boolean var1, int var2, int var3, int var4);

    public static native void nativeSetRemoteAudioJitterCycle(String var0, long var1);

    public static native void nativeSetRemoteAudioBlockThreshold(String var0, long var1);

    public static native void nativeMuteRemoteAudio(String var0, boolean var1);

    public static native void nativeMuteRemoteAudioInSpeaker(String var0, boolean var1);

    public static native void nativeSetRemotePlayoutVolume(String var0, int var1);

    public static native void nativeSetAudioEngineRemoteStreamDataListener(String var0, boolean var1);

    public static native int nativeGetRemotePlayoutVolumeLevel(String var0);

    public static native boolean nativeIsRemoteAudioPlaying(String var0);

    public static native int nativeGetMixingPlayoutVolumeLevel();

    public static native void nativeSetPlayoutDataListener(boolean var0);

    public static native int nativeStartLocalAudioDumping(int var0, int var1, int var2, String var3);

    public static native void nativeStopLocalAudioDumping();

    public static native void nativeUseSysAudioDevice(boolean var0);

    public static native void nativeSetAudioDeviceDSPEnabled(boolean var0);

    public static native void nativeInitAudioDevice();

    public static native void nativeUninitAudioDevice();

    public static native void nativeSetEncoderSampleRate(int var0);

    public static native void nativeSetEncoderChannels(int var0);

    public static native int nativeGetEncoderSampleRate();

    public static native int nativeGetEncoderChannels();

    public static native TXCAudioEncoderConfig nativeGetEncoderConfig();

    public static native void nativeSetAudioCompatibleConfig(String var0);

    public static native void nativeClean();

    public static native void nativeSetCaptureDataCallbackFormat(int var0, int var1, int var2);

    public static native void nativeSetLocalProcessedDataCallbackFormat(int var0, int var1, int var2);

    public static native void nativeSetPlayoutDataCallbackFormat(int var0, int var1, int var2);

    public static native void nativeSetRemoteStreamDataCallbackFormat(String var0, int var1, int var2, int var3);

    public static native boolean nativeIsDataCallbackFormatInvalid(int var0, int var1, int var2);

    public static native void nativeEnableAutoRestartDevice(boolean var0);

    public static native void nativeEnableInbandFEC(boolean var0);

    public static native void nativeSetMaxSelectedPlayStreams(int var0);

    public static native int nativeOpenAudioTunnel(boolean var0);

    public static native int nativeWriteDataToTunnel(int var0, int var1, int var2, int var3, byte[] var4);

    public static native void nativeSetVolumeToTunnel(int var0, int var1);

    public static native void nativeCloseAudioTunnel(int var0);

    public static native void nativeSetAudioPlayoutTunnelEnabled(boolean var0);

    public static native void nativeForceCallbackMixedPlayAudioFrame(boolean var0);

    public static native void nativeSetAudioCacheParams(int var0, int var1);

    public static native void nativeNotifySystemEarMonitoringInitializing();

    public static native void nativeSetSystemEarMonitoring(TXSystemAudioKit var0);

    public static native void nativeEnableDeviceAbnormalDetection(boolean var0);

    public static native void nativeEnableCustomAudioRendering(boolean var0);

    public static native void nativeSetLocalAudioMuteAction(int var0, int var1);

    public static native void nativeGetCustomAudioRenderingFrame(byte[] var0, int var1, int var2);

    static {
        i.d();
        TXCAudioEngineJNI.nativeCacheClassForNative();
        mAudioDumpingListener = null;
        mAudioCaptureDataListener = null;
        mMixedAllDataListener = new WeakReference<Object>(null);
    }

    public static interface a {
        public void onLocalAudioWriteFailed();
    }
}

