/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.basic.datareport;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.tencent.liteav.basic.datareport.TXCDRExtInfo;
import com.tencent.liteav.basic.datareport.a;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCCommonUtil;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.basic.util.f;
import com.tencent.liteav.basic.util.i;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import java.util.UUID;

public class TXCDRApi {
    private static final String TAG = "TXCDRApi";
    private static String mDevType = "";
    private static String mNetType = "";
    private static String mDevId = "";
    private static String mDevUUID = "";
    private static String mAppName = "";
    private static String mSysVersion = "";
    private static String g_simulate_idfa = "";
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static boolean initRpt = false;

    public static void InitEvent(Context context, String token, int commandId, int moduleId, TXCDRExtInfo extInfo) {
        TXCDRApi.setCommonInfo(context);
        if (token == null) {
            return;
        }
        TXCDRApi.nativeInitEventInternal(token, commandId, moduleId, extInfo);
    }

    public static void txSetEventValue(String token, int commandId, String key, String value) {
        TXCDRApi.nativeSetEventValueInterval(token, commandId, key, value);
    }

    public static void txSetEventIntValue(String token, int commandId, String key, long value) {
        TXCDRApi.nativeSetEventValueInterval(token, commandId, key, "" + value);
    }

    public static void txReportDAU(Context context, int eventId) {
        if (context != null) {
            TXCDRApi.setCommonInfo(context);
        }
        TXCDRApi.nativeReportDAUInterval(eventId, 0, "");
    }

    public static void txReportDAU(Context context, int eventId, int errCode, String errInfo) {
        if (context != null) {
            TXCDRApi.setCommonInfo(context);
        }
        TXCDRApi.nativeReportDAUInterval(eventId, errCode, errInfo);
    }

    public static void reportEvent40003(String url, int code, int subcode, String errmsg, String msg) {
        TXCDRApi.nativeReportEvent40003(url, code, subcode, errmsg, msg);
    }

    public static void reportAVRoomEvent(int sdkappid, long userid, String roomid, int code, int subcode, String msg, String msg_more) {
        TXCDRApi.nativeReportAVRoomEvent(sdkappid, userid, roomid, code, subcode, msg, msg_more);
    }

    public static int getStatusReportInterval() {
        return TXCDRApi.nativeGetStatusReportInterval();
    }

    public static void setCommonInfo(Context context) {
        mDevType = f.a;
        mNetType = Integer.toString(i.e(context));
        if (mDevId.isEmpty()) {
            mDevId = TXCDRApi.getSimulateIDFA(context);
        }
        if (mDevUUID.isEmpty()) {
            mDevUUID = TXCDRApi.getDevUUID(context, mDevId);
        }
        String string = TXCDRApi.getPackageName(context);
        mAppName = TXCDRApi.getApplicationNameByPackageName(context, string) + ":" + string;
        mSysVersion = String.valueOf(Build.VERSION.SDK_INT);
        TXCDRApi.txSetCommonInfo();
    }

    public static void txSetCommonInfo() {
        if (mDevType != null) {
            TXCDRApi.nativeSetCommonValue(a.f, mDevType);
        }
        if (mNetType != null) {
            TXCDRApi.nativeSetCommonValue(a.g, mNetType);
        }
        if (mDevId != null) {
            TXCDRApi.nativeSetCommonValue(a.h, mDevId);
        }
        if (mDevUUID != null) {
            TXCDRApi.nativeSetCommonValue(a.i, mDevUUID);
        }
        if (mAppName != null) {
            TXCDRApi.nativeSetCommonValue(a.j, mAppName);
        }
        if (mSysVersion != null) {
            TXCDRApi.nativeSetCommonValue(a.l, mSysVersion);
        }
    }

    public static void txSetAppVersion(String ver) {
        if (ver != null) {
            TXCDRApi.nativeSetCommonValue(a.k, ver);
        }
    }

    public static String txCreateToken() {
        return UUID.randomUUID().toString();
    }

    private static String byteArrayToHexString(byte[] data) {
        char[] cArray = new char[data.length << 1];
        int n2 = 0;
        for (int i2 = 0; i2 < data.length; ++i2) {
            cArray[n2++] = DIGITS_LOWER[(0xF0 & data[i2]) >>> 4];
            cArray[n2++] = DIGITS_LOWER[0xF & data[i2]];
        }
        return new String(cArray);
    }

    public static String string2Md5(String value) {
        String string = "";
        if (null == value) {
            return string;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            string = TXCDRApi.byteArrayToHexString(messageDigest.digest(value.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "string2Md5 failed.", exception);
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static String getSimulateIDFA(Context context) {
        Object object;
        Object object2;
        File file;
        if (g_simulate_idfa != null && g_simulate_idfa.length() > 0) {
            return g_simulate_idfa;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        File file2 = context.getExternalFilesDir(null);
        if (file2 == null) {
            TXCLog.e(TAG, "getSimulateIDFA sdcardDir is null");
            return g_simulate_idfa;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.tencent.liteav.dev_uuid", 0);
        string2 = sharedPreferences.getString("com.tencent.liteav.key_dev_uuid", "");
        try {
            String string4 = file2.getAbsolutePath() + "/liteav/spuid";
            file = new File(string4);
            if (file.exists()) {
                object2 = new FileInputStream(file);
                int n2 = ((FileInputStream)object2).available();
                if (n2 > 0) {
                    object = new byte[n2];
                    ((FileInputStream)object2).read((byte[])object);
                    string3 = new String((byte[])object, "UTF-8");
                }
                ((FileInputStream)object2).close();
            }
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "read UUID from file failed! reason: " + exception.getMessage());
        }
        if (string2 != null && string2.length() > 0) {
            string = string2;
        } else if (string3 != null && string3.length() > 0) {
            string = string3;
        }
        if (string == null || string.length() == 0) {
            int n3;
            string = "";
            long l2 = System.currentTimeMillis();
            long l3 = TXCTimeUtil.getTimeTick();
            object = i.c(context);
            for (n3 = 5; n3 >= 0; --n3) {
                string = string + String.format("%02x", (byte)(l2 >> n3 * 8 & 0xFFL));
            }
            for (n3 = 3; n3 >= 0; --n3) {
                string = string + String.format("%02x", (byte)(l3 >> n3 * 8 & 0xFFL));
            }
            string = string + TXCDRApi.string2Md5((String)object + UUID.randomUUID().toString());
        }
        g_simulate_idfa = string;
        TXCLog.i(TAG, "UUID:" + g_simulate_idfa);
        if (string3 == null || !string3.equals(string)) {
            try {
                File file3;
                String string5 = file2.getAbsolutePath() + "/liteav";
                file = new File(string5);
                if (!file.exists()) {
                    file.mkdir();
                }
                if (!(file3 = new File((String)(object2 = file2.getAbsolutePath() + "/liteav/spuid"))).exists()) {
                    file3.createNewFile();
                }
                object = new FileOutputStream(file3);
                byte[] byArray = string.getBytes();
                ((FileOutputStream)object).write(byArray);
                ((FileOutputStream)object).close();
            }
            catch (Exception exception) {
                TXCLog.e(TAG, "write UUID to file failed! reason: " + exception.getMessage());
            }
        }
        if (string2 == null || !string2.equals(string)) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString("com.tencent.liteav.key_dev_uuid", string);
            editor.commit();
        }
        return g_simulate_idfa;
    }

    public static String getDevUUID(Context context, String simulateIDFA) {
        return TXCDRApi.getSimulateIDFA(context);
    }

    private static String getPackageName(Context context) {
        String string = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            string = packageInfo.packageName;
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "get package name failed.", exception);
        }
        return string;
    }

    public static String getApplicationNameByPackageName(Context context, String packageName) {
        String string;
        PackageManager packageManager = context.getPackageManager();
        try {
            string = packageManager.getApplicationLabel(packageManager.getApplicationInfo(packageName, 128)).toString();
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCrashReport(Context context) {
        try {
            Class<TXCDRApi> clazz = TXCDRApi.class;
            synchronized (TXCDRApi.class) {
                String string;
                if (!initRpt && context != null && (string = TXCCommonUtil.getSDKVersionStr()) != null) {
                    SharedPreferences sharedPreferences = context.getSharedPreferences("BuglySdkInfos", 0);
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    editor.putString("8e50744bf0", string);
                    editor.commit();
                    initRpt = true;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "init crash report failed.", exception);
        }
        {
            return;
        }
    }

    private static native void nativeInitDataReport();

    private static native void nativeUninitDataReport();

    private static native void nativeInitEventInternal(String var0, int var1, int var2, TXCDRExtInfo var3);

    private static native void nativeReportDAUInterval(int var0, int var1, String var2);

    private static native void nativeSetEventValueInterval(String var0, int var1, String var2, String var3);

    public static native void nativeSetCommonValue(String var0, String var1);

    public static native void nativeReportEvent(String var0, int var1);

    public static native int nativeGetStatusReportInterval();

    public static native void nativeReportEvent40003(String var0, int var1, int var2, String var3, String var4);

    public static native void nativeReportAVRoomEvent(int var0, long var1, String var3, int var4, int var5, String var6, String var7);

    static {
        i.d();
        TXCDRApi.nativeInitDataReport();
    }
}

