/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.basic.util;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.d;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;

public class TXHttpRequest {
    private static final String TAG = "TXHttpRequest";
    private static final int CON_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private long mNativeHttps = 0L;

    public TXHttpRequest(long nativeHttp) {
        this.mNativeHttps = nativeHttp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static b downloadFileInternal(String url, String savePath) {
        HttpURLConnection httpURLConnection = null;
        b b2 = new b();
        try {
            httpURLConnection = (HttpsURLConnection)new URL(url).openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.setReadTimeout(5000);
            int n2 = httpURLConnection.getResponseCode();
            if (n2 != 200) {
                throw new IOException("download file failed with " + n2);
            }
            b2.d = TXHttpRequest.getHeaders((HttpsURLConnection)httpURLConnection);
            d.a(httpURLConnection.getInputStream(), savePath);
            b2.a = 0;
        }
        catch (Exception exception) {
            b2.b = exception.getMessage();
            TXCLog.e(TAG, "download file failed. " + url, exception);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return b2;
    }

    public int sendHttpsRequest(Map<String, String> headers, String action, byte[] data, boolean keepAlive, long callbackFunc) {
        TXCLog.i(TAG, "sendHttpsRequest->enter action: " + action + ", data size: " + data.length);
        this.asyncPostRequest(headers, action.getBytes(), data, keepAlive, callbackFunc);
        return 0;
    }

    public int downloadFile(final String url, final String savePath, final long callbackFunc) {
        final ExecutorService executorService = Executors.newSingleThreadExecutor();
        Looper looper = Looper.myLooper();
        final Handler handler = looper == null ? null : new Handler(looper);
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                b b2 = TXHttpRequest.downloadFileInternal(url, savePath);
                TXHttpRequest.this.notifyResult(handler, b2, callbackFunc);
                executorService.shutdown();
            }
        });
        return 0;
    }

    private void notifyResult(Handler handler, final b result, final long callbackFunc) {
        if (handler != null) {
            handler.post(new Runnable(){

                @Override
                public void run() {
                    TXHttpRequest.this.nativeOnRecvMessage(TXHttpRequest.this.mNativeHttps, result.a, result.c, result.d, callbackFunc);
                }
            });
        } else {
            this.nativeOnRecvMessage(this.mNativeHttps, result.a, result.c, result.d, callbackFunc);
        }
    }

    public static b getHttpsPostRsp(Map<String, String> headers, String strAction, byte[] data, boolean keepAlive) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream;
        TXCLog.i(TAG, "getHttpsPostRsp->request: " + strAction);
        TXCLog.i(TAG, "getHttpsPostRsp->data: " + data.length);
        URL uRL = new URL(strAction.replace(" ", "%20"));
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setDoInput(true);
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setConnectTimeout(5000);
        httpsURLConnection.setReadTimeout(5000);
        httpsURLConnection.setRequestMethod("POST");
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpsURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (keepAlive) {
            httpsURLConnection.setRequestProperty("Connection", "Keep-Alive");
        }
        DataOutputStream dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
        dataOutputStream.write(data);
        dataOutputStream.flush();
        dataOutputStream.close();
        int n2 = httpsURLConnection.getResponseCode();
        b b2 = new b();
        if (n2 >= 200 && n2 < 300) {
            int n3;
            InputStream inputStream = httpsURLConnection.getInputStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n3 = inputStream.read(data, 0, data.length)) != -1) {
                byteArrayOutputStream.write(data, 0, n3);
            }
            byteArrayOutputStream.flush();
            b2.d = new HashMap<String, String>();
            Map<String, List<String>> map = httpsURLConnection.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                if (TextUtils.isEmpty((CharSequence)entry.getKey())) continue;
                b2.d.put(entry.getKey(), entry.getValue().get(0));
            }
            inputStream.close();
            if (!keepAlive) {
                httpsURLConnection.disconnect();
            }
        } else {
            TXCLog.i(TAG, "getHttpsPostRsp->response code: " + n2);
            throw new Exception("response: " + n2);
        }
        b2.c = byteArrayOutputStream.toByteArray();
        b2.a = 0;
        TXCLog.i(TAG, "getHttpsPostRsp->rsp size: " + byteArrayOutputStream.size());
        return b2;
    }

    public void asyncPostRequest(Map<String, String> headers, byte[] action, byte[] data, boolean keepAlive, long callbackFunc) {
        a a2 = new a(this, headers, keepAlive, callbackFunc);
        a2.execute((Object[])new byte[][]{action, data});
    }

    private static Map<String, String> getHeaders(HttpsURLConnection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, List<String>> map = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (TextUtils.isEmpty((CharSequence)entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return hashMap;
    }

    private native void nativeOnRecvMessage(long var1, int var3, byte[] var4, Map<String, String> var5, long var6);

    static class a
    extends AsyncTask<byte[], Void, b> {
        private WeakReference<TXHttpRequest> a;
        private Handler b = null;
        private Map<String, String> c;
        private boolean d = false;
        private long e = 0L;

        public a(TXHttpRequest tXHttpRequest, Map<String, String> map, boolean bl, long l2) {
            this.c = map;
            this.a = new WeakReference<TXHttpRequest>(tXHttpRequest);
            Looper looper = Looper.myLooper();
            this.b = looper != null ? new Handler(looper) : null;
            this.d = bl;
            this.e = l2;
        }

        protected b a(byte[] ... byArray) {
            b b2 = new b();
            try {
                if (new String(byArray[0]).startsWith("https")) {
                    b2 = TXHttpRequest.getHttpsPostRsp(this.c, new String(byArray[0]), byArray[1], this.d);
                    b2.a = 0;
                } else {
                    b2.a = 1;
                    b2.b = "http request not support";
                }
            }
            catch (Exception exception) {
                b2.b = exception.toString();
                b2.a = 1;
            }
            TXCLog.i(TXHttpRequest.TAG, "TXPostRequest->result: " + b2.a + "|" + b2.b);
            return b2;
        }

        protected void a(final b b2) {
            super.onPostExecute((Object)b2);
            final TXHttpRequest tXHttpRequest = (TXHttpRequest)this.a.get();
            if (tXHttpRequest != null && tXHttpRequest.mNativeHttps != 0L) {
                if (this.b != null) {
                    this.b.post(new Runnable(){

                        @Override
                        public void run() {
                            TXCLog.i(TXHttpRequest.TAG, "TXPostRequest->recvMsg: " + b2.a + "|" + b2.b);
                            tXHttpRequest.nativeOnRecvMessage(tXHttpRequest.mNativeHttps, b2.a, b2.c, b2.d, a.this.e);
                        }
                    });
                } else {
                    TXCLog.i(TXHttpRequest.TAG, "TXPostRequest->recvMsg: " + b2.a + "|" + b2.b);
                    tXHttpRequest.nativeOnRecvMessage(tXHttpRequest.mNativeHttps, b2.a, b2.c, b2.d, this.e);
                }
            }
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((b)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((byte[][])objectArray);
        }
    }

    static class b {
        public int a = 1;
        public String b = "";
        public byte[] c = "".getBytes();
        public Map<String, String> d;

        b() {
        }
    }
}

