/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.live2.impl;

import android.text.TextUtils;
import com.tencent.liteav.basic.enums.c;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.live2.V2TXLiveDef;
import com.tencent.live2.impl.a;

public class V2TXLiveUtils {
    private static final String TAG = "V2TXLiveUtils";
    public static final String TRTC_ADDRESS1 = "room://cloud.tencent.com/rtc";
    public static final String TRTC_ADDRESS2 = "room://rtc.tencent.com";

    public static V2TXLiveDef.V2TXLiveMode parseLiveMode(String url) {
        if (url.startsWith("trtc://") || url.startsWith(TRTC_ADDRESS1) || url.startsWith(TRTC_ADDRESS2)) {
            TXCLog.i(TAG, "parseLiveMode: rtc.");
            return V2TXLiveDef.V2TXLiveMode.TXLiveMode_RTC;
        }
        TXCLog.i(TAG, "parseLiveMode: rtmp.");
        return V2TXLiveDef.V2TXLiveMode.TXLiveMode_RTMP;
    }

    public static a.c parsePlayerType(String url) {
        if (url.startsWith("trtc://")) {
            TXCLog.i(TAG, "parsePlayerType: rtc.");
            return a.c.b;
        }
        if (url.startsWith(TRTC_ADDRESS1) || url.startsWith(TRTC_ADDRESS2)) {
            TXCLog.i(TAG, "parsePlayerType: room.");
            return a.c.a;
        }
        if (url.startsWith("webrtc://")) {
            TXCLog.i(TAG, "parsePlayerType: webrtc.");
            return a.c.d;
        }
        TXCLog.i(TAG, "parsePlayerType: rtmp.");
        return a.c.c;
    }

    public static int getRTMPRotation(V2TXLiveDef.V2TXLiveRotation rotation) {
        if (rotation == null) {
            return 0;
        }
        int n2 = 0;
        switch (rotation) {
            case V2TXLiveRotation270: {
                n2 = 270;
                break;
            }
            case V2TXLiveRotation180: {
                n2 = 180;
                break;
            }
            case V2TXLiveRotation90: {
                n2 = 90;
                break;
            }
            case V2TXLiveRotation0: {
                n2 = 0;
            }
        }
        return n2;
    }

    public static int getRTMPFillMode(V2TXLiveDef.V2TXLiveFillMode fillMode) {
        if (fillMode == null) {
            return 0;
        }
        int n2 = 0;
        switch (fillMode) {
            case V2TXLiveFillModeFill: {
                n2 = 0;
                break;
            }
            case V2TXLiveFillModeFit: {
                n2 = 1;
            }
        }
        return n2;
    }

    public static int getRTMPResolution(V2TXLiveDef.V2TXLiveVideoResolution resolution) {
        int n2 = 1;
        switch (resolution) {
            case V2TXLiveVideoResolution160x160: {
                n2 = 19;
                break;
            }
            case V2TXLiveVideoResolution270x270: {
                n2 = 18;
                break;
            }
            case V2TXLiveVideoResolution480x480: {
                n2 = 17;
                break;
            }
            case V2TXLiveVideoResolution320x240: {
                n2 = 11;
                break;
            }
            case V2TXLiveVideoResolution480x360: {
                n2 = 12;
                break;
            }
            case V2TXLiveVideoResolution640x480: {
                n2 = 13;
                break;
            }
            case V2TXLiveVideoResolution320x180: {
                n2 = 7;
                break;
            }
            case V2TXLiveVideoResolution480x270: {
                n2 = 8;
                break;
            }
            case V2TXLiveVideoResolution640x360: {
                n2 = 0;
                break;
            }
            case V2TXLiveVideoResolution960x540: {
                n2 = 1;
                break;
            }
            case V2TXLiveVideoResolution1280x720: {
                n2 = 2;
                break;
            }
            case V2TXLiveVideoResolution1920x1080: {
                n2 = 30;
            }
        }
        return n2;
    }

    public static c convertResolution(int resolution) {
        switch (resolution) {
            case 0: {
                return c.b;
            }
            case 1: {
                return c.c;
            }
            case 2: {
                return c.d;
            }
            case 3: {
                return c.e;
            }
            case 4: {
                return c.f;
            }
            case 5: {
                return c.g;
            }
            case 7: {
                return c.i;
            }
            case 8: {
                return c.j;
            }
            case 9: {
                return c.k;
            }
            case 10: {
                return c.l;
            }
            case 11: {
                return c.m;
            }
            case 12: {
                return c.n;
            }
            case 13: {
                return c.o;
            }
            case 14: {
                return c.p;
            }
            case 15: {
                return c.q;
            }
            case 16: {
                return c.r;
            }
            case 17: {
                return c.s;
            }
            case 18: {
                return c.t;
            }
            case 19: {
                return c.u;
            }
            case 30: {
                return c.w;
            }
            case 31: {
                return c.x;
            }
        }
        return c.c;
    }

    public static b getVideoSize(V2TXLiveDef.V2TXLiveVideoResolution resolution, V2TXLiveDef.V2TXLiveVideoResolutionMode mode) {
        b b2 = new b(544, 960);
        switch (resolution) {
            case V2TXLiveVideoResolution160x160: {
                b2 = new b(160, 160);
                break;
            }
            case V2TXLiveVideoResolution270x270: {
                b2 = new b(270, 270);
                break;
            }
            case V2TXLiveVideoResolution480x480: {
                b2 = new b(480, 480);
                break;
            }
            case V2TXLiveVideoResolution320x240: {
                if (mode == V2TXLiveDef.V2TXLiveVideoResolutionMode.V2TXLiveVideoResolutionModePortrait) {
                    b2 = new b(240, 320);
                    break;
                }
                b2 = new b(320, 240);
                break;
            }
            case V2TXLiveVideoResolution480x360: {
                if (mode == V2TXLiveDef.V2TXLiveVideoResolutionMode.V2TXLiveVideoResolutionModePortrait) {
                    b2 = new b(368, 480);
                    break;
                }
                b2 = new b(480, 368);
                break;
            }
            case V2TXLiveVideoResolution640x480: {
                if (mode == V2TXLiveDef.V2TXLiveVideoResolutionMode.V2TXLiveVideoResolutionModePortrait) {
                    b2 = new b(480, 640);
                    break;
                }
                b2 = new b(640, 480);
                break;
            }
            case V2TXLiveVideoResolution320x180: {
                if (mode == V2TXLiveDef.V2TXLiveVideoResolutionMode.V2TXLiveVideoResolutionModePortrait) {
                    b2 = new b(192, 320);
                    break;
                }
                b2 = new b(320, 192);
                break;
            }
            case V2TXLiveVideoResolution480x270: {
                if (mode == V2TXLiveDef.V2TXLiveVideoResolutionMode.V2TXLiveVideoResolutionModePortrait) {
                    b2 = new b(272, 480);
                    break;
                }
                b2 = new b(480, 272);
                break;
            }
            case V2TXLiveVideoResolution640x360: {
                if (mode == V2TXLiveDef.V2TXLiveVideoResolutionMode.V2TXLiveVideoResolutionModePortrait) {
                    b2 = new b(368, 640);
                    break;
                }
                b2 = new b(640, 368);
                break;
            }
            case V2TXLiveVideoResolution960x540: {
                if (mode == V2TXLiveDef.V2TXLiveVideoResolutionMode.V2TXLiveVideoResolutionModePortrait) {
                    b2 = new b(544, 960);
                    break;
                }
                b2 = new b(960, 544);
                break;
            }
            case V2TXLiveVideoResolution1280x720: {
                if (mode == V2TXLiveDef.V2TXLiveVideoResolutionMode.V2TXLiveVideoResolutionModePortrait) {
                    b2 = new b(720, 1280);
                    break;
                }
                b2 = new b(1280, 720);
                break;
            }
            case V2TXLiveVideoResolution1920x1080: {
                b2 = mode == V2TXLiveDef.V2TXLiveVideoResolutionMode.V2TXLiveVideoResolutionModePortrait ? new b(1088, 1920) : new b(1920, 1088);
            }
        }
        return b2;
    }

    public static boolean isPortraitResolution(int resolution) {
        switch (resolution) {
            case 0: 
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 30: {
                return true;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 31: {
                return false;
            }
        }
        return true;
    }

    public static a getBitrateByResolution(V2TXLiveDef.V2TXLiveVideoResolution resolution) {
        int n2 = 800;
        int n3 = 1500;
        switch (resolution) {
            case V2TXLiveVideoResolution160x160: {
                n2 = 100;
                n3 = 150;
                break;
            }
            case V2TXLiveVideoResolution270x270: {
                n2 = 200;
                n3 = 300;
                break;
            }
            case V2TXLiveVideoResolution480x480: {
                n2 = 350;
                n3 = 525;
                break;
            }
            case V2TXLiveVideoResolution320x240: {
                n2 = 250;
                n3 = 375;
                break;
            }
            case V2TXLiveVideoResolution480x360: {
                n2 = 400;
                n3 = 600;
                break;
            }
            case V2TXLiveVideoResolution640x480: {
                n2 = 600;
                n3 = 900;
                break;
            }
            case V2TXLiveVideoResolution320x180: {
                n2 = 250;
                n3 = 400;
                break;
            }
            case V2TXLiveVideoResolution480x270: {
                n2 = 350;
                n3 = 550;
                break;
            }
            case V2TXLiveVideoResolution640x360: {
                n2 = 500;
                n3 = 900;
                break;
            }
            case V2TXLiveVideoResolution960x540: {
                n2 = 800;
                n3 = 1500;
                break;
            }
            case V2TXLiveVideoResolution1280x720: {
                n2 = 1000;
                n3 = 1800;
                break;
            }
            case V2TXLiveVideoResolution1920x1080: {
                n2 = 2500;
                n3 = 3000;
            }
        }
        return new a(n2, n3);
    }

    public static String removeURLSensitiveInfo(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        try {
            String[] stringArray = new String[]{"roomsig", "privatemapkey", "usersig"};
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                int n2;
                if (!url.contains(stringArray[i2]) || (n2 = url.indexOf(stringArray[i2])) == -1) continue;
                int n3 = url.indexOf("&", n2);
                url = n3 == -1 ? url.substring(0, n2) : url.substring(0, n2) + url.substring(n3);
            }
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "remove url sensitive info failed.", exception);
        }
        return url;
    }

    public static boolean isNextPlayerStatusValid(V2TXLiveDef.V2TXLivePlayStatus currentStatus, V2TXLiveDef.V2TXLivePlayStatus nextStatus, V2TXLiveDef.V2TXLiveStatusChangeReason reason) {
        boolean bl = false;
        switch (currentStatus) {
            case V2TXLivePlayStatusPlaying: {
                if (nextStatus == V2TXLiveDef.V2TXLivePlayStatus.V2TXLivePlayStatusLoading && reason == V2TXLiveDef.V2TXLiveStatusChangeReason.V2TXLiveStatusChangeReasonBufferingBegin) {
                    bl = true;
                    break;
                }
                if (nextStatus != V2TXLiveDef.V2TXLivePlayStatus.V2TXLivePlayStatusStopped || reason != V2TXLiveDef.V2TXLiveStatusChangeReason.V2TXLiveStatusChangeReasonLocalStopped && reason != V2TXLiveDef.V2TXLiveStatusChangeReason.V2TXLiveStatusChangeReasonRemoteStopped && reason != V2TXLiveDef.V2TXLiveStatusChangeReason.V2TXLiveStatusChangeReasonRemoteOffline) break;
                bl = true;
                break;
            }
            case V2TXLivePlayStatusLoading: {
                if (nextStatus == V2TXLiveDef.V2TXLivePlayStatus.V2TXLivePlayStatusPlaying && reason == V2TXLiveDef.V2TXLiveStatusChangeReason.V2TXLiveStatusChangeReasonBufferingEnd || reason == V2TXLiveDef.V2TXLiveStatusChangeReason.V2TXLiveStatusChangeReasonLocalStarted) {
                    bl = true;
                    break;
                }
                if (nextStatus != V2TXLiveDef.V2TXLivePlayStatus.V2TXLivePlayStatusStopped || reason != V2TXLiveDef.V2TXLiveStatusChangeReason.V2TXLiveStatusChangeReasonLocalStopped && reason != V2TXLiveDef.V2TXLiveStatusChangeReason.V2TXLiveStatusChangeReasonRemoteStopped && reason != V2TXLiveDef.V2TXLiveStatusChangeReason.V2TXLiveStatusChangeReasonRemoteOffline) break;
                bl = true;
                break;
            }
            case V2TXLivePlayStatusStopped: {
                if (nextStatus != V2TXLiveDef.V2TXLivePlayStatus.V2TXLivePlayStatusPlaying || reason != V2TXLiveDef.V2TXLiveStatusChangeReason.V2TXLiveStatusChangeReasonLocalStarted && reason != V2TXLiveDef.V2TXLiveStatusChangeReason.V2TXLiveStatusChangeReasonRemoteStarted) break;
                bl = true;
            }
        }
        if (!bl) {
            TXCLog.e(TAG, "play state invalid.[current:" + (Object)((Object)currentStatus) + "][next:" + (Object)((Object)nextStatus) + "][reason:" + (Object)((Object)reason) + "]");
        }
        return bl;
    }

    public static int getFinalResolution(int rtmpResolution, boolean isPortrait, boolean isCameraCapture) {
        isPortrait = isCameraCapture ? true : isPortrait;
        int n2 = -1;
        switch (rtmpResolution) {
            case 17: 
            case 18: 
            case 19: {
                n2 = rtmpResolution;
                break;
            }
            case 11: {
                if (isPortrait) {
                    n2 = 11;
                    break;
                }
                n2 = 14;
                break;
            }
            case 12: {
                if (isPortrait) {
                    n2 = 12;
                    break;
                }
                n2 = 15;
                break;
            }
            case 13: {
                if (isPortrait) {
                    n2 = 13;
                    break;
                }
                n2 = 16;
                break;
            }
            case 7: {
                if (isPortrait) {
                    n2 = 7;
                    break;
                }
                n2 = 9;
                break;
            }
            case 8: {
                if (isPortrait) {
                    n2 = 8;
                    break;
                }
                n2 = 10;
                break;
            }
            case 0: {
                if (isPortrait) {
                    n2 = 0;
                    break;
                }
                n2 = 3;
                break;
            }
            case 1: {
                if (isPortrait) {
                    n2 = 1;
                    break;
                }
                n2 = 4;
                break;
            }
            case 2: {
                if (isPortrait) {
                    n2 = 2;
                    break;
                }
                n2 = 5;
                break;
            }
            case 30: {
                n2 = isPortrait ? 30 : 31;
            }
        }
        if (n2 == -1) {
            TXCLog.e(TAG, "getFinalResolution: seriously error!!! can't map resolution, use original resolution.");
            n2 = rtmpResolution;
        }
        TXCLog.i(TAG, "getFinalResolution: [old res:" + rtmpResolution + "][new res:" + n2 + "]");
        return n2;
    }

    public static class a {
        public int a;
        public int b;

        public a(int n2, int n3) {
            this.a = n2;
            this.b = n3;
        }
    }

    public static class b {
        public int a;
        public int b;

        public b(int n2, int n3) {
            this.a = n2;
            this.b = n3;
        }
    }
}

