/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Surface;
import com.tencent.liteav.TXCRenderAndDec;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.module.TXCStatus;
import com.tencent.liteav.renderer.e;
import com.tencent.liteav.trtc.impl.TRTCCloudImpl;
import com.tencent.liteav.trtc.impl.TRTCRoomInfo;
import com.tencent.rtmp.ITXLivePlayListener;
import com.tencent.rtmp.ITXLivePushListener;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.trtc.TRTCCloudDef;
import com.tencent.trtc.TRTCStatistics;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class WXTRTCCloud
extends TRTCCloudImpl {
    private static final String TAG = "WXTRTCCloud";
    private static WXTRTCCloud sInstance = null;
    private HashMap<String, a> mMapAudioVolumeListener = new HashMap();
    private HashMap<String, Integer> mMapLastUserVolumes = new HashMap();
    private WeakReference<ITXLivePushListener> mPushListener = null;
    private HashMap<String, WeakReference<ITXLivePlayListener>> mMapMainStreamPlayListener = new HashMap();
    private HashMap<String, WeakReference<ITXLivePlayListener>> mMapSubStreamPlayListener = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WXTRTCCloud sharedInstance(Context context) {
        Class<WXTRTCCloud> clazz = WXTRTCCloud.class;
        synchronized (WXTRTCCloud.class) {
            if (sInstance == null) {
                sInstance = new WXTRTCCloud(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroySharedInstance() {
        Class<WXTRTCCloud> clazz = WXTRTCCloud.class;
        synchronized (WXTRTCCloud.class) {
            if (sInstance != null) {
                TXCLog.i(TAG, "trtc_api destroy instance " + sInstance);
                sInstance.destroy();
                sInstance = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public WXTRTCCloud(Context context) {
        super(context);
        this.mConfig.X = false;
        this.mConfig.k = 1;
        this.mCaptureAndEnc.a(this.mConfig);
        this.mCaptureAndEnc.h(false);
        this.setLocalViewFillMode(0);
    }

    @Override
    public void enterRoom(TRTCCloudDef.TRTCParams params, int appScene) {
        super.enterRoom(params, appScene);
    }

    @Override
    public void exitRoom() {
        super.exitRoom();
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                WXTRTCCloud.this.mMapAudioVolumeListener.clear();
                WXTRTCCloud.this.mMapLastUserVolumes.clear();
                WXTRTCCloud.this.mMapMainStreamPlayListener.clear();
                WXTRTCCloud.this.mMapSubStreamPlayListener.clear();
            }
        });
    }

    @Override
    public void startLocalAudio() {
        this.mEnableEosMode = true;
        super.startLocalAudio();
    }

    public void setConfig(boolean touchFocus, boolean enableZoom) {
        if (touchFocus != this.mConfig.L || enableZoom != this.mConfig.M) {
            this.mConfig.L = touchFocus;
            this.mConfig.M = enableZoom;
            this.mCaptureAndEnc.a(this.mConfig);
        }
    }

    public int getMaxZoom() {
        return this.mCaptureAndEnc.r();
    }

    public void setFocusPosition(float x2, float y2) {
        this.mCaptureAndEnc.a(x2, y2);
    }

    @Override
    public void setLocalSurface(final Surface surface) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                WXTRTCCloud.this.apiLog("setLocalSurface " + surface);
                WXTRTCCloud.this.mCaptureAndEnc.a(surface);
            }
        });
    }

    @Override
    public void setLocalSurfaceSize(final int width, final int height) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                WXTRTCCloud.this.apiLog("setLocalSurfaceSize: " + width + "," + height);
                WXTRTCCloud.this.mCaptureAndEnc.a(width, height);
            }
        });
    }

    public void pausePusher() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                WXTRTCCloud.this.apiLog("pausePusher");
                if (WXTRTCCloud.this.mCaptureAndEnc != null) {
                    WXTRTCCloud.this.mCaptureAndEnc.h();
                }
            }
        });
    }

    public void resumePusher() {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                WXTRTCCloud.this.apiLog("resumePusher");
                if (WXTRTCCloud.this.mCaptureAndEnc != null) {
                    WXTRTCCloud.this.mCaptureAndEnc.i();
                }
            }
        });
    }

    public void enableBlackStream(final boolean enable) {
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                WXTRTCCloud.this.apiLog("enableBlackStream " + enable);
                if (WXTRTCCloud.this.mCaptureAndEnc != null) {
                    WXTRTCCloud.this.mCaptureAndEnc.c(enable);
                }
            }
        });
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (enable) {
                    WXTRTCCloud.this.nativeAddUpstream(WXTRTCCloud.this.mNativeRtcContext, 2);
                }
            }
        });
    }

    public void setRemoteSurface(final String userId, final Surface surface) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                WXTRTCCloud.this.apiLog("setRemoteSurface " + userId + ", " + surface);
                TRTCRoomInfo.UserInfo userInfo = WXTRTCCloud.this.mRoomInfo.getUser(userId);
                if (userInfo != null) {
                    TXCRenderAndDec tXCRenderAndDec = userInfo.mainRender.render;
                    if (tXCRenderAndDec != null) {
                        e e2 = tXCRenderAndDec.getVideoRender();
                        if (e2 != null) {
                            e2.a(surface);
                        } else {
                            WXTRTCCloud.this.apiLog("videoRender no exist");
                        }
                    } else {
                        WXTRTCCloud.this.apiLog("render no exist");
                    }
                } else {
                    WXTRTCCloud.this.apiLog("user no exist");
                }
            }
        });
    }

    public void setRemoteSurfaceSize(final String userId, final int width, final int height) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                WXTRTCCloud.this.apiLog("seRemoteSurfaceSize: " + userId + ", " + width + "," + height);
                TRTCRoomInfo.UserInfo userInfo = WXTRTCCloud.this.mRoomInfo.getUser(userId);
                if (userInfo != null) {
                    TXCRenderAndDec tXCRenderAndDec = userInfo.mainRender.render;
                    if (tXCRenderAndDec != null) {
                        e e2 = tXCRenderAndDec.getVideoRender();
                        if (e2 != null) {
                            e2.d(width, height);
                        } else {
                            WXTRTCCloud.this.apiLog("videoRender no exist");
                        }
                    } else {
                        WXTRTCCloud.this.apiLog("render no exist");
                    }
                } else {
                    WXTRTCCloud.this.apiLog("user no exist");
                }
            }
        });
    }

    public void setRemoteSubStreamSurface(final String userId, final Surface surface) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                WXTRTCCloud.this.apiLog("setRemoteSubStreamSurface " + userId + ", " + surface);
                TRTCRoomInfo.UserInfo userInfo = WXTRTCCloud.this.mRoomInfo.getUser(userId);
                if (userInfo != null) {
                    TXCRenderAndDec tXCRenderAndDec = userInfo.subRender.render;
                    if (tXCRenderAndDec != null) {
                        e e2 = tXCRenderAndDec.getVideoRender();
                        if (e2 != null) {
                            e2.a(surface);
                        } else {
                            WXTRTCCloud.this.apiLog("videoRender no exist");
                        }
                    } else {
                        WXTRTCCloud.this.apiLog("render no exist");
                    }
                } else {
                    WXTRTCCloud.this.apiLog("user no exist");
                }
            }
        });
    }

    public void setRemoteSubStreamSurfaceSize(final String userId, final int width, final int height) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                WXTRTCCloud.this.apiLog("seRemoteSubStreamSurfaceSize: " + userId + ", " + width + "," + height);
                TRTCRoomInfo.UserInfo userInfo = WXTRTCCloud.this.mRoomInfo.getUser(userId);
                if (userInfo != null) {
                    TXCRenderAndDec tXCRenderAndDec = userInfo.subRender.render;
                    if (tXCRenderAndDec != null) {
                        e e2 = tXCRenderAndDec.getVideoRender();
                        if (e2 != null) {
                            e2.d(width, height);
                        } else {
                            WXTRTCCloud.this.apiLog("videoRender no exist");
                        }
                    } else {
                        WXTRTCCloud.this.apiLog("render no exist");
                    }
                } else {
                    WXTRTCCloud.this.apiLog("user no exist");
                }
            }
        });
    }

    public void registerAudioVolumeEvaluationListener(final String userId, final boolean subStream, final ITXAudioVolumeEvaluationListener listener) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                a a2 = null;
                if (WXTRTCCloud.this.mMapAudioVolumeListener.containsKey(userId)) {
                    a2 = (a)WXTRTCCloud.this.mMapAudioVolumeListener.get(userId);
                } else {
                    a2 = new a();
                    a2.a = 0;
                }
                if (a2 != null) {
                    if (subStream) {
                        a2.c = new WeakReference<ITXAudioVolumeEvaluationListener>(listener);
                    } else {
                        a2.b = new WeakReference<ITXAudioVolumeEvaluationListener>(listener);
                    }
                    WXTRTCCloud.this.mMapAudioVolumeListener.put(userId, a2);
                }
            }
        });
    }

    public void unregisterAudioVolumeEvaluationListener(final String userId, final boolean subStream) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (WXTRTCCloud.this.mMapAudioVolumeListener.containsKey(userId)) {
                    a a2 = (a)WXTRTCCloud.this.mMapAudioVolumeListener.get(userId);
                    if (a2 != null) {
                        if (subStream) {
                            a2.c = null;
                        } else {
                            a2.b = null;
                        }
                        if (a2.b == null && a2.c == null) {
                            WXTRTCCloud.this.mMapAudioVolumeListener.remove(userId);
                        }
                    } else {
                        WXTRTCCloud.this.mMapAudioVolumeListener.remove(userId);
                    }
                }
            }
        });
    }

    public void notifyUserVoiceVolume(final ArrayList<TRTCCloudDef.TRTCVolumeInfo> userVolumes, int totalVolume) {
        this.runOnSDKThread(new Runnable(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                Object object;
                Object object22;
                Object object3;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (userVolumes == null || userVolumes.size() == 0) {
                    if (WXTRTCCloud.this.mMapLastUserVolumes.size() > 0) {
                        for (String string : WXTRTCCloud.this.mMapLastUserVolumes.keySet()) {
                            object3 = new TRTCCloudDef.TRTCVolumeInfo();
                            ((TRTCCloudDef.TRTCVolumeInfo)object3).userId = string;
                            ((TRTCCloudDef.TRTCVolumeInfo)object3).volume = 0;
                            arrayList.add(object3);
                        }
                        WXTRTCCloud.this.mMapLastUserVolumes.clear();
                    }
                } else {
                    Iterator iterator = userVolumes;
                    Collections.sort(iterator, new Comparator<TRTCCloudDef.TRTCVolumeInfo>(){

                        public int a(TRTCCloudDef.TRTCVolumeInfo tRTCVolumeInfo, TRTCCloudDef.TRTCVolumeInfo tRTCVolumeInfo2) {
                            return tRTCVolumeInfo2.volume - tRTCVolumeInfo.volume;
                        }

                        @Override
                        public /* synthetic */ int compare(Object object, Object object2) {
                            return this.a((TRTCCloudDef.TRTCVolumeInfo)object, (TRTCCloudDef.TRTCVolumeInfo)object2);
                        }
                    });
                    boolean n2 = false;
                    object3 = new HashMap();
                    Iterator<Object> n3 = ((ArrayList)((Object)iterator)).iterator();
                    while (n3.hasNext()) {
                        void tRTCVolumeInfo;
                        object22 = (TRTCCloudDef.TRTCVolumeInfo)n3.next();
                        if (tRTCVolumeInfo >= 10) break;
                        if (((TRTCCloudDef.TRTCVolumeInfo)object22).volume <= 10) continue;
                        ++tRTCVolumeInfo;
                        ((HashMap)object3).put(((TRTCCloudDef.TRTCVolumeInfo)object22).userId, ((TRTCCloudDef.TRTCVolumeInfo)object22).volume);
                        arrayList.add(object22);
                    }
                    for (Object object22 : WXTRTCCloud.this.mMapLastUserVolumes.keySet()) {
                        if (((HashMap)object3).containsKey(object22)) continue;
                        object = new TRTCCloudDef.TRTCVolumeInfo();
                        ((TRTCCloudDef.TRTCVolumeInfo)object).userId = object22;
                        ((TRTCCloudDef.TRTCVolumeInfo)object).volume = 0;
                        arrayList.add(object);
                    }
                    WXTRTCCloud.this.mMapLastUserVolumes.clear();
                    WXTRTCCloud.this.mMapLastUserVolumes.putAll(object3);
                }
                for (TRTCCloudDef.TRTCVolumeInfo tRTCVolumeInfo : arrayList) {
                    object3 = tRTCVolumeInfo.userId;
                    int n2 = tRTCVolumeInfo.volume;
                    if (!WXTRTCCloud.this.mMapAudioVolumeListener.keySet().contains(object3) || (object22 = (a)WXTRTCCloud.this.mMapAudioVolumeListener.get(object3)) == null || n2 == ((a)object22).a) continue;
                    ((a)object22).a = n2;
                    object = null;
                    if (((a)object22).b != null) {
                        object = (ITXAudioVolumeEvaluationListener)((a)object22).b.get();
                    } else if (((a)object22).c != null) {
                        object = (ITXAudioVolumeEvaluationListener)((a)object22).c.get();
                    }
                    if (object == null) continue;
                    object.onAudioVolumeEvaluationNotify(n2);
                }
            }
        });
    }

    public void setPushListener(ITXLivePushListener listener) {
        this.mPushListener = new WeakReference<ITXLivePushListener>(listener);
    }

    public void registerPlayListener(final String userId, final boolean subStream, final ITXLivePlayListener listener) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (subStream) {
                    WXTRTCCloud.this.mMapSubStreamPlayListener.put(userId, new WeakReference<ITXLivePlayListener>(listener));
                } else {
                    WXTRTCCloud.this.mMapMainStreamPlayListener.put(userId, new WeakReference<ITXLivePlayListener>(listener));
                }
            }
        });
    }

    public void unregisterPlayListener(final String userId, final boolean subStream) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (subStream) {
                    WXTRTCCloud.this.mMapSubStreamPlayListener.remove(userId);
                } else {
                    WXTRTCCloud.this.mMapMainStreamPlayListener.remove(userId);
                }
            }
        });
    }

    @Override
    protected void notifyEvent(final String userId, final int eventCode, final Bundle eventParam) {
        super.notifyEvent(userId, eventCode, eventParam);
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (TextUtils.isEmpty((CharSequence)userId) || ((WXTRTCCloud)WXTRTCCloud.this).mRoomInfo.userId != null && userId.equalsIgnoreCase(((WXTRTCCloud)WXTRTCCloud.this).mRoomInfo.userId)) {
                    ITXLivePushListener iTXLivePushListener;
                    if (WXTRTCCloud.this.mPushListener != null && (iTXLivePushListener = (ITXLivePushListener)WXTRTCCloud.this.mPushListener.get()) != null) {
                        iTXLivePushListener.onPushEvent(eventCode, eventParam);
                    }
                } else {
                    int n2 = eventParam.getInt("EVT_STREAM_TYPE", 2);
                    TRTCRoomInfo.UserInfo userInfo = WXTRTCCloud.this.mRoomInfo.getUser(userId);
                    if (userInfo != null) {
                        ITXLivePlayListener iTXLivePlayListener;
                        Reference reference = null;
                        if (n2 == 7) {
                            if (WXTRTCCloud.this.mMapSubStreamPlayListener.keySet().contains(userId)) {
                                reference = (WeakReference)WXTRTCCloud.this.mMapSubStreamPlayListener.get(userId);
                            }
                        } else if (WXTRTCCloud.this.mMapMainStreamPlayListener.keySet().contains(userId)) {
                            reference = (WeakReference)WXTRTCCloud.this.mMapMainStreamPlayListener.get(userId);
                        }
                        if (reference != null && (iTXLivePlayListener = (ITXLivePlayListener)reference.get()) != null) {
                            iTXLivePlayListener.onPlayEvent(eventCode, eventParam);
                        }
                    }
                }
            }
        });
    }

    public void notifyStatistics(final TRTCStatistics statics) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9 = statics.appCpu;
                int n10 = statics.systemCpu;
                String string = String.format("%d%%|%d%%", n9, n10);
                String string2 = TXCStatus.b("18446744073709551615", 10001);
                for (TRTCStatistics.TRTCLocalStatistics object : statics.localArray) {
                    ITXLivePushListener iTXLivePushListener;
                    if (object.streamType != 0) continue;
                    n8 = object.width;
                    int n11 = object.height;
                    n7 = object.frameRate;
                    n6 = object.videoBitrate;
                    n5 = object.audioBitrate;
                    n4 = n5 + n6;
                    n3 = WXTRTCCloud.this.getNetworkQuality(statics.rtt, statics.upLoss);
                    n2 = 0;
                    if (WXTRTCCloud.this.mAppScene == 1) {
                        n2 = TXCStatus.c("18446744073709551615", 4006);
                        if (n7 > 0) {
                            n2 = (int)((double)((float)(10 * n2 / n7) / 10.0f) + 0.5);
                        }
                    }
                    Bundle bundle = new Bundle();
                    bundle.putString("CPU_USAGE", string);
                    bundle.putInt("VIDEO_WIDTH", n8);
                    bundle.putInt("VIDEO_HEIGHT", n11);
                    bundle.putInt("VIDEO_FPS", n7);
                    bundle.putInt("VIDEO_GOP", n2);
                    bundle.putInt("NET_SPEED", n4);
                    bundle.putInt("VIDEO_BITRATE", n6);
                    bundle.putInt("AUDIO_BITRATE", n5);
                    bundle.putString("AUDIO_PLAY_INFO", "");
                    bundle.putString("SERVER_IP", string2);
                    bundle.putInt("NET_QUALITY_LEVEL", n3);
                    if (WXTRTCCloud.this.mPushListener == null || (iTXLivePushListener = (ITXLivePushListener)WXTRTCCloud.this.mPushListener.get()) == null) continue;
                    iTXLivePushListener.onNetStatus(bundle);
                }
                for (TRTCStatistics.TRTCRemoteStatistics tRTCRemoteStatistics : statics.remoteArray) {
                    ITXLivePlayListener iTXLivePlayListener;
                    n8 = tRTCRemoteStatistics.streamType;
                    String string3 = tRTCRemoteStatistics.userId;
                    n7 = tRTCRemoteStatistics.width;
                    n6 = tRTCRemoteStatistics.height;
                    n5 = tRTCRemoteStatistics.frameRate;
                    n4 = tRTCRemoteStatistics.videoBitrate;
                    n3 = tRTCRemoteStatistics.audioBitrate;
                    n2 = n3 + n4;
                    int n12 = 0;
                    int n13 = 0;
                    int n14 = 0;
                    int n15 = 0;
                    int n16 = WXTRTCCloud.this.getNetworkQuality(statics.rtt, tRTCRemoteStatistics.finalLoss);
                    TRTCRoomInfo.UserInfo userInfo = WXTRTCCloud.this.mRoomInfo.getUser(string3);
                    if (userInfo != null) {
                        int n17 = 2;
                        switch (n8) {
                            case 0: {
                                n17 = 2;
                                break;
                            }
                            case 1: {
                                n17 = 3;
                                break;
                            }
                            case 2: {
                                n17 = 7;
                                break;
                            }
                        }
                        n12 = TXCStatus.c(userInfo.userID, 2007);
                        n13 = TXCStatus.c(userInfo.userID, 6104, n17);
                        n15 = TXCStatus.c(userInfo.userID, 6105, n17);
                        n14 = TXCStatus.c(userInfo.userID, 6106, n17);
                    }
                    Bundle bundle = new Bundle();
                    bundle.putString("CPU_USAGE", string);
                    bundle.putInt("VIDEO_WIDTH", n7);
                    bundle.putInt("VIDEO_HEIGHT", n6);
                    bundle.putInt("VIDEO_FPS", n5);
                    bundle.putInt("NET_SPEED", n2);
                    bundle.putInt("VIDEO_BITRATE", n4);
                    bundle.putInt("AUDIO_BITRATE", n3);
                    bundle.putInt("AUDIO_CACHE", n12);
                    bundle.putInt("VIDEO_CACHE", n13);
                    bundle.putInt("V_SUM_CACHE_SIZE", n15);
                    bundle.putInt("V_DEC_CACHE_SIZE", n14);
                    bundle.putString("AUDIO_PLAY_INFO", "");
                    bundle.putString("SERVER_IP", string2);
                    bundle.putInt("NET_QUALITY_LEVEL", n16);
                    Reference reference = null;
                    if (n8 == 2) {
                        if (WXTRTCCloud.this.mMapSubStreamPlayListener.keySet().contains(string3)) {
                            reference = (WeakReference)WXTRTCCloud.this.mMapSubStreamPlayListener.get(string3);
                        }
                    } else if (WXTRTCCloud.this.mMapMainStreamPlayListener.keySet().contains(string3)) {
                        reference = (WeakReference)WXTRTCCloud.this.mMapMainStreamPlayListener.get(string3);
                    }
                    if (reference == null || (iTXLivePlayListener = (ITXLivePlayListener)reference.get()) == null) continue;
                    iTXLivePlayListener.onNetStatus(bundle);
                }
            }
        });
    }

    @Override
    protected void checkDashBoard() {
        final TXCloudVideoView tXCloudVideoView = this.mRoomInfo.localView;
        if (tXCloudVideoView != null) {
            final CharSequence charSequence = this.getUploadStreamInfo();
            TXCLog.i(TAG, "[STATUS]" + charSequence.toString().replace("\n", ""));
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    tXCloudVideoView.setDashBoardStatusInfo(charSequence);
                }
            });
        }
        this.mRoomInfo.forEachUser(new TRTCRoomInfo.UserAction(){

            @Override
            public void accept(String userId, TRTCRoomInfo.UserInfo userInfo) {
                if (userInfo.mainRender.render != null && userInfo.mainRender.render.isRendering()) {
                    userInfo.mainRender.render.updateLoadInfo();
                }
                if (userInfo.subRender.render != null && userInfo.subRender.render.isRendering()) {
                    userInfo.subRender.render.updateLoadInfo();
                }
                WXTRTCCloud.this.checkRemoteDashBoard(userInfo.mainRender.view, userInfo.mainRender.render, userInfo);
                WXTRTCCloud.this.checkRemoteDashBoard(userInfo.subRender.view, userInfo.subRender.render, userInfo);
            }
        });
    }

    public void notifySEIMessage(final String userId, final byte[] data) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (data != null && data.length > 0) {
                    ITXLivePlayListener iTXLivePlayListener;
                    WeakReference weakReference = null;
                    if (WXTRTCCloud.this.mMapMainStreamPlayListener.keySet().contains(userId)) {
                        weakReference = (WeakReference)WXTRTCCloud.this.mMapMainStreamPlayListener.get(userId);
                    } else if (WXTRTCCloud.this.mMapSubStreamPlayListener.keySet().contains(userId)) {
                        weakReference = (WeakReference)WXTRTCCloud.this.mMapSubStreamPlayListener.get(userId);
                    }
                    if (weakReference != null && (iTXLivePlayListener = (ITXLivePlayListener)weakReference.get()) != null) {
                        Bundle bundle = new Bundle();
                        bundle.putByteArray("EVT_GET_MSG", data);
                        iTXLivePlayListener.onPlayEvent(2012, bundle);
                    }
                }
            }
        });
    }

    public static interface ITXAudioVolumeEvaluationListener {
        public void onAudioVolumeEvaluationNotify(int var1);
    }

    private static class a {
        public int a;
        public WeakReference<ITXAudioVolumeEvaluationListener> b = null;
        public WeakReference<ITXAudioVolumeEvaluationListener> c = null;

        private a() {
        }
    }
}

