/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoencoder;

import android.opengl.GLES20;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.opengl.j;
import com.tencent.liteav.basic.structs.TXSNALPacket;
import com.tencent.liteav.basic.util.i;
import com.tencent.liteav.beauty.b.o;
import com.tencent.liteav.videoencoder.TXSVideoEncoderParam;
import com.tencent.liteav.videoencoder.e;
import java.lang.ref.WeakReference;

public class TXCSWVideoEncoder
extends e {
    private static final String TAG = TXCSWVideoEncoder.class.getSimpleName();
    private long mNativeEncoder = 0L;
    private int mBitrate = 0;
    private j mRawFrameFilter;
    private j mResizeFilter;
    private long mPTS = 0L;
    private static final boolean DEBUG = false;
    private int mPushIdx = 0;
    private int mRendIdx = 0;
    private int mPopIdx = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int start(TXSVideoEncoderParam param) {
        super.start(param);
        int n2 = (param.width + 7) / 8 * 8;
        int n3 = (param.height + 1) / 2 * 2;
        if (n2 != param.width || n3 != param.height) {
            TXCLog.w(TAG, "Encode Resolution not supportted, transforming...");
            TXCLog.w(TAG, param.width + "x" + param.height + "-> " + n2 + "x" + n3);
        }
        param.width = n2;
        param.height = n3;
        this.mOutputWidth = n2;
        this.mOutputHeight = n3;
        this.mInputWidth = n2;
        this.mInputHeight = n3;
        this.mRawFrameFilter = null;
        this.mResizeFilter = null;
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.mNativeEncoder = this.nativeInit(new WeakReference<TXCSWVideoEncoder>(this));
            this.nativeSetBitrate(this.mNativeEncoder, this.mBitrate);
            this.nativeSetID(this.mNativeEncoder, this.getID());
            this.nativeStart(this.mNativeEncoder, param);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        TXCLog.i(TAG, "stop->enter with mRawFrameFilter:" + this.mRawFrameFilter);
        this.mGLContextExternal = null;
        long l2 = 0L;
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            l2 = this.mNativeEncoder;
            this.mNativeEncoder = 0L;
        }
        this.nativeStop(l2);
        this.nativeRelease(l2);
        if (this.mRawFrameFilter != null) {
            this.mRawFrameFilter.d();
            this.mRawFrameFilter = null;
        }
        if (this.mResizeFilter != null) {
            this.mResizeFilter.d();
            this.mResizeFilter = null;
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setID(String id) {
        super.setID(id);
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeSetID(this.mNativeEncoder, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFPS(int fps) {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeSetFPS(this.mNativeEncoder, fps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableNearestRPS(int nearestRefSize) {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeEnableNearestRPS(this.mNativeEncoder, nearestRefSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBitrate(int bitrate) {
        this.mBitrate = bitrate;
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeSetBitrate(this.mNativeEncoder, bitrate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBitrateFromQos(int videoBitrate, int totalBitrate) {
        this.mBitrate = videoBitrate;
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeSetBitrateFromQos(this.mNativeEncoder, videoBitrate, totalBitrate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEncodeIdrFpsFromQos(int idrFps) {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeSetEncodeIdrFpsFromQos(this.mNativeEncoder, idrFps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRealFPS() {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            return this.nativeGetRealFPS(this.mNativeEncoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRealBitrate() {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            return this.nativegetRealBitrate(this.mNativeEncoder);
        }
    }

    @Override
    public long pushVideoFrame(int textureID, int width, int height, long ptsMS) {
        return this.pushVideoFrameInternal(textureID, width, height, ptsMS, false);
    }

    @Override
    public long pushVideoFrameSync(int textureID, int width, int height, long ptsMS) {
        return this.pushVideoFrameInternal(textureID, width, height, ptsMS, true);
    }

    @Override
    public long pushVideoFrameAsync(int textureID, int width, int height, long ptsMS) {
        return this.pushVideoFrameInternal(textureID, width, height, ptsMS, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalEOSAndFlush() {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeSignalEOSAndFlush(this.mNativeEncoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRPSRefBitmap(int frameRef, int bitmap, long recvTimestamp) {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeSetRPSRefBitmap(this.mNativeEncoder, frameRef, bitmap, recvTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartIDR() {
        TXCSWVideoEncoder tXCSWVideoEncoder = this;
        synchronized (tXCSWVideoEncoder) {
            this.nativeRestartIDR(this.mNativeEncoder);
        }
    }

    public static long getAndIncreateSeq() {
        return TXCSWVideoEncoder.nativeGetAndIncreaseSeq();
    }

    public static long getAndIncreaseGopIndex() {
        return TXCSWVideoEncoder.nativeGetAndIncreaseGopIndex();
    }

    public static boolean isRPSSupported() {
        return TXCSWVideoEncoder.nativeIsRPSSupported();
    }

    private static void postEventFromNative(WeakReference<TXCSWVideoEncoder> weakSelf, byte[] nalData, int nalType, long gopIndex, long gopFrameIndex, long frameIndex, long refFrameIndex, long pts, long dts, int errCode) {
        TXCSWVideoEncoder tXCSWVideoEncoder = (TXCSWVideoEncoder)weakSelf.get();
        if (tXCSWVideoEncoder != null) {
            TXSNALPacket tXSNALPacket = new TXSNALPacket();
            tXSNALPacket.nalData = nalData;
            tXSNALPacket.nalType = nalType;
            tXSNALPacket.gopIndex = gopIndex;
            tXSNALPacket.gopFrameIndex = gopFrameIndex;
            tXSNALPacket.frameIndex = frameIndex;
            tXSNALPacket.refFremeIndex = refFrameIndex;
            tXSNALPacket.pts = pts;
            tXSNALPacket.dts = dts;
            tXCSWVideoEncoder.callDelegate(tXSNALPacket, errCode);
            if (nalData != null) {
                // empty if block
            }
        }
    }

    private static void onEncodeFinishedFromNative(WeakReference<TXCSWVideoEncoder> weakSelf, int streamType, long gopIndex, long rpsFrameIndex) {
        TXCSWVideoEncoder tXCSWVideoEncoder = (TXCSWVideoEncoder)weakSelf.get();
        if (tXCSWVideoEncoder != null) {
            tXCSWVideoEncoder.onEncodeFinished(streamType, gopIndex, rpsFrameIndex);
        }
    }

    private long pushVideoFrameInternal(int textureID, int width, int height, long ptsMS, final boolean fSync) {
        j j2 = this.mResizeFilter;
        j j3 = this.mRawFrameFilter;
        if (this.mGLContextExternal != null) {
            int n2;
            int n3;
            this.mInputWidth = width;
            this.mInputHeight = height;
            if (j2 == null) {
                this.mResizeFilter = j2 = new j();
                j2.a();
                j2.a(true);
            }
            j2.a(this.mOutputWidth, this.mOutputHeight);
            GLES20.glViewport((int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight);
            if (j2 != null) {
                n3 = (720 - this.mRotation) % 360;
                int n4 = n3 == 90 || n3 == 270 ? this.mOutputHeight : this.mOutputWidth;
                n2 = n3 == 90 || n3 == 270 ? this.mOutputWidth : this.mOutputHeight;
                j2.a(width, height, n3, null, (float)n4 / (float)n2, this.mEnableXMirror, false);
                j2.b(textureID);
            }
            n3 = j2 != null ? j2.l() : textureID;
            int[] nArray = new int[1];
            this.mPTS = ptsMS;
            if (j3 == null) {
                TXCLog.i(TAG, "pushVideoFrameInternal->create mRawFrameFilter");
                this.mRawFrameFilter = j3 = new o(1);
                j3.a(true);
                n2 = j3.a() ? 1 : 0;
                if (n2 == 0) {
                    TXCLog.i(TAG, "pushVideoFrameInternal->destroy mRawFrameFilter, init failed!");
                    this.mRawFrameFilter = null;
                    return 10000004L;
                }
                j3.a(this.mOutputWidth, this.mOutputHeight);
                j3.a(new j.a(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void a(int n2) {
                        TXCSWVideoEncoder tXCSWVideoEncoder = TXCSWVideoEncoder.this;
                        synchronized (tXCSWVideoEncoder) {
                            if (TXCSWVideoEncoder.this.mListener != null) {
                                TXCSWVideoEncoder.this.mListener.n(TXCSWVideoEncoder.this.mStreamType);
                            }
                            if (fSync) {
                                TXCSWVideoEncoder.this.nativeEncodeSync(TXCSWVideoEncoder.this.mNativeEncoder, n3, TXCSWVideoEncoder.this.mOutputWidth, TXCSWVideoEncoder.this.mOutputHeight, TXCSWVideoEncoder.this.mPTS);
                            } else {
                                TXCSWVideoEncoder.this.nativeEncode(TXCSWVideoEncoder.this.mNativeEncoder, n3, TXCSWVideoEncoder.this.mOutputWidth, TXCSWVideoEncoder.this.mOutputHeight, TXCSWVideoEncoder.this.mPTS);
                            }
                        }
                    }
                });
            }
            if (j3 == null) {
                return 10000004L;
            }
            GLES20.glViewport((int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight);
            j3.b(n3);
            n2 = nArray[0];
            if (n2 != 0) {
                this.callDelegate(n2);
            }
        }
        return 0L;
    }

    private native long nativeInit(WeakReference<TXCSWVideoEncoder> var1);

    private native void nativeRelease(long var1);

    private native int nativeStart(long var1, TXSVideoEncoderParam var3);

    private native void nativeStop(long var1);

    private native void nativeSetID(long var1, String var3);

    private native int nativeEncode(long var1, int var3, int var4, int var5, long var6);

    private native int nativeEncodeSync(long var1, int var3, int var4, int var5, long var6);

    private native void nativeSetFPS(long var1, int var3);

    private native void nativeSetBitrate(long var1, int var3);

    private native void nativeSetBitrateFromQos(long var1, int var3, int var4);

    private native void nativeSetEncodeIdrFpsFromQos(long var1, int var3);

    private native void nativeEnableNearestRPS(long var1, int var3);

    private native void nativeSignalEOSAndFlush(long var1);

    private native long nativeGetRealFPS(long var1);

    private native long nativegetRealBitrate(long var1);

    private native void nativeSetRPSRefBitmap(long var1, int var3, int var4, long var5);

    private native void nativeRestartIDR(long var1);

    private static native void nativeClassInit();

    private static native long nativeGetAndIncreaseSeq();

    private static native long nativeGetAndIncreaseGopIndex();

    private static native boolean nativeIsRPSSupported();

    static {
        i.d();
        TXCSWVideoEncoder.nativeClassInit();
    }
}

