/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.live2.impl;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Looper;
import android.text.TextUtils;
import android.view.SurfaceView;
import android.view.TextureView;
import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.basic.license.LicenceCheck;
import com.tencent.liteav.basic.license.f;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.module.Monitor;
import com.tencent.liteav.basic.util.g;
import com.tencent.liteav.basic.util.i;
import com.tencent.liteav.beauty.TXBeautyManager;
import com.tencent.liteav.device.TXDeviceManager;
import com.tencent.liteav.p;
import com.tencent.live2.V2TXLiveDef;
import com.tencent.live2.V2TXLivePusher;
import com.tencent.live2.V2TXLivePusherObserver;
import com.tencent.live2.a.c;
import com.tencent.live2.impl.V2TXLiveUtils;
import com.tencent.live2.impl.a;
import com.tencent.rtmp.ui.TXCloudVideoView;

public class V2TXLivePusherImpl
extends V2TXLivePusher {
    private static final String TAG = "V2-TXLivePusherImpl";
    private static final int PUSH_TYPE_SIMPLE = 101;
    private int mMode;
    private Context mContext;
    private g mMainHandler = new g(Looper.getMainLooper());
    private V2TXLivePusher mInnerPusher;
    private V2TXLiveDef.V2TXLiveMode mURLMode;
    private String mURL;
    private a.b mAsyncState = a.b.a;

    private V2TXLivePusherImpl(Context context, int mode) {
        this.mContext = context.getApplicationContext();
        this.mMode = mode;
        if (mode == 101) {
            this.mInnerPusher = new c(context);
        } else {
            this.apiOnlineError("mode " + mode + " is invalid", false);
        }
    }

    public V2TXLivePusherImpl(Context context, V2TXLiveDef.V2TXLiveMode mode) {
        this.mContext = context.getApplicationContext();
        this.mURLMode = mode;
        this.mInnerPusher = p.a(context, mode);
    }

    @Override
    public void setObserver(final V2TXLivePusherObserver observer) {
        this.apiOnlineLog("setObserver: " + observer, false);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.setObserver(observer);
            }
        });
    }

    @Override
    public int setProperty(final String key, final Object value) {
        if (key != "sendSEIMessage") {
            this.apiOnlineLog("setProperty: key-" + key + " value-" + value, false);
        }
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.setProperty(key, value);
            }
        });
        return 0;
    }

    @Override
    public int setMixTranscodingConfig(V2TXLiveDef.V2TXLiveTranscodingConfig config) {
        this.apiOnlineLog("setMixTranscodingConfig: config-" + config, false);
        if (this.isPushing() != 1) {
            this.apiOnlineError("set mix transcoding config failed. pusher can't set mix transcoding config before calling startPush.", false);
            return -3;
        }
        if (this.mURLMode == V2TXLiveDef.V2TXLiveMode.TXLiveMode_RTMP) {
            this.apiOnlineError("set mix transcoding config failed. pusher isn't support set mix transcoding when RTMP mode.", false);
            return -4;
        }
        final V2TXLiveDef.V2TXLiveTranscodingConfig v2TXLiveTranscodingConfig = config == null ? null : new V2TXLiveDef.V2TXLiveTranscodingConfig(config);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.setMixTranscodingConfig(v2TXLiveTranscodingConfig);
            }
        });
        return 0;
    }

    @Override
    public int sendSeiMessage(final int payloadType, final byte[] data) {
        if (payloadType != 5 && payloadType != 242) {
            this.apiOnlineError("sendSEIMessage payloadType invalid " + payloadType, false);
            return -2;
        }
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.sendSeiMessage(payloadType, data);
            }
        });
        return 0;
    }

    @Override
    public int setRenderView(final TXCloudVideoView view) {
        this.apiOnlineLog("setRenderView: view-" + (view != null ? String.valueOf(((Object)((Object)view)).hashCode()) : "null"), false);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.setRenderView(view);
            }
        });
        return 0;
    }

    @Override
    public int setRenderView(final TextureView view) {
        this.apiOnlineLog("setRenderView: view-" + (view != null ? String.valueOf(view.hashCode()) : "null"), false);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.setRenderView(view);
            }
        });
        return 0;
    }

    @Override
    public int setRenderView(final SurfaceView view) {
        this.apiOnlineLog("setRenderView: view-" + (view != null ? String.valueOf(view.hashCode()) : "null"), false);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.setRenderView(view);
            }
        });
        return 0;
    }

    @Override
    public int setRenderMirror(final V2TXLiveDef.V2TXLiveMirrorType mirrorType) {
        this.apiOnlineLog("setRenderMirror: type-" + (Object)((Object)mirrorType), false);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.setRenderMirror(mirrorType);
            }
        });
        return 0;
    }

    @Override
    public int setRenderRotation(final V2TXLiveDef.V2TXLiveRotation rotation) {
        this.apiOnlineLog("setRenderRotation: rotation-" + (Object)((Object)rotation), false);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.setRenderRotation(rotation);
            }
        });
        return 0;
    }

    @Override
    public int startCamera(final boolean frontCamera) {
        this.apiOnlineLog("startCamera: frontCamera-" + frontCamera, true);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.startCamera(frontCamera);
            }
        });
        return 0;
    }

    @Override
    public int stopCamera() {
        this.apiOnlineLog("stopCamera", true);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.stopCamera();
            }
        });
        return 0;
    }

    @Override
    public int startVirtualCamera(final Bitmap image) {
        this.apiOnlineLog("startVirtualCamera", true);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.startVirtualCamera(image);
            }
        });
        return 0;
    }

    @Override
    public int stopVirtualCamera() {
        this.apiOnlineLog("stopVirtualCamera", true);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.stopVirtualCamera();
            }
        });
        return 0;
    }

    @Override
    public int pauseAudio() {
        this.apiOnlineLog("pauseAudio", true);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.pauseAudio();
            }
        });
        return 0;
    }

    @Override
    public int resumeAudio() {
        this.apiOnlineLog("resumeAudio", true);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.resumeAudio();
            }
        });
        return 0;
    }

    @Override
    public int pauseVideo() {
        this.apiOnlineLog("pauseVideo", true);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.pauseVideo();
            }
        });
        return 0;
    }

    @Override
    public int resumeVideo() {
        this.apiOnlineLog("resumeVideo", true);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.resumeVideo();
            }
        });
        return 0;
    }

    @Override
    public int startScreenCapture() {
        this.apiOnlineLog("startScreenCapture:", true);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.startScreenCapture();
            }
        });
        return 0;
    }

    @Override
    public int stopScreenCapture() {
        this.apiOnlineLog("stopScreenCapture: ", true);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.stopScreenCapture();
            }
        });
        return 0;
    }

    @Override
    public int startMicrophone() {
        this.apiOnlineLog("startMicrophone", true);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.startMicrophone();
            }
        });
        return 0;
    }

    @Override
    public int stopMicrophone() {
        this.apiOnlineLog("stopMicrophone", true);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.stopMicrophone();
            }
        });
        return 0;
    }

    @Override
    public int startPush(final String url) {
        int n2;
        this.apiOnlineLog("startPush: url:" + V2TXLiveUtils.removeURLSensitiveInfo(url), true);
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.apiOnlineError("startPush fail, url invalid:" + url, false);
            return -2;
        }
        if (this.mMode != 101) {
            boolean bl;
            V2TXLiveDef.V2TXLiveMode v2TXLiveMode = V2TXLiveUtils.parseLiveMode(url);
            if (v2TXLiveMode != this.mURLMode) {
                this.apiOnlineError("start push fail. invalid mode.", false);
                return -2;
            }
            if (v2TXLiveMode == V2TXLiveDef.V2TXLiveMode.TXLiveMode_RTC && !(bl = p.a(url))) {
                this.apiOnlineError("start push fail. invalid param. [url:" + url + "]", false);
                return -2;
            }
        }
        if ((n2 = LicenceCheck.a().a((f)null, this.mContext)) != 0) {
            this.apiOnlineError("startPush failed, invalid license, please call setLicenceURL to set a valid license. result: " + n2 + "(-1=InvalidJSON, -2=InvalidSignature, -3=DecodeError, -4=PackageNameError, -5=Outdated, -6=AssetNoLicense, -7=SDcardNoLicense, -8=EmptyFile, -9=LicenseVersionError, -10=NoSDcard, -11=FeatureError)", false);
            return -5;
        }
        this.mAsyncState = a.b.b;
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                if (url.equals(V2TXLivePusherImpl.this.mURL) && V2TXLivePusherImpl.this.mInnerPusher.isPushing() == 1) {
                    V2TXLivePusherImpl.this.apiOnlineError("startPush fail, same url, current is pushing", false);
                    V2TXLivePusherImpl.this.mAsyncState = a.b.a;
                    return;
                }
                if (V2TXLivePusherImpl.this.mInnerPusher.isPushing() == 1) {
                    V2TXLivePusherImpl.this.apiOnlineLog("startPusher\uff0cnow is pushing so stop current push", false);
                    V2TXLivePusherImpl.this.mInnerPusher.stopPush();
                }
                V2TXLivePusherImpl.this.mInnerPusher.startPush(url);
                V2TXLivePusherImpl.this.mURL = url;
                V2TXLivePusherImpl.this.mAsyncState = a.b.a;
            }
        });
        return 0;
    }

    @Override
    public int stopPush() {
        this.apiOnlineLog("stopPush", true);
        this.mAsyncState = a.b.c;
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mURL = null;
                V2TXLivePusherImpl.this.mAsyncState = a.b.a;
                V2TXLivePusherImpl.this.mInnerPusher.stopPush();
            }
        });
        return 0;
    }

    @Override
    public int isPushing() {
        if (this.mAsyncState == a.b.a) {
            return this.mInnerPusher != null ? this.mInnerPusher.isPushing() : 0;
        }
        if (this.mAsyncState == a.b.b) {
            return 1;
        }
        if (this.mAsyncState == a.b.c) {
            return 0;
        }
        return 0;
    }

    @Override
    public int setAudioQuality(final V2TXLiveDef.V2TXLiveAudioQuality quality) {
        this.apiOnlineLog("setAudioQuality: quality-" + (Object)((Object)quality), false);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.setAudioQuality(quality);
            }
        });
        return 0;
    }

    @Override
    public int setVideoQuality(V2TXLiveDef.V2TXLiveVideoEncoderParam param) {
        if (param == null) {
            this.apiOnlineError("setVideoQuality: videoEncoderParam is null.", false);
            return -2;
        }
        this.apiOnlineLog("setVideoQuality: videoEncoderParam-" + param.toString(), false);
        boolean bl = param.minVideoBitrate >= 0 && param.videoBitrate > 0 && param.videoBitrate >= param.minVideoBitrate;
        final V2TXLiveDef.V2TXLiveVideoEncoderParam v2TXLiveVideoEncoderParam = new V2TXLiveDef.V2TXLiveVideoEncoderParam(param.videoResolution);
        v2TXLiveVideoEncoderParam.videoResolutionMode = param.videoResolutionMode;
        if (param.videoFps > 0) {
            v2TXLiveVideoEncoderParam.videoFps = param.videoFps;
        }
        if (bl) {
            v2TXLiveVideoEncoderParam.videoBitrate = param.videoBitrate;
            v2TXLiveVideoEncoderParam.minVideoBitrate = param.minVideoBitrate;
        }
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.setVideoQuality(v2TXLiveVideoEncoderParam);
            }
        });
        return 0;
    }

    @Override
    public TXBeautyManager getBeautyManager() {
        return this.mInnerPusher.getBeautyManager();
    }

    @Override
    public TXDeviceManager getDeviceManager() {
        return this.mInnerPusher.getDeviceManager();
    }

    @Override
    public int snapshot() {
        if (this.isPushing() == 0) {
            this.apiOnlineError("snapshot: snapshot is not allowed before the pusher starts pushing.", false);
            return -3;
        }
        this.apiOnlineLog("snapshot", false);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.snapshot();
            }
        });
        return 0;
    }

    @Override
    public TXAudioEffectManager getAudioEffectManager() {
        return this.mInnerPusher.getAudioEffectManager();
    }

    @Override
    public int setWatermark(final Bitmap bitmap, final float x2, final float y2, final float scale) {
        this.apiOnlineLog("setWatermark:" + bitmap + " x-" + x2 + " y-" + y2 + "scale-" + scale, false);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.setWatermark(bitmap, x2, y2, scale);
            }
        });
        return 0;
    }

    @Override
    public int setEncoderMirror(final boolean mirror) {
        this.apiOnlineLog("setEncoderMirror:" + mirror, false);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.setEncoderMirror(mirror);
            }
        });
        return 0;
    }

    @Override
    public int enableVolumeEvaluation(final int intervalMs) {
        this.apiOnlineLog("enableVolumeEvaluation:" + intervalMs, false);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.enableVolumeEvaluation(intervalMs);
            }
        });
        return 0;
    }

    @Override
    public int enableCustomVideoProcess(final boolean enable, final V2TXLiveDef.V2TXLivePixelFormat format, final V2TXLiveDef.V2TXLiveBufferType type) {
        this.apiOnlineLog("enableCustomVideoProcess\uff1a" + enable + " format:" + (Object)((Object)format) + "type:" + (Object)((Object)type), false);
        if (enable) {
            if (this.mURLMode == V2TXLiveDef.V2TXLiveMode.TXLiveMode_RTC) {
                boolean bl;
                boolean bl2 = bl = format == V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatTexture2D && type == V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeTexture || format == V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatI420 && type == V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteBuffer || format == V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatI420 && type == V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteArray;
                if (!bl) {
                    this.apiOnlineError("enable custom video process fail. nonsupport format or type.", false);
                    return -4;
                }
            } else if (this.mURLMode == V2TXLiveDef.V2TXLiveMode.TXLiveMode_RTMP) {
                boolean bl;
                boolean bl3 = bl = format == V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatTexture2D && type == V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeTexture;
                if (!bl) {
                    this.apiOnlineError("enable custom video process fail. nonsupport format or type.", false);
                    return -4;
                }
            }
        }
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.enableCustomVideoProcess(enable, format, type);
            }
        });
        return 0;
    }

    @Override
    public int enableCustomVideoCapture(final boolean enable) {
        this.apiOnlineLog("enableCustomVideoCapture:" + enable, false);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.enableCustomVideoCapture(enable);
            }
        });
        return 0;
    }

    @Override
    public int sendCustomVideoFrame(V2TXLiveDef.V2TXLiveVideoFrame frame) {
        if (frame == null) {
            this.apiOnlineError("sendCustomVideoFrame frame is null.", false);
            return -2;
        }
        return this.mInnerPusher.sendCustomVideoFrame(frame);
    }

    @Override
    public void showDebugView(final boolean enable) {
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.showDebugView(enable);
            }
        });
    }

    @Override
    public int enableCustomAudioCapture(final boolean enable) {
        this.apiOnlineLog("enableCustomAudioCapture:" + enable, false);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePusherImpl.this.mInnerPusher.enableCustomAudioCapture(enable);
            }
        });
        return 0;
    }

    @Override
    public int sendCustomAudioFrame(V2TXLiveDef.V2TXLiveAudioFrame frame) {
        if (frame == null) {
            this.apiOnlineError("sendCustomAudioFrame frame is null.", false);
            return -2;
        }
        return this.mInnerPusher.sendCustomAudioFrame(frame);
    }

    private void apiOnlineLog(String msg, boolean isOnlineLog) {
        if (msg == null) {
            msg = "";
        }
        if (isOnlineLog) {
            Monitor.a(1, "v2_api_pusher(" + this.hashCode() + ")", msg, 0);
        } else {
            TXCLog.i(TAG, "v2_api_pusher(" + this.hashCode() + ") " + msg);
        }
    }

    private void apiOnlineError(String msg, boolean isOnlineLog) {
        if (msg == null) {
            msg = "";
        }
        if (isOnlineLog) {
            Monitor.a(1, "v2_api_pusher(" + this.hashCode() + ")", msg, 0);
        } else {
            TXCLog.e(TAG, "v2_api_pusher(" + this.hashCode() + ") " + msg);
        }
    }

    private void runOnMainThreadAsync(Runnable runnable) {
        this.mMainHandler.post(runnable);
    }

    static {
        i.d();
    }
}

