/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoencoder;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Range;
import com.tencent.liteav.basic.log.TXCLog;

class a {
    private static String a = "MediaFormatUtil";

    public static MediaFormat a(String string, int n2, int n3, int n4, int n5, int n6) {
        TXCLog.i(a, "createBaseFormat:  mineType:" + string + "  width:" + n2 + "  height:" + n3 + "  bitrate:" + n4 + "  fps:" + n5 + "  gop:" + n6);
        if (n2 == 0 || n3 == 0 || n4 == 0 || n5 == 0) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 18) {
            return null;
        }
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)string, (int)n2, (int)n3);
        mediaFormat.setInteger("bitrate", n4 * 1024);
        mediaFormat.setInteger("frame-rate", n5);
        mediaFormat.setInteger("color-format", 2130708361);
        mediaFormat.setInteger("i-frame-interval", n6);
        return mediaFormat;
    }

    public static void a(MediaFormat mediaFormat, String string, int n2, int n3, boolean bl) {
        TXCLog.i(a, "updateFormat: format:" + mediaFormat + "  mineType:" + string + "  bitrateMod:" + n2 + "  targetProfile:" + n3 + "  fullIFrame:" + bl);
        if (mediaFormat == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        MediaCodecInfo mediaCodecInfo = com.tencent.liteav.videoencoder.a.a(string);
        if (mediaCodecInfo == null) {
            return;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string);
        if (codecCapabilities == null) {
            return;
        }
        codecCapabilities = com.tencent.liteav.videoencoder.a.a(mediaFormat, codecCapabilities, n3, string);
        com.tencent.liteav.videoencoder.a.a(codecCapabilities, n2, mediaFormat, bl);
        com.tencent.liteav.videoencoder.a.a(mediaFormat, codecCapabilities);
        com.tencent.liteav.videoencoder.a.b(mediaFormat, codecCapabilities);
    }

    private static void a(MediaCodecInfo.CodecCapabilities codecCapabilities, int n2, MediaFormat mediaFormat, boolean bl) {
        if (Build.VERSION.SDK_INT >= 21) {
            MediaCodecInfo.EncoderCapabilities encoderCapabilities = codecCapabilities.getEncoderCapabilities();
            if (encoderCapabilities == null) {
                return;
            }
            if (encoderCapabilities.isBitrateModeSupported(n2)) {
                mediaFormat.setInteger("bitrate-mode", n2);
            } else if (bl) {
                if (encoderCapabilities.isBitrateModeSupported(1)) {
                    mediaFormat.setInteger("bitrate-mode", 1);
                } else if (encoderCapabilities.isBitrateModeSupported(2)) {
                    mediaFormat.setInteger("bitrate-mode", 2);
                }
            } else if (encoderCapabilities.isBitrateModeSupported(2)) {
                mediaFormat.setInteger("bitrate-mode", 2);
            }
            Range range = encoderCapabilities.getComplexityRange();
            if (range != null) {
                mediaFormat.setInteger("complexity", ((Integer)range.getUpper()).intValue());
                TXCLog.i(a, "createFormat:MediaFormat.KEY_COMPLEXITY :" + range.getUpper());
            }
        }
    }

    private static MediaCodecInfo.CodecCapabilities a(MediaFormat mediaFormat, MediaCodecInfo.CodecCapabilities codecCapabilities, int n2, String string) {
        int n3 = 0;
        int n4 = 0;
        for (MediaCodecInfo.CodecProfileLevel codecProfileLevel : codecCapabilities.profileLevels) {
            if (codecProfileLevel.profile > n2 || codecProfileLevel.profile < n3 && (codecProfileLevel.profile != n3 || codecProfileLevel.level <= n4)) continue;
            n3 = codecProfileLevel.profile;
            n4 = codecProfileLevel.level;
        }
        mediaFormat.setInteger("profile", n3);
        TXCLog.i(a, "createFormat: targetProfile:" + n3 + "  fixLevel:" + n4);
        if (Build.VERSION.SDK_INT >= 23) {
            mediaFormat.setInteger("level", n4);
            codecCapabilities = MediaCodecInfo.CodecCapabilities.createFromProfileLevel((String)string, (int)n3, (int)n4);
        }
        return codecCapabilities;
    }

    private static void a(MediaFormat mediaFormat, MediaCodecInfo.CodecCapabilities codecCapabilities) {
        if (codecCapabilities == null || mediaFormat == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        int n2 = mediaFormat.getInteger("width");
        int n3 = mediaFormat.getInteger("height");
        MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
        if (videoCapabilities == null) {
            return;
        }
        int n4 = n2;
        int n5 = n3;
        Integer n6 = (Integer)videoCapabilities.getSupportedWidths().getUpper();
        Integer n7 = (Integer)videoCapabilities.getSupportedHeights().getUpper();
        if (n6 < n2 || n7 < n3) {
            float f2 = (float)n6.intValue() / ((float)n2 * 1.0f);
            float f3 = (float)n7.intValue() / ((float)n3 * 1.0f);
            float f4 = Math.min(f3, f2);
            n4 = (int)(f4 * (float)n2);
            n5 = (int)(f4 * (float)n3);
        }
        int n8 = videoCapabilities.getWidthAlignment();
        int n9 = videoCapabilities.getHeightAlignment();
        n8 = Math.max(n8, 2);
        n9 = Math.max(n9, 2);
        n4 = n4 / n8 * n8;
        n5 = n5 / n9 * n9;
        if (n2 != n4 || n3 != n5) {
            mediaFormat.setInteger("width", n4);
            mediaFormat.setInteger("height", n5);
            TXCLog.i(a, "MediaFormatUtil : updateSize () createFormat: fixSize: src:" + n2 + " " + n3 + " fix:" + n4 + " " + n5 + " widthAlignment\uff1a" + n8 + "  heightAlignment\uff1a" + n9 + "   upperW:" + n6 + "  upperH:" + n7);
        }
    }

    private static void b(MediaFormat mediaFormat, MediaCodecInfo.CodecCapabilities codecCapabilities) {
        if (codecCapabilities == null || mediaFormat == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
        if (videoCapabilities == null) {
            return;
        }
        Range range = videoCapabilities.getBitrateRange();
        TXCLog.i(a, "bitrateRange: " + range.getLower() + "  " + range.getUpper());
        int n2 = mediaFormat.getInteger("bitrate");
        TXCLog.i(a, "bitrateRange: " + range.getLower() + "  " + range.getUpper() + ", bitrate = " + n2);
        if (n2 < (Integer)range.getLower()) {
            TXCLog.i(a, "fix bitrate = " + n2 + " to lower " + range.getLower());
            n2 = (Integer)range.getLower();
        }
        if (n2 > (Integer)range.getUpper()) {
            TXCLog.i(a, "fix bitrate = " + n2 + " to upper " + range.getUpper());
            n2 = (Integer)range.getUpper();
        }
        mediaFormat.setInteger("bitrate", n2);
    }

    private static MediaCodecInfo a(String string) {
        int n2 = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            String[] stringArray;
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (!mediaCodecInfo.isEncoder()) continue;
            for (String string2 : stringArray = mediaCodecInfo.getSupportedTypes()) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return mediaCodecInfo;
            }
        }
        return null;
    }
}

