/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoengine.decoder;

import androidx.annotation.NonNull;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.videobase.a.a;
import com.tencent.liteav.videobase.e.b;
import com.tencent.liteav.videobase.f.a;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.f;
import com.tencent.liteav.videoengine.decoder.DecodeFailException;
import com.tencent.liteav.videoengine.decoder.n;
import com.tencent.liteav.videoengine.decoder.o;
import java.nio.ByteBuffer;

public class SoftwareVideoDecoder
implements n {
    private static final String TAG = "FFMPEGVideoDecoder";
    @NonNull
    private final a mReporter;
    private long mNativeHandle = 0L;
    private o mListener;

    public SoftwareVideoDecoder(@NonNull a reporter) {
        this.mReporter = reporter;
    }

    @Override
    public void start(Object glContext, o listener) {
        if (this.mNativeHandle != 0L) {
            TXCLog.w(TAG, "decoder is already started!");
            return;
        }
        this.mListener = listener;
        this.mNativeHandle = this.nativeCreate();
        if (this.mNativeHandle == 0L) {
            this.handleDecoderError(com.tencent.liteav.videobase.f.b.ae, "VideoDecode: out of memory, start decoder failed", "create software decoder failed.", new Object[0]);
            TXCLog.e(TAG, "create native instance failed.");
            return;
        }
        if (!this.nativeStart(this.mNativeHandle)) {
            this.handleDecoderError(com.tencent.liteav.videobase.f.b.af, "VideoDecode: start decoder failed", "", new Object[0]);
            TXCLog.e(TAG, "start software decoder failed.");
            return;
        }
        this.mReporter.a(com.tencent.liteav.videobase.f.b.aa, "VideoDecode: start decoder success", "", new Object[0]);
        TXCLog.i(TAG, "decoder start success.");
    }

    @Override
    public void decode(b frame) {
        PixelFrame pixelFrame;
        if (frame == null) {
            return;
        }
        try {
            pixelFrame = this.nativeDecode(this.mNativeHandle, frame.a, frame.b.a(), frame.d, frame.f);
        }
        catch (DecodeFailException decodeFailException) {
            this.handleDecoderError(com.tencent.liteav.videobase.f.b.an, "VideoDecode: decode error, restart decoder", decodeFailException.getMessage(), new Object[0]);
            TXCLog.e(TAG, "decode failed.", decodeFailException);
            return;
        }
        if (pixelFrame != null && this.mListener != null) {
            this.mListener.onDecodeFrame(pixelFrame, pixelFrame.getTimestamp());
        }
    }

    @Override
    public void stop() {
        if (this.mNativeHandle == 0L) {
            TXCLog.w(TAG, "decoder has already stopped");
            return;
        }
        this.nativeStop(this.mNativeHandle);
        this.nativeDestroy(this.mNativeHandle);
        this.mNativeHandle = 0L;
    }

    @Override
    public n.a getDecoderType() {
        return n.a.b;
    }

    private void handleDecoderError(com.tencent.liteav.videobase.f.b code, String msg, String format, Object ... args) {
        this.mReporter.b(code, msg, format, args);
        if (this.mListener != null) {
            this.mListener.onDecodeFailed(code);
        }
    }

    private static PixelFrame createPixelFrameCallFromNative(ByteBuffer buffer, int formatType, int width, int height, int rotation, long timestamp) throws DecodeFailException {
        a.c c2;
        switch (formatType) {
            case 0: 
            case 4: {
                c2 = a.c.b;
                break;
            }
            case 1: {
                c2 = a.c.c;
                break;
            }
            case 3: {
                c2 = a.c.d;
                break;
            }
            default: {
                throw new DecodeFailException("unknown format " + formatType);
            }
        }
        PixelFrame pixelFrame = new PixelFrame();
        pixelFrame.setPixelBufferType(a.b.b);
        pixelFrame.setPixelFormatType(c2);
        pixelFrame.setBuffer(buffer);
        pixelFrame.setWidth(width);
        pixelFrame.setHeight(height);
        pixelFrame.setRotation(f.a(rotation));
        pixelFrame.setTimestamp(timestamp);
        return pixelFrame;
    }

    private static native void nativeClassInit();

    private native long nativeCreate();

    private native void nativeDestroy(long var1);

    private native boolean nativeStart(long var1);

    private native PixelFrame nativeDecode(long var1, byte[] var3, int var4, int var5, long var6) throws DecodeFailException;

    private native void nativeStop(long var1);

    static {
        SoftwareVideoDecoder.nativeClassInit();
    }
}

