/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.text.TextUtils;
import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.audio.TXAudioEffectManagerImpl;
import com.tencent.liteav.audio.b;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCCommonUtil;
import com.tencent.liteav.basic.util.d;
import com.tencent.liteav.basic.util.i;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class TXCSoundEffectPlayer
implements TXAudioEffectManager.TXMusicPlayObserver {
    private static final String TAG = "AudioCenter:TXCSoundEffectPlayer";
    private static WeakReference<b> mWeakSoundEffectListener;
    private List<Integer> mShortEffectorIDList = new ArrayList<Integer>();

    public static TXCSoundEffectPlayer getInstance() {
        return a.a;
    }

    public boolean playEffectWithId(int effectId, String path, boolean publish, int loopCount) {
        TXCLog.i(TAG, "playEffectWithId -> effect id = " + effectId + ", path = " + path + ", loop = " + loopCount);
        String string = this.checkIfAssetsFile(path);
        TXAudioEffectManager.AudioMusicParam audioMusicParam = new TXAudioEffectManager.AudioMusicParam(effectId, string);
        audioMusicParam.publish = publish;
        audioMusicParam.loopCount = loopCount;
        audioMusicParam.isShortFile = true;
        boolean bl = TXAudioEffectManagerImpl.getCacheInstance().startPlayMusic(audioMusicParam);
        TXAudioEffectManagerImpl.getCacheInstance().setMusicObserver(effectId, this);
        this.mShortEffectorIDList.add(effectId);
        TXCLog.i(TAG, "playEffectWithId ->effect id = " + effectId + ", startPlayMusic result = " + bl);
        return bl;
    }

    public void stopEffectWithId(int effectId) {
        TXCLog.i(TAG, "stopEffectWithId -> effect id = " + effectId);
        TXAudioEffectManagerImpl.getCacheInstance().setMusicObserver(effectId, null);
        TXAudioEffectManagerImpl.getCacheInstance().stopPlayMusic(effectId);
        int n2 = this.mShortEffectorIDList.indexOf(effectId);
        if (n2 >= 0) {
            this.mShortEffectorIDList.remove(n2);
        }
    }

    public void stopAllEffect() {
        TXCLog.i(TAG, "stopAllEffect -> start");
        for (int n2 : this.mShortEffectorIDList) {
            TXAudioEffectManagerImpl.getCacheInstance().stopPlayMusic(n2);
        }
        this.mShortEffectorIDList.clear();
        TXCLog.i(TAG, "stopAllEffect -> finish");
    }

    public void setEffectsVolume(float volume) {
        TXCLog.i(TAG, "setEffectsVolume -> volume = " + volume);
        for (int n2 : this.mShortEffectorIDList) {
            TXAudioEffectManagerImpl.getCacheInstance().setMusicVolume(n2, (int)(volume * 100.0f));
        }
    }

    public void setVolumeOfEffect(int effectId, float volume) {
        TXCLog.i(TAG, "setVolumeOfEffect -> effect id = " + effectId + ", volume = " + volume);
        TXAudioEffectManagerImpl.getCacheInstance().setMusicVolume(effectId, (int)(volume * 100.0f));
    }

    public void pauseEffectWithId(int effectId) {
        TXCLog.i(TAG, "pauseEffectWithId -> effect id = " + effectId);
        TXAudioEffectManagerImpl.getCacheInstance().pausePlayMusic(effectId);
    }

    public void resumeEffectWithId(int effectId) {
        TXCLog.i(TAG, "resumeEffectWithId -> effect id = " + effectId);
        TXAudioEffectManagerImpl.getCacheInstance().resumePlayMusic(effectId);
    }

    public void setSoundEffectListener(b soundListener) {
        mWeakSoundEffectListener = soundListener == null ? null : new WeakReference<b>(soundListener);
    }

    @Override
    public void onPlayProgress(int id, long curPtsMS, long durationMS) {
    }

    @Override
    public void onStart(int id, int errCode) {
        TXCLog.i(TAG, "onStart -> effect id = " + id + ", errCode = " + errCode);
        if (mWeakSoundEffectListener != null && mWeakSoundEffectListener.get() != null) {
            ((b)mWeakSoundEffectListener.get()).onEffectPlayStart(id, errCode);
        }
    }

    @Override
    public void onComplete(int id, int errCode) {
        TXCLog.i(TAG, "onMusicPlayFinish -> effect id = " + id);
        if (mWeakSoundEffectListener != null && mWeakSoundEffectListener.get() != null) {
            ((b)mWeakSoundEffectListener.get()).onEffectPlayFinish(id);
        }
    }

    public void clearCache() {
        if (TXCCommonUtil.getAppContext() == null) {
            return;
        }
        try {
            int n2;
            long l2;
            File file = new File(this.getEffectCachePath());
            if (file.exists() && file.isDirectory() && (l2 = d.a(file)) > (long)(n2 = 0x3200000)) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    file2.delete();
                }
            }
        }
        catch (Exception exception) {
            TXCLog.w(TAG, "clearCache error " + exception.toString());
        }
    }

    private String getEffectCachePath() {
        if (TXCCommonUtil.getAppContext() == null) {
            return "";
        }
        return TXCCommonUtil.getAppContext().getCacheDir() + File.separator + "liteav_effect";
    }

    private String checkIfAssetsFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path) || TXCCommonUtil.getAppContext() == null) {
            return path;
        }
        String string = "/assets/";
        if (!path.startsWith("/assets/")) {
            return path;
        }
        String string2 = path;
        String string3 = string2.substring("/assets/".length());
        try {
            long l2 = 0L;
            try {
                l2 = TXCCommonUtil.getAppContext().getAssets().openFd(string3).getLength();
            }
            catch (Exception exception) {
                TXCLog.e(TAG, "playAudioEffect openFd error " + exception.toString());
                l2 = 0L;
            }
            String string4 = this.getEffectCachePath();
            File file = new File(string4);
            if (!file.exists()) {
                file.mkdirs();
            } else if (file.isFile()) {
                file.delete();
                file.mkdirs();
            }
            int n2 = string3.lastIndexOf(File.separatorChar);
            string2 = n2 != -1 ? string4 + File.separator + l2 + "_" + string3.substring(n2 + 1) : string4 + File.separator + l2 + "_" + string3;
            if (!d.a(string2)) {
                d.a(TXCCommonUtil.getAppContext(), string3, string2);
            }
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "playAudioEffect error " + exception.toString());
        }
        return string2;
    }

    static {
        i.d();
    }

    private static class a {
        private static final TXCSoundEffectPlayer a = new TXCSoundEffectPlayer();
    }
}

