/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.impl.route;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import com.tencent.liteav.audio.impl.TXCAudioEngineJNI;
import com.tencent.liteav.audio.impl.route.a;
import com.tencent.liteav.audio.impl.route.e;
import com.tencent.liteav.audio.impl.route.f;
import com.tencent.liteav.basic.log.TXCLog;

public class TXCAudioNativeInterface {
    private static final String TAG = "AudioNativeInterface";
    private static final int OUTPUT_MODE_HEADSET = 0;
    private static final int OUTPUT_MODE_SPEAKER = 1;
    private final e mAudioRouteManager;
    private final Context mContext;
    private String[] mDeviceList = null;
    private AudioManager mAudioManager = null;
    private f mAudioSession = null;

    public TXCAudioNativeInterface(Context context) {
        this.mContext = context;
        this.mAudioRouteManager = new e(context);
        TXCLog.i(TAG, "AudioDeviceInterface SDK_INT: %d, MANUFACTURE: %s, MODEL: %s", Build.VERSION.SDK_INT, Build.MANUFACTURER, Build.MODEL);
    }

    public void initAudioRouteManager() {
        if (this.mContext == null) {
            return;
        }
        TXCLog.i(TAG, "initAudioManager, TXCAudioSession create");
        if (this.mAudioSession == null) {
            this.mAudioSession = new f(this.mContext, this.mAudioRouteManager, new f.a(){

                @Override
                public void a(String[] stringArray, String string, String string2, String string3) {
                    TXCAudioNativeInterface.access$002(TXCAudioNativeInterface.this, stringArray);
                    TXCAudioNativeInterface.this.notifyPlayoutDeviceChanged(string);
                }

                @Override
                public void a(int n2, String[] stringArray, String string, String string2, String string3) {
                    TXCAudioNativeInterface.access$002(TXCAudioNativeInterface.this, stringArray);
                }

                @Override
                public void a(int n2, String string) {
                    if (n2 == 0) {
                        TXCAudioNativeInterface.this.notifyPlayoutDeviceChanged(string);
                    }
                }
            });
        }
        this.mAudioSession.a("DEVICE_EARPHONE;DEVICE_SPEAKERPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;");
    }

    public int startService(String deviceConfig) {
        TXCLog.i(TAG, "startService: " + (Object)((Object)this.mAudioSession) + " deviceConfig:" + deviceConfig);
        if (this.mAudioSession != null) {
            return this.mAudioSession.a(deviceConfig);
        }
        return -1;
    }

    public void notifyAudioIOSceneChanged(int oldScene, int newScene) {
        a.a a2 = this.nativeValueToAudioIOScene(oldScene);
        a.a a3 = this.nativeValueToAudioIOScene(newScene);
        TXCLog.i(TAG, "notify audio io scene changed, %s -> %s", new Object[]{a2, a3});
        if (!a2.a()) {
            this.mAudioSession.e();
        }
        this.mAudioRouteManager.a(a3);
        if (a3 != a.a.a) {
            AudioManager audioManager = this.getAudioManager();
            if (audioManager != null) {
                this.waitAMomentIfInPhoneCall();
                if (audioManager.isMicrophoneMute()) {
                    audioManager.setMicrophoneMute(false);
                    TXCLog.i(TAG, "setMicrophoneMute false when ioscene changed");
                }
            }
            if (a3.a()) {
                this.updateVolumeTypeForMedia();
            } else {
                this.updateVolumeTypeForVoIP(a3);
            }
        }
    }

    public int setAudioOutputMode(int outputMode) {
        TXCLog.w(TAG, "TXCAudioSession SetAudioOutputMode: " + outputMode);
        if (0 == outputMode) {
            if (null == this.mDeviceList || null == this.mAudioSession) {
                return -1;
            }
            boolean bl = false;
            do {
                int n2;
                for (n2 = 0; n2 < this.mDeviceList.length && !bl; ++n2) {
                    if (!"DEVICE_WIREDHEADSET".equals(this.mDeviceList[n2])) continue;
                    this.mAudioSession.b("DEVICE_WIREDHEADSET");
                    bl = true;
                }
                for (n2 = 0; n2 < this.mDeviceList.length && !bl; ++n2) {
                    if (!"DEVICE_BLUETOOTHHEADSET".equals(this.mDeviceList[n2])) continue;
                    this.mAudioSession.b("DEVICE_BLUETOOTHHEADSET");
                    bl = true;
                }
                for (n2 = 0; n2 < this.mDeviceList.length && !bl; ++n2) {
                    if (!"DEVICE_EARPHONE".equals(this.mDeviceList[n2])) continue;
                    this.mAudioSession.b("DEVICE_EARPHONE");
                    bl = true;
                }
            } while (!bl);
        } else {
            if (1 == outputMode) {
                if (this.mAudioSession == null) {
                    return -1;
                }
                this.mAudioSession.b("DEVICE_SPEAKERPHONE");
                return 0;
            }
            return -1;
        }
        return 0;
    }

    public int stopService() {
        TXCLog.i(TAG, "stopService: " + (Object)((Object)this.mAudioSession));
        if (this.mAudioSession != null) {
            return this.mAudioSession.c();
        }
        return -1;
    }

    public void uninitAudioRouteManager() {
        if (this.mContext != null) {
            TXCLog.w(TAG, "uninitTXCAudioManager , stopService");
            if (this.mAudioSession != null) {
                this.mAudioSession.c();
                this.mAudioSession.b();
                this.mAudioSession = null;
            }
        } else {
            TXCLog.w(TAG, "uninitTXCAudioManager , context null");
        }
    }

    private void updateVolumeTypeForVoIP(a.a ioScene) {
        TXCAudioNativeInterface.LogTraceEntry("");
        int n2 = a.a(ioScene);
        this.mAudioSession.a(n2);
        this.mAudioSession.d();
        TXCAudioNativeInterface.LogTraceExit();
    }

    private void updateVolumeTypeForMedia() {
        TXCAudioNativeInterface.LogTraceEntry("");
        AudioManager audioManager = this.getAudioManager();
        if (audioManager != null && audioManager.getMode() != 0) {
            audioManager.setMode(0);
        }
        this.mAudioSession.d();
        TXCAudioNativeInterface.LogTraceExit();
    }

    private void waitAMomentIfInPhoneCall() {
        AudioManager audioManager = this.getAudioManager();
        if (audioManager == null) {
            return;
        }
        int n2 = 5;
        while (n2-- > 0 && this.mAudioManager.getMode() == 2) {
            TXCLog.e(TAG, "waiting.  mode:" + this.mAudioManager.getMode());
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static String getTraceInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        stringBuilder.append(stackTraceElementArray[2].getClassName()).append(".").append(stackTraceElementArray[2].getMethodName()).append(": ").append(stackTraceElementArray[2].getLineNumber());
        return stringBuilder.toString();
    }

    public static void LogTraceEntry(String msg) {
        String string = TXCAudioNativeInterface.getTraceInfo() + " entry:" + msg;
        TXCLog.i(TAG, string);
    }

    public static void LogTraceExit() {
        String string = TXCAudioNativeInterface.getTraceInfo() + " exit";
        TXCLog.i(TAG, string);
    }

    private AudioManager getAudioManager() {
        if (this.mAudioManager == null && this.mContext != null) {
            this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        }
        return this.mAudioManager;
    }

    private a.a nativeValueToAudioIOScene(int value) {
        a.a[] aArray = new a.a[]{a.a.a, a.a.a, a.a.b, a.a.c, a.a.d, a.a.e, a.a.f};
        if (value >= 0 && value < aArray.length) {
            return aArray[value];
        }
        return a.a.a;
    }

    private void notifyPlayoutDeviceChanged(String strDeviceName) {
        TXCLog.i(TAG, "device: " + strDeviceName);
        int n2 = 0;
        n2 = strDeviceName.equals("DEVICE_EARPHONE") ? 1 : (strDeviceName.equals("DEVICE_SPEAKERPHONE") ? 2 : (strDeviceName.equals("DEVICE_WIREDHEADSET") ? 3 : (strDeviceName.equals("DEVICE_BLUETOOTHHEADSET") ? 4 : 0)));
        TXCAudioEngineJNI.nativeSetPlayoutDevice(n2);
    }

    static /* synthetic */ String[] access$002(TXCAudioNativeInterface x0, String[] x1) {
        x0.mDeviceList = x1;
        return x1;
    }
}

