/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.device;

import android.os.Handler;
import android.os.Looper;
import com.tencent.liteav.audio.TXCAudioEngine;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.module.Monitor;
import com.tencent.liteav.d;
import com.tencent.liteav.device.TXDeviceManager;
import com.tencent.liteav.g;

public class TXDeviceManagerImpl
implements TXDeviceManager {
    public static final String TAG = "TXDeviceManagerImpl";
    public static final int AUDIO_ROUTE_SPEAKER = 0;
    public static final int AUDIO_ROUTE_EARPIECE = 1;
    public static final int SystemVolumeTypeAuto = 0;
    public static final int SystemVolumeTypeMedia = 1;
    public static final int SystemVolumeTypeVOIP = 2;
    private TXDeviceManagerListener mDeviceManagerListener;
    protected d mCaptureAndEnc;
    protected Handler mSDKHandler;
    private boolean mIsFrontCamera;

    protected void runOnSDKThread(Runnable task) {
        if (this.mSDKHandler != null) {
            if (Looper.myLooper() != this.mSDKHandler.getLooper()) {
                this.mSDKHandler.post(task);
            } else {
                task.run();
            }
        }
    }

    public TXDeviceManagerImpl(Handler handler) {
        this.mSDKHandler = handler;
    }

    public void setCaptureAndEnc(d captureAndEnc) {
        this.mCaptureAndEnc = captureAndEnc;
    }

    public void setDeviceManagerListener(TXDeviceManagerListener deviceManagerListener) {
        this.mDeviceManagerListener = deviceManagerListener;
    }

    protected void apiLog(String api) {
        TXCLog.i(TAG, "trtc_api TXDeviceManager:" + api);
    }

    protected void apiOnlineLog(String format, Object ... args) {
        String string = "trtc_api TXDeviceManager:";
        Monitor.a(1, String.format(format, args), "", 0, string);
    }

    public void setFrontCamera(boolean isFrontCamera) {
        this.mIsFrontCamera = isFrontCamera;
    }

    @Override
    public boolean isFrontCamera() {
        return this.mIsFrontCamera;
    }

    @Override
    public int switchCamera(final boolean frontCamera) {
        final boolean bl = this.mIsFrontCamera;
        this.mIsFrontCamera = frontCamera;
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (bl != frontCamera) {
                    TXDeviceManagerImpl.this.mCaptureAndEnc.l();
                    if (TXDeviceManagerImpl.this.mDeviceManagerListener != null) {
                        TXDeviceManagerImpl.this.mDeviceManagerListener.onSwitchCamera(frontCamera);
                    }
                }
            }
        });
        return 0;
    }

    @Override
    public float getCameraZoomMaxRatio() {
        return this.mCaptureAndEnc.r();
    }

    @Override
    public int setCameraZoomRatio(final float zoomRatio) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiLog("setCameraZoomRatio " + zoomRatio);
                TXDeviceManagerImpl.this.mCaptureAndEnc.j((int)zoomRatio);
            }
        });
        return 0;
    }

    @Override
    public int enableCameraAutoFocus(final boolean enabled) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiLog("enableCameraAutoFocus " + enabled);
                g g2 = TXDeviceManagerImpl.this.mCaptureAndEnc.c();
                g2.N = !enabled;
                TXDeviceManagerImpl.this.mCaptureAndEnc.a(g2);
                if (TXDeviceManagerImpl.this.mDeviceManagerListener != null) {
                    TXDeviceManagerImpl.this.mDeviceManagerListener.onSwitchAutoFocus(enabled);
                }
            }
        });
        return 0;
    }

    @Override
    public boolean isAutoFocusEnabled() {
        g g2 = this.mCaptureAndEnc.c();
        return !g2.N;
    }

    @Override
    public boolean enableCameraTorch(boolean enable) {
        this.apiLog("enableCameraTorch " + enable);
        return this.mCaptureAndEnc.f(enable);
    }

    @Override
    public int setCameraFocusPosition(final int x2, final int y2) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiLog("setCameraFocusPosition x:" + x2 + "y:" + y2);
                TXDeviceManagerImpl.this.mCaptureAndEnc.b(x2, y2);
            }
        });
        return 0;
    }

    @Override
    public int setAudioRoute(final TXDeviceManager.TXAudioRoute route) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiOnlineLog("setAudioRoute route:" + (route == TXDeviceManager.TXAudioRoute.TXAudioRouteEarpiece ? "earpiece" : "speakerphone"), new Object[0]);
                switch (route) {
                    case TXAudioRouteSpeakerphone: {
                        TXCAudioEngine.setAudioRoute(0);
                        break;
                    }
                    case TXAudioRouteEarpiece: {
                        TXCAudioEngine.setAudioRoute(1);
                        break;
                    }
                }
            }
        });
        return 0;
    }

    @Override
    public int setSystemVolumeType(final TXDeviceManager.TXSystemVolumeType type) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiOnlineLog("setSystemVolumeType type:%s,  auto(0),media(1),VOIP(2)", type.name());
                switch (type) {
                    case TXSystemVolumeTypeAuto: {
                        TXCAudioEngine.setSystemVolumeType(0);
                        break;
                    }
                    case TXSystemVolumeTypeVOIP: {
                        TXCAudioEngine.setSystemVolumeType(2);
                        break;
                    }
                    case TXSystemVolumeTypeMedia: {
                        TXCAudioEngine.setSystemVolumeType(1);
                    }
                }
                if (TXDeviceManagerImpl.this.mDeviceManagerListener != null) {
                    TXDeviceManagerImpl.this.mDeviceManagerListener.onSwitchSystemVolumeType(type);
                }
            }
        });
        return 0;
    }

    @Override
    public void setCameraCapturerParam(final TXDeviceManager.TXCameraCaptureParam params) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (params == null) {
                    TXDeviceManagerImpl.this.apiLog("setCameraCapturerParam error when params is null");
                    return;
                }
                g g2 = new g();
                switch (params.mode) {
                    case TXCameraResolutionStrategyPerformance: {
                        g2.X = true;
                        g2.W = false;
                        break;
                    }
                    case TXCameraResolutionStrategyHighQuality: {
                        g2.W = true;
                        g2.X = false;
                        break;
                    }
                    case TXCameraCaptureManual: {
                        g2.W = false;
                        g2.X = false;
                        g2.c = params.width;
                        g2.d = params.height;
                        break;
                    }
                    default: {
                        g2.W = false;
                        g2.X = false;
                    }
                }
                TXDeviceManagerImpl.this.apiLog("setCameraCapturerParam mode:" + (Object)((Object)params.mode) + " width:" + params.width + " height:" + params.height);
                if (TXDeviceManagerImpl.this.mDeviceManagerListener != null) {
                    TXDeviceManagerImpl.this.mDeviceManagerListener.onCameraParamChange(g2);
                }
            }
        });
    }

    public static interface TXDeviceManagerListener {
        public void onSwitchCamera(boolean var1);

        public void onSwitchAutoFocus(boolean var1);

        public void onSwitchSystemVolumeType(TXDeviceManager.TXSystemVolumeType var1);

        public void onCameraParamChange(g var1);
    }
}

