/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.network;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.network.TXCStreamDownloader;
import com.tencent.liteav.network.TXIStreamDownloader;
import com.tencent.liteav.network.e;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.SSLException;

public class TXCFLVDownloader
extends TXIStreamDownloader {
    public final String TAG = "network.TXCFLVDownloader";
    private final int FLV_HEAD_SIZE = 9;
    private final int MAX_FRAME_SIZE = 0x100000;
    private final int MSG_CONNECT = 100;
    private final int MSG_RECV_DATA = 101;
    private final int MSG_DISCONNECT = 102;
    private final int MSG_RECONNECT = 103;
    private final int MSG_SEEK = 104;
    private final int MSG_RESUME = 105;
    private final int MSG_QUIT = 106;
    private final int CONNECT_TIMEOUT = 8000;
    private final int READ_STREAM_SIZE = 1388;
    private final int ERROR_CONNECT_SOCKET_TIME_OUT = -1001;
    private final int ERROR_CONNECT_FILE_NOT_FOUND = -1008;
    private final int ERROR_CONNECT_COMMON = -1010;
    private final int ERROR_CONNECT_THROWABLE = -1011;
    private final int ERROR_READ_STREAM_SOCKET_TIME_OUT = -1012;
    private final int ERROR_READ_STREAM_SOCKET = -1013;
    private final int ERROR_READ_STREAM_SSL = -1014;
    private final int ERROR_READ_STREAM_EOF = -1015;
    private final int ERROR_READ_STREAM_COMMON = -1016;
    private final int ERROR_READ_STREAM_THROWABLE = -1017;
    private HandlerThread mFlvThread = null;
    private Handler mFlvHandler = null;
    private InputStream mInputStream = null;
    private HttpURLConnection mConnection = null;
    private byte[] mPacketBytes = null;
    private boolean mRecvData = false;
    private long mContentLength = 0L;
    private long mDownloadedSize = 0L;
    private boolean mHandleDataInJava = false;
    private long mFLVParser = 0L;
    private long mCurrentNalTs = 0L;
    private long mLastIFramelTs = 0L;
    private boolean mStopJitter = true;
    private String mPlayUrl = "";
    private boolean mHasReceivedFirstVideo = false;
    private boolean mHasReceivedFirstAudio = false;
    private TXCStreamDownloader.DownloadStats mStats = new TXCStreamDownloader.DownloadStats();
    private WeakReference<TXCFLVDownloader> mRefFLVDownloader = null;

    public TXCFLVDownloader(Context context) {
        super(context);
        this.mStats.afterParseAudioBytes = 0L;
        this.mStats.dnsTS = 0L;
        this.mStats.startTS = TXCTimeUtil.getTimeTick();
        TXCLog.i("network.TXCFLVDownloader", "new flv download " + this);
    }

    public TXCFLVDownloader(Context context, TXCFLVDownloader refFLVDownloader) {
        super(context);
        this.mStats.afterParseAudioBytes = 0L;
        this.mStats.dnsTS = 0L;
        this.mStats.startTS = TXCTimeUtil.getTimeTick();
        this.mRefFLVDownloader = new WeakReference<TXCFLVDownloader>(refFLVDownloader);
        TXCLog.i("network.TXCFLVDownloader", "new multi flv download " + this);
    }

    @Override
    public void setPayloadType(int payloadType) {
        this.mPayloadType = payloadType;
        if (this.mFLVParser != 0L) {
            this.nativeSetPayloadType(this.mFLVParser, payloadType);
        }
    }

    public void recvData(boolean needRecv) {
        this.mHandleDataInJava = needRecv;
    }

    @Override
    public void PushVideoFrame(byte[] data, int frameType, long dts, long pts, int codecId) {
        this.nativePushVideoFrame(this.mFLVParser, data, frameType, dts, pts, codecId);
    }

    @Override
    public void PushAudioFrame(byte[] data, int packetType, long pts, int nCodecFormat) {
        this.nativePushAudioFrame(this.mFLVParser, data, packetType, pts, nCodecFormat);
    }

    @Override
    public long getCurrentTS() {
        return this.mCurrentNalTs;
    }

    @Override
    public long getLastIFrameTS() {
        return this.mLastIFramelTs;
    }

    private void processMsgConnect() {
        try {
            this.connect();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            TXCLog.e("network.TXCFLVDownloader", "[Network]socket timeout, reconnect");
            this.mStats.errorCode = -1001;
            this.mStats.errorInfo = socketTimeoutException.toString();
            this.postReconnectMsg();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            TXCLog.e("network.TXCFLVDownloader", "[Network]file not found, reconnect");
            this.mStats.errorCode = -1008;
            this.mStats.errorInfo = fileNotFoundException.toString();
            fileNotFoundException.printStackTrace();
            this.postReconnectMsg();
            return;
        }
        catch (Exception exception) {
            TXCLog.e("network.TXCFLVDownloader", "[Network]exception, reconnect");
            this.mStats.errorCode = -1010;
            this.mStats.errorInfo = exception.toString();
            exception.printStackTrace();
            this.postReconnectMsg();
            return;
        }
        catch (Error error) {
            TXCLog.e("network.TXCFLVDownloader", "[Network]error, reconnect");
            this.mStats.errorCode = -1011;
            this.mStats.errorInfo = error.toString();
            error.printStackTrace();
            this.postReconnectMsg();
            return;
        }
        if (this.mFLVParser == 0L) {
            long l2 = 0L;
            if (this.mRefFLVDownloader != null) {
                TXCFLVDownloader tXCFLVDownloader = (TXCFLVDownloader)this.mRefFLVDownloader.get();
                if (tXCFLVDownloader != null) {
                    boolean bl = tXCFLVDownloader.mIsRunning;
                    if (bl) {
                        TXCLog.i("network.TXCFLVDownloader", "[Network]init flv parser with old downloader:" + tXCFLVDownloader.hashCode());
                        tXCFLVDownloader.mStopJitter = false;
                        l2 = tXCFLVDownloader.mFLVParser;
                    } else {
                        TXCLog.e("network.TXCFLVDownloader", "[Network]old downloader:" + tXCFLVDownloader.hashCode() + " isn't running now. just create new parser.");
                    }
                }
                this.mRefFLVDownloader = null;
            }
            if (l2 != 0L) {
                TXCLog.i("network.TXCFLVDownloader", "[Network]init flv parser with reference parse:" + l2);
                this.mFLVParser = this.nativeInitFlvHanderByRef(l2);
            } else {
                TXCLog.i("network.TXCFLVDownloader", "[Network]init flv parser.");
                this.mFLVParser = this.nativeInitFlvHander(this.mUserID, 0, this.mEnableMessage, this.mEnableMetaData);
            }
            if (this.mPayloadType != 0) {
                this.nativeSetPayloadType(this.mFLVParser, this.mPayloadType);
            }
        }
        if (this.mFlvHandler != null) {
            this.mFlvHandler.sendEmptyMessage(101);
        }
    }

    private void processMsgRecvData() {
        if (this.mInputStream != null) {
            try {
                int n2 = this.mInputStream.read(this.mPacketBytes, 0, 1388);
                if (n2 > 0) {
                    this.mDownloadedSize += (long)n2;
                    if (!this.mRecvData) {
                        this.mRecvData = true;
                        TXCLog.i("network.TXCFLVDownloader", "[FirstFramePath][Network] TXCFLVDownloader: recv first data packet. instance:" + this.hashCode());
                    }
                    int n3 = 0;
                    if (this.mFLVParser != 0L) {
                        this.mStats.beforeParseVideoBytes += (long)n2;
                        n3 = this.nativeParseData(this.mFLVParser, this.mPacketBytes, n2);
                        this.mStats.afterParseVideoBytes = this.nativeGetVideoBytes(this.mFLVParser);
                        this.mStats.afterParseAudioBytes = this.nativeGetAudioBytes(this.mFLVParser);
                        this.mStats.videoGop = this.nativeGetVideoGop(this.mFLVParser);
                    }
                    if (n3 > 0x100000) {
                        TXCLog.e("network.TXCFLVDownloader", "[Network]flv play parse frame: " + n3 + " > " + 0x100000 + ",start reconnect");
                        this.postReconnectMsg();
                        return;
                    }
                } else if (n2 < 0) {
                    TXCLog.e("network.TXCFLVDownloader", "[Network]http read: " + n2 + " < 0, start reconnect");
                    this.postReconnectMsg();
                    return;
                }
                if (this.mFlvHandler != null) {
                    this.mFlvHandler.sendEmptyMessage(101);
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                TXCLog.e("network.TXCFLVDownloader", "[Network]socket timeout start reconnect");
                this.mStats.errorCode = -1012;
                this.mStats.errorInfo = socketTimeoutException.toString();
                this.postReconnectMsg();
            }
            catch (SocketException socketException) {
                TXCLog.e("network.TXCFLVDownloader", "[Network]socket exception start reconnect");
                this.mStats.errorCode = -1013;
                this.mStats.errorInfo = socketException.toString();
                this.postReconnectMsg();
            }
            catch (SSLException sSLException) {
                TXCLog.e("network.TXCFLVDownloader", "[Network]ssl exception start reconnect");
                this.mStats.errorCode = -1014;
                this.mStats.errorInfo = sSLException.toString();
                this.postReconnectMsg();
            }
            catch (EOFException eOFException) {
                TXCLog.e("network.TXCFLVDownloader", "[Network]eof exception start reconnect");
                this.mStats.errorCode = -1015;
                this.mStats.errorInfo = eOFException.toString();
                this.postReconnectMsg();
            }
            catch (Exception exception) {
                TXCLog.e("network.TXCFLVDownloader", "[Network]exception");
                this.mStats.errorCode = -1016;
                this.mStats.errorInfo = exception.toString();
                exception.printStackTrace();
                this.mInputStream = null;
                this.mConnection = null;
            }
            catch (Error error) {
                TXCLog.e("network.TXCFLVDownloader", "[Network]error");
                this.mStats.errorCode = -1017;
                this.mStats.errorInfo = error.toString();
                error.printStackTrace();
                this.mInputStream = null;
                this.mConnection = null;
            }
        }
    }

    private void processMsgDisConnect() {
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            TXCLog.e("network.TXCFLVDownloader", "disconnect failed.", exception);
        }
        if (this.mFLVParser != 0L) {
            this.nativeUninitFlvhander(this.mFLVParser, this.mStopJitter);
            this.mFLVParser = 0L;
        }
    }

    private void processMsgReconnect() {
        if (this.mStopJitter) {
            this.reconnect();
        } else {
            TXCLog.i("network.TXCFLVDownloader", "ignore processMsgReconnect when start multi stream switch" + this);
            if (this.mRestartListener != null) {
                this.mRestartListener.onOldStreamStop();
            }
        }
    }

    private void startInternal() {
        if (this.mFlvThread == null) {
            this.mFlvThread = new HandlerThread("FlvThread");
            this.mFlvThread.start();
            TXCLog.i("network.TXCFLVDownloader", "[Network] flv downloader thread id:" + this.mFlvThread.getId() + " instance:" + this.hashCode());
        }
        if (this.mFlvHandler == null) {
            this.mFlvHandler = new Handler(this.mFlvThread.getLooper()){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 100: {
                            TXCFLVDownloader.this.processMsgConnect();
                            break;
                        }
                        case 101: {
                            TXCFLVDownloader.this.processMsgRecvData();
                            break;
                        }
                        case 102: {
                            TXCFLVDownloader.this.processMsgDisConnect();
                            break;
                        }
                        case 103: {
                            TXCFLVDownloader.this.processMsgReconnect();
                            break;
                        }
                        case 106: {
                            try {
                                Looper.myLooper().quit();
                            }
                            catch (Exception exception) {}
                            break;
                        }
                    }
                }
            };
        }
        this.postConnectMsg();
    }

    private void reconnect() {
        this.processMsgDisConnect();
        String string = "ServerIp:" + this.mStats.serverIP + ",errCode:" + this.mStats.errorCode + ",errInfo:" + this.mStats.errorInfo;
        TXCLog.i("network.TXCFLVDownloader", "reconnect:" + string);
        if (this.connectRetryTimes < this.connectRetryLimit) {
            ++this.connectRetryTimes;
            String string2 = "[Network] start reconnect, times:" + this.connectRetryTimes + " limit:" + this.connectRetryLimit;
            TXCLog.i("network.TXCFLVDownloader", string2);
            this.processMsgConnect();
            this.sendNotifyEvent(2103, string);
        } else {
            String string3 = "[Network] reconnect fail. all times retried. limit:" + this.connectRetryLimit;
            TXCLog.i("network.TXCFLVDownloader", string3);
            this.sendNotifyEvent(-2301, string);
        }
    }

    private void postReconnectMsg() {
        if (this.mFlvHandler != null) {
            this.mFlvHandler.sendEmptyMessageDelayed(103, (long)(this.connectRetryInterval * 1000));
        }
    }

    private void postDisconnectMsg() {
        if (this.mFlvHandler != null) {
            this.mFlvHandler.sendEmptyMessage(102);
        }
    }

    private void postConnectMsg() {
        this.mInputStream = null;
        if (this.mConnection != null) {
            this.mConnection.disconnect();
            this.mConnection = null;
        }
        Message message = new Message();
        message.what = 100;
        message.arg1 = 0;
        if (this.mFlvHandler != null) {
            this.mFlvHandler.sendMessage(message);
        }
    }

    private void connect() throws Exception {
        String string;
        String string2;
        if (this.mConnection != null) {
            this.mConnection.disconnect();
            this.mConnection = null;
        }
        TXCLog.i("network.TXCFLVDownloader", "[FirstFramePath][Network] TXCFLVDownloader: start network connect. instance:" + this.hashCode() + " url:" + this.mPlayUrl);
        long l2 = System.currentTimeMillis();
        URL uRL = new URL(this.mPlayUrl);
        this.mConnection = (HttpURLConnection)uRL.openConnection();
        this.mStats.dnsTS = TXCTimeUtil.getTimeTick();
        this.mConnection.setConnectTimeout(8000);
        this.mConnection.setReadTimeout(8000);
        this.mConnection.setRequestProperty("Accept-Encoding", "identity");
        this.mConnection.setInstanceFollowRedirects(true);
        if (this.mHeaders != null) {
            for (Map.Entry entry : this.mHeaders.entrySet()) {
                this.mConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.mConnection.connect();
        if (200 == this.mConnection.getResponseCode()) {
            this.mStats.connTS = TXCTimeUtil.getTimeTick();
        } else {
            this.mStats.errorCode = this.mConnection.getResponseCode();
        }
        this.mInputStream = this.mConnection.getInputStream();
        this.mPacketBytes = new byte[1388];
        this.mRecvData = false;
        this.mContentLength = this.mConnection.getContentLength();
        this.mDownloadedSize = 0L;
        this.mStats.serverIP = InetAddress.getByName(this.mConnection.getURL().getHost()).getHostAddress();
        String string3 = "connect server success,ServerIp:" + this.mStats.serverIP;
        TXCLog.i("network.TXCFLVDownloader", string3);
        long l3 = System.currentTimeMillis() - l2;
        String string4 = "[FirstFramePath][Network] TXCFLVDownloader: connect server success. instance:" + this.hashCode() + " ip:" + this.mStats.serverIP + " cost:" + l3 + " rspCode:" + this.mStats.errorCode;
        TXCLog.i("network.TXCFLVDownloader", string4);
        this.sendNotifyEvent(2001, string3);
        this.mStats.flvSessionKey = string2 = this.mConnection.getHeaderField("X-Tlive-SpanId");
        if (!TextUtils.isEmpty((CharSequence)this.mFlvSessionKey) && (string = this.mConnection.getHeaderField(this.mFlvSessionKey)) != null) {
            TXCLog.i("network.TXCFLVDownloader", "receive flvSessionKey " + string);
            this.sendNotifyEvent(2031, string);
        }
    }

    @Override
    public String getRealStreamUrl() {
        if (this.mConnection != null) {
            return this.mConnection.getURL().toString();
        }
        return null;
    }

    private void disconnect() throws Exception {
        TXCLog.i("network.TXCFLVDownloader", "[Network]FLVDownloader disconnect.");
        if (this.mConnection != null) {
            this.mConnection.disconnect();
            this.mConnection = null;
        }
        if (this.mInputStream != null) {
            this.mInputStream.close();
            this.mInputStream = null;
        }
    }

    private native long nativeInitFlvHander(String var1, int var2, boolean var3, boolean var4);

    private native long nativeInitFlvHanderByRef(long var1);

    private native void nativeUninitFlvhander(long var1, boolean var3);

    private native int nativeParseData(long var1, byte[] var3, int var4);

    private native int nativeGetVideoBytes(long var1);

    private native int nativeGetAudioBytes(long var1);

    private native int nativeGetVideoGop(long var1);

    private native void nativeCleanData(long var1);

    public native void nativePushVideoFrame(long var1, byte[] var3, int var4, long var5, long var7, int var9);

    public native void nativePushAudioFrame(long var1, byte[] var3, int var4, long var5, int var7);

    public native void nativeSetPayloadType(long var1, int var3);

    @Override
    public TXCStreamDownloader.DownloadStats getDownloadStats() {
        TXCStreamDownloader.DownloadStats downloadStats = new TXCStreamDownloader.DownloadStats();
        downloadStats.afterParseAudioBytes = this.mStats.afterParseAudioBytes;
        downloadStats.afterParseVideoBytes = this.mStats.afterParseVideoBytes;
        downloadStats.beforeParseVideoBytes = this.mStats.beforeParseVideoBytes;
        downloadStats.beforeParseAudioBytes = this.mStats.beforeParseAudioBytes;
        downloadStats.videoGop = this.mStats.videoGop;
        downloadStats.startTS = this.mStats.startTS;
        downloadStats.dnsTS = this.mStats.dnsTS;
        downloadStats.connTS = this.mStats.connTS;
        downloadStats.firstAudioTS = this.mStats.firstAudioTS;
        downloadStats.firstVideoTS = this.mStats.firstVideoTS;
        downloadStats.serverIP = this.mStats.serverIP;
        downloadStats.flvSessionKey = this.mStats.flvSessionKey;
        downloadStats.errorCode = this.mStats.errorCode;
        downloadStats.errorInfo = this.mStats.errorInfo;
        return downloadStats;
    }

    @Override
    public void startDownload(Vector<e> urls, boolean isPlayRtmpAccStream, boolean enableNearestIP, boolean enableMessage, boolean enableMetaData) {
        if (this.mIsRunning) {
            return;
        }
        if (urls == null || urls.isEmpty()) {
            return;
        }
        this.mEnableMessage = enableMessage;
        this.mEnableMetaData = enableMetaData;
        this.mIsRunning = true;
        this.mPlayUrl = urls.get((int)0).a;
        TXCLog.i("network.TXCFLVDownloader", "start pull with url " + this.mPlayUrl);
        this.startInternal();
    }

    @Override
    public void stopDownload() {
        if (!this.mIsRunning) {
            return;
        }
        this.mIsRunning = false;
        TXCLog.i("network.TXCFLVDownloader", "stop pull");
        try {
            if (this.mFlvHandler != null) {
                this.mFlvHandler.removeCallbacksAndMessages(null);
                this.mFlvHandler.sendEmptyMessage(102);
                this.mFlvHandler.sendEmptyMessage(106);
                this.mFlvHandler = null;
            }
        }
        catch (Exception exception) {
            TXCLog.e("network.TXCFLVDownloader", "stop download failed.", exception);
        }
    }

    @Override
    public void onRecvVideoData(byte[] nal, int nalType, long dts, long pts, int codecId) {
        if (!this.mHasReceivedFirstVideo) {
            this.mHasReceivedFirstVideo = true;
            this.mStats.firstVideoTS = TXCTimeUtil.getTimeTick();
            TXCLog.i("network.TXCFLVDownloader", "[FirstFramePath][Network][Video] TXCFlvDownloader: recv first video frame. instance:" + this.hashCode());
        }
        this.mStats.afterParseVideoBytes += (long)nal.length;
        super.onRecvVideoData(nal, nalType, dts, pts, codecId);
    }

    @Override
    public void onRecvAudioData(byte[] aac, int ts, int audioType, int tagType) {
        if (!this.mHasReceivedFirstAudio) {
            this.mHasReceivedFirstAudio = true;
            this.mStats.firstAudioTS = TXCTimeUtil.getTimeTick();
            TXCLog.i("network.TXCFLVDownloader", "[FirstFramePath][Network][Audio] TXCFlvDownloader: recv first audio frame. instance:" + this.hashCode());
        }
        this.mStats.afterParseAudioBytes += (long)aac.length;
        super.onRecvAudioData(aac, ts, audioType, tagType);
    }

    private void onRecvFirstVideoData() {
        if (!this.mHasReceivedFirstVideo) {
            this.mHasReceivedFirstVideo = true;
            this.mStats.firstVideoTS = TXCTimeUtil.getTimeTick();
            TXCLog.i("network.TXCFLVDownloader", "[FirstFramePath][Network][Video] TXCFlvDownloader: recv first video frame. instance:" + this.hashCode());
        }
    }

    private void onRecvFirstAudioData() {
        if (!this.mHasReceivedFirstAudio) {
            this.mHasReceivedFirstAudio = true;
            this.mStats.firstAudioTS = TXCTimeUtil.getTimeTick();
            TXCLog.i("network.TXCFLVDownloader", "[FirstFramePath][Network][Audio] TXCFlvDownloader: recv first audio frame. instance:" + this.hashCode());
        }
    }
}

