/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.sharp.jni;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.rtmp.sharp.jni.QLog;
import com.tencent.rtmp.sharp.jni.RingBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AudioDecoder {
    private static final String TAG = "AudioDecoder";
    private String srcPath;
    private MediaCodec mediaDecode = null;
    private MediaExtractor mediaExtractor = null;
    private ByteBuffer[] decodeInputBuffers = null;
    private ByteBuffer[] decodeOutputBuffers = null;
    private MediaCodec.BufferInfo decodeBufferInfo = null;
    private OnCompleteListener onCompleteListener = null;
    private OnProgressListener onProgressListener = null;
    private long fileTotalMs = 0L;
    private RingBuffer decRingBuffer = null;
    int sampleRate = 0;
    int channels = 0;
    int nFrameSize = 3840;
    boolean IsTenFramesReady = false;
    int nFirstThreeFrameInfo = 3;
    int m_nIndex = 0;
    private boolean codeOver = true;

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }

    public long getFileTotalMs() {
        return this.fileTotalMs;
    }

    public int getFrameSize() {
        return this.nFrameSize;
    }

    public void setIOPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public void setIndex(int index) {
        this.m_nIndex = index;
    }

    public int prepare(int frame) {
        if (this.srcPath == null) {
            return -1;
        }
        return this.initMediaDecode(frame);
    }

    private int initMediaDecode(int frame) {
        try {
            this.mediaExtractor = new MediaExtractor();
            this.mediaExtractor.setDataSource(this.srcPath);
            if (this.mediaExtractor.getTrackCount() > 1) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "m_nIndex: " + this.m_nIndex + " initMediaDecode mediaExtractor container video, getTrackCount: " + this.mediaExtractor.getTrackCount());
                }
                this.codeOver = true;
                return -2;
            }
            for (int i2 = 0; i2 < this.mediaExtractor.getTrackCount(); ++i2) {
                MediaFormat mediaFormat = this.mediaExtractor.getTrackFormat(i2);
                String string = mediaFormat.getString("mime");
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "m_nIndex: " + this.m_nIndex + " initMediaDecode mediaExtractor audio type:" + string);
                }
                if (!string.startsWith("audio/mpeg")) continue;
                this.mediaExtractor.selectTrack(i2);
                this.mediaDecode = MediaCodec.createDecoderByType((String)string);
                this.mediaDecode.configure(mediaFormat, null, null, 0);
                this.sampleRate = mediaFormat.getInteger("sample-rate");
                this.channels = mediaFormat.getInteger("channel-count");
                long l2 = mediaFormat.getLong("durationUs");
                this.fileTotalMs = l2 / 1000L;
                this.nFrameSize = this.sampleRate * this.channels * 2 * 20 / 1000;
                this.decRingBuffer = new RingBuffer(frame * this.nFrameSize);
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "m_nIndex: " + this.m_nIndex + " initMediaDecode open succeed, mp3 format:(" + this.sampleRate + "," + this.channels + "), fileTotalMs:" + this.fileTotalMs + "ms RingBufferFrame:" + frame);
                }
                break;
            }
        }
        catch (IOException iOException) {
            TXCLog.e(TAG, "init media decode failed.", iOException);
            this.codeOver = true;
            return -1;
        }
        if (this.mediaDecode == null) {
            Log.e((String)TAG, (String)("m_nIndex: " + this.m_nIndex + " initMediaDecode create mediaDecode failed"));
            this.codeOver = true;
            return -1;
        }
        if (this.decRingBuffer == null) {
            Log.e((String)TAG, (String)("m_nIndex: " + this.m_nIndex + " initMediaDecode create decRingBuffer failed"));
            this.codeOver = true;
            return -1;
        }
        this.mediaDecode.start();
        this.decodeInputBuffers = this.mediaDecode.getInputBuffers();
        this.decodeOutputBuffers = this.mediaDecode.getOutputBuffers();
        this.decodeBufferInfo = new MediaCodec.BufferInfo();
        this.codeOver = false;
        this.IsTenFramesReady = false;
        this.nFirstThreeFrameInfo = 3;
        return 0;
    }

    private void srcAudioFormatToPCM() {
        if (this.decodeInputBuffers.length <= 1) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "m_nIndex: " + this.m_nIndex + " srcAudioFormatToPCM decodeInputBuffers.length to small," + this.decodeInputBuffers.length);
            }
            this.codeOver = true;
            return;
        }
        int n2 = this.mediaDecode.dequeueInputBuffer(-1L);
        if (n2 < 0) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "m_nIndex: " + this.m_nIndex + " srcAudioFormatToPCM decodeInputBuffers.inputIndex <0");
            }
            this.codeOver = true;
            return;
        }
        int n3 = Build.VERSION.SDK_INT;
        ByteBuffer byteBuffer = n3 >= 21 ? this.mediaDecode.getInputBuffer(n2) : this.decodeInputBuffers[n2];
        byteBuffer.clear();
        int n4 = this.mediaExtractor.readSampleData(byteBuffer, 0);
        if (n4 < 0) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "m_nIndex: " + this.m_nIndex + " srcAudioFormatToPCM readSampleData over,end");
            }
            this.codeOver = true;
        } else {
            this.mediaDecode.queueInputBuffer(n2, 0, n4, 0L, 0);
            this.mediaExtractor.advance();
        }
        int n5 = this.mediaDecode.dequeueOutputBuffer(this.decodeBufferInfo, 10000L);
        while (n5 >= 0) {
            ByteBuffer byteBuffer2 = n3 >= 21 ? this.mediaDecode.getOutputBuffer(n5) : this.decodeOutputBuffers[n5];
            byte[] byArray = new byte[this.decodeBufferInfo.size];
            try {
                byteBuffer2.get(byArray);
            }
            catch (Exception exception) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "m_nIndex: " + this.m_nIndex + " srcAudioFormatToPCM wrong outputIndex: " + n5);
                }
                this.codeOver = true;
                return;
            }
            byteBuffer2.clear();
            if (this.decRingBuffer != null && this.decodeBufferInfo.size > 0) {
                this.decRingBuffer.Push(byArray, this.decodeBufferInfo.size);
                if (this.nFirstThreeFrameInfo-- > 0 && QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "m_nIndex: " + this.m_nIndex + " DecodeOneFrame size: " + this.decodeBufferInfo.size + " Remain: " + this.decRingBuffer.RemainRead() / this.nFrameSize);
                }
            }
            this.mediaDecode.releaseOutputBuffer(n5, false);
            if (this.decodeBufferInfo.size > 0) break;
            n5 = this.mediaDecode.dequeueOutputBuffer(this.decodeBufferInfo, 10000L);
        }
    }

    public int SeekTo(int timeMs) {
        if (this.mediaExtractor != null) {
            long l2 = this.mediaExtractor.getSampleTime();
            timeMs += this.decRingBuffer.RemainRead() * 20 / this.nFrameSize;
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "m_nIndex: " + this.m_nIndex + " current PlayMs: " + l2 / 1000L + " SeekTo: " + timeMs);
            }
            this.mediaExtractor.seekTo((long)(timeMs * 1000), 2);
            long l3 = this.mediaExtractor.getSampleTime();
            int n2 = (int)((l3 - l2) / 1000L);
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "m_nIndex: " + this.m_nIndex + " total SeekTo time: " + n2 + " t2:" + l3 / 1000L);
            }
            return n2;
        }
        return 0;
    }

    public int ReadOneFrame(byte[] pBuf, int nLen) {
        int n2;
        int n3 = -1;
        if (!this.IsTenFramesReady) {
            n2 = 20;
            while (this.decRingBuffer.RemainRead() / this.nFrameSize < 10 && n2-- > 0 && !this.codeOver) {
                this.srcAudioFormatToPCM();
            }
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "m_nIndex: " + this.m_nIndex + " 10 FramesReady Remain frame: " + this.decRingBuffer.RemainRead() / this.nFrameSize);
            }
            this.IsTenFramesReady = true;
        }
        n2 = 20;
        while (!this.codeOver && this.decRingBuffer.RemainRead() / this.nFrameSize < 10 && n2-- > 0) {
            this.srcAudioFormatToPCM();
        }
        if (this.decRingBuffer.RemainRead() >= nLen) {
            this.decRingBuffer.Pop(pBuf, nLen);
            n3 = nLen;
        }
        return n3;
    }

    public void release() {
        if (this.mediaDecode != null) {
            this.mediaDecode.stop();
            this.mediaDecode.release();
            this.mediaDecode = null;
        }
        if (this.mediaExtractor != null) {
            this.mediaExtractor.release();
            this.mediaExtractor = null;
        }
        if (this.onCompleteListener != null) {
            this.onCompleteListener = null;
        }
        if (this.onProgressListener != null) {
            this.onProgressListener = null;
        }
        this.showLog("release");
    }

    public void setOnCompleteListener(OnCompleteListener onCompleteListener) {
        this.onCompleteListener = onCompleteListener;
    }

    public void setOnProgressListener(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
    }

    private void showLog(String msg) {
        Log.e((String)"AudioCodec", (String)msg);
    }

    public static interface OnProgressListener {
        public void progress();
    }

    public static interface OnCompleteListener {
        public void completed();
    }
}

