/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.sharp.jni;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.liteav.basic.a.b;
import com.tencent.liteav.basic.util.f;
import com.tencent.rtmp.sharp.jni.AudioDeviceInterface;
import com.tencent.rtmp.sharp.jni.QLog;
import com.tencent.rtmp.sharp.jni.TraeAudioSession;
import com.tencent.rtmp.sharp.jni.TraeAudioSessionHost;
import com.tencent.rtmp.sharp.jni.TraeMediaPlayer;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@SuppressLint(value={"NewApi"})
public class TraeAudioManager
extends BroadcastReceiver {
    private static final String TAG = "TraeAudioManager";
    public static final String ACTION_TRAEAUDIOMANAGER_REQUEST = "com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_REQUEST";
    public static final String ACTION_TRAEAUDIOMANAGER_RES = "com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_RES";
    public static final String ACTION_TRAEAUDIOMANAGER_NOTIFY = "com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_NOTIFY";
    public static final String PARAM_OPERATION = "PARAM_OPERATION";
    public static final String PARAM_SESSIONID = "PARAM_SESSIONID";
    public static final String PARAM_ISHOSTSIDE = "PARAM_ISHOSTSIDE";
    public static final String PARAM_RES_ERRCODE = "PARAM_RES_ERRCODE";
    public static final int RES_ERRCODE_NONE = 0;
    public static final int RES_ERRCODE_SERVICE_OFF = 1;
    public static final int RES_ERRCODE_VOICECALL_EXIST = 2;
    public static final int RES_ERRCODE_VOICECALL_NOT_EXIST = 3;
    public static final int RES_ERRCODE_STOPRING_INTERRUPT = 4;
    public static final int RES_ERRCODE_RING_NOT_EXIST = 5;
    public static final int RES_ERRCODE_VOICECALLPOST_INTERRUPT = 6;
    public static final int RES_ERRCODE_DEVICE_UNKOWN = 7;
    public static final int RES_ERRCODE_DEVICE_NOT_VISIABLE = 8;
    public static final int RES_ERRCODE_DEVICE_UNCHANGEABLE = 9;
    public static final int RES_ERRCODE_DEVICE_BTCONNCECTED_TIMEOUT = 10;
    public static final String PARAM_STATUS = "PARAM_STATUS";
    public static final String PARAM_DEVICE = "PARAM_DEVICE";
    public static final String PARAM_ERROR = "PARAM_ERROR";
    public static final String PARAM_MODEPOLICY = "PARAM_MODEPOLICY";
    public static final String PARAM_STREAMTYPE = "PARAM_STREAMTYPE";
    public static final String PARAM_RING_DATASOURCE = "PARAM_RING_DATASOURCE";
    public static final String PARAM_RING_RSID = "PARAM_RING_RSID";
    public static final String PARAM_RING_URI = "PARAM_RING_URI";
    public static final String PARAM_RING_FILEPATH = "PARAM_RING_FILEPATH";
    public static final String PARAM_RING_LOOP = "PARAM_RING_LOOP";
    public static final String PARAM_RING_LOOPCOUNT = "PARAM_RING_LOOPCOUNT";
    public static final String PARAM_RING_MODE = "PARAM_RING_MODE";
    public static final String PARAM_RING_USERDATA_STRING = "PARAM_RING_USERDATA_STRING";
    public static final String OPERATION_STARTSERVICE = "OPERATION_STARTSERVICE";
    public static final String EXTRA_DATA_DEVICECONFIG = "EXTRA_DATA_DEVICECONFIG";
    public static final String OPERATION_STOPSERVICE = "OPERATION_STOPSERVICE";
    public static final String OPERATION_REGISTERAUDIOSESSION = "OPERATION_REGISTERAUDIOSESSION";
    public static final String REGISTERAUDIOSESSION_ISREGISTER = "REGISTERAUDIOSESSION_ISREGISTER";
    public static final String OPERATION_GETDEVICELIST = "OPERATION_GETDEVICELIST";
    public static final String OPERATION_GETSTREAMTYPE = "OPERATION_GETSTREAMTYPE";
    public static final String OPERATION_CONNECTDEVICE = "OPERATION_CONNECTDEVICE";
    public static final String CONNECTDEVICE_DEVICENAME = "CONNECTDEVICE_DEVICENAME";
    public static final String CONNECTDEVICE_RESULT_DEVICENAME = "CONNECTDEVICE_RESULT_DEVICENAME";
    public static final String OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE = "OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE";
    public static final String OPERATION_ISDEVICECHANGABLED = "OPERATION_ISDEVICECHANGABLED";
    public static final String ISDEVICECHANGABLED_RESULT_ISCHANGABLED = "ISDEVICECHANGABLED_REULT_ISCHANGABLED";
    public static final String OPERATION_GETCONNECTEDDEVICE = "OPERATION_GETCONNECTEDDEVICE";
    public static final String GETCONNECTEDDEVICE_RESULT_LIST = "GETCONNECTEDDEVICE_REULT_LIST";
    public static final String OPERATION_GETCONNECTINGDEVICE = "OPERATION_GETCONNECTINGDEVICE";
    public static final String GETCONNECTINGDEVICE_RESULT_LIST = "GETCONNECTINGDEVICE_REULT_LIST";
    public static final String EXTRA_DATA_STREAMTYPE = "EXTRA_DATA_STREAMTYPE";
    public static final String OPERATION_VOICECALL_PREPROCESS = "OPERATION_VOICECALL_PREPROCESS";
    public static final String OPERATION_VOICECALL_POSTPROCESS = "OPERATION_VOICECALL_POSTROCESS";
    public static final String OPERATION_STARTRING = "OPERATION_STARTRING";
    public static final String OPERATION_STOPRING = "OPERATION_STOPRING";
    public static final String OPERATION_REQUEST_RELEASE_AUDIO_FOCUS = "OPERATION_REQUEST_RELEASE_AUDIO_FOCUS";
    public static final String OPERATION_RECOVER_AUDIO_FOCUS = "OPERATION_RECOVER_AUDIO_FOCUS";
    public static final String OPERATION_VOICECALL_AUDIOPARAM_CHANGED = "OPERATION_VOICECALL_AUDIOPARAM_CHANGED";
    public static final String NOTIFY_SERVICE_STATE = "NOTIFY_SERVICE_STATE";
    public static final String NOTIFY_SERVICE_STATE_DATE = "NOTIFY_SERVICE_STATE_DATE";
    public static final String NOTIFY_DEVICELIST_UPDATE = "NOTIFY_DEVICELISTUPDATE";
    public static final String EXTRA_DATA_AVAILABLEDEVICE_LIST = "EXTRA_DATA_AVAILABLEDEVICE_LIST";
    public static final String EXTRA_DATA_PREV_CONNECTEDDEVICE = "EXTRA_DATA_PREV_CONNECTEDDEVICE";
    public static final String EXTRA_DATA_CONNECTEDDEVICE = "EXTRA_DATA_CONNECTEDDEVICE";
    public static final String EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME = "EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME";
    public static final String NOTIFY_DEVICECHANGABLE_UPDATE = "NOTIFY_DEVICECHANGABLE_UPDATE";
    public static final String NOTIFY_DEVICECHANGABLE_UPDATE_DATE = "NOTIFY_DEVICECHANGABLE_UPDATE_DATE";
    public static final String NOTIFY_RING_COMPLETION = "NOTIFY_RING_COMPLETION";
    public static final String NOTIFY_STREAMTYPE_UPDATE = "NOTIFY_STREAMTYPE_UPDATE";
    public static final String NOTIFY_ROUTESWITCHSTART = "NOTIFY_ROUTESWITCHSTART";
    public static final String EXTRA_DATA_ROUTESWITCHSTART_FROM = "EXTRA_DATA_ROUTESWITCHSTART_FROM";
    public static final String EXTRA_DATA_ROUTESWITCHSTART_TO = "EXTRA_DATA_ROUTESWITCHSTART_TO";
    public static final String NOTIFY_ROUTESWITCHEND = "NOTIFY_ROUTESWITCHEND";
    public static final String EXTRA_DATA_ROUTESWITCHEND_DEV = "EXTRA_DATA_ROUTESWITCHEND_DEV";
    public static final String EXTRA_DATA_ROUTESWITCHEND_TIME = "EXTRA_DATA_ROUTESWITCHEND_TIME";
    public static final int EARACTION_AWAY = 0;
    public static final int EARACTION_CLOSE = 1;
    public static final String OPERATION_EARACTION = "OPERATION_EARACTION";
    public static final String EXTRA_EARACTION = "EXTRA_EARACTION";
    public static final String DEVICE_NONE = "DEVICE_NONE";
    public static final String DEVICE_EARPHONE = "DEVICE_EARPHONE";
    public static final String DEVICE_SPEAKERPHONE = "DEVICE_SPEAKERPHONE";
    public static final String DEVICE_WIREDHEADSET = "DEVICE_WIREDHEADSET";
    public static final String DEVICE_BLUETOOTHHEADSET = "DEVICE_BLUETOOTHHEADSET";
    public static final int DEVICE_STATUS_ERROR = -1;
    public static final int DEVICE_STATUS_DISCONNECTED = 0;
    public static final int DEVICE_STATUS_CONNECTING = 1;
    public static final int DEVICE_STATUS_CONNECTED = 2;
    public static final int DEVICE_STATUS_DISCONNECTING = 3;
    public static final int DEVICE_STATUS_UNCHANGEABLE = 4;
    public static final int AUDIO_MANAGER_ACTIVE_NONE = 0;
    public static final int AUDIO_MANAGER_ACTIVE_VOICECALL = 1;
    public static final int AUDIO_MANAGER_ACTIVE_RING = 2;
    public static final int MODE_VOICE_CHAT = 0;
    public static final int MODE_MUSIC_PLAY_RECORD = 1;
    public static final int MODE_MUSIC_PLAYBACK = 2;
    public static final int MODE_MUSIC_PLAY_RECORD_HIGH_QUALITY = 3;
    public static final int MODE_VOICE_PLAYBACK = 4;
    public static final int MODE_MUSIC_PLAY_RECORD_LOW_QUALITY = 5;
    AudioManager _am = null;
    Context _context = null;
    int _activeMode = 0;
    int _prevMode = 0;
    int _streamType = 0;
    int _modePolicy = -1;
    private int bluetoothState = 4;
    final boolean[] _bluetooth_sco_connect = new boolean[]{false};
    public static boolean IsMusicScene = false;
    public static boolean IsEarPhoneSupported = false;
    public static boolean IsUpdateSceneFlag = false;
    public static boolean enableDeviceSwitchFlag = true;
    boolean IsBluetoothA2dpExisted = true;
    boolean IsServiceReadytoStop = false;
    public static final String VOICECALL_CONFIG = "DEVICE_SPEAKERPHONE;DEVICE_EARPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;";
    public static final String VIDEO_CONFIG = "DEVICE_EARPHONE;DEVICE_SPEAKERPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;";
    public static final String MUSIC_CONFIG = "DEVICE_SPEAKERPHONE;DEVICE_WIREDHEADSET;DEVICE_BLUETOOTHHEADSET;";
    TraeAudioSessionHost _audioSessionHost = new TraeAudioSessionHost();
    DeviceConfigManager _deviceConfigManager = new DeviceConfigManager();
    BluetoohHeadsetCheckInterface _bluetoothCheck = null;
    String sessionConnectedDev = "DEVICE_NONE";
    static ReentrantLock _glock = new ReentrantLock();
    static TraeAudioManager _ginstance = null;
    TraeAudioManagerLooper mTraeAudioManagerLooper = null;
    ReentrantLock _lock = new ReentrantLock();
    static final String AUDIO_PARAMETER_STREAM_ROUTING = "routing";
    static final int AUDIO_DEVICE_OUT_EARPIECE = 1;
    static final int AUDIO_DEVICE_OUT_SPEAKER = 2;
    static final int AUDIO_DEVICE_OUT_WIRED_HEADSET = 4;
    static final int AUDIO_DEVICE_OUT_WIRED_HEADPHONE = 8;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_SCO = 16;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_SCO_HEADSET = 32;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_SCO_CARKIT = 64;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_A2DP = 128;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES = 256;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER = 512;
    switchThread _switchThread = null;
    ReentrantLock _gSwitchTreadlock = new ReentrantLock();
    public static final int FORCE_NONE = 0;
    public static final int FORCE_SPEAKER = 1;
    public static final int FORCE_HEADPHONES = 2;
    public static final int FORCE_BT_SCO = 3;
    public static final int FORCE_BT_A2DP = 4;
    public static final int FORCE_WIRED_ACCESSORY = 5;
    public static final int FORCE_BT_CAR_DOCK = 6;
    public static final int FORCE_BT_DESK_DOCK = 7;
    public static final int FORCE_ANALOG_DOCK = 8;
    public static final int FORCE_DIGITAL_DOCK = 9;
    public static final int FORCE_NO_BT_A2DP = 10;
    private static final int NUM_FORCE_CONFIG = 11;
    public static final int FORCE_DEFAULT = 0;
    public static final int FOR_COMMUNICATION = 0;
    public static final int FOR_MEDIA = 1;
    public static final int FOR_RECORD = 2;
    public static final int FOR_DOCK = 3;
    private static final int NUM_FORCE_USE = 4;
    static final String[] forceName = new String[]{"FORCE_NONE", "FORCE_SPEAKER", "FORCE_HEADPHONES", "FORCE_BT_SCO", "FORCE_BT_A2DP", "FORCE_WIRED_ACCESSORY", "FORCE_BT_CAR_DOCK", "FORCE_BT_DESK_DOCK", "FORCE_ANALOG_DOCK", "FORCE_NO_BT_A2DP", "FORCE_DIGITAL_DOCK"};

    public static boolean checkDevName(String strDeviceName) {
        if (strDeviceName == null) {
            return false;
        }
        return DEVICE_SPEAKERPHONE.equals(strDeviceName) || DEVICE_EARPHONE.equals(strDeviceName) || DEVICE_WIREDHEADSET.equals(strDeviceName) || DEVICE_BLUETOOTHHEADSET.equals(strDeviceName);
    }

    public static boolean isHandfree(String strDeviceName) {
        if (!TraeAudioManager.checkDevName(strDeviceName)) {
            return false;
        }
        return DEVICE_SPEAKERPHONE.equals(strDeviceName);
    }

    void printDevices() {
        AudioDeviceInterface.LogTraceEntry("");
        if (null == this._deviceConfigManager) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "_deviceConfigManager is null");
            }
            return;
        }
        int n2 = this._deviceConfigManager.getDeviceNumber();
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "   ConnectedDevice:" + this._deviceConfigManager.getConnectedDevice());
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "   ConnectingDevice:" + this._deviceConfigManager.getConnectingDevice());
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "   prevConnectedDevice:" + this._deviceConfigManager.getPrevConnectedDevice());
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "   AHPDevice:" + this._deviceConfigManager.getAvailabledHighestPriorityDevice());
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "   deviceNamber:" + n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this._deviceConfigManager.getDeviceName(i2);
            if (!QLog.isColorLevel()) continue;
            QLog.w(TAG, 2, "      " + i2 + " devName:" + string + " Visible:" + this._deviceConfigManager.getVisible(string) + " Priority:" + this._deviceConfigManager.getPriority(string));
        }
        String[] stringArray = this._deviceConfigManager.getAvailableDeviceList().toArray(new String[0]);
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "   AvailableNamber:" + stringArray.length);
        }
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            String string = stringArray[i3];
            if (!QLog.isColorLevel()) continue;
            QLog.w(TAG, 2, "      " + i3 + " devName:" + string + " Visible:" + this._deviceConfigManager.getVisible(string) + " Priority:" + this._deviceConfigManager.getPriority(string));
        }
        AudioDeviceInterface.LogTraceExit();
    }

    static boolean isCloseSystemAPM(int modePolicy) {
        if (modePolicy != -1) {
            return false;
        }
        if (f.c.equals("Xiaomi")) {
            if (f.a.equals("MI 2")) {
                return true;
            }
            if (f.a.equals("MI 2A")) {
                return true;
            }
            if (f.a.equals("MI 2S")) {
                return true;
            }
            if (f.a.equals("MI 2SC")) {
                return true;
            }
        } else if (f.c.equals("samsung") && f.a.equals("SCH-I959")) {
            return true;
        }
        return false;
    }

    public static boolean IsEabiLowVersionByAbi(String platform) {
        if (platform == null) {
            return true;
        }
        if (platform.contains("x86")) {
            return false;
        }
        if (platform.contains("mips")) {
            return false;
        }
        if (platform.equalsIgnoreCase("armeabi")) {
            return true;
        }
        if (platform.equalsIgnoreCase("armeabi-v7a")) {
            return false;
        }
        return !platform.equalsIgnoreCase("arm64-v8a");
    }

    static boolean IsEabiLowVersion() {
        String string = Build.CPU_ABI;
        String string2 = "unknown";
        if (Build.VERSION.SDK_INT >= 8) {
            try {
                string2 = (String)Build.class.getDeclaredField("CPU_ABI2").get(null);
            }
            catch (Exception exception) {
                return TraeAudioManager.IsEabiLowVersionByAbi(string);
            }
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "IsEabiVersion CPU_ABI:" + string + " CPU_ABI2:" + string2);
        }
        return TraeAudioManager.IsEabiLowVersionByAbi(string) && TraeAudioManager.IsEabiLowVersionByAbi(string2);
    }

    static int getAudioSource(int audioSourcePolicy) {
        int n2 = 0;
        if (IsMusicScene) {
            return n2;
        }
        if (TraeAudioManager.IsEabiLowVersion()) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "[Config] armeabi low Version, getAudioSource _audioSourcePolicy:" + audioSourcePolicy + " source:" + n2);
            }
            return n2;
        }
        int n3 = Build.VERSION.SDK_INT;
        if (audioSourcePolicy >= 0) {
            n2 = audioSourcePolicy;
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "[Config] getAudioSource _audioSourcePolicy:" + audioSourcePolicy + " source:" + n2);
            }
            return audioSourcePolicy;
        }
        if (n3 >= 11) {
            n2 = 7;
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "[Config] getAudioSource _audioSourcePolicy:" + audioSourcePolicy + " source:" + n2);
        }
        return n2;
    }

    static int getAudioStreamType(int audioStreamTypePolicy) {
        int n2 = 3;
        if (IsMusicScene) {
            return n2;
        }
        if (TraeAudioManager.IsEabiLowVersion()) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "[Config] armeabi low Version, getAudioStreamType audioStreamTypePolicy:" + audioStreamTypePolicy + " streamType:" + n2);
            }
            return n2;
        }
        int n3 = Build.VERSION.SDK_INT;
        if (audioStreamTypePolicy >= 0) {
            n2 = audioStreamTypePolicy;
        } else if (n3 >= 9) {
            n2 = 0;
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "[Config] getAudioStreamType audioStreamTypePolicy:" + audioStreamTypePolicy + " streamType:" + n2);
        }
        return n2;
    }

    static int getCallAudioMode(int modePolicy) {
        int n2 = 0;
        if (IsMusicScene) {
            return n2;
        }
        if (TraeAudioManager.IsEabiLowVersion()) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "[Config] armeabi low Version, getCallAudioMode modePolicy:" + modePolicy + " mode:" + n2);
            }
            return n2;
        }
        int n3 = Build.VERSION.SDK_INT;
        if (modePolicy >= 0) {
            n2 = modePolicy;
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "[Config] getCallAudioMode modePolicy:" + modePolicy + " mode:" + n2);
            }
            return n2;
        }
        if (n3 >= 11) {
            n2 = 3;
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "[Config] getCallAudioMode _modePolicy:" + modePolicy + " mode:" + n2 + "facturer:" + f.c + " model:" + f.a);
        }
        return n2;
    }

    void updateDeviceStatus() {
        if (null == this._deviceConfigManager) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "_deviceConfigManager is null");
            }
            return;
        }
        int n2 = this._deviceConfigManager.getDeviceNumber();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl = false;
            String string = this._deviceConfigManager.getDeviceName(i2);
            if (string != null) {
                if (string.equals(DEVICE_BLUETOOTHHEADSET)) {
                    bl = this._bluetoothCheck == null ? this._deviceConfigManager.setVisible(string, false) : this._deviceConfigManager.setVisible(string, this._bluetoothCheck.isConnected());
                } else if (string.equals(DEVICE_WIREDHEADSET)) {
                    bl = this._deviceConfigManager.setVisible(string, this._am.isWiredHeadsetOn());
                } else if (string.equals(DEVICE_SPEAKERPHONE)) {
                    this._deviceConfigManager.setVisible(string, true);
                }
            }
            if (!bl || !QLog.isColorLevel()) continue;
            QLog.w(TAG, 2, "pollUpdateDevice dev:" + string + " Visible:" + this._deviceConfigManager.getVisible(string));
        }
        this.checkAutoDeviceListUpdate(false);
    }

    void _updateEarphoneVisable() {
        if (null == this._deviceConfigManager) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "_deviceConfigManager is null");
            }
            return;
        }
        if (this._deviceConfigManager.getVisible(DEVICE_WIREDHEADSET) || this._deviceConfigManager.getVisible(DEVICE_BLUETOOTHHEADSET)) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, " detected headset plugin,so disable earphone");
            }
            this._deviceConfigManager.setVisible(DEVICE_EARPHONE, false);
        } else {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, " detected headset plugout,so enable earphone");
            }
            this._deviceConfigManager.setVisible(DEVICE_EARPHONE, true);
        }
    }

    void checkAutoDeviceListUpdate(boolean force) {
        if (null == this._deviceConfigManager) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "_deviceConfigManager is null");
            }
            return;
        }
        if (force || this._deviceConfigManager.getVisiableUpdateFlag()) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "checkAutoDeviceListUpdate got update!");
            }
            this._updateEarphoneVisable();
            this._deviceConfigManager.resetVisiableUpdateFlag();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            this.internalSendMessage(32785, hashMap);
        }
    }

    void checkDevicePlug(String devName, boolean isPlugin) {
        if (null == this._deviceConfigManager) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "_deviceConfigManager is null");
            }
            return;
        }
        if (this._deviceConfigManager.getVisiableUpdateFlag()) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "checkDevicePlug got update dev:" + devName + (isPlugin ? " piugin" : " plugout") + " connectedDev:" + this._deviceConfigManager.getConnectedDevice());
            }
            this._updateEarphoneVisable();
            this._deviceConfigManager.resetVisiableUpdateFlag();
            if (isPlugin) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put(PARAM_DEVICE, devName);
                this.internalSendMessage(32786, hashMap);
            } else {
                String string = this._deviceConfigManager.getConnectedDevice();
                if (string.equals(devName) || string.equals(DEVICE_NONE)) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put(PARAM_DEVICE, devName);
                    this.internalSendMessage(32787, hashMap);
                } else {
                    if (QLog.isColorLevel()) {
                        QLog.w(TAG, 2, " ---No switch,plugout:" + devName + " connectedDev:" + string);
                    }
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    this.internalSendMessage(32793, hashMap);
                }
            }
        }
    }

    public static int SetSpeakerForTest(Context context, boolean speakerOn) {
        int n2 = -1;
        _glock.lock();
        if (null != _ginstance) {
            n2 = _ginstance.InternalSetSpeaker(context, speakerOn);
        } else if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "TraeAudioManager|static SetSpeakerForTest|null == _ginstance");
        }
        _glock.unlock();
        return n2;
    }

    int InternalSetSpeaker(Context context, boolean speakerOn) {
        int n2;
        if (context == null) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "Could not InternalSetSpeaker - no context");
            }
            return -1;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager == null) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "Could not InternalSetSpeaker - no audio manager");
            }
            return -1;
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "InternalSetSpeaker entry:speaker:" + (audioManager.isSpeakerphoneOn() ? "Y" : "N") + "-->:" + (speakerOn ? "Y" : "N"));
        }
        if (TraeAudioManager.isCloseSystemAPM(this._modePolicy) && this._activeMode != 2) {
            return this.InternalSetSpeakerSpe(audioManager, speakerOn);
        }
        try {
            if (audioManager.isSpeakerphoneOn() != speakerOn) {
                audioManager.setSpeakerphoneOn(speakerOn);
            }
        }
        catch (Exception exception) {
            QLog.e(TAG, 2, "setSpeakerphoneOn failed with " + exception.getMessage());
        }
        int n3 = n2 = audioManager.isSpeakerphoneOn() == speakerOn ? 0 : -1;
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "InternalSetSpeaker exit:" + speakerOn + " res:" + n2 + " mode:" + audioManager.getMode());
        }
        return n2;
    }

    int InternalSetSpeakerSpe(AudioManager am, boolean speakerOn) {
        int n2;
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "InternalSetSpeakerSpe fac:" + f.c + " model:" + f.a + " st:" + this._streamType + " media_force_use:" + TraeAudioManager.getForceUse(1));
        }
        if (speakerOn) {
            this.InternalSetMode(0);
            am.setSpeakerphoneOn(true);
            TraeAudioManager.setForceUse(1, 1);
        } else {
            this.InternalSetMode(3);
            am.setSpeakerphoneOn(false);
            TraeAudioManager.setForceUse(1, 0);
        }
        int n3 = n2 = am.isSpeakerphoneOn() == speakerOn ? 0 : -1;
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "InternalSetSpeakerSpe exit:" + speakerOn + " res:" + n2 + " mode:" + am.getMode());
        }
        return n2;
    }

    void InternalSetMode(int audioMode) {
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "SetMode entry:" + audioMode);
        }
        if (this._am == null) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "setMode:" + audioMode + " fail am=null");
            }
            return;
        }
        this._am.setMode(audioMode);
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "setMode:" + audioMode + (this._am.getMode() != audioMode ? "fail" : "success"));
        }
    }

    public static int registerAudioSession(TraeAudioSession _traeAs, boolean bRegister, long nSessionId, Context ctx) {
        int n2 = -1;
        _glock.lock();
        if (null != _ginstance) {
            if (bRegister) {
                if (null != TraeAudioManager._ginstance._audioSessionHost) {
                    TraeAudioManager._ginstance._audioSessionHost.add(_traeAs, nSessionId, ctx);
                    if (QLog.isColorLevel()) {
                        QLog.d(TAG, 2, "[register] add AudioSession: " + nSessionId);
                    }
                } else if (QLog.isColorLevel()) {
                    QLog.d(TAG, 2, "_ginstance._audioSessionHost is null");
                }
            } else if (null != TraeAudioManager._ginstance._audioSessionHost) {
                TraeAudioManager._ginstance._audioSessionHost.remove(nSessionId);
                if (QLog.isColorLevel()) {
                    QLog.d(TAG, 2, "[register] remove AudioSession: " + nSessionId);
                }
            } else if (QLog.isColorLevel()) {
                QLog.d(TAG, 2, "_ginstance._audioSessionHost is null");
            }
            n2 = 0;
        }
        _glock.unlock();
        return n2;
    }

    public static int sendMessage(int nMsg, HashMap<String, Object> params) {
        int n2 = -1;
        _glock.lock();
        if (null != _ginstance) {
            n2 = _ginstance.internalSendMessage(nMsg, params);
        }
        _glock.unlock();
        return n2;
    }

    public static int init(Context ctx) {
        QLog.w(TAG, 2, "TraeAudioManager init _ginstance:" + (Object)((Object)_ginstance));
        AudioDeviceInterface.LogTraceEntry(" _ginstance:" + (Object)((Object)_ginstance));
        _glock.lock();
        if (null == _ginstance) {
            _ginstance = new TraeAudioManager(ctx);
        }
        _glock.unlock();
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    public static void uninit() {
        QLog.w(TAG, 2, "TraeAudioManager uninit _ginstance:" + (Object)((Object)_ginstance));
        AudioDeviceInterface.LogTraceEntry(" _ginstance:" + (Object)((Object)_ginstance));
        _glock.lock();
        if (null != _ginstance) {
            _ginstance.release();
            _ginstance = null;
        }
        _glock.unlock();
        AudioDeviceInterface.LogTraceExit();
    }

    TraeAudioManager(Context ctx) {
        AudioDeviceInterface.LogTraceEntry(" context:" + ctx);
        if (ctx == null) {
            return;
        }
        this._context = ctx;
        this.mTraeAudioManagerLooper = new TraeAudioManagerLooper(this);
        if (this.mTraeAudioManagerLooper != null) {
            // empty if block
        }
        AudioDeviceInterface.LogTraceExit();
    }

    public void release() {
        AudioDeviceInterface.LogTraceEntry("");
        if (null != this.mTraeAudioManagerLooper) {
            this.mTraeAudioManagerLooper.quit();
            this.mTraeAudioManagerLooper = null;
        }
        AudioDeviceInterface.LogTraceExit();
    }

    public void onReceive(Context context, Intent intent) {
        block48: {
            if (intent == null || context == null) {
                if (QLog.isColorLevel()) {
                    QLog.d(TAG, 2, "onReceive intent or context is null!");
                }
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            try {
                String string = intent.getAction();
                String string2 = intent.getStringExtra(PARAM_OPERATION);
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, "TraeAudioManager|onReceive::Action:" + intent.getAction());
                }
                if (this._deviceConfigManager == null) {
                    if (QLog.isColorLevel()) {
                        QLog.d(TAG, 2, "_deviceConfigManager null!");
                    }
                    return;
                }
                bl = this._deviceConfigManager.getVisible(DEVICE_WIREDHEADSET);
                bl2 = this._deviceConfigManager.getVisible(DEVICE_BLUETOOTHHEADSET);
                if ("android.intent.action.HEADSET_PLUG".equals(intent.getAction())) {
                    this.onHeadsetPlug(context, intent);
                    if (!bl && this._deviceConfigManager.getVisible(DEVICE_WIREDHEADSET)) {
                        this.checkDevicePlug(DEVICE_WIREDHEADSET, true);
                    }
                    if (bl && !this._deviceConfigManager.getVisible(DEVICE_WIREDHEADSET)) {
                        this.checkDevicePlug(DEVICE_WIREDHEADSET, false);
                    }
                } else if (!"android.media.AUDIO_BECOMING_NOISY".equals(intent.getAction())) {
                    if (ACTION_TRAEAUDIOMANAGER_REQUEST.equals(string)) {
                        if (QLog.isColorLevel()) {
                            QLog.w(TAG, 2, "   OPERATION:" + string2);
                        }
                        if (OPERATION_STARTSERVICE.equals(string2)) {
                            TraeAudioManager.startService(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, intent.getStringExtra(EXTRA_DATA_DEVICECONFIG));
                        } else if (OPERATION_STOPSERVICE.equals(string2)) {
                            TraeAudioManager.stopService(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                        } else if (OPERATION_GETDEVICELIST.equals(string2)) {
                            TraeAudioManager.getDeviceList(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                        } else if (OPERATION_GETSTREAMTYPE.equals(string2)) {
                            TraeAudioManager.getStreamType(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                        } else if (OPERATION_CONNECTDEVICE.equals(string2)) {
                            TraeAudioManager.connectDevice(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, intent.getStringExtra(CONNECTDEVICE_DEVICENAME));
                        } else if (OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE.equals(string2)) {
                            TraeAudioManager.connectHighestPriorityDevice(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                        } else if (OPERATION_EARACTION.equals(string2)) {
                            TraeAudioManager.earAction(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, intent.getIntExtra(EXTRA_EARACTION, -1));
                        } else if (OPERATION_ISDEVICECHANGABLED.equals(string2)) {
                            TraeAudioManager.isDeviceChangabled(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                        } else if (OPERATION_GETCONNECTEDDEVICE.equals(string2)) {
                            TraeAudioManager.getConnectedDevice(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                        } else if (OPERATION_GETCONNECTINGDEVICE.equals(string2)) {
                            TraeAudioManager.getConnectingDevice(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                        } else if (OPERATION_VOICECALL_PREPROCESS.equals(string2)) {
                            int n2 = intent.getIntExtra(PARAM_MODEPOLICY, -1);
                            int n3 = intent.getIntExtra(PARAM_STREAMTYPE, -1);
                            TraeAudioManager.voicecallPreprocess(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, n2, n3);
                        } else if (OPERATION_VOICECALL_POSTPROCESS.equals(string2)) {
                            TraeAudioManager.voicecallPostprocess(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                        } else if (OPERATION_VOICECALL_AUDIOPARAM_CHANGED.equals(string2)) {
                            int n4 = intent.getIntExtra(PARAM_MODEPOLICY, -1);
                            int n5 = intent.getIntExtra(PARAM_STREAMTYPE, -1);
                            TraeAudioManager.voiceCallAudioParamChanged(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, n4, n5);
                        } else if (OPERATION_STARTRING.equals(string2)) {
                            Uri uri = null;
                            String string3 = null;
                            String string4 = null;
                            int n6 = intent.getIntExtra(PARAM_RING_DATASOURCE, -1);
                            int n7 = intent.getIntExtra(PARAM_RING_RSID, -1);
                            uri = (Uri)intent.getParcelableExtra(PARAM_RING_URI);
                            string3 = intent.getStringExtra(PARAM_RING_FILEPATH);
                            boolean bl3 = intent.getBooleanExtra(PARAM_RING_LOOP, false);
                            string4 = intent.getStringExtra(PARAM_RING_USERDATA_STRING);
                            int n8 = intent.getIntExtra(PARAM_RING_LOOPCOUNT, 1);
                            boolean bl4 = intent.getBooleanExtra(PARAM_RING_MODE, false);
                            TraeAudioManager.startRing(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, n6, n7, uri, string3, bl3, n8, string4, bl4);
                        } else if (OPERATION_STOPRING.equals(string2)) {
                            TraeAudioManager.stopRing(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                        }
                    } else if (this._deviceConfigManager != null) {
                        if (this._bluetoothCheck != null) {
                            this._bluetoothCheck.onReceive(context, intent, this._deviceConfigManager);
                        }
                        if (!bl2 && this._deviceConfigManager.getVisible(DEVICE_BLUETOOTHHEADSET)) {
                            this.checkDevicePlug(DEVICE_BLUETOOTHHEADSET, true);
                        }
                        if (bl2 && !this._deviceConfigManager.getVisible(DEVICE_BLUETOOTHHEADSET)) {
                            this.checkDevicePlug(DEVICE_BLUETOOTHHEADSET, false);
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block48;
                QLog.e(TAG, 2, "deal with receiver failed." + exception.getMessage());
            }
        }
    }

    void onHeadsetPlug(Context context, Intent intent) {
        String string = "";
        String string2 = intent.getStringExtra("name");
        if (string2 == null) {
            string2 = "unkonw";
        }
        string = string + " [" + string2 + "] ";
        int n2 = intent.getIntExtra("state", -1);
        if (n2 != -1) {
            string = string + (n2 == 0 ? "unplugged" : "plugged");
        }
        string = string + " mic:";
        int n3 = intent.getIntExtra("microphone", -1);
        if (n3 != -1) {
            string = string + (n3 == 1 ? "Y" : "unkown");
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "onHeadsetPlug:: " + string);
        }
        if (this._deviceConfigManager != null) {
            this._deviceConfigManager.setVisible(DEVICE_WIREDHEADSET, 1 == n2);
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "onHeadsetPlug exit");
        }
    }

    int internalSendMessage(int nMsg, HashMap<String, Object> params) {
        int n2 = -1;
        if (null != this.mTraeAudioManagerLooper) {
            n2 = this.mTraeAudioManagerLooper.sendMessage(nMsg, params);
        }
        return n2;
    }

    static int getDeviceList(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32774, hashMap);
    }

    static int getStreamType(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32784, hashMap);
    }

    static int startService(String strOption, long nSessionId, boolean bHostside, String deviceConfig) {
        if (deviceConfig.length() <= 0) {
            return -1;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        hashMap.put(EXTRA_DATA_DEVICECONFIG, deviceConfig);
        return TraeAudioManager.sendMessage(32772, hashMap);
    }

    static int stopService(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32773, hashMap);
    }

    static int disableDeviceSwitch() {
        enableDeviceSwitchFlag = false;
        return 0;
    }

    static int connectDevice(String strOption, long nSessionId, boolean bHostside, String strDevice) {
        if (strDevice == null) {
            return -1;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        hashMap.put(CONNECTDEVICE_DEVICENAME, strDevice);
        hashMap.put(PARAM_DEVICE, strDevice);
        return TraeAudioManager.sendMessage(32775, hashMap);
    }

    static int connectHighestPriorityDevice(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32789, hashMap);
    }

    static int earAction(String strOption, long nSessionId, boolean bHostside, int earAction) {
        if (earAction != 0 && earAction != 1) {
            return -1;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        hashMap.put(EXTRA_EARACTION, earAction);
        return TraeAudioManager.sendMessage(32776, hashMap);
    }

    static int isDeviceChangabled(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32777, hashMap);
    }

    static int getConnectedDevice(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32778, hashMap);
    }

    static int getConnectingDevice(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32779, hashMap);
    }

    static int voicecallPreprocess(String strOption, long nSessionId, boolean bHostside, int modePolicy, int streamType) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        hashMap.put(PARAM_MODEPOLICY, modePolicy);
        hashMap.put(PARAM_STREAMTYPE, streamType);
        return TraeAudioManager.sendMessage(32780, hashMap);
    }

    static int voicecallPostprocess(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32781, hashMap);
    }

    static int voiceCallAudioParamChanged(String strOption, long nSessionId, boolean bHostside, int modePolicy, int streamType) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        hashMap.put(PARAM_MODEPOLICY, modePolicy);
        hashMap.put(PARAM_STREAMTYPE, streamType);
        return TraeAudioManager.sendMessage(32788, hashMap);
    }

    static int startRing(String strOption, long nSessionId, boolean bHostside, int dataSource, int rsId, Uri res, String strFilePath, boolean bLoop, int loopCount, String userData, boolean ringMode) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        hashMap.put(PARAM_RING_DATASOURCE, dataSource);
        hashMap.put(PARAM_RING_RSID, rsId);
        hashMap.put(PARAM_RING_URI, res);
        hashMap.put(PARAM_RING_FILEPATH, strFilePath);
        hashMap.put(PARAM_RING_LOOP, bLoop);
        hashMap.put(PARAM_RING_LOOPCOUNT, loopCount);
        hashMap.put(PARAM_RING_MODE, ringMode);
        hashMap.put(PARAM_RING_USERDATA_STRING, userData);
        return TraeAudioManager.sendMessage(32782, hashMap);
    }

    static int stopRing(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32783, hashMap);
    }

    static int requestReleaseAudioFocus(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32790, hashMap);
    }

    static int recoverAudioFocus(String strOption, long nSessionId, boolean bHostside) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, nSessionId);
        hashMap.put(PARAM_OPERATION, strOption);
        hashMap.put(PARAM_ISHOSTSIDE, bHostside);
        return TraeAudioManager.sendMessage(32791, hashMap);
    }

    int InternalSessionConnectDevice(HashMap<String, Object> params) {
        AudioDeviceInterface.LogTraceEntry("");
        if (null == params || this._context == null) {
            return -1;
        }
        if (IsMusicScene) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "MusicScene: InternalSessionConnectDevice failed");
            }
            return -1;
        }
        String string = "unkown";
        string = (String)params.get(PARAM_DEVICE);
        Log.w((String)TAG, (String)("ConnectDevice: " + string));
        if (!IsEarPhoneSupported && string.equals(DEVICE_EARPHONE)) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "InternalSessionConnectDevice IsEarPhoneSupported = false, Connect device:" + string + " failed");
            }
            return -1;
        }
        int n2 = 0;
        boolean bl = this.InternalIsDeviceChangeable();
        if (!TraeAudioManager.checkDevName(string)) {
            n2 = 7;
        } else if (!this._deviceConfigManager.getVisible(string)) {
            n2 = 8;
        } else if (!bl) {
            n2 = 9;
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "sessonID:" + (Long)params.get(PARAM_SESSIONID) + " devName:" + string + " bChangabled:" + (bl ? "Y" : "N") + " err:" + n2);
        }
        if (n2 != 0) {
            Intent intent = new Intent();
            intent.putExtra(CONNECTDEVICE_RESULT_DEVICENAME, (String)params.get(PARAM_DEVICE));
            this.sendResBroadcast(intent, params, n2);
            return -1;
        }
        if (string.equals(this._deviceConfigManager.getConnectedDevice())) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, " --has connected!");
            }
            Intent intent = new Intent();
            intent.putExtra(CONNECTDEVICE_RESULT_DEVICENAME, (String)params.get(PARAM_DEVICE));
            this.sendResBroadcast(intent, params, n2);
            return 0;
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, " --connecting...");
        }
        this.InternalConnectDevice(string, params, false);
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    int InternalSessionEarAction(HashMap<String, Object> params) {
        return 0;
    }

    int InternalConnectDevice(String devName, HashMap<String, Object> needResParams, boolean IsForceConnectDevice) {
        AudioDeviceInterface.LogTraceEntry(" devName:" + devName);
        if (devName == null) {
            return -1;
        }
        if (!IsForceConnectDevice && !DEVICE_BLUETOOTHHEADSET.equals(devName) && !this._deviceConfigManager.getConnectedDevice().equals(DEVICE_NONE) && devName.equals(this._deviceConfigManager.getConnectedDevice())) {
            return 0;
        }
        if (!TraeAudioManager.checkDevName(devName) || !this._deviceConfigManager.getVisible(devName)) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, " checkDevName fail");
            }
            return -1;
        }
        if (!this.InternalIsDeviceChangeable()) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, " InternalIsDeviceChangeable fail");
            }
            return -1;
        }
        if (this.IsServiceReadytoStop) {
            QLog.e(TAG, 2, " InternalConnectDevice fail,ready to stopService");
            return -1;
        }
        this._gSwitchTreadlock.lock();
        if (!this.IsServiceReadytoStop) {
            this._deviceConfigManager.setConnecting(devName);
            if (this._switchThread != null) {
                QLog.w(TAG, 2, "_switchThread:" + this._switchThread.getDeviceName());
                this._switchThread.quit();
                this._switchThread = null;
            }
            if (devName.equals(DEVICE_EARPHONE)) {
                this._switchThread = new earphoneSwitchThread();
            } else if (devName.equals(DEVICE_SPEAKERPHONE)) {
                this._switchThread = new speakerSwitchThread();
            } else if (devName.equals(DEVICE_WIREDHEADSET)) {
                this._switchThread = new headsetSwitchThread();
            } else if (devName.equals(DEVICE_BLUETOOTHHEADSET)) {
                this._switchThread = new bluetoothHeadsetSwitchThread();
            }
            if (this._switchThread != null) {
                this._switchThread.setDeviceConnectParam(needResParams);
                this._switchThread.start();
            }
        }
        this._gSwitchTreadlock.unlock();
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    int InternalSessionIsDeviceChangabled(HashMap<String, Object> params) {
        Intent intent = new Intent();
        intent.putExtra(ISDEVICECHANGABLED_RESULT_ISCHANGABLED, this.InternalIsDeviceChangeable());
        this.sendResBroadcast(intent, params, 0);
        return 0;
    }

    boolean InternalIsDeviceChangeable() {
        String string = null;
        string = this._deviceConfigManager.getConnectingDevice();
        return string == null || string.equals(DEVICE_NONE) || string.equals("");
    }

    int InternalSessionGetConnectedDevice(HashMap<String, Object> params) {
        Intent intent = new Intent();
        intent.putExtra(GETCONNECTEDDEVICE_RESULT_LIST, this._deviceConfigManager.getConnectedDevice());
        this.sendResBroadcast(intent, params, 0);
        return 0;
    }

    int InternalSessionGetConnectingDevice(HashMap<String, Object> params) {
        Intent intent = new Intent();
        intent.putExtra(GETCONNECTINGDEVICE_RESULT_LIST, this._deviceConfigManager.getConnectingDevice());
        this.sendResBroadcast(intent, params, 0);
        return 0;
    }

    int sendResBroadcast(Intent intent, HashMap<String, Object> params, int err) {
        if (this._context == null) {
            return -1;
        }
        Long l2 = (Long)params.get(PARAM_SESSIONID);
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, " sessonID:" + l2 + " " + (String)params.get(PARAM_OPERATION));
        }
        if (l2 == null || l2 == Long.MIN_VALUE) {
            this.InternalNotifyDeviceListUpdate();
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "sendResBroadcast sid null,don't send res");
            }
            return -1;
        }
        final Intent intent2 = intent;
        final Long l3 = (Long)params.get(PARAM_SESSIONID);
        final String string = (String)params.get(PARAM_OPERATION);
        final int n2 = err;
        if (OPERATION_VOICECALL_PREPROCESS.equals(string)) {
            intent2.setAction(ACTION_TRAEAUDIOMANAGER_RES);
            intent2.putExtra(PARAM_SESSIONID, (Serializable)l3);
            intent2.putExtra(PARAM_OPERATION, string);
            intent2.putExtra(PARAM_RES_ERRCODE, n2);
            if (this._audioSessionHost != null) {
                this._audioSessionHost.sendToAudioSessionMessage(intent2);
            }
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    intent2.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_RES);
                    intent2.putExtra(TraeAudioManager.PARAM_SESSIONID, (Serializable)l3);
                    intent2.putExtra(TraeAudioManager.PARAM_OPERATION, string);
                    intent2.putExtra(TraeAudioManager.PARAM_RES_ERRCODE, n2);
                    if (TraeAudioManager.this._context != null) {
                        b.a(TraeAudioManager.this._context).a(intent2);
                    }
                }
            });
        }
        return 0;
    }

    int InternalNotifyDeviceListUpdate() {
        AudioDeviceInterface.LogTraceEntry("");
        if (null == this._context) {
            return -1;
        }
        HashMap<String, Object> hashMap = this._deviceConfigManager.getSnapParams();
        final ArrayList arrayList = (ArrayList)hashMap.get(EXTRA_DATA_AVAILABLEDEVICE_LIST);
        final String string = (String)hashMap.get(EXTRA_DATA_CONNECTEDDEVICE);
        final String string2 = (String)hashMap.get(EXTRA_DATA_PREV_CONNECTEDDEVICE);
        final String string3 = this._deviceConfigManager.getBluetoothName();
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                intent.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
                intent.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_DEVICELIST_UPDATE);
                intent.putExtra(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST, arrayList.toArray(new String[0]));
                intent.putExtra(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE, string);
                intent.putExtra(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE, string2);
                intent.putExtra(TraeAudioManager.EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME, string3);
                if (TraeAudioManager.this._context != null) {
                    b.a(TraeAudioManager.this._context).a(intent);
                }
            }
        });
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    int InternalNotifyDeviceChangableUpdate() {
        if (null == this._context) {
            return -1;
        }
        final boolean bl = this.InternalIsDeviceChangeable();
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                intent.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
                intent.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_DEVICECHANGABLE_UPDATE);
                intent.putExtra(TraeAudioManager.NOTIFY_DEVICECHANGABLE_UPDATE_DATE, bl);
                if (TraeAudioManager.this._context != null) {
                    b.a(TraeAudioManager.this._context).a(intent);
                }
            }
        });
        return 0;
    }

    public BluetoohHeadsetCheckInterface CreateBluetoothCheck(Context context, DeviceConfigManager devCfg) {
        BluetoohHeadsetCheckInterface bluetoohHeadsetCheckInterface = null;
        bluetoohHeadsetCheckInterface = Build.VERSION.SDK_INT >= 11 ? new BluetoohHeadsetCheck() : (Build.VERSION.SDK_INT != 18 ? new BluetoohHeadsetCheckFor2x() : new BluetoohHeadsetCheckFake());
        if (!bluetoohHeadsetCheckInterface.init(context, devCfg)) {
            bluetoohHeadsetCheckInterface = new BluetoohHeadsetCheckFake();
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "CreateBluetoothCheck:" + bluetoohHeadsetCheckInterface.interfaceDesc() + " skip android4.3:" + (Build.VERSION.SDK_INT == 18 ? "Y" : "N"));
        }
        return bluetoohHeadsetCheckInterface;
    }

    static String getForceConfigName(int config) {
        if (config >= 0 && config < forceName.length) {
            return forceName[config];
        }
        return "unknow";
    }

    public static Object invokeMethod(Object owner, String methodName, Object[] args, Class[] argsClass) {
        Object object;
        block2: {
            object = null;
            try {
                Class<?> clazz = owner.getClass();
                Method method = clazz.getMethod(methodName, argsClass);
                object = method.invoke(owner, args);
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block2;
                QLog.w(TAG, 2, "invokeMethod Exception:" + exception.getMessage());
            }
        }
        return object;
    }

    public static Object invokeStaticMethod(String className, String methodName, Object[] args, Class[] argsClass) {
        Object object;
        block12: {
            object = null;
            try {
                Class<?> clazz = Class.forName(className);
                Method method = clazz.getMethod(methodName, argsClass);
                object = method.invoke(null, args);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, "ClassNotFound:" + className);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, "NoSuchMethod:" + methodName);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, "IllegalArgument:" + methodName);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, "IllegalAccess:" + methodName);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, "InvocationTarget:" + methodName);
                }
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block12;
                QLog.w(TAG, 2, "invokeStaticMethod Exception:" + exception.getMessage());
            }
        }
        return object;
    }

    static void setParameters(String keyValuePairs) {
        Object[] objectArray = new Object[]{keyValuePairs};
        Class[] classArray = new Class[objectArray.length];
        classArray[0] = String.class;
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "setParameters  :" + keyValuePairs);
        }
        TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "setParameters", objectArray, classArray);
    }

    static void setPhoneState(int state) {
        Object[] objectArray = new Object[]{state};
        Class[] classArray = new Class[objectArray.length];
        classArray[0] = Integer.TYPE;
        TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "setPhoneState", objectArray, classArray);
    }

    static void setForceUse(int usage, int config) {
        Object[] objectArray = new Object[]{usage, config};
        Class[] classArray = new Class[objectArray.length];
        classArray[0] = Integer.TYPE;
        classArray[1] = Integer.TYPE;
        Object object = TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "setForceUse", objectArray, classArray);
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "setForceUse  usage:" + usage + " config:" + config + " ->" + TraeAudioManager.getForceConfigName(config) + " res:" + object);
        }
    }

    static int getForceUse(int usage) {
        Integer n2 = 0;
        Object[] objectArray = new Object[]{usage};
        Class[] classArray = new Class[objectArray.length];
        classArray[0] = Integer.TYPE;
        Object object = TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "getForceUse", objectArray, classArray);
        if (object != null) {
            n2 = (Integer)object;
        }
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "getForceUse  usage:" + usage + " config:" + n2 + " ->" + TraeAudioManager.getForceConfigName(n2));
        }
        return n2;
    }

    static void forceVolumeControlStream(AudioManager am, int streamType) {
        if (f.c.equals("Google")) {
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "forceVolumeControlStream, Google phone nothing to do");
            }
            return;
        }
        Object[] objectArray = new Object[]{streamType};
        Class[] classArray = new Class[objectArray.length];
        classArray[0] = Integer.TYPE;
        Object object = TraeAudioManager.invokeMethod(am, "forceVolumeControlStream", objectArray, classArray);
        if (QLog.isColorLevel()) {
            QLog.w(TAG, 2, "forceVolumeControlStream  streamType:" + streamType + " res:" + object);
        }
    }

    class BluetoohHeadsetCheckFor2x
    extends BluetoohHeadsetCheckInterface {
        public static final String ACTION_BLUETOOTHHEADSET_AUDIO_STATE_CHANGED = "android.bluetooth.headset.action.AUDIO_STATE_CHANGED";
        public static final String ACTION_BLUETOOTHHEADSET_STATE_CHANGED = "android.bluetooth.headset.action.STATE_CHANGED";
        static final int STATE_CONNECTED = 2;
        static final int STATE_DISCONNECTED = 0;
        public static final int AUDIO_STATE_DISCONNECTED = 0;
        public static final int AUDIO_STATE_CONNECTED = 1;
        Class<?> BluetoothHeadsetClass;
        Class<?> ListenerClass;
        Object BluetoothHeadsetObj;
        Method getCurrentHeadsetMethod;
        Context _ctx;
        DeviceConfigManager _devCfg;

        BluetoohHeadsetCheckFor2x() {
            this.BluetoothHeadsetClass = null;
            this.ListenerClass = null;
            this.BluetoothHeadsetObj = null;
            this.getCurrentHeadsetMethod = null;
            this._ctx = null;
            this._devCfg = null;
        }

        @Override
        public boolean init(Context ctx, DeviceConfigManager devCfg) {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            AudioDeviceInterface.LogTraceEntry("");
                            Object var3_3 = null;
                            this._ctx = ctx;
                            this._devCfg = devCfg;
                            if (this._ctx == null || this._devCfg == null) {
                                return false;
                            }
                            try {
                                this.BluetoothHeadsetClass = Class.forName("android.bluetooth.BluetoothHeadset");
                            }
                            catch (Exception exception) {
                                if (!QLog.isColorLevel()) break block23;
                                QLog.e(TraeAudioManager.TAG, 2, "BTLooperThread BluetoothHeadset class not found");
                            }
                        }
                        if (this.BluetoothHeadsetClass == null) {
                            return false;
                        }
                        try {
                            this.ListenerClass = Class.forName("android.bluetooth.BluetoothHeadset$ServiceListener");
                        }
                        catch (Exception exception) {
                            if (!QLog.isColorLevel()) break block24;
                            QLog.e(TraeAudioManager.TAG, 2, "BTLooperThread BluetoothHeadset.ServiceListener class not found:" + exception);
                        }
                    }
                    if (this.ListenerClass == null) {
                        // empty if block
                    }
                    try {
                        this.getCurrentHeadsetMethod = this.BluetoothHeadsetClass.getDeclaredMethod("getCurrentHeadset", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (!QLog.isColorLevel()) break block25;
                        QLog.e(TraeAudioManager.TAG, 2, "BTLooperThread BluetoothHeadset method getCurrentHeadset NoSuchMethodException");
                    }
                }
                if (this.getCurrentHeadsetMethod == null) {
                    return false;
                }
                try {
                    this.BluetoothHeadsetObj = this.BluetoothHeadsetClass.getConstructor(Context.class, this.ListenerClass).newInstance(ctx, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TraeAudioManager.TAG, 2, "BTLooperThread BluetoothHeadset getConstructor IllegalArgumentException");
                    }
                }
                catch (InstantiationException instantiationException) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TraeAudioManager.TAG, 2, "BTLooperThread BluetoothHeadset getConstructor InstantiationException");
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TraeAudioManager.TAG, 2, "BTLooperThread BluetoothHeadset getConstructor IllegalAccessException");
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TraeAudioManager.TAG, 2, "BTLooperThread BluetoothHeadset getConstructor InvocationTargetException");
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!QLog.isColorLevel()) break block26;
                    QLog.e(TraeAudioManager.TAG, 2, "BTLooperThread BluetoothHeadset getConstructor NoSuchMethodException");
                }
            }
            if (this.BluetoothHeadsetObj == null) {
                return false;
            }
            this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, this.isConnected());
            if (this.isConnected()) {
                this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                TraeAudioManager.this.checkDevicePlug(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
            } else {
                this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
            }
            AudioDeviceInterface.LogTraceExit();
            return true;
        }

        @Override
        public void release() {
            block7: {
                Method method;
                block6: {
                    AudioDeviceInterface.LogTraceEntry("");
                    method = null;
                    if (this.BluetoothHeadsetObj == null) {
                        return;
                    }
                    try {
                        method = this.BluetoothHeadsetClass.getDeclaredMethod("close", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (!QLog.isColorLevel()) break block6;
                        QLog.e(TraeAudioManager.TAG, 2, "BTLooperThread _uninitHeadsetfor2x method close NoSuchMethodException");
                    }
                }
                if (method == null) {
                    return;
                }
                try {
                    method.invoke(this.BluetoothHeadsetObj, new Object[0]);
                }
                catch (Exception exception) {
                    if (!QLog.isColorLevel()) break block7;
                    QLog.e(TraeAudioManager.TAG, 2, "close bluetooth headset failed." + exception.getMessage());
                }
            }
            this.BluetoothHeadsetClass = null;
            this.ListenerClass = null;
            this.BluetoothHeadsetObj = null;
            this.getCurrentHeadsetMethod = null;
            AudioDeviceInterface.LogTraceExit();
        }

        @Override
        public boolean isConnected() {
            Object object;
            block8: {
                object = null;
                if (this.getCurrentHeadsetMethod == null || this.getCurrentHeadsetMethod == null) {
                    return false;
                }
                try {
                    object = this.getCurrentHeadsetMethod.invoke(this.BluetoothHeadsetObj, new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (QLog.isColorLevel()) {
                        QLog.w(TraeAudioManager.TAG, 2, "BTLooperThread BluetoothHeadset method getCurrentHeadset IllegalArgumentException");
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (QLog.isColorLevel()) {
                        QLog.w(TraeAudioManager.TAG, 2, "BTLooperThread BluetoothHeadset method getCurrentHeadset IllegalAccessException");
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!QLog.isColorLevel()) break block8;
                    QLog.w(TraeAudioManager.TAG, 2, "BTLooperThread BluetoothHeadset method getCurrentHeadset InvocationTargetException");
                }
            }
            if (QLog.isColorLevel()) {
                QLog.w(TraeAudioManager.TAG, 2, "BTLooperThread BluetoothHeadset method getCurrentHeadset res:" + (object != null ? " Y" : "N"));
            }
            return object != null;
        }

        @Override
        void _addAction(IntentFilter systemBroadcastFilter, IntentFilter appBroadcastFilter) {
            if (QLog.isColorLevel()) {
                QLog.w(TraeAudioManager.TAG, 2, " " + this.interfaceDesc() + " _addAction");
            }
            systemBroadcastFilter.addAction(ACTION_BLUETOOTHHEADSET_AUDIO_STATE_CHANGED);
            systemBroadcastFilter.addAction(ACTION_BLUETOOTHHEADSET_STATE_CHANGED);
        }

        @Override
        void _onReceive(Context context, Intent intent) {
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            if (ACTION_BLUETOOTHHEADSET_AUDIO_STATE_CHANGED.equals(intent.getAction())) {
                n2 = intent.getIntExtra("android.bluetooth.headset.extra.STATE", -2);
                n3 = intent.getIntExtra("android.bluetooth.headset.extra.PREVIOUS_STATE", -2);
                n4 = intent.getIntExtra("android.bluetooth.headset.extra.AUDIO_STATE", -2);
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "++ AUDIO_STATE_CHANGED|  STATE " + n2);
                }
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "       PREVIOUS_STATE " + n3);
                }
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "       AUDIO_STATE " + n4);
                }
                if (n4 == 2) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                } else if (n4 == 0) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
            } else if (ACTION_BLUETOOTHHEADSET_STATE_CHANGED.equals(intent.getAction())) {
                n2 = intent.getIntExtra("android.bluetooth.headset.extra.STATE", -2);
                n3 = intent.getIntExtra("android.bluetooth.headset.extra.PREVIOUS_STATE", -2);
                n4 = intent.getIntExtra("android.bluetooth.headset.extra.AUDIO_STATE", -2);
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "++ STATE_CHANGED|  STATE " + n2);
                }
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "       PREVIOUS_STATE " + n3);
                }
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "       AUDIO_STATE " + n4);
                }
                if (n4 == 2) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                } else if (n4 == 0) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
            }
        }

        @Override
        public String interfaceDesc() {
            return "BluetoohHeadsetCheckFor2x";
        }
    }

    @TargetApi(value=11)
    class BluetoohHeadsetCheck
    extends BluetoohHeadsetCheckInterface
    implements BluetoothProfile.ServiceListener {
        Context _ctx;
        DeviceConfigManager _devCfg;
        BluetoothAdapter _adapter;
        BluetoothProfile _profile;
        private final ReentrantLock _profileLock;

        BluetoohHeadsetCheck() {
            this._ctx = null;
            this._devCfg = null;
            this._adapter = null;
            this._profile = null;
            this._profileLock = new ReentrantLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TargetApi(value=11)
        public boolean init(Context ctx, DeviceConfigManager devCfg) {
            AudioDeviceInterface.LogTraceEntry("");
            if (ctx == null || devCfg == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " err ctx==null||_devCfg==null");
                }
                return false;
            }
            this._ctx = ctx;
            this._devCfg = devCfg;
            this._adapter = BluetoothAdapter.getDefaultAdapter();
            if (this._adapter == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " err getDefaultAdapter fail!");
                }
                return false;
            }
            this._profileLock.lock();
            try {
                if (this._adapter.isEnabled() && this._profile == null && !this._adapter.getProfileProxy(this._ctx, (BluetoothProfile.ServiceListener)this, 1)) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TraeAudioManager.TAG, 2, "BluetoohHeadsetCheck: getProfileProxy HEADSET fail!");
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this._profileLock.unlock();
            }
            AudioDeviceInterface.LogTraceExit();
            return true;
        }

        @Override
        public void release() {
            AudioDeviceInterface.LogTraceEntry("_profile:" + this._profile);
            this._profileLock.lock();
            try {
                if (this._adapter != null) {
                    if (this._profile != null) {
                        this._adapter.closeProfileProxy(1, this._profile);
                    }
                    this._profile = null;
                }
            }
            catch (Exception exception) {
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, " closeProfileProxy:e:" + exception.getMessage());
                }
            }
            finally {
                this._profileLock.unlock();
            }
            AudioDeviceInterface.LogTraceExit();
        }

        private List<BluetoothDevice> getConnectedDevices() {
            List list;
            block5: {
                if (this._profile == null) {
                    return null;
                }
                list = null;
                try {
                    boolean bl = true;
                    if (TraeAudioManager.this._context != null && Build.VERSION.SDK_INT >= 31) {
                        boolean bl2 = bl = 0 == TraeAudioManager.this._context.checkPermission("android.permission.BLUETOOTH_CONNECT", Process.myPid(), Process.myUid());
                    }
                    if (bl) {
                        list = this._profile.getConnectedDevices();
                    }
                }
                catch (Exception exception) {
                    if (!QLog.isColorLevel()) break block5;
                    QLog.e(TraeAudioManager.TAG, 2, "get connected devices failed." + exception.getMessage());
                }
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isConnected() {
            boolean bl = false;
            this._profileLock.lock();
            try {
                if (this._profile != null) {
                    List<BluetoothDevice> list = this.getConnectedDevices();
                    if (list == null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    bl = list.size() > 0;
                }
            }
            finally {
                this._profileLock.unlock();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TargetApi(value=11)
        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            AudioDeviceInterface.LogTraceEntry("_profile:" + this._profile + " profile:" + profile + " proxy:" + proxy);
            if (profile == 1) {
                List<BluetoothDevice> list;
                block18: {
                    this._profileLock.lock();
                    try {
                        if (this._profile != null && this._profile != proxy) {
                            if (QLog.isColorLevel()) {
                                QLog.w(TraeAudioManager.TAG, 2, "BluetoohHeadsetCheck: HEADSET Connected proxy:" + proxy + " _profile:" + this._profile);
                            }
                            this._adapter.closeProfileProxy(1, this._profile);
                            this._profile = null;
                        }
                        this._profile = proxy;
                        list = this.getConnectedDevices();
                        if (list == null || this._profile == null) break block18;
                        if (QLog.isColorLevel()) {
                            QLog.w(TraeAudioManager.TAG, 2, "TRAEBluetoohProxy: HEADSET Connected devs:" + list.size() + " _profile:" + this._profile);
                        }
                        for (int i2 = 0; i2 < list.size(); ++i2) {
                            int n2;
                            BluetoothDevice bluetoothDevice;
                            block19: {
                                bluetoothDevice = list.get(i2);
                                n2 = 0;
                                try {
                                    if (this._profile != null) {
                                        n2 = this._profile.getConnectionState(bluetoothDevice);
                                    }
                                }
                                catch (Exception exception) {
                                    if (!QLog.isColorLevel()) break block19;
                                    QLog.e(TraeAudioManager.TAG, 2, "get bluetooth connection state failed." + exception.getMessage());
                                }
                            }
                            if (n2 == 2) {
                                this._devCfg.setBluetoothName(bluetoothDevice.getName());
                            }
                            if (!QLog.isColorLevel()) continue;
                            QLog.w(TraeAudioManager.TAG, 2, "   " + i2 + " " + bluetoothDevice.getName() + " ConnectionState:" + n2);
                        }
                    }
                    finally {
                        this._profileLock.unlock();
                    }
                }
                if (this._devCfg != null) {
                    list = null;
                    if (TraeAudioManager.this._deviceConfigManager != null) {
                        list = TraeAudioManager.this._deviceConfigManager.getBluetoothName();
                    }
                    if (TextUtils.isEmpty(list)) {
                        this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                    } else if (this.isConnected()) {
                        this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                        TraeAudioManager.this.checkDevicePlug(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                    } else {
                        this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                    }
                }
            }
            AudioDeviceInterface.LogTraceExit();
        }

        @TargetApi(value=11)
        public void onServiceDisconnected(int profile) {
            AudioDeviceInterface.LogTraceEntry("_profile:" + this._profile + " profile:" + profile);
            if (profile == 1) {
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "TRAEBluetoohProxy: HEADSET Disconnected");
                }
                if (this.isConnected()) {
                    TraeAudioManager.this.checkDevicePlug(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
                this._profileLock.lock();
                try {
                    if (this._profile != null) {
                        this._adapter.closeProfileProxy(1, this._profile);
                        this._profile = null;
                    }
                }
                finally {
                    this._profileLock.unlock();
                }
            }
            AudioDeviceInterface.LogTraceExit();
        }

        @Override
        void _addAction(IntentFilter systemBroadcastFilter, IntentFilter appBroadcastFilter) {
            if (QLog.isColorLevel()) {
                QLog.w(TraeAudioManager.TAG, 2, " " + this.interfaceDesc() + " _addAction");
            }
            systemBroadcastFilter.addAction("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
            systemBroadcastFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
            systemBroadcastFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void _onReceive(Context context, Intent intent) {
            int n2 = -1;
            int n3 = -1;
            BluetoothDevice bluetoothDevice = null;
            int n4 = -1;
            if ("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED".equals(intent.getAction())) {
                int n5 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 10);
                if (n5 == 12) {
                    if (TraeAudioManager.this.bluetoothState == 6) {
                        QLog.w(TraeAudioManager.TAG, 2, "bluetoothHeadsetSwitchThread ACTION_AUDIO_STATE_CHANGED +++ Bluetooth audio SCO is now connected, SCO_CONNECTED");
                        TraeAudioManager.this.bluetoothState = 7;
                        boolean[] blArray = TraeAudioManager.this._bluetooth_sco_connect;
                        synchronized (TraeAudioManager.this._bluetooth_sco_connect) {
                            TraeAudioManager.this._bluetooth_sco_connect[0] = true;
                            TraeAudioManager.this._bluetooth_sco_connect.notifyAll();
                            // ** MonitorExit[var8_10] (shouldn't be in output)
                        }
                    }
                } else if (n5 == 10) {
                    TraeAudioManager.this.checkAutoDeviceListUpdate(true);
                }
            } else if ("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED".equals(intent.getAction())) {
                int n6 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                switch (n6) {
                    case 0: {
                        TraeAudioManager.this.bluetoothState = 3;
                        this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                        QLog.w(TraeAudioManager.TAG, 2, "BluetoothHeadset ACTION_CONNECTION_STATE_CHANGED BluetoothProfile.STATE_DISCONNECTED");
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        TraeAudioManager.this.bluetoothState = 4;
                        this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                        QLog.w(TraeAudioManager.TAG, 2, "BluetoothHeadset ACTION_CONNECTION_STATE_CHANGED BluetoothProfile.STATE_CONNECTED");
                        TraeAudioManager.this.checkAutoDeviceListUpdate(false);
                    }
                }
            } else if ("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED".equals(intent.getAction())) {
                n2 = intent.getIntExtra("android.bluetooth.adapter.extra.CONNECTION_STATE", -1);
                n3 = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE", -1);
                bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "BT ACTION_CONNECTION_STATE_CHANGED|   EXTRA_CONNECTION_STATE " + this.getBTAdapterConnectionState(n2));
                }
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "    EXTRA_PREVIOUS_CONNECTION_STATE " + this.getBTAdapterConnectionState(n3));
                }
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "    EXTRA_DEVICE " + bluetoothDevice + " " + (bluetoothDevice != null ? bluetoothDevice.getName() : " "));
                }
                if (n2 == 2) {
                    String string;
                    if (QLog.isColorLevel()) {
                        QLog.w(TraeAudioManager.TAG, 2, "   dev:" + bluetoothDevice.getName() + " connected");
                    }
                    String string2 = string = bluetoothDevice != null ? bluetoothDevice.getName() : "unkown";
                    if (!string.contains("FreeBuds")) {
                        this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                    }
                    this._devCfg.setBluetoothName(string);
                } else if (n2 == 0) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
            }
        }

        @Override
        public String interfaceDesc() {
            return "BluetoohHeadsetCheck";
        }
    }

    class BluetoohHeadsetCheckFake
    extends BluetoohHeadsetCheckInterface {
        BluetoohHeadsetCheckFake() {
        }

        @Override
        public boolean init(Context ctx, DeviceConfigManager devCfg) {
            return true;
        }

        @Override
        public void release() {
        }

        @Override
        public boolean isConnected() {
            return false;
        }

        @Override
        void _addAction(IntentFilter systemBroadcastFilter, IntentFilter appBroadcastFilter) {
        }

        @Override
        void _onReceive(Context context, Intent intent) {
        }

        @Override
        public String interfaceDesc() {
            return "BluetoohHeadsetCheckFake";
        }
    }

    abstract class BluetoohHeadsetCheckInterface {
        BluetoohHeadsetCheckInterface() {
        }

        public abstract String interfaceDesc();

        public abstract boolean init(Context var1, DeviceConfigManager var2);

        public abstract void release();

        public abstract boolean isConnected();

        public void addAction(IntentFilter systemBroadcastFilter, IntentFilter appBroadcastFilter) {
            systemBroadcastFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            systemBroadcastFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
            systemBroadcastFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
            this._addAction(systemBroadcastFilter, appBroadcastFilter);
        }

        abstract void _addAction(IntentFilter var1, IntentFilter var2);

        abstract void _onReceive(Context var1, Intent var2);

        public void onReceive(Context context, Intent intent, DeviceConfigManager devCfg) {
            if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(intent.getAction())) {
                int n2 = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
                int n3 = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", -1);
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "BT ACTION_STATE_CHANGED|   EXTRA_STATE " + this.getBTActionStateChangedExtraString(n2));
                }
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "BT ACTION_STATE_CHANGED|   EXTRA_PREVIOUS_STATE " + this.getBTActionStateChangedExtraString(n3));
                }
                if (n2 == 10) {
                    if (QLog.isColorLevel()) {
                        QLog.w(TraeAudioManager.TAG, 2, "    BT off");
                    }
                    devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                } else if (n2 == 12 && QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "BT OFF-->ON,Visiable it...");
                }
            } else if (!("android.bluetooth.device.action.ACL_CONNECTED".equals(intent.getAction()) && Build.VERSION.SDK_INT < 11 || "android.bluetooth.device.action.ACL_DISCONNECTED".equals(intent.getAction()) && Build.VERSION.SDK_INT < 11)) {
                this._onReceive(context, intent);
            }
        }

        String getBTActionStateChangedExtraString(int state) {
            String string;
            switch (state) {
                case 10: {
                    string = "STATE_OFF";
                    break;
                }
                case 11: {
                    string = "STATE_TURNING_ON";
                    break;
                }
                case 12: {
                    string = "STATE_ON";
                    break;
                }
                case 13: {
                    string = "STATE_TURNING_OFF";
                    break;
                }
                default: {
                    string = "unknow";
                }
            }
            return string + ":" + state;
        }

        String getSCOAudioStateExtraString(int state) {
            String string;
            switch (state) {
                case 0: {
                    string = "SCO_AUDIO_STATE_DISCONNECTED";
                    break;
                }
                case 1: {
                    string = "SCO_AUDIO_STATE_CONNECTED";
                    break;
                }
                case 2: {
                    string = "SCO_AUDIO_STATE_CONNECTING";
                    break;
                }
                case -1: {
                    string = "SCO_AUDIO_STATE_ERROR";
                    break;
                }
                default: {
                    string = "unknow";
                }
            }
            return string + ":" + state;
        }

        String getBTAdapterConnectionState(int state) {
            String string;
            switch (state) {
                case 0: {
                    string = "STATE_DISCONNECTED";
                    break;
                }
                case 1: {
                    string = "STATE_CONNECTING";
                    break;
                }
                case 2: {
                    string = "STATE_CONNECTED";
                    break;
                }
                case 3: {
                    string = "STATE_DISCONNECTING";
                    break;
                }
                default: {
                    string = "unknow";
                }
            }
            return string + ":" + state;
        }

        String getBTHeadsetConnectionState(int state) {
            String string;
            switch (state) {
                case 0: {
                    string = "STATE_DISCONNECTED";
                    break;
                }
                case 1: {
                    string = "STATE_CONNECTING";
                    break;
                }
                case 2: {
                    string = "STATE_CONNECTED";
                    break;
                }
                case 3: {
                    string = "STATE_DISCONNECTING";
                    break;
                }
                default: {
                    string = "unknow";
                }
            }
            return string + ":" + state;
        }

        String getBTHeadsetAudioState(int state) {
            String string;
            switch (state) {
                case 12: {
                    string = "STATE_AUDIO_CONNECTED";
                    break;
                }
                case 10: {
                    string = "STATE_AUDIO_DISCONNECTED";
                    break;
                }
                default: {
                    string = "unknow:" + state;
                }
            }
            return string + ":" + state;
        }
    }

    class bluetoothHeadsetSwitchThread
    extends switchThread {
        bluetoothHeadsetSwitchThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void _run() {
            if (IsMusicScene || !IsUpdateSceneFlag) {
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "connect bluetoothHeadset: do nothing, IsMusicScene:" + IsMusicScene + " ,IsUpdateSceneFlag:" + IsUpdateSceneFlag);
                }
                this.updateStatus();
                return;
            }
            if (!enableDeviceSwitchFlag) {
                if (!QLog.isColorLevel()) return;
                QLog.w(TraeAudioManager.TAG, 2, "connect bluetoothHeadset: disableDeviceSwitchFlag");
                return;
            }
            String string = TraeAudioManager.this._deviceConfigManager.getBluetoothName();
            try {
                if (TraeAudioManager.this.bluetoothState == 8) {
                    QLog.w(TraeAudioManager.TAG, 2, "bluetoothHeadsetSwitchThread SCO_DISCONNECTED sleep 5000");
                    Thread.sleep(5000L);
                } else {
                    QLog.w(TraeAudioManager.TAG, 2, "bluetoothHeadsetSwitchThread sleep 1000");
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TraeAudioManager.this.bluetoothState = 4;
            boolean bl = false;
            boolean bl2 = false;
            if (!bl && this._running) {
                TraeAudioManager.this.bluetoothState = 6;
                boolean[] blArray = TraeAudioManager.this._bluetooth_sco_connect;
                // MONITORENTER : TraeAudioManager.this._bluetooth_sco_connect
                TraeAudioManager.this._bluetooth_sco_connect[0] = false;
                // MONITOREXIT : blArray
                this._startBluetoothSco();
                bl2 = true;
                QLog.w(TraeAudioManager.TAG, 2, "bluetoothHeadsetSwitchThread _startBluetoothSco");
            }
            int n2 = 1;
            while (this._running && !bl) {
                QLog.w(TraeAudioManager.TAG, 2, "bluetoothHeadsetSwitchThread i:" + n2 + " sco:" + (TraeAudioManager.this._am.isBluetoothScoOn() ? "Y" : "N") + " :" + TraeAudioManager.this._deviceConfigManager.getBluetoothName());
                if (TraeAudioManager.this.bluetoothState == 7) {
                    QLog.w(TraeAudioManager.TAG, 2, "bluetoothHeadsetSwitchThread bluetoothState ==  Bluetooth_State.SCO_CONNECTED 1");
                    this.updateStatus();
                    break;
                }
                boolean[] blArray = TraeAudioManager.this._bluetooth_sco_connect;
                // MONITORENTER : TraeAudioManager.this._bluetooth_sco_connect
                if (!TraeAudioManager.this._bluetooth_sco_connect[0]) {
                    try {
                        TraeAudioManager.this._bluetooth_sco_connect.wait(4000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : blArray
                if (TraeAudioManager.this.bluetoothState == 7) {
                    QLog.w(TraeAudioManager.TAG, 2, "bluetoothHeadsetSwitchThread bluetoothState ==  Bluetooth_State.SCO_CONNECTED 2");
                    this.updateStatus();
                    break;
                }
                if (n2++ > 3) break;
                if (!bl2) continue;
                this._stopBluetoothSco();
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                TraeAudioManager.this.bluetoothState = 6;
                blArray = TraeAudioManager.this._bluetooth_sco_connect;
                // MONITORENTER : TraeAudioManager.this._bluetooth_sco_connect
                TraeAudioManager.this._bluetooth_sco_connect[0] = false;
                // MONITOREXIT : blArray
                this._startBluetoothSco();
                QLog.w(TraeAudioManager.TAG, 2, "bluetoothHeadsetSwitchThread retry start sco");
            }
            if (TraeAudioManager.this.bluetoothState == 7) return;
            if (!bl) {
                QLog.e(TraeAudioManager.TAG, 2, "bluetoothHeadsetSwitchThread sco fail,remove btheadset");
            }
            TraeAudioManager.this._deviceConfigManager.setVisible(this.getDeviceName(), false);
            TraeAudioManager.this._deviceConfigManager.resetNullConnecting();
            this.processDeviceConnectRes(10);
            TraeAudioManager.this.checkAutoDeviceListUpdate(false);
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_BLUETOOTHHEADSET;
        }

        @Override
        @TargetApi(value=8)
        public void _quit() {
            if (TraeAudioManager.this._am == null) {
                return;
            }
            QLog.w(TraeAudioManager.TAG, 2, "bluetoothHeadsetSwitchThread _quit _stopBluetoothSco");
            this._stopBluetoothSco();
        }

        @TargetApi(value=8)
        void _startBluetoothSco() {
            TraeAudioManager.this._am.setBluetoothScoOn(true);
            if (Build.VERSION.SDK_INT > 8) {
                TraeAudioManager.this._am.startBluetoothSco();
            }
        }

        @TargetApi(value=8)
        void _stopBluetoothSco() {
            try {
                TraeAudioManager.this._am.stopBluetoothSco();
                TraeAudioManager.this._am.setBluetoothScoOn(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class headsetSwitchThread
    extends switchThread {
        headsetSwitchThread() {
        }

        @Override
        public void _run() {
            int n2 = 0;
            if (!IsMusicScene && IsUpdateSceneFlag && enableDeviceSwitchFlag) {
                TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, false);
                TraeAudioManager.this._am.setWiredHeadsetOn(true);
            }
            this.updateStatus();
            if (!enableDeviceSwitchFlag) {
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "connect headset: disableDeviceSwitchFlag");
                }
                return;
            }
            while (this._running) {
                if (IsMusicScene || !IsUpdateSceneFlag) {
                    if (QLog.isColorLevel()) {
                        QLog.d(TraeAudioManager.TAG, 2, "connect headset: do nothing");
                    }
                } else if (TraeAudioManager.this._am.isSpeakerphoneOn()) {
                    TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, false);
                }
                try {
                    Thread.sleep(n2 < 5 ? 1000L : 4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
            }
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_WIREDHEADSET;
        }

        @Override
        public void _quit() {
        }
    }

    class speakerSwitchThread
    extends switchThread {
        speakerSwitchThread() {
        }

        @Override
        public void _run() {
            int n2 = 0;
            if (!IsMusicScene && IsUpdateSceneFlag && enableDeviceSwitchFlag) {
                TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, true);
            }
            this.updateStatus();
            if (!enableDeviceSwitchFlag) {
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "connect speakerPhone: disableDeviceSwitchFlag");
                }
                return;
            }
            if (QLog.isColorLevel()) {
                QLog.w(TraeAudioManager.TAG, 2, " _run:" + this.getDeviceName() + " _running:" + this._running);
            }
            while (this._running) {
                if (IsMusicScene || !IsUpdateSceneFlag) {
                    if (QLog.isColorLevel()) {
                        QLog.d(TraeAudioManager.TAG, 2, "connect speakerPhone: do nothing");
                    }
                } else if (!TraeAudioManager.this._am.isSpeakerphoneOn()) {
                    TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, true);
                }
                try {
                    Thread.sleep(n2 < 5 ? 1000L : 4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
            }
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_SPEAKERPHONE;
        }

        @Override
        public void _quit() {
        }
    }

    class earphoneSwitchThread
    extends switchThread {
        earphoneSwitchThread() {
        }

        @Override
        public void _run() {
            int n2 = 0;
            if (!IsMusicScene && IsUpdateSceneFlag && enableDeviceSwitchFlag) {
                TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, false);
            }
            this.updateStatus();
            if (!enableDeviceSwitchFlag) {
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "connect earphone: disableDeviceSwitchFlag");
                }
                return;
            }
            while (this._running) {
                if (IsMusicScene || !IsUpdateSceneFlag) {
                    if (QLog.isColorLevel()) {
                        QLog.d(TraeAudioManager.TAG, 2, "connect earphone: do nothing");
                    }
                } else {
                    try {
                        if (TraeAudioManager.this._am.isSpeakerphoneOn()) {
                            TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, false);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(n2 < 5 ? 1000L : 4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
            }
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_EARPHONE;
        }

        @Override
        public void _quit() {
        }
    }

    abstract class switchThread
    extends Thread {
        boolean _running = true;
        boolean[] _exited = new boolean[]{false};
        HashMap<String, Object> _params = null;
        long _usingtime = 0L;

        switchThread() {
            if (QLog.isColorLevel()) {
                QLog.w(TraeAudioManager.TAG, 2, "construct switchThread:" + this.getDeviceName());
            }
        }

        public void setDeviceConnectParam(HashMap<String, Object> params) {
            this._params = params;
        }

        void updateStatus() {
            TraeAudioManager.this._deviceConfigManager.setConnected(this.getDeviceName());
            this.processDeviceConnectRes(0);
        }

        void processDeviceConnectRes(int err) {
            TraeAudioManager.this.InternalNotifyDeviceChangableUpdate();
            AudioDeviceInterface.LogTraceEntry(this.getDeviceName() + " err:" + err);
            if (this._params == null) {
                TraeAudioManager.this.InternalNotifyDeviceListUpdate();
                return;
            }
            TraeAudioManager.this.sessionConnectedDev = TraeAudioManager.this._deviceConfigManager.getConnectedDevice();
            Long l2 = (Long)this._params.get(TraeAudioManager.PARAM_SESSIONID);
            if (QLog.isColorLevel()) {
                QLog.w(TraeAudioManager.TAG, 2, " sessonID:" + l2);
            }
            if (l2 == null || l2 == Long.MIN_VALUE) {
                TraeAudioManager.this.InternalNotifyDeviceListUpdate();
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "processDeviceConnectRes sid null,don't send res");
                }
                return;
            }
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.CONNECTDEVICE_RESULT_DEVICENAME, (String)this._params.get(TraeAudioManager.PARAM_DEVICE));
            if (TraeAudioManager.this.sendResBroadcast(intent, this._params, err) == 0) {
                TraeAudioManager.this.InternalNotifyDeviceListUpdate();
            }
            AudioDeviceInterface.LogTraceExit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AudioDeviceInterface.LogTraceEntry(this.getDeviceName());
            TraeAudioManager.this._deviceConfigManager.setConnecting(this.getDeviceName());
            TraeAudioManager.this.InternalNotifyDeviceChangableUpdate();
            this._run();
            boolean[] blArray = this._exited;
            synchronized (this._exited) {
                this._exited[0] = true;
                this._exited.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                AudioDeviceInterface.LogTraceExit();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            AudioDeviceInterface.LogTraceEntry(this.getDeviceName());
            this._running = false;
            if (QLog.isColorLevel()) {
                QLog.w(TraeAudioManager.TAG, 2, " quit:" + this.getDeviceName() + " _running:" + this._running);
            }
            this.interrupt();
            this._quit();
            boolean[] blArray = this._exited;
            synchronized (this._exited) {
                if (!this._exited[0]) {
                    try {
                        this._exited.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                AudioDeviceInterface.LogTraceExit();
                return;
            }
        }

        public abstract String getDeviceName();

        public abstract void _run();

        public abstract void _quit();
    }

    class TraeAudioManagerLooper
    extends Thread {
        public static final int MESSAGE_BEGIN = 32768;
        public static final int MESSAGE_ENABLE = 32772;
        public static final int MESSAGE_DISABLE = 32773;
        public static final int MESSAGE_GETDEVICELIST = 32774;
        public static final int MESSAGE_CONNECTDEVICE = 32775;
        public static final int MESSAGE_EARACTION = 32776;
        public static final int MESSAGE_ISDEVICECHANGABLED = 32777;
        public static final int MESSAGE_GETCONNECTEDDEVICE = 32778;
        public static final int MESSAGE_GETCONNECTINGDEVICE = 32779;
        public static final int MESSAGE_VOICECALLPREPROCESS = 32780;
        public static final int MESSAGE_VOICECALLPOSTPROCESS = 32781;
        public static final int MESSAGE_STARTRING = 32782;
        public static final int MESSAGE_STOPRING = 32783;
        public static final int MESSAGE_GETSTREAMTYPE = 32784;
        public static final int MESSAGE_AUTO_DEVICELIST_UPDATE = 32785;
        public static final int MESSAGE_AUTO_DEVICELIST_PLUGIN_UPDATE = 32786;
        public static final int MESSAGE_AUTO_DEVICELIST_PLUGOUT_UPDATE = 32787;
        public static final int MESSAGE_VOICECALL_AUIDOPARAM_CHANGED = 32788;
        public static final int MESSAGE_CONNECT_HIGHEST_PRIORITY_DEVICE = 32789;
        public static final int MESSAGE_REQUEST_RELEASE_AUDIO_FOCUS = 32790;
        public static final int MESSAGE_RECOVER_AUDIO_FOCUS = 32791;
        public static final int MESSAGE_NOTIFY_DEVICELIST_UPDATE = 32793;
        Handler mMsgHandler = null;
        TraeMediaPlayer _ringPlayer = null;
        long _ringSessionID = -1L;
        String _ringOperation = "";
        String _ringUserdata = "";
        final boolean[] _started = new boolean[]{false};
        boolean _enabled = false;
        TraeAudioManager _parent = null;
        String _lastCfg = "";
        int _preServiceMode = 0;
        int _preRingMode = 0;
        long _voiceCallSessionID = -1L;
        String _voiceCallOperation = "";
        AudioManager.OnAudioFocusChangeListener mAudioFocusChangeListener = null;
        int _focusSteamType = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TraeAudioManagerLooper(TraeAudioManager parent) {
            this._parent = parent;
            long l2 = SystemClock.elapsedRealtime();
            if (QLog.isColorLevel()) {
                QLog.e(TraeAudioManager.TAG, 2, "TraeAudioManagerLooper start...");
            }
            this.start();
            boolean[] blArray = this._started;
            synchronized (this._started) {
                if (!this._started[0]) {
                    try {
                        this._started.wait(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, "  start used:" + (SystemClock.elapsedRealtime() - l2) + "ms");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            AudioDeviceInterface.LogTraceEntry("");
            if (null == this.mMsgHandler) {
                return;
            }
            long l2 = SystemClock.elapsedRealtime();
            this.mMsgHandler.getLooper().quit();
            boolean[] blArray = this._started;
            synchronized (this._started) {
                if (this._started[0]) {
                    try {
                        this._started.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, "  quit used:" + (SystemClock.elapsedRealtime() - l2) + "ms");
                }
                this.mMsgHandler = null;
                AudioDeviceInterface.LogTraceExit();
                return;
            }
        }

        public int sendMessage(int nMsg, HashMap<String, Object> params) {
            if (null == this.mMsgHandler) {
                AudioDeviceInterface.LogTraceEntry(" fail mMsgHandler==null _enabled:" + (this._enabled ? "Y" : "N") + " activeMode:" + TraeAudioManager.this._activeMode + " msg:" + nMsg);
                return -1;
            }
            Message message = Message.obtain((Handler)this.mMsgHandler, (int)nMsg, params);
            if (nMsg == 32786 && !TraeAudioManager.this.InternalIsDeviceChangeable()) {
                QLog.w(TraeAudioManager.TAG, 2, "sendMessageDelayed, device is connecting, plugin need delay 1 second");
                return this.mMsgHandler.sendMessageDelayed(message, 1000L) ? 0 : -1;
            }
            return this.mMsgHandler.sendMessage(message) ? 0 : -1;
        }

        void startService(HashMap<String, Object> params) {
            String string = (String)params.get(TraeAudioManager.EXTRA_DATA_DEVICECONFIG);
            QLog.w(TraeAudioManager.TAG, 2, "startService cfg:" + string);
            AudioDeviceInterface.LogTraceEntry(" _enabled:" + (this._enabled ? "Y" : "N") + " activeMode:" + TraeAudioManager.this._activeMode + " cfg:" + string);
            if (TraeAudioManager.this._context == null) {
                return;
            }
            QLog.w(TraeAudioManager.TAG, 2, "   startService:" + string);
            if (this._enabled && this._lastCfg.equals(string) || TraeAudioManager.this._activeMode != 0) {
                return;
            }
            if (this._enabled) {
                this.stopService();
            }
            this._prev_startService();
            AudioManager audioManager = (AudioManager)TraeAudioManager.this._context.getSystemService("audio");
            if (null != TraeAudioManager.this._deviceConfigManager) {
                TraeAudioManager.this._deviceConfigManager.clearConfig();
                TraeAudioManager.this._deviceConfigManager.init(string);
            }
            this._lastCfg = string;
            if (TraeAudioManager.this._am != null) {
                this._preServiceMode = TraeAudioManager.this._am.getMode();
            }
            this._enabled = true;
            TraeAudioManager.this.IsServiceReadytoStop = false;
            if (this._ringPlayer == null) {
                this._ringPlayer = new TraeMediaPlayer(TraeAudioManager.this._context, new TraeMediaPlayer.OnCompletionListener(){

                    @Override
                    public void onCompletion() {
                        if (QLog.isColorLevel()) {
                            QLog.w(TraeAudioManager.TAG, 2, "_ringPlayer onCompletion _activeMode:" + TraeAudioManager.this._activeMode + " _preRingMode:" + TraeAudioManagerLooper.this._preRingMode);
                        }
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put(TraeAudioManager.PARAM_ISHOSTSIDE, true);
                        TraeAudioManagerLooper.this.sendMessage(32783, hashMap);
                        TraeAudioManagerLooper.this.notifyRingCompletion();
                    }
                });
            }
            TraeAudioManager.this.updateDeviceStatus();
            this.notifyServiceState(this._enabled);
            AudioDeviceInterface.LogTraceExit();
        }

        boolean isNeedForceVolumeType() {
            if (f.c.equals("Xiaomi")) {
                if (f.a.equals("MI 5")) {
                    return true;
                }
                if (f.a.equals("MI 5s")) {
                    return true;
                }
                if (f.a.equals("MI 5s Plus")) {
                    return true;
                }
            }
            return false;
        }

        void stopService() {
            block11: {
                AudioDeviceInterface.LogTraceEntry(" _enabled:" + (this._enabled ? "Y" : "N") + " activeMode:" + TraeAudioManager.this._activeMode);
                if (!this._enabled) {
                    return;
                }
                TraeAudioManager.this.IsServiceReadytoStop = true;
                if (TraeAudioManager.this._activeMode == 1) {
                    this.interruptVoicecallPostprocess();
                } else if (TraeAudioManager.this._activeMode == 2) {
                    this.interruptRing();
                }
                TraeAudioManager.this._gSwitchTreadlock.lock();
                if (TraeAudioManager.this._switchThread != null) {
                    if (QLog.isColorLevel()) {
                        QLog.w(TraeAudioManager.TAG, 2, "_switchThread:" + TraeAudioManager.this._switchThread.getDeviceName());
                    }
                    TraeAudioManager.this._switchThread.quit();
                    TraeAudioManager.this._switchThread = null;
                }
                TraeAudioManager.this._gSwitchTreadlock.unlock();
                if (this._ringPlayer != null) {
                    this._ringPlayer.stopRing();
                }
                this._ringPlayer = null;
                this._enabled = false;
                this.notifyServiceState(this._enabled);
                if (TraeAudioManager.this._am != null && TraeAudioManager.this._context != null) {
                    try {
                        TraeAudioManager.this.InternalSetMode(0);
                        if (this.isNeedForceVolumeType()) {
                            QLog.w(TraeAudioManager.TAG, 2, "NeedForceVolumeType: AudioManager.STREAM_MUSIC");
                            TraeAudioManager.forceVolumeControlStream(TraeAudioManager.this._am, 3);
                        }
                    }
                    catch (Exception exception) {
                        if (!QLog.isColorLevel()) break block11;
                        QLog.e(TraeAudioManager.TAG, 2, "set mode failed." + exception.getMessage());
                    }
                }
            }
            this._post_stopService();
            AudioDeviceInterface.LogTraceExit();
        }

        int notifyServiceState(boolean on) {
            if (null == TraeAudioManager.this._context) {
                return -1;
            }
            Intent intent = new Intent();
            intent.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
            intent.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_SERVICE_STATE);
            intent.putExtra(TraeAudioManager.NOTIFY_SERVICE_STATE_DATE, on);
            if (TraeAudioManager.this._context != null) {
                b.a(TraeAudioManager.this._context).a(intent);
            }
            return 0;
        }

        String msgToText(int what) {
            String string;
            switch (what) {
                case 32768: {
                    string = "MESSAGE_BEGIN";
                    break;
                }
                case 32772: {
                    string = "MESSAGE_ENABLE";
                    break;
                }
                case 32773: {
                    string = "MESSAGE_DISABLE";
                    break;
                }
                case 32774: {
                    string = "MESSAGE_GETDEVICELIST";
                    break;
                }
                case 32775: {
                    string = "MESSAGE_CONNECTDEVICE";
                    break;
                }
                case 32776: {
                    string = "MESSAGE_EARACTION";
                    break;
                }
                case 32777: {
                    string = "MESSAGE_ISDEVICECHANGABLED";
                    break;
                }
                case 32778: {
                    string = "MESSAGE_GETCONNECTEDDEVICE";
                    break;
                }
                case 32779: {
                    string = "MESSAGE_GETCONNECTINGDEVICE";
                    break;
                }
                case 32780: {
                    string = "MESSAGE_VOICECALLPREPROCESS";
                    break;
                }
                case 32781: {
                    string = "MESSAGE_VOICECALLPOSTPROCESS";
                    break;
                }
                case 32782: {
                    string = "MESSAGE_STARTRING";
                    break;
                }
                case 32783: {
                    string = "MESSAGE_STOPRING";
                    break;
                }
                case 32784: {
                    string = "MESSAGE_GETSTREAMTYPE";
                    break;
                }
                case 32785: {
                    string = "MESSAGE_AUTO_DEVICELIST_UPDATE";
                    break;
                }
                case 32786: {
                    string = "MESSAGE_AUTO_DEVICELIST_PLUGIN_UPDATE";
                    break;
                }
                case 32787: {
                    string = "MESSAGE_AUTO_DEVICELIST_PLUGOUT_UPDATE";
                    break;
                }
                case 32788: {
                    string = "MESSAGE_VOICECALL_AUIDOPARAM_CHANGED";
                    break;
                }
                case 32789: {
                    string = "MESSAGE_CONNECT_HIGHEST_PRIORITY_DEVICE";
                    break;
                }
                case 32790: {
                    string = "MESSAGE_REQUEST_RELEASE_AUDIO_FOCUS";
                    break;
                }
                case 32791: {
                    string = "MESSAGE_RECOVER_AUDIO_FOCUS";
                    break;
                }
                default: {
                    string = "MESSAGE_NONE";
                }
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AudioDeviceInterface.LogTraceEntry("");
            Looper.prepare();
            this.mMsgHandler = new Handler(){

                public void handleMessage(Message msg) {
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    boolean bl = true;
                    HashMap hashMap = null;
                    try {
                        hashMap = (HashMap)msg.obj;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (QLog.isColorLevel()) {
                        QLog.w(TraeAudioManager.TAG, 2, "TraeAudioManagerLooper msg " + msg.what + ":" + TraeAudioManagerLooper.this.msgToText(msg.what) + " _enabled:" + (TraeAudioManagerLooper.this._enabled ? "Y" : "N"));
                    }
                    if (msg.what == 32772) {
                        TraeAudioManagerLooper.this.startService(hashMap);
                    } else if (!TraeAudioManagerLooper.this._enabled) {
                        if (QLog.isColorLevel()) {
                            QLog.w(TraeAudioManager.TAG, 2, "******* disabled ,skip msg******");
                        }
                        Intent intent = new Intent();
                        TraeAudioManager.this.sendResBroadcast(intent, hashMap, 1);
                    } else {
                        switch (msg.what) {
                            case 32773: {
                                TraeAudioManagerLooper.this.stopService();
                                break;
                            }
                            case 32774: {
                                TraeAudioManagerLooper.this.InternalSessionGetDeviceList(hashMap);
                                break;
                            }
                            case 32777: {
                                TraeAudioManager.this.InternalSessionIsDeviceChangabled(hashMap);
                                break;
                            }
                            case 32778: {
                                TraeAudioManager.this.InternalSessionGetConnectedDevice(hashMap);
                                break;
                            }
                            case 32779: {
                                TraeAudioManager.this.InternalSessionGetConnectingDevice(hashMap);
                                break;
                            }
                            case 32780: {
                                TraeAudioManagerLooper.this.InternalVoicecallPreprocess(hashMap);
                                break;
                            }
                            case 32781: {
                                TraeAudioManagerLooper.this.InternalVoicecallPostprocess(hashMap);
                                break;
                            }
                            case 32788: {
                                Integer n2 = (Integer)hashMap.get(TraeAudioManager.PARAM_STREAMTYPE);
                                if (n2 == null) {
                                    if (!QLog.isColorLevel()) break;
                                    QLog.e(TraeAudioManager.TAG, 2, " MESSAGE_VOICECALL_AUIDOPARAM_CHANGED params.get(PARAM_STREAMTYPE)==null!!");
                                    break;
                                }
                                TraeAudioManager.this._streamType = n2;
                                TraeAudioManagerLooper.this.InternalNotifyStreamTypeUpdate(n2);
                                break;
                            }
                            case 32782: {
                                TraeAudioManagerLooper.this.InternalStartRing(hashMap);
                                break;
                            }
                            case 32783: {
                                TraeAudioManagerLooper.this.InternalStopRing(hashMap);
                                break;
                            }
                            case 32790: {
                                TraeAudioManagerLooper.this.abandonAudioFocus();
                                break;
                            }
                            case 32791: {
                                break;
                            }
                            case 32784: {
                                TraeAudioManagerLooper.this.InternalGetStreamType(hashMap);
                                break;
                            }
                            case 32775: {
                                TraeAudioManager.this.InternalSessionConnectDevice(hashMap);
                                break;
                            }
                            case 32776: {
                                TraeAudioManager.this.InternalSessionEarAction(hashMap);
                                break;
                            }
                            case 32785: 
                            case 32789: {
                                string = TraeAudioManager.this._deviceConfigManager.getAvailabledHighestPriorityDevice();
                                string2 = TraeAudioManager.this._deviceConfigManager.getConnectedDevice();
                                if (QLog.isColorLevel()) {
                                    QLog.w(TraeAudioManager.TAG, 2, "MESSAGE_AUTO_DEVICELIST_UPDATE  connectedDev:" + string2 + " highestDev" + string);
                                }
                                if (IsUpdateSceneFlag && bl) {
                                    bl = false;
                                    if (IsMusicScene && !TraeAudioManager.this.IsBluetoothA2dpExisted) {
                                        TraeAudioManager.this.InternalConnectDevice(TraeAudioManager.this._deviceConfigManager.getAvailabledHighestPriorityDevice(TraeAudioManager.DEVICE_BLUETOOTHHEADSET), null, true);
                                        break;
                                    }
                                    TraeAudioManager.this.InternalConnectDevice(string, null, true);
                                    break;
                                }
                                if (TraeAudioManager.DEVICE_BLUETOOTHHEADSET.equals(string2) || !string.equals(string2)) {
                                    TraeAudioManager.this.InternalConnectDevice(string, null, false);
                                    break;
                                }
                                TraeAudioManager.this.InternalNotifyDeviceListUpdate();
                                break;
                            }
                            case 32786: {
                                string3 = (String)hashMap.get(TraeAudioManager.PARAM_DEVICE);
                                if (TraeAudioManager.this.InternalConnectDevice(string3, null, false) == 0) break;
                                if (QLog.isColorLevel()) {
                                    QLog.w(TraeAudioManager.TAG, 2, " plugin dev:" + string3 + " sessionConnectedDev:" + TraeAudioManager.this.sessionConnectedDev + " connected fail,auto switch!");
                                }
                                TraeAudioManager.this.InternalConnectDevice(TraeAudioManager.this._deviceConfigManager.getAvailabledHighestPriorityDevice(), null, false);
                                break;
                            }
                            case 32787: {
                                if (TraeAudioManager.this.InternalConnectDevice(TraeAudioManager.this.sessionConnectedDev, null, false) == 0) break;
                                string3 = (String)hashMap.get(TraeAudioManager.PARAM_DEVICE);
                                QLog.w("TRAE", 2, " plugout dev:" + string3 + " sessionConnectedDev:" + TraeAudioManager.this.sessionConnectedDev + " connected fail,auto switch!");
                                TraeAudioManager.this.InternalConnectDevice(TraeAudioManager.this._deviceConfigManager.getAvailabledHighestPriorityDevice(), null, false);
                                break;
                            }
                            case 32793: {
                                TraeAudioManager.this.InternalNotifyDeviceListUpdate();
                                break;
                            }
                        }
                    }
                }
            };
            this._init();
            boolean[] blArray = this._started;
            synchronized (this._started) {
                this._started[0] = true;
                this._started.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                Looper.loop();
                this._uninit();
                blArray = this._started;
                synchronized (this._started) {
                    this._started[0] = false;
                    this._started.notifyAll();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    AudioDeviceInterface.LogTraceExit();
                    return;
                }
            }
        }

        void _init() {
            AudioDeviceInterface.LogTraceEntry("");
            if (null == TraeAudioManager.this._deviceConfigManager) {
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "_deviceConfigManager is null");
                }
                return;
            }
            try {
                TraeAudioManager.this._am = (AudioManager)TraeAudioManager.this._context.getSystemService("audio");
                TraeAudioManager.this._bluetoothCheck = TraeAudioManager.this.CreateBluetoothCheck(TraeAudioManager.this._context, TraeAudioManager.this._deviceConfigManager);
                IntentFilter intentFilter = new IntentFilter();
                IntentFilter intentFilter2 = new IntentFilter();
                intentFilter.addAction("android.intent.action.HEADSET_PLUG");
                intentFilter.addAction("android.media.AUDIO_BECOMING_NOISY");
                TraeAudioManager.this._bluetoothCheck.addAction(intentFilter, intentFilter2);
                TraeAudioManager.this._context.registerReceiver((BroadcastReceiver)this._parent, intentFilter);
                intentFilter2.addAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_REQUEST);
                b.a(TraeAudioManager.this._context).a(this._parent, intentFilter2);
                QLog.i(TraeAudioManager.TAG, 2, "register receiver in _init");
            }
            catch (Exception exception) {
                QLog.e(TraeAudioManager.TAG, 2, "init failed, " + exception.getMessage());
            }
            AudioDeviceInterface.LogTraceExit();
        }

        void _prev_startService() {
            AudioDeviceInterface.LogTraceEntry("");
            if (null == TraeAudioManager.this._deviceConfigManager) {
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "_deviceConfigManager is null");
                }
                return;
            }
            try {
                TraeAudioManager.this._am = (AudioManager)TraeAudioManager.this._context.getSystemService("audio");
                if (TraeAudioManager.this._bluetoothCheck == null) {
                    TraeAudioManager.this._bluetoothCheck = TraeAudioManager.this.CreateBluetoothCheck(TraeAudioManager.this._context, TraeAudioManager.this._deviceConfigManager);
                }
                try {
                    TraeAudioManager.this._context.unregisterReceiver((BroadcastReceiver)this._parent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                QLog.i(TraeAudioManager.TAG, 2, "unregister receiver in _prev_startService");
                b.a(TraeAudioManager.this._context).a(this._parent);
                IntentFilter intentFilter = new IntentFilter();
                IntentFilter intentFilter2 = new IntentFilter();
                intentFilter.addAction("android.intent.action.HEADSET_PLUG");
                intentFilter.addAction("android.media.AUDIO_BECOMING_NOISY");
                TraeAudioManager.this._bluetoothCheck.addAction(intentFilter, intentFilter2);
                intentFilter2.addAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_REQUEST);
                TraeAudioManager.this._context.registerReceiver((BroadcastReceiver)this._parent, intentFilter);
                QLog.i(TraeAudioManager.TAG, 2, "register receiver in _prev_startService");
                b.a(TraeAudioManager.this._context).a(this._parent, intentFilter2);
            }
            catch (Exception exception) {
                QLog.w(TraeAudioManager.TAG, 2, "prev start service failed." + exception.getMessage());
            }
            AudioDeviceInterface.LogTraceExit();
        }

        void _post_stopService() {
            block7: {
                AudioDeviceInterface.LogTraceEntry("");
                if (null == TraeAudioManager.this._deviceConfigManager) {
                    if (QLog.isColorLevel()) {
                        QLog.w(TraeAudioManager.TAG, 2, "_deviceConfigManager is null");
                    }
                    return;
                }
                try {
                    if (TraeAudioManager.this._bluetoothCheck != null) {
                        TraeAudioManager.this._bluetoothCheck.release();
                    }
                    TraeAudioManager.this._bluetoothCheck = null;
                    if (TraeAudioManager.this._context == null) break block7;
                    try {
                        TraeAudioManager.this._context.unregisterReceiver((BroadcastReceiver)this._parent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    QLog.i(TraeAudioManager.TAG, 2, "unregister receiver in _post_stopService");
                    b.a(TraeAudioManager.this._context).a(this._parent);
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_REQUEST);
                    b.a(TraeAudioManager.this._context).a(this._parent, intentFilter);
                }
                catch (Exception exception) {
                    if (!QLog.isColorLevel()) break block7;
                    QLog.e(TraeAudioManager.TAG, 2, "stop service failed." + exception.getMessage());
                }
            }
            AudioDeviceInterface.LogTraceExit();
        }

        void _uninit() {
            block7: {
                AudioDeviceInterface.LogTraceEntry("");
                try {
                    this.stopService();
                    if (TraeAudioManager.this._bluetoothCheck != null) {
                        TraeAudioManager.this._bluetoothCheck.release();
                    }
                    TraeAudioManager.this._bluetoothCheck = null;
                    if (null != TraeAudioManager.this._context) {
                        try {
                            TraeAudioManager.this._context.unregisterReceiver((BroadcastReceiver)this._parent);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        QLog.i(TraeAudioManager.TAG, 2, "unregister receiver in _uninit");
                        b.a(TraeAudioManager.this._context).a(this._parent);
                        TraeAudioManager.this._context = null;
                    }
                    if (TraeAudioManager.this._deviceConfigManager != null) {
                        TraeAudioManager.this._deviceConfigManager.clearConfig();
                    }
                }
                catch (Exception exception) {
                    if (!QLog.isColorLevel()) break block7;
                    QLog.e(TraeAudioManager.TAG, 2, "uninit failed." + exception.getMessage());
                }
            }
            AudioDeviceInterface.LogTraceExit();
        }

        int InternalSessionGetDeviceList(HashMap<String, Object> params) {
            Intent intent = new Intent();
            HashMap<String, Object> hashMap = TraeAudioManager.this._deviceConfigManager.getSnapParams();
            ArrayList arrayList = (ArrayList)hashMap.get(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST);
            String string = (String)hashMap.get(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE);
            String string2 = (String)hashMap.get(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE);
            intent.putExtra(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST, arrayList.toArray(new String[0]));
            intent.putExtra(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE, string);
            intent.putExtra(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE, string2);
            intent.putExtra(TraeAudioManager.EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME, TraeAudioManager.this._deviceConfigManager.getBluetoothName());
            TraeAudioManager.this.sendResBroadcast(intent, params, 0);
            return 0;
        }

        @TargetApi(value=8)
        void abandonAudioFocus() {
        }

        int InternalVoicecallPreprocess(HashMap<String, Object> params) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode);
            if (null == params) {
                return -1;
            }
            if (TraeAudioManager.this._deviceConfigManager == null) {
                return -1;
            }
            if (TraeAudioManager.this._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " InternalVoicecallPreprocess am==null!!");
                }
                return -1;
            }
            if (TraeAudioManager.this._activeMode == 1) {
                Intent intent = new Intent();
                TraeAudioManager.this.sendResBroadcast(intent, params, 2);
                return -1;
            }
            this._voiceCallSessionID = (Long)params.get(TraeAudioManager.PARAM_SESSIONID);
            this._voiceCallOperation = (String)params.get(TraeAudioManager.PARAM_OPERATION);
            TraeAudioManager.this._activeMode = 1;
            TraeAudioManager.this._prevMode = TraeAudioManager.this._am.getMode();
            Integer n2 = -1;
            Integer n3 = 0;
            n2 = (Integer)params.get(TraeAudioManager.PARAM_MODEPOLICY);
            if (n2 == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " params.get(PARAM_MODEPOLICY)==null!!");
                }
                TraeAudioManager.this._modePolicy = -1;
            } else {
                TraeAudioManager.this._modePolicy = n2;
            }
            if (QLog.isColorLevel()) {
                QLog.e(TraeAudioManager.TAG, 2, "  _modePolicy:" + TraeAudioManager.this._modePolicy);
            }
            if ((n3 = (Integer)params.get(TraeAudioManager.PARAM_STREAMTYPE)) == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " params.get(PARAM_STREAMTYPE)==null!!");
                }
                TraeAudioManager.this._streamType = 0;
            } else {
                TraeAudioManager.this._streamType = n3;
            }
            if (TraeAudioManager.isCloseSystemAPM(TraeAudioManager.this._modePolicy) && TraeAudioManager.this._activeMode != 2 && TraeAudioManager.this._deviceConfigManager != null) {
                if (TraeAudioManager.this._deviceConfigManager.getConnectedDevice().equals(TraeAudioManager.DEVICE_SPEAKERPHONE)) {
                    TraeAudioManager.this.InternalSetMode(0);
                } else {
                    TraeAudioManager.this.InternalSetMode(3);
                }
            } else {
                TraeAudioManager.this.InternalSetMode(TraeAudioManager.getCallAudioMode(TraeAudioManager.this._modePolicy));
            }
            Intent intent = new Intent();
            TraeAudioManager.this.sendResBroadcast(intent, params, 0);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalVoicecallPostprocess(HashMap<String, Object> params) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode);
            if (TraeAudioManager.this._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " InternalVoicecallPostprocess am==null!!");
                }
                return -1;
            }
            if (TraeAudioManager.this._activeMode != 1) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " not ACTIVE_VOICECALL!!");
                }
                Intent intent = new Intent();
                TraeAudioManager.this.sendResBroadcast(intent, params, 3);
                return -1;
            }
            TraeAudioManager.this._activeMode = 0;
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int interruptVoicecallPostprocess() {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode);
            if (TraeAudioManager.this._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " am==null!!");
                }
                return -1;
            }
            if (TraeAudioManager.this._activeMode != 1) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " not ACTIVE_RING!!");
                }
                return -1;
            }
            TraeAudioManager.this._activeMode = 0;
            if (TraeAudioManager.this._prevMode != -1) {
                TraeAudioManager.this.InternalSetMode(TraeAudioManager.this._prevMode);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(TraeAudioManager.PARAM_SESSIONID, this._voiceCallSessionID);
            hashMap.put(TraeAudioManager.PARAM_OPERATION, this._voiceCallOperation);
            Intent intent = new Intent();
            TraeAudioManager.this.sendResBroadcast(intent, hashMap, 6);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalStartRing(HashMap<String, Object> params) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode);
            if (TraeAudioManager.this._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " InternalStartRing am==null!!");
                }
                return -1;
            }
            if (TraeAudioManager.this._activeMode == 2) {
                this.interruptRing();
            }
            int n2 = 0;
            int n3 = -1;
            Uri uri = null;
            String string = null;
            boolean bl = false;
            int n4 = 1;
            boolean bl2 = false;
            try {
                this._ringSessionID = (Long)params.get(TraeAudioManager.PARAM_SESSIONID);
                this._ringOperation = (String)params.get(TraeAudioManager.PARAM_OPERATION);
                this._ringUserdata = (String)params.get(TraeAudioManager.PARAM_RING_USERDATA_STRING);
                n2 = (Integer)params.get(TraeAudioManager.PARAM_RING_DATASOURCE);
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, "  dataSource:" + n2);
                }
                n3 = (Integer)params.get(TraeAudioManager.PARAM_RING_RSID);
                uri = (Uri)params.get(TraeAudioManager.PARAM_RING_URI);
                string = (String)params.get(TraeAudioManager.PARAM_RING_FILEPATH);
                bl = (Boolean)params.get(TraeAudioManager.PARAM_RING_LOOP);
                n4 = (Integer)params.get(TraeAudioManager.PARAM_RING_LOOPCOUNT);
                bl2 = (Boolean)params.get(TraeAudioManager.PARAM_RING_MODE);
            }
            catch (Exception exception) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " startRing err params");
                }
                return -1;
            }
            if (TraeAudioManager.this._activeMode != 1) {
                TraeAudioManager.this._activeMode = 2;
            }
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            TraeAudioManager.this.sendResBroadcast(intent, params, 0);
            this._preRingMode = TraeAudioManager.this._am.getMode();
            this._ringPlayer.playRing(n2, n3, uri, string, bl, n4, bl2, TraeAudioManager.this._activeMode == 1, TraeAudioManager.this._streamType);
            if (QLog.isColorLevel()) {
                QLog.w(TraeAudioManager.TAG, 2, " _ringUserdata:" + this._ringUserdata + " DurationMS:" + this._ringPlayer.getDuration());
            }
            this.InternalNotifyStreamTypeUpdate(this._ringPlayer.getStreamType());
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalStopRing(HashMap<String, Object> params) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode + " _preRingMode:" + this._preRingMode);
            if (TraeAudioManager.this._am == null || this._ringPlayer == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " InternalStopRing am==null!!");
                }
                return -1;
            }
            this._ringPlayer.stopRing();
            if (!this._ringPlayer.hasCall() && TraeAudioManager.this._activeMode == 2) {
                this.abandonAudioFocus();
                TraeAudioManager.this._activeMode = 0;
            }
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            TraeAudioManager.this.sendResBroadcast(intent, params, 0);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalGetStreamType(HashMap<String, Object> params) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode + " _preRingMode:" + this._preRingMode);
            if (TraeAudioManager.this._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " InternalStopRing am==null!!");
                }
                return -1;
            }
            int n2 = -1;
            n2 = TraeAudioManager.this._activeMode == 2 ? this._ringPlayer.getStreamType() : TraeAudioManager.this._streamType;
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.EXTRA_DATA_STREAMTYPE, n2);
            TraeAudioManager.this.sendResBroadcast(intent, params, 0);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalNotifyStreamTypeUpdate(int st) {
            if (null == TraeAudioManager.this._context) {
                return -1;
            }
            final int n2 = st;
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    Intent intent = new Intent();
                    intent.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
                    intent.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_STREAMTYPE_UPDATE);
                    intent.putExtra(TraeAudioManager.EXTRA_DATA_STREAMTYPE, n2);
                    if (TraeAudioManager.this._context != null) {
                        b.a(TraeAudioManager.this._context).a(intent);
                    }
                }
            });
            return 0;
        }

        int interruptRing() {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode + " _preRingMode:" + this._preRingMode);
            if (TraeAudioManager.this._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " interruptRing am==null!!");
                }
                return -1;
            }
            if (TraeAudioManager.this._activeMode != 2) {
                if (QLog.isColorLevel()) {
                    QLog.e(TraeAudioManager.TAG, 2, " not ACTIVE_RING!!");
                }
                return -1;
            }
            this._ringPlayer.stopRing();
            this.abandonAudioFocus();
            TraeAudioManager.this._activeMode = 0;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(TraeAudioManager.PARAM_SESSIONID, this._ringSessionID);
            hashMap.put(TraeAudioManager.PARAM_OPERATION, this._ringOperation);
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            TraeAudioManager.this.sendResBroadcast(intent, hashMap, 4);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        void notifyRingCompletion() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(TraeAudioManager.PARAM_SESSIONID, this._ringSessionID);
            hashMap.put(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_RING_COMPLETION);
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            TraeAudioManager.this.sendResBroadcast(intent, hashMap, 0);
        }
    }

    class DeviceConfigManager {
        HashMap<String, DeviceConfig> deviceConfigs = new HashMap();
        String prevConnectedDevice = "DEVICE_NONE";
        String connectedDevice = "DEVICE_NONE";
        String connectingDevice = "DEVICE_NONE";
        ReentrantLock mLock = new ReentrantLock();
        boolean visiableUpdate = false;
        String _bluetoothDevName = "unknow";

        public boolean init(String strConfigs) {
            String[] stringArray;
            AudioDeviceInterface.LogTraceEntry(" strConfigs:" + strConfigs);
            if (null == strConfigs || strConfigs.length() <= 0) {
                return false;
            }
            strConfigs = strConfigs.replace("\n", "");
            if (null == (strConfigs = strConfigs.replace("\r", "")) || strConfigs.length() <= 0) {
                return false;
            }
            if (0 > strConfigs.indexOf(";")) {
                strConfigs = strConfigs + ";";
            }
            if (null == (stringArray = strConfigs.split(";")) || 1 > stringArray.length) {
                return false;
            }
            this.mLock.lock();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this._addConfig(stringArray[i2], i2);
            }
            this.mLock.unlock();
            TraeAudioManager.this.printDevices();
            return true;
        }

        boolean _addConfig(String strDeviceName, int nPriority) {
            AudioDeviceInterface.LogTraceEntry(" devName:" + strDeviceName + " priority:" + nPriority);
            DeviceConfig deviceConfig = new DeviceConfig();
            if (deviceConfig.init(strDeviceName, nPriority)) {
                if (this.deviceConfigs.containsKey(strDeviceName)) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TraeAudioManager.TAG, 2, "err dev exist!");
                    }
                    return false;
                }
                this.deviceConfigs.put(strDeviceName, deviceConfig);
                this.visiableUpdate = true;
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, " n" + this.getDeviceNumber() + " 0:" + this.getDeviceName(0));
                }
                AudioDeviceInterface.LogTraceExit();
                return true;
            }
            if (QLog.isColorLevel()) {
                QLog.e(TraeAudioManager.TAG, 2, " err dev init!");
            }
            return false;
        }

        public void clearConfig() {
            this.mLock.lock();
            this.deviceConfigs.clear();
            this.prevConnectedDevice = TraeAudioManager.DEVICE_NONE;
            this.connectedDevice = TraeAudioManager.DEVICE_NONE;
            this.connectingDevice = TraeAudioManager.DEVICE_NONE;
            this.mLock.unlock();
        }

        public boolean getVisiableUpdateFlag() {
            boolean bl = false;
            this.mLock.lock();
            bl = this.visiableUpdate;
            this.mLock.unlock();
            return bl;
        }

        public void resetVisiableUpdateFlag() {
            this.mLock.lock();
            this.visiableUpdate = false;
            this.mLock.unlock();
        }

        public boolean setVisible(String strDeviceName, boolean bVisible) {
            boolean bl = false;
            this.mLock.lock();
            DeviceConfig deviceConfig = this.deviceConfigs.get(strDeviceName);
            if (deviceConfig != null && deviceConfig.getVisible() != bVisible) {
                deviceConfig.setVisible(bVisible);
                this.visiableUpdate = true;
                if (QLog.isColorLevel()) {
                    QLog.w(TraeAudioManager.TAG, 2, " ++setVisible:" + strDeviceName + (bVisible ? " Y" : " N"));
                }
                bl = true;
            }
            this.mLock.unlock();
            return bl;
        }

        public void setBluetoothName(String btName) {
            if (btName == null) {
                this._bluetoothDevName = "unknow";
                return;
            }
            this._bluetoothDevName = btName.isEmpty() ? "unknow" : btName;
        }

        public String getBluetoothName() {
            return this._bluetoothDevName;
        }

        public boolean getVisible(String strDeviceName) {
            boolean bl = false;
            this.mLock.lock();
            DeviceConfig deviceConfig = this.deviceConfigs.get(strDeviceName);
            if (null != deviceConfig) {
                bl = deviceConfig.getVisible();
            }
            this.mLock.unlock();
            return bl;
        }

        public int getPriority(String strDeviceName) {
            int n2 = -1;
            this.mLock.lock();
            DeviceConfig deviceConfig = this.deviceConfigs.get(strDeviceName);
            if (null != deviceConfig) {
                n2 = deviceConfig.getPriority();
            }
            this.mLock.unlock();
            return n2;
        }

        public int getDeviceNumber() {
            this.mLock.lock();
            int n2 = this.deviceConfigs.size();
            this.mLock.unlock();
            return n2;
        }

        public String getDeviceName(int id) {
            String string = TraeAudioManager.DEVICE_NONE;
            int n2 = 0;
            this.mLock.lock();
            DeviceConfig deviceConfig = null;
            for (Map.Entry<String, DeviceConfig> entry : this.deviceConfigs.entrySet()) {
                if (n2 == id) {
                    deviceConfig = entry.getValue();
                    break;
                }
                ++n2;
            }
            if (deviceConfig != null) {
                string = deviceConfig.getDeviceName();
            }
            this.mLock.unlock();
            return string;
        }

        public String getAvailabledHighestPriorityDevice(String IgnoreDeviceName) {
            DeviceConfig deviceConfig = null;
            this.mLock.lock();
            DeviceConfig deviceConfig2 = null;
            for (Map.Entry<String, DeviceConfig> entry : this.deviceConfigs.entrySet()) {
                String string = entry.getKey();
                DeviceConfig deviceConfig3 = entry.getValue();
                deviceConfig2 = entry.getValue();
                if (deviceConfig2 == null || !deviceConfig2.getVisible() || deviceConfig2.getDeviceName().equals(IgnoreDeviceName)) continue;
                if (deviceConfig == null) {
                    deviceConfig = deviceConfig2;
                    continue;
                }
                if (deviceConfig2.getPriority() < deviceConfig.getPriority()) continue;
                deviceConfig = deviceConfig2;
            }
            this.mLock.unlock();
            return deviceConfig != null ? deviceConfig.getDeviceName() : TraeAudioManager.DEVICE_SPEAKERPHONE;
        }

        public String getAvailabledHighestPriorityDevice() {
            DeviceConfig deviceConfig = null;
            this.mLock.lock();
            DeviceConfig deviceConfig2 = null;
            for (Map.Entry<String, DeviceConfig> entry : this.deviceConfigs.entrySet()) {
                String string = entry.getKey();
                DeviceConfig deviceConfig3 = entry.getValue();
                deviceConfig2 = entry.getValue();
                if (deviceConfig2 == null || !deviceConfig2.getVisible()) continue;
                if (deviceConfig == null) {
                    deviceConfig = deviceConfig2;
                    continue;
                }
                if (deviceConfig2.getPriority() < deviceConfig.getPriority()) continue;
                deviceConfig = deviceConfig2;
            }
            this.mLock.unlock();
            return deviceConfig != null ? deviceConfig.getDeviceName() : TraeAudioManager.DEVICE_SPEAKERPHONE;
        }

        public String getConnectingDevice() {
            String string = TraeAudioManager.DEVICE_NONE;
            this.mLock.lock();
            string = null;
            DeviceConfig deviceConfig = this.deviceConfigs.get(this.connectingDevice);
            if (null != deviceConfig && deviceConfig.getVisible()) {
                string = this.connectingDevice;
            }
            this.mLock.unlock();
            return string;
        }

        public String getConnectedDevice() {
            String string = TraeAudioManager.DEVICE_NONE;
            this.mLock.lock();
            string = this._getConnectedDevice();
            this.mLock.unlock();
            return string;
        }

        public String getPrevConnectedDevice() {
            String string = TraeAudioManager.DEVICE_NONE;
            this.mLock.lock();
            string = this._getPrevConnectedDevice();
            this.mLock.unlock();
            return string;
        }

        public boolean setConnecting(String strDeviceName) {
            boolean bl = false;
            this.mLock.lock();
            DeviceConfig deviceConfig = this.deviceConfigs.get(strDeviceName);
            if (deviceConfig != null && deviceConfig.getVisible()) {
                this.connectingDevice = strDeviceName;
                bl = true;
            }
            this.mLock.unlock();
            return bl;
        }

        public boolean resetNullConnecting() {
            boolean bl = false;
            this.mLock.lock();
            this.connectingDevice = "";
            bl = true;
            this.mLock.unlock();
            return bl;
        }

        public boolean setConnected(String strDeviceName) {
            boolean bl = false;
            this.mLock.lock();
            DeviceConfig deviceConfig = this.deviceConfigs.get(strDeviceName);
            if (deviceConfig != null && deviceConfig.getVisible()) {
                if (this.connectedDevice != null && !this.connectedDevice.equals(strDeviceName)) {
                    this.prevConnectedDevice = this.connectedDevice;
                }
                this.connectedDevice = strDeviceName;
                this.connectingDevice = "";
                bl = true;
            }
            this.mLock.unlock();
            return bl;
        }

        public boolean isConnected(String strDeviceName) {
            boolean bl = false;
            this.mLock.lock();
            DeviceConfig deviceConfig = this.deviceConfigs.get(strDeviceName);
            if (deviceConfig != null && deviceConfig.getVisible()) {
                bl = this.connectedDevice.equals(strDeviceName);
            }
            this.mLock.unlock();
            return bl;
        }

        public HashMap<String, Object> getSnapParams() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            this.mLock.lock();
            hashMap.put(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST, this._getAvailableDeviceList());
            hashMap.put(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE, this._getConnectedDevice());
            hashMap.put(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE, this._getPrevConnectedDevice());
            this.mLock.unlock();
            return hashMap;
        }

        public ArrayList<String> getAvailableDeviceList() {
            ArrayList<String> arrayList = new ArrayList();
            this.mLock.lock();
            arrayList = this._getAvailableDeviceList();
            this.mLock.unlock();
            return arrayList;
        }

        ArrayList<String> _getAvailableDeviceList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            DeviceConfig deviceConfig = null;
            for (Map.Entry<String, DeviceConfig> entry : this.deviceConfigs.entrySet()) {
                deviceConfig = entry.getValue();
                if (deviceConfig == null || !deviceConfig.getVisible()) continue;
                arrayList.add(deviceConfig.getDeviceName());
            }
            return arrayList;
        }

        String _getConnectedDevice() {
            String string = TraeAudioManager.DEVICE_NONE;
            DeviceConfig deviceConfig = this.deviceConfigs.get(this.connectedDevice);
            if (null != deviceConfig && deviceConfig.getVisible()) {
                string = this.connectedDevice;
            }
            return string;
        }

        String _getPrevConnectedDevice() {
            String string = TraeAudioManager.DEVICE_NONE;
            DeviceConfig deviceConfig = this.deviceConfigs.get(this.prevConnectedDevice);
            if (null != deviceConfig && deviceConfig.getVisible()) {
                string = this.prevConnectedDevice;
            }
            return string;
        }

        public class DeviceConfig {
            String deviceName = "DEVICE_NONE";
            boolean visible = false;
            int priority = 0;

            public boolean init(String strDeviceName, int nPriority) {
                if (null == strDeviceName || strDeviceName.length() <= 0) {
                    return false;
                }
                if (!TraeAudioManager.checkDevName(strDeviceName)) {
                    return false;
                }
                this.deviceName = strDeviceName;
                this.priority = nPriority;
                return true;
            }

            public String getDeviceName() {
                return this.deviceName;
            }

            public boolean getVisible() {
                return this.visible;
            }

            public int getPriority() {
                return this.priority;
            }

            public void setVisible(boolean arg) {
                this.visible = arg;
            }
        }
    }

    public static interface Bluetooth_State {
        public static final int UNINITIALIZED = 1;
        public static final int ERROR = 2;
        public static final int HEADSET_UNAVAILABLE = 3;
        public static final int HEADSET_AVAILABLE = 4;
        public static final int SCO_DISCONNECTING = 5;
        public static final int SCO_CONNECTING = 6;
        public static final int SCO_CONNECTED = 7;
        public static final int SCO_DISCONNECTED = 8;
    }

    public class Parameters {
        public static final String CONTEXT = "com.tencent.sharp.TraeAudioManager.Parameters.CONTEXT";
        public static final String MODEPOLICY = "com.tencent.sharp.TraeAudioManager.Parameters.MODEPOLICY";
        public static final String BLUETOOTHPOLICY = "com.tencent.sharp.TraeAudioManager.Parameters.BLUETOOTHPOLICY";
        public static final String DEVICECONFIG = "com.tencent.sharp.TraeAudioManager.Parameters.DEVICECONFIG";
    }
}

