/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.audio.TXAudioEffectManagerImpl;
import com.tencent.liteav.audio.h;
import com.tencent.liteav.audio.impl.Play.TXCMultAudioTrackPlayer;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.i;
import java.lang.ref.WeakReference;

public class TXCUGCBGMPlayer
implements TXAudioEffectManager.TXMusicPlayObserver {
    private static final String TAG = "AudioCenter:TXCUGCBGMPlayer";
    private WeakReference<h> mWeakListener = null;
    private static final int PLAY_SUCCESS = 0;
    private static final int PLAY_ERR_OPEN = -1;
    private boolean mIsRunning = false;
    private float mVolume = 1.0f;
    private float mSpeedRate = 1.0f;
    private long mStartTimeMS = 0L;
    private long mEndTimeMS = 0L;
    private long mSeekBytes = 0L;
    private int mBGMId = Integer.MIN_VALUE;

    public static TXCUGCBGMPlayer getInstance() {
        return a.a();
    }

    private TXCUGCBGMPlayer() {
        TXCMultAudioTrackPlayer.getInstance();
    }

    public synchronized void setOnPlayListener(h listener) {
        if (listener == null) {
            this.mWeakListener = null;
        }
        this.mWeakListener = new WeakReference<h>(listener);
    }

    public void startPlay(String filePath, boolean record) {
        TXCLog.i(TAG, "startPlay:" + filePath + "record:" + record);
        if (filePath == null || filePath.isEmpty()) {
            return;
        }
        if (this.mIsRunning) {
            TXCLog.w(TAG, "BGM is playing, restarting...");
            this.stopPlay();
        }
        this.mSeekBytes = 0L;
        this.mIsRunning = true;
        TXAudioEffectManager.AudioMusicParam audioMusicParam = new TXAudioEffectManager.AudioMusicParam(this.mBGMId, filePath);
        audioMusicParam.publish = record;
        audioMusicParam.loopCount = 0;
        audioMusicParam.startTimeMS = this.mStartTimeMS;
        audioMusicParam.endTimeMS = this.mEndTimeMS;
        audioMusicParam.isShortFile = true;
        TXCLog.i(TAG, "start bgm play : filePath = " + filePath + " publish:" + record + " startTimeMS:" + this.mStartTimeMS + " endTimeMS:" + this.mEndTimeMS + " isShortFile:" + audioMusicParam.isShortFile + "mVolume:" + this.mVolume);
        TXAudioEffectManagerImpl.getCacheInstance().setMusicVolume(this.mBGMId, (int)(this.mVolume * 100.0f));
        TXAudioEffectManagerImpl.getCacheInstance().setMusicPlayoutSpeedRate(this.mBGMId, this.mSpeedRate);
        if (record) {
            TXAudioEffectManagerImpl.getCacheInstance().setMuteDataDurationToPublish(this.mBGMId, 200);
        }
        boolean bl = TXAudioEffectManagerImpl.getCacheInstance().startPlayMusic(audioMusicParam);
        TXAudioEffectManagerImpl.getCacheInstance().setMusicObserver(this.mBGMId, this);
        if (!bl) {
            this.onPlayEnd(-1);
            return;
        }
        this.onPlayStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlay() {
        TXCLog.i(TAG, "stopPlay");
        this.mIsRunning = false;
        long l2 = System.currentTimeMillis();
        TXCUGCBGMPlayer tXCUGCBGMPlayer = this;
        synchronized (tXCUGCBGMPlayer) {
            TXAudioEffectManagerImpl.getCacheInstance().setMusicObserver(this.mBGMId, null);
            TXAudioEffectManagerImpl.getCacheInstance().stopPlayMusic(this.mBGMId);
        }
        TXCLog.i(TAG, "stopBGMPlay cost(MS): " + (System.currentTimeMillis() - l2));
    }

    public void pause() {
        TXCLog.i(TAG, "pause");
        TXAudioEffectManagerImpl.getCacheInstance().pausePlayMusic(this.mBGMId);
    }

    public void resume() {
        TXCLog.i(TAG, "resume");
        TXAudioEffectManagerImpl.getCacheInstance().resumePlayMusic(this.mBGMId);
    }

    public void setVolume(float volume) {
        TXCLog.i(TAG, "setVolume:" + volume);
        this.mVolume = volume;
        TXAudioEffectManagerImpl.getCacheInstance().setMusicVolume(this.mBGMId, (int)(volume * 100.0f));
    }

    public void setSpeedRate(float speedRate) {
        TXCLog.i(TAG, "setSpeedRate:" + speedRate);
        this.mSpeedRate = speedRate;
        TXAudioEffectManagerImpl.getCacheInstance().setMusicPlayoutSpeedRate(this.mBGMId, speedRate);
    }

    public void setChangerType(int changerType) {
        TXCLog.i(TAG, "changerType:" + changerType);
        TXAudioEffectManagerImpl.getCacheInstance().setMusicChangerType(this.mBGMId, changerType);
    }

    public void setReverbType(int reverbType) {
        TXCLog.i(TAG, "int reverbType:" + reverbType);
        TXAudioEffectManagerImpl.getCacheInstance().setMusicReverbType(this.mBGMId, reverbType);
    }

    public void playFromTime(long startTimeMS, long endTimeMS) {
        TXCLog.i(TAG, "startPlayRange:" + startTimeMS + ", " + endTimeMS);
        this.mStartTimeMS = startTimeMS;
        this.mEndTimeMS = endTimeMS;
    }

    public void seekBytes(long positionBytes) {
        long l2;
        if (positionBytes < 0L) {
            positionBytes = 0L;
            TXCLog.e(TAG, "seek bytes can not be negative. change to 0");
        }
        if ((l2 = TXAudioEffectManagerImpl.getCacheInstance().getAvailableBGMBytes(this.mBGMId)) > 0L) {
            positionBytes %= l2;
        }
        this.mSeekBytes = positionBytes;
        TXCLog.i(TAG, "mSeekBytes:" + this.mSeekBytes);
        TXAudioEffectManagerImpl.getCacheInstance().seekMusicToPosInBytes(this.mBGMId, positionBytes);
    }

    public long getDurationMS(String filePath) {
        return TXAudioEffectManagerImpl.getCacheInstance().getMusicDurationInMS(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayStart() {
        h h2 = null;
        TXCUGCBGMPlayer tXCUGCBGMPlayer = this;
        synchronized (tXCUGCBGMPlayer) {
            if (this.mWeakListener != null) {
                h2 = (h)this.mWeakListener.get();
            }
        }
        if (h2 != null) {
            h2.onPlayStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayEnd(int err) {
        h h2 = null;
        TXCUGCBGMPlayer tXCUGCBGMPlayer = this;
        synchronized (tXCUGCBGMPlayer) {
            if (this.mWeakListener != null) {
                h2 = (h)this.mWeakListener.get();
            }
        }
        if (h2 != null) {
            h2.onPlayEnd(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayProgress(long curPtsMS, long durationMS) {
        h h2 = null;
        TXCUGCBGMPlayer tXCUGCBGMPlayer = this;
        synchronized (tXCUGCBGMPlayer) {
            if (this.mWeakListener != null) {
                h2 = (h)this.mWeakListener.get();
            }
        }
        if (h2 != null) {
            h2.onPlayProgress(curPtsMS, durationMS);
        }
    }

    @Override
    public void onPlayProgress(int id, long curPtsMS, long durationMS) {
        this.onPlayProgress(curPtsMS, durationMS);
    }

    @Override
    public void onStart(int id, int errCode) {
        this.onPlayStart();
    }

    @Override
    public void onComplete(int id, int errCode) {
        this.onPlayEnd(errCode);
    }

    static {
        i.d();
    }

    private static class a {
        private static TXCUGCBGMPlayer a = new TXCUGCBGMPlayer();

        public static TXCUGCBGMPlayer a() {
            return a;
        }
    }
}

