/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.impl.Record;

import android.media.AudioRecord;
import android.os.Process;
import com.tencent.liteav.basic.log.TXCLog;
import java.nio.ByteBuffer;

public class TXCAudioCapturer {
    private static final String TAG = "TXCAudioCapturer";
    private AudioRecord mAudioRecord;

    public boolean startRecord(int audioSource, int samplerate, int channelCount, int frameSize) {
        int[] nArray = new int[]{audioSource, 1, 5, 0};
        int n2 = channelCount == 1 ? 16 : 12;
        int n3 = AudioRecord.getMinBufferSize((int)samplerate, (int)n2, (int)2);
        for (int i2 = 0; i2 < nArray.length && this.mAudioRecord == null; ++i2) {
            int n4 = nArray[i2];
            for (int i3 = 1; i3 <= 2 && this.mAudioRecord == null; ++i3) {
                int n5 = n3 * i3;
                if (n5 < frameSize * 4 && i3 < 2) continue;
                this.mAudioRecord = TXCAudioCapturer.createStartedAudioRecord(n4, samplerate, n2, n5);
            }
        }
        Thread.currentThread().setName("tx_audio_capturer");
        Process.setThreadPriority((int)-19);
        return this.mAudioRecord != null;
    }

    private static AudioRecord createStartedAudioRecord(int audioSource, int samplerate, int channelConfig, int bufferSize) {
        AudioRecord audioRecord = null;
        try {
            audioRecord = new AudioRecord(audioSource, samplerate, channelConfig, 2, bufferSize);
            if (audioRecord.getState() != 1) {
                throw new RuntimeException("AudioRecord is not initialized.");
            }
            audioRecord.startRecording();
        }
        catch (Exception exception) {
            TXCLog.w(TAG, "create AudioRecord failed. source: %s, samplerate: %d, channelConfig: %d, bufferSize: %d", TXCAudioCapturer.audioSourceToText(audioSource), samplerate, channelConfig, bufferSize);
            TXCAudioCapturer.tearDownAudioRecord(audioRecord);
            audioRecord = null;
        }
        return audioRecord;
    }

    private static void tearDownAudioRecord(AudioRecord audioRecord) {
        if (audioRecord == null) {
            return;
        }
        try {
            if (audioRecord.getRecordingState() == 3) {
                audioRecord.stop();
            }
            audioRecord.release();
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "stop AudioRecord failed.", exception);
        }
    }

    private static String audioSourceToText(int audioSource) {
        switch (audioSource) {
            case 1: {
                return "MIC";
            }
            case 7: {
                return "VOICE_COMMUNICATION";
            }
        }
        return "UNSUPPORT " + audioSource;
    }

    public int read(ByteBuffer buffer, int size) {
        if (this.mAudioRecord == null) {
            return -1;
        }
        buffer.position(0);
        int n2 = this.mAudioRecord.read(buffer, size);
        if (n2 <= 0) {
            TXCLog.e(TAG, "read failed, %d", n2);
            return -1;
        }
        return n2;
    }

    public void stopRecord() {
        TXCAudioCapturer.tearDownAudioRecord(this.mAudioRecord);
        this.mAudioRecord = null;
    }
}

