/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.network;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.module.Monitor;
import com.tencent.liteav.basic.module.TXCEventRecorderProxy;
import com.tencent.liteav.basic.module.TXCStatus;
import com.tencent.liteav.basic.structs.TXSNALPacket;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.network.c;
import com.tencent.liteav.network.i;
import com.tencent.liteav.network.j;
import com.tencent.liteav.network.k;
import java.lang.ref.WeakReference;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONObject;

public class TXCStreamUploader
extends com.tencent.liteav.basic.module.a
implements com.tencent.liteav.network.b {
    static final String TAG = "TXCStreamUploader";
    public static final int TXE_UPLOAD_MODE_REAL_TIME = 0;
    public static final int TXE_UPLOAD_MODE_AUDIO_ONLY = 1;
    public static final int TXE_UPLOAD_MODE_LINK_MIC = 2;
    public static final int TXE_UPLOAD_PROTOCOL_RTMP = 0;
    public static final int TXE_UPLOAD_PROTOCOL_AV = 1;
    public static final int RTMPSENDSTRATEGY_LIVE = 1;
    public static final int RTMPSENDSTRATEGY_REALTIME_TCP = 2;
    public static final int RTMPSENDSTRATEGY_REALTIME_QUIC = 3;
    public static final int NAL_CODEC_ID_AVC = 0;
    public static final int NAL_CODEC_ID_HEVC = 1;
    private long mUploaderInstance = 0L;
    private Thread mThread = null;
    private Object mThreadLock = null;
    private boolean mIsPushing = false;
    private String mRtmpUrl = "";
    private boolean mQuicChannel = false;
    private int mChannelType = 0;
    private boolean mEnableNearestIP = true;
    private c mIntelligentRoute = null;
    private int mLastNetworkType = 0;
    private WeakReference<com.tencent.liteav.basic.b.b> mNotifyListener = null;
    private Context mContext = null;
    private ArrayList<com.tencent.liteav.network.a> mIpList = null;
    private int mCurrentRecordIdx = 0;
    private int mRetryCount = 0;
    private long mConnectSuccessTimeStamps = 0L;
    private long mGoodPushTime = 30000L;
    private HandlerThread mHandlerThread = null;
    private Handler mHandler = null;
    private final int MSG_RECONNECT = 101;
    private final int MSG_EVENT = 102;
    private final int MSG_REPORT_STATUS = 103;
    private final int MSG_RTMPPROXY_HEARTBEAT = 104;
    private long mLastTimeStamp = 0L;
    private UploadStats mLastUploadStats = null;
    private Vector<TXSNALPacket> mVecPendingNAL = new Vector();
    private i mParam = null;
    private int mConnectCountQuic = 0;
    private int mConnectCountTcp = 0;
    private k mUploadQualityReport = null;
    private boolean mRtmpProxyEnable = false;
    private boolean mAudioMuted = false;
    private a mRtmpProxyParam = new a();
    private Vector<String> mRtmpProxyIPList = new Vector();
    private int mRtmpProxyIPIndex = 0;
    private long mRtmpProxyInstance = 0L;
    private long mRtmpMsgRecvThreadInstance = 0L;
    private Object mRtmpProxyLock = new Object();
    private Object mRtmpMsgRecvThreadLock = new Object();
    HashMap<String, String> mMetaData;

    public void setNotifyListener(com.tencent.liteav.basic.b.b listener) {
        this.mNotifyListener = new WeakReference<com.tencent.liteav.basic.b.b>(listener);
    }

    public TXCStreamUploader(Context context, i param) {
        this.mContext = context;
        if (param == null) {
            param = new i();
            param.a = 0;
            param.g = 3;
            param.f = 3;
            param.h = 40;
            param.i = 1000;
            param.j = true;
        }
        this.mParam = param;
        this.mThreadLock = new Object();
        this.mIntelligentRoute = new c();
        this.mIntelligentRoute.a = this;
        this.mUploaderInstance = 0L;
        this.mRetryCount = 0;
        this.mCurrentRecordIdx = 0;
        this.mIpList = null;
        this.mIsPushing = false;
        this.mThread = null;
        this.mRtmpUrl = null;
        this.mLastNetworkType = 0;
        this.mHandlerThread = null;
        this.mUploadQualityReport = new k(context);
        j.a().a(context);
    }

    public void setRetryInterval(int second) {
        if (this.mParam != null) {
            this.mParam.g = second;
        }
    }

    public void setAudioInfo(int samplerate, int channels) {
        if (this.mParam != null) {
            this.mParam.d = channels;
            this.mParam.e = samplerate;
        }
    }

    public void setRetryTimes(int times) {
        if (this.mParam != null) {
            this.mParam.f = times;
        }
    }

    public void setMode(int mode) {
        if (this.mParam != null) {
            this.mParam.a = mode;
        }
    }

    private void postReconnectMsg(String url, boolean quicChannel, int delayms) {
        Message message = new Message();
        message.what = 101;
        message.obj = url;
        int n2 = message.arg1 = quicChannel ? 2 : 1;
        if (this.mHandler != null) {
            this.mHandler.sendMessageDelayed(message, (long)delayms);
        }
    }

    @Override
    public void onFetchDone(int code, ArrayList<com.tencent.liteav.network.a> ipRecordList) {
        if (!this.mIsPushing) {
            return;
        }
        if (code == 1) {
            TXCLog.w(TAG, "onFetchDone: Network connection failed. Invalid push url!");
            this.sendNotifyEvent(-1313, "Network connection failed. Invalid push url!");
            return;
        }
        if (code == 0 && ipRecordList != null && ipRecordList.size() > 0) {
            TXCLog.i(TAG, "onFetchDone: connect success, ip count = " + ipRecordList.size());
            this.mIpList = ipRecordList;
            this.mCurrentRecordIdx = 0;
            int n2 = 0;
            String string = "";
            for (com.tencent.liteav.network.a a2 : this.mIpList) {
                if (a2 != null && a2.c && a2.a != null && a2.a.length() > 0) {
                    ++n2;
                }
                if (a2 == null) continue;
                string = string + " " + this.getConfusionIP(a2.a) + ":" + a2.b;
            }
            this.setStatusValue(7016, n2);
            this.setStatusValue(7019, "{" + string + " }");
        } else {
            TXCLog.i(TAG, "onFetchDone: code = " + code + " ip count = " + (ipRecordList != null ? ipRecordList.size() : 0));
        }
        b b2 = this.getRtmpRealConnectInfo();
        this.postReconnectMsg(b2.a, b2.b, 0);
    }

    public String getConfusionIP(String srcIP) {
        String string;
        int n2;
        if (srcIP != null && (n2 = (string = srcIP).indexOf(".")) != -1 && (n2 = (string = string.substring(n2 + 1)).indexOf(".")) != -1) {
            string = string.substring(n2 + 1);
            return "A.B." + string;
        }
        return srcIP;
    }

    public int init() {
        return 0;
    }

    public String start(String url, boolean enableNearestIP, int channelType) {
        if (this.mIsPushing) {
            return this.mRtmpUrl;
        }
        this.mIsPushing = true;
        this.mConnectSuccessTimeStamps = 0L;
        this.mRetryCount = 0;
        this.mRtmpUrl = url;
        this.mChannelType = channelType;
        this.mConnectCountQuic = 0;
        this.mConnectCountTcp = 0;
        this.mRtmpProxyEnable = false;
        this.mRtmpProxyParam.a();
        this.mRtmpProxyIPList.clear();
        this.mRtmpProxyIPIndex = 0;
        this.mRtmpProxyInstance = 0L;
        this.mRtmpMsgRecvThreadInstance = 0L;
        this.setStatusValue(7016, 0L);
        this.setStatusValue(7017, 0L);
        this.setStatusValue(7018, 0L);
        this.mUploadQualityReport.a();
        TXCLog.i(TAG, "start push with url:" + this.mRtmpUrl + " enable nearest ip:" + (enableNearestIP ? "yes" : "no") + "channel type:" + channelType);
        if (com.tencent.liteav.basic.util.i.e(this.mContext) == 0) {
            this.sendNotifyEvent(-1325);
            return this.mRtmpUrl;
        }
        this.mEnableNearestIP = enableNearestIP;
        if (this.mHandlerThread == null) {
            this.mHandlerThread = new HandlerThread("RTMP_PUSH");
            this.mHandlerThread.start();
        }
        this.mHandler = new Handler(this.mHandlerThread.getLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 101: {
                        TXCStreamUploader.this.startPushTask((String)msg.obj, msg.arg1 == 2, 0);
                        break;
                    }
                    case 103: {
                        TXCStreamUploader.this.reportNetStatus();
                        break;
                    }
                    case 104: {
                        TXCStreamUploader.this.rtmpProxySendHeartBeat();
                        if (TXCStreamUploader.this.mHandler == null) break;
                        TXCStreamUploader.this.mHandler.sendEmptyMessageDelayed(104, 2000L);
                        break;
                    }
                }
            }
        };
        this.parseProxyInfo(url);
        if (this.mRtmpProxyEnable) {
            this.mLastNetworkType = com.tencent.liteav.basic.util.i.e(this.mContext);
            this.nativeCacheJNIParams();
            this.startPushTask(this.mRtmpUrl, this.mQuicChannel, 0);
        } else if (this.mEnableNearestIP && this.mLastNetworkType != com.tencent.liteav.basic.util.i.e(this.mContext)) {
            TXCLog.i(TAG, "fetching nearest ip list");
            this.mLastNetworkType = com.tencent.liteav.basic.util.i.e(this.mContext);
            this.mIntelligentRoute.a(url, channelType);
        } else {
            this.startPushTask(this.mRtmpUrl, this.mQuicChannel, 0);
        }
        this.mHandler.sendEmptyMessageDelayed(103, 2000L);
        return this.mRtmpUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object;
        if (!this.mIsPushing) {
            return;
        }
        this.mIsPushing = false;
        TXCLog.i(TAG, "stop push");
        if (this.mRtmpProxyEnable) {
            object = this.mRtmpProxyLock;
            synchronized (object) {
                this.nativeRtmpProxyLeaveRoom(this.mRtmpProxyInstance);
            }
        }
        object = this.mThreadLock;
        synchronized (object) {
            this.nativeStopPush(this.mUploaderInstance);
        }
        if (this.mHandlerThread != null) {
            this.mHandlerThread.getLooper().quit();
            this.mHandlerThread = null;
        }
        if (this.mHandler != null) {
            this.mHandler = null;
        }
        if (this.mRtmpProxyEnable) {
            this.nativeReleaseJNIParams();
        }
        this.mUploadQualityReport.c();
        this.mUploadQualityReport.a();
    }

    private void tryResetRetryCount() {
        if (this.mConnectSuccessTimeStamps != 0L && TXCTimeUtil.getTimeTick() - this.mConnectSuccessTimeStamps > (long)(this.mParam.f * (this.mParam.g + 13) * 1000)) {
            this.mRetryCount = 0;
            this.mConnectSuccessTimeStamps = 0L;
            TXCLog.i(TAG, "reset retry count");
        }
    }

    public void setMetaData(HashMap<String, String> metaData) {
        this.mMetaData = metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushAAC(byte[] aac, long ts) {
        this.tryResetRetryCount();
        Object object = this.mThreadLock;
        synchronized (object) {
            if (!this.mAudioMuted || !this.mRtmpProxyEnable) {
                this.nativePushAAC(this.mUploaderInstance, aac, ts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushNAL(TXSNALPacket nal) {
        this.tryResetRetryCount();
        Object object = this.mThreadLock;
        synchronized (object) {
            if (this.mUploaderInstance != 0L) {
                if (nal != null && nal.nalData != null && nal.nalData.length > 0) {
                    this.nativePushNAL(this.mUploaderInstance, nal.nalData, nal.nalType, nal.frameIndex, nal.pts, nal.dts, nal.codecId == 1);
                }
            } else {
                if (nal.nalType == 0) {
                    this.mVecPendingNAL.removeAllElements();
                }
                this.mVecPendingNAL.add(nal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAudioMute(boolean audioMuted) {
        Object object = this.mThreadLock;
        synchronized (object) {
            this.mAudioMuted = audioMuted;
            if (this.mRtmpProxyEnable && this.mUploaderInstance != 0L) {
                int n2 = this.mParam.m ? (this.mQuicChannel ? 3 : 2) : 1;
                this.nativeSetSendStrategy(this.mUploaderInstance, n2, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDropEanble(boolean enable) {
        TXCLog.i(TAG, "drop enable " + (enable ? "yes" : "no"));
        Object object = this.mThreadLock;
        synchronized (object) {
            this.nativeEnableDrop(this.mUploaderInstance, enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVideoDropParams(boolean waitIframe, int maxVideoCnt, int maxVideoCacheTime) {
        TXCLog.i(TAG, "drop params wait i frame:" + (waitIframe ? "yes" : "no") + " max video count:" + maxVideoCnt + " max video cache time: " + maxVideoCacheTime + " ms");
        Object object = this.mThreadLock;
        synchronized (object) {
            this.mParam.j = waitIframe;
            this.mParam.h = maxVideoCnt;
            this.mParam.i = maxVideoCacheTime;
            if (this.mUploaderInstance != 0L) {
                this.nativeSetVideoDropParams(this.mUploaderInstance, this.mParam.j, this.mParam.h, this.mParam.i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSendStrategy(boolean realTimeMode, boolean sendAudioFirst) {
        int n2;
        this.mParam.m = realTimeMode;
        this.mParam.n = sendAudioFirst;
        this.mUploadQualityReport.a(realTimeMode);
        int n3 = realTimeMode ? (this.mQuicChannel ? 3 : 2) : (n2 = 1);
        if (!(this.mRtmpProxyEnable || this.mIpList != null && this.mIpList.size() != 0)) {
            n2 = 1;
        }
        Object object = this.mThreadLock;
        synchronized (object) {
            if (this.mUploaderInstance != 0L) {
                this.nativeSetSendStrategy(this.mUploaderInstance, n2, sendAudioFirst);
            }
        }
        this.setStatusValue(7020, n2);
    }

    public void sendSeiMessage(int payloadType, byte[] data) {
        this.nativeSendSeiMessage(this.mUploaderInstance, payloadType, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadStats getUploadStats() {
        UploadStats uploadStats;
        Object object = this.mThreadLock;
        synchronized (object) {
            uploadStats = this.nativeGetStats(this.mUploaderInstance);
            if (uploadStats != null) {
                uploadStats.channelType = this.mQuicChannel ? 2L : 1L;
            }
        }
        return uploadStats;
    }

    private void startPushTask(final String url, final boolean quicChannel, int Delayms) {
        TXCLog.i(TAG, "start push task");
        if (this.mQuicChannel != quicChannel && this.mQuicChannel) {
            Monitor.a(2, String.format("Network: switch push channel from quic to tcp.[retryCount:%d][retryLimit:%d]", this.mRetryCount, this.mParam.f), "", 0);
        }
        if (quicChannel) {
            this.setStatusValue(7017, ++this.mConnectCountQuic);
        } else {
            this.setStatusValue(7018, ++this.mConnectCountTcp);
        }
        this.mThread = new Thread("RTMPUpload"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (TXCStreamUploader.this.mUploaderInstance != 0L) {
                    try {
                        2.sleep(100L, 0);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                TXCStreamUploader.this.mUploadQualityReport.b();
                TXCStreamUploader.this.mUploadQualityReport.a(((TXCStreamUploader)TXCStreamUploader.this).mParam.m);
                TXCStreamUploader.this.mUploadQualityReport.a(TXCStreamUploader.this.mRtmpUrl);
                TXCStreamUploader.this.mUploadQualityReport.a(quicChannel, TXCStreamUploader.this.getAddressFromUrl(url));
                Object object = TXCStreamUploader.this.mThreadLock;
                synchronized (object) {
                    int n2;
                    TXCStreamUploader.this.mQuicChannel = quicChannel;
                    int n3 = ((TXCStreamUploader)TXCStreamUploader.this).mParam.m ? (TXCStreamUploader.this.mQuicChannel ? 3 : 2) : (n2 = 1);
                    if (!TXCStreamUploader.this.mRtmpProxyEnable) {
                        if (TXCStreamUploader.this.mIpList == null || TXCStreamUploader.this.mIpList.size() == 0) {
                            n2 = 1;
                        }
                    } else if (TXCStreamUploader.this.mAudioMuted) {
                        ((TXCStreamUploader)TXCStreamUploader.this).mParam.n = false;
                    }
                    TXCStreamUploader.this.setStatusValue(7020, n2);
                    TXCStreamUploader.this.mUploaderInstance = TXCStreamUploader.this.nativeInitUploader(TXCStreamUploader.this.mRtmpUrl, url, quicChannel, ((TXCStreamUploader)TXCStreamUploader.this).mParam.e, ((TXCStreamUploader)TXCStreamUploader.this).mParam.d, ((TXCStreamUploader)TXCStreamUploader.this).mParam.a, ((TXCStreamUploader)TXCStreamUploader.this).mParam.c, ((TXCStreamUploader)TXCStreamUploader.this).mParam.h, 16, n2, ((TXCStreamUploader)TXCStreamUploader.this).mParam.n, ((TXCStreamUploader)TXCStreamUploader.this).mParam.o, TXCStreamUploader.this.mMetaData);
                    if (TXCStreamUploader.this.mUploaderInstance != 0L) {
                        TXCStreamUploader.this.nativeSetVideoDropParams(TXCStreamUploader.this.mUploaderInstance, ((TXCStreamUploader)TXCStreamUploader.this).mParam.j, ((TXCStreamUploader)TXCStreamUploader.this).mParam.h, ((TXCStreamUploader)TXCStreamUploader.this).mParam.i);
                        boolean bl = false;
                        for (TXSNALPacket tXSNALPacket : TXCStreamUploader.this.mVecPendingNAL) {
                            if (!bl && tXSNALPacket.nalType == 0) {
                                bl = true;
                            }
                            if (!bl) continue;
                            TXCStreamUploader.this.nativePushNAL(TXCStreamUploader.this.mUploaderInstance, tXSNALPacket.nalData, tXSNALPacket.nalType, tXSNALPacket.frameIndex, tXSNALPacket.pts, tXSNALPacket.dts, tXSNALPacket.codecId == 1);
                        }
                        TXCStreamUploader.this.mVecPendingNAL.removeAllElements();
                    }
                }
                if (TXCStreamUploader.this.mRtmpProxyEnable) {
                    object = TXCStreamUploader.this.mRtmpProxyLock;
                    synchronized (object) {
                        TXCStreamUploader.this.mRtmpProxyInstance = TXCStreamUploader.this.nativeInitRtmpProxyInstance(((TXCStreamUploader)TXCStreamUploader.this).mRtmpProxyParam.a, ((TXCStreamUploader)TXCStreamUploader.this).mRtmpProxyParam.b, ((TXCStreamUploader)TXCStreamUploader.this).mRtmpProxyParam.c, ((TXCStreamUploader)TXCStreamUploader.this).mRtmpProxyParam.d, ((TXCStreamUploader)TXCStreamUploader.this).mRtmpProxyParam.e, ((TXCStreamUploader)TXCStreamUploader.this).mRtmpProxyParam.f, ((TXCStreamUploader)TXCStreamUploader.this).mRtmpProxyParam.g, ((TXCStreamUploader)TXCStreamUploader.this).mRtmpProxyParam.h, ((TXCStreamUploader)TXCStreamUploader.this).mRtmpProxyParam.i, ((TXCStreamUploader)TXCStreamUploader.this).mRtmpProxyParam.j);
                    }
                    object = TXCStreamUploader.this.mRtmpMsgRecvThreadLock;
                    synchronized (object) {
                        TXCStreamUploader.this.mRtmpMsgRecvThreadInstance = TXCStreamUploader.this.nativeInitRtmpMsgRecvThreadInstance(TXCStreamUploader.this.mRtmpProxyInstance, TXCStreamUploader.this.mUploaderInstance);
                    }
                }
                TXCStreamUploader.this.nativeOnThreadRun(TXCStreamUploader.this.mUploaderInstance);
                if (TXCStreamUploader.this.mRtmpProxyEnable) {
                    object = TXCStreamUploader.this.mRtmpMsgRecvThreadLock;
                    synchronized (object) {
                        TXCStreamUploader.this.nativeRtmpMsgRecvThreadStop(TXCStreamUploader.this.mRtmpMsgRecvThreadInstance);
                        TXCStreamUploader.this.nativeUninitRtmpMsgRecvThreadInstance(TXCStreamUploader.this.mRtmpMsgRecvThreadInstance);
                        TXCStreamUploader.this.mRtmpMsgRecvThreadInstance = 0L;
                    }
                    object = TXCStreamUploader.this.mRtmpProxyLock;
                    synchronized (object) {
                        TXCStreamUploader.this.nativeUninitRtmpProxyInstance(TXCStreamUploader.this.mRtmpProxyInstance);
                        TXCStreamUploader.this.mRtmpProxyInstance = 0L;
                    }
                }
                object = TXCStreamUploader.this.mThreadLock;
                synchronized (object) {
                    TXCStreamUploader.this.nativeUninitUploader(TXCStreamUploader.this.mUploaderInstance);
                    TXCStreamUploader.this.mUploaderInstance = 0L;
                }
            }
        };
        this.mThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPushTask() {
        TXCLog.i(TAG, "stop push task");
        Object object = this.mThreadLock;
        synchronized (object) {
            this.mVecPendingNAL.removeAllElements();
            this.nativeStopPush(this.mUploaderInstance);
        }
    }

    private b getRtmpRealConnectInfo() {
        if (!this.mEnableNearestIP) {
            return new b(this.mRtmpUrl, false);
        }
        if (this.mIpList == null) {
            return new b(this.mRtmpUrl, false);
        }
        if (this.mCurrentRecordIdx >= this.mIpList.size() || this.mCurrentRecordIdx < 0) {
            return new b(this.mRtmpUrl, false);
        }
        com.tencent.liteav.network.a a2 = this.mIpList.get(this.mCurrentRecordIdx);
        String[] stringArray = this.mRtmpUrl.split("://");
        if (stringArray.length < 2) {
            return new b(this.mRtmpUrl, false);
        }
        String[] stringArray2 = stringArray[1].split("/");
        String[] stringArray3 = a2.a.split(":");
        stringArray2[0] = stringArray3.length > 1 && !a2.a.startsWith("[") ? "[" + a2.a + "]:" + a2.b : a2.a + ":" + a2.b;
        StringBuilder stringBuilder = new StringBuilder(stringArray2[0]);
        for (int i2 = 1; i2 < stringArray2.length; ++i2) {
            stringBuilder.append("/");
            stringBuilder.append(stringArray2[i2]);
        }
        String string = stringArray[0] + "://" + stringBuilder.toString();
        return new b(string, a2.c);
    }

    private boolean nextRecordIdx(boolean setfail) {
        if (this.mIpList == null || this.mIpList.size() == 0) {
            return false;
        }
        if (setfail) {
            com.tencent.liteav.network.a a2 = this.mIpList.get(this.mCurrentRecordIdx);
            ++a2.e;
        }
        if (this.mCurrentRecordIdx + 1 < this.mIpList.size()) {
            ++this.mCurrentRecordIdx;
            return true;
        }
        return false;
    }

    private String getAddressFromUrl(String url) {
        String string;
        int n2;
        if (url != null && (n2 = url.indexOf("://")) != -1 && (n2 = (string = url.substring(n2 + 3)).indexOf("/")) != -1) {
            return string.substring(0, n2);
        }
        return "";
    }

    private void reconnect(final boolean bchangeip) {
        this.stopPushTask();
        if (this.mHandler != null) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    TXCStreamUploader.this.internalReconnect(bchangeip);
                }
            }, (long)(this.mParam.g * 1000));
        }
    }

    private void internalReconnect(boolean bchangeip) {
        if (!this.mIsPushing) {
            return;
        }
        if (this.mRtmpProxyEnable) {
            if (this.mLastNetworkType != com.tencent.liteav.basic.util.i.e(this.mContext)) {
                TXCLog.e(TAG, "reconnect network switch from " + this.mLastNetworkType + " to " + com.tencent.liteav.basic.util.i.e(this.mContext));
                this.mLastNetworkType = com.tencent.liteav.basic.util.i.e(this.mContext);
                this.mRetryCount = 0;
                Monitor.a(2, "WebrtcRoom: need enter again by user", "", 0);
                String string = String.format("Network type has changed. Need to re-enter the room", new Object[0]);
                this.sendNotifyEvent(1021, string);
                return;
            }
            if (this.mRetryCount < this.mParam.f) {
                ++this.mRetryCount;
                Monitor.a(2, String.format("Network: reconnecting to upload server with quic.[addr:%s][retryCount:%d][retryLimit:%d]", this.mRtmpProxyParam.h, this.mRetryCount, this.mParam.f), "", 0);
                TXCEventRecorderProxy.a(this.mRtmpUrl, 91003, -1L, -1L, "reconnect rtmp-proxy server(econnect retry count:" + this.mRetryCount + " retry limit:" + this.mParam.f + ")", 0);
                this.sendNotifyEvent(1102);
                this.startPushTask(this.mRtmpUrl, this.mQuicChannel, 0);
            } else {
                boolean bl = this.getNextRtmpProxyIP();
                if (bl) {
                    this.mRetryCount = 0;
                    Monitor.a(2, String.format("Network: reconnecting to upload server with quic.[addr:%s][retryCount:%d][retryLimit:%d]", this.mRtmpProxyParam.h, this.mRetryCount, this.mParam.f), "", 0);
                    this.sendNotifyEvent(1102);
                    this.startPushTask(this.mRtmpUrl, this.mQuicChannel, 0);
                } else {
                    TXCEventRecorderProxy.a(this.mRtmpUrl, 91002, -1L, -1L, "connect rtmp-proxy server failed(try all addresses)", 0);
                    this.sendNotifyEvent(-1324);
                }
            }
        } else {
            boolean bl;
            this.mUploadQualityReport.c();
            if (this.mEnableNearestIP && this.mLastNetworkType != com.tencent.liteav.basic.util.i.e(this.mContext)) {
                TXCLog.e(TAG, "reconnect network switch from " + this.mLastNetworkType + " to " + com.tencent.liteav.basic.util.i.e(this.mContext));
                this.mLastNetworkType = com.tencent.liteav.basic.util.i.e(this.mContext);
                this.mIntelligentRoute.a(this.mRtmpUrl, this.mChannelType);
                this.mRetryCount = 0;
                return;
            }
            if (!this.mEnableNearestIP) {
                bchangeip = false;
            }
            if (this.mQuicChannel) {
                bchangeip = true;
            }
            if (bchangeip && !(bl = this.nextRecordIdx(true))) {
                TXCLog.e(TAG, "reconnect: try all addresses failed");
                TXCEventRecorderProxy.a(this.mRtmpUrl, 91002, -1L, -1L, "connect upload server failed(try all addresses failed)", 0);
            }
            b b2 = this.getRtmpRealConnectInfo();
            String string = this.getAddressFromUrl(b2.a);
            TXCLog.e(TAG, "reconnect change ip: " + string + " enableNearestIP: " + this.mEnableNearestIP + " last channel type: " + (this.mQuicChannel ? "Q Channel" : "TCP"));
            if (this.mQuicChannel) {
                TXCLog.e(TAG, "reconnect last channel type is Q Channel\uff0cignore retry limit");
                Monitor.a(2, String.format("Network: reconnecting to upload server with quic.[addr:%s]", string), "", 0);
                this.startPushTask(b2.a, b2.b, 0);
                this.sendNotifyEvent(1102);
            } else {
                TXCLog.e(TAG, "reconnect retry count:" + this.mRetryCount + " retry limit:" + this.mParam.f);
                if (this.mRetryCount < this.mParam.f) {
                    ++this.mRetryCount;
                    Monitor.a(2, String.format("Network: reconnecting to upload server with tcp.[addr:%s][retryCount:%d][retryLimit:%d]", string, this.mRetryCount, this.mParam.f), "", 0);
                    TXCEventRecorderProxy.a(this.mRtmpUrl, 91003, -1L, -1L, "reconnect upload server:(retry count:" + this.mRetryCount + " retry limit:" + this.mParam.f + ")", 0);
                    this.startPushTask(b2.a, b2.b, 0);
                    this.sendNotifyEvent(1102);
                } else {
                    TXCLog.e(TAG, "reconnect: try all times failed");
                    TXCEventRecorderProxy.a(this.mRtmpUrl, 91002, -1L, -1L, "connect upload server failed(try all times failed)", 0);
                    this.sendNotifyEvent(-1324);
                }
            }
        }
    }

    private void sendNotifyEvent(int event, String msg) {
        Object object;
        if (msg == null || msg.isEmpty()) {
            this.sendNotifyEvent(event);
        } else {
            object = new Bundle();
            object.putString("EVT_MSG", msg);
            object.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
            object.putLong("EVT_UTC_TIME", TXCTimeUtil.getUtcTimeTick());
            com.tencent.liteav.basic.util.i.a(this.mNotifyListener, event, object);
        }
        if (event == 1002) {
            object = this.getUploadStats();
            if (object != null) {
                this.mUploadQualityReport.a(object.dnsparseTimeCost, object.connectTimeCost, object.handshakeTimeCost);
            }
        } else if (event == 1101) {
            this.mUploadQualityReport.d();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotifyEvent(int event) {
        if (event == 0) {
            this.reconnect(false);
        } else if (event == 1) {
            this.reconnect(true);
        } else {
            if (event == 1001) {
                this.mConnectSuccessTimeStamps = TXCTimeUtil.getTimeTick();
            }
            if (event == 1026) {
                if (this.mRtmpProxyEnable) {
                    Object object = this.mRtmpMsgRecvThreadLock;
                    synchronized (object) {
                        this.nativeRtmpMsgRecvThreadStart(this.mRtmpMsgRecvThreadInstance);
                    }
                    object = this.mRtmpProxyLock;
                    synchronized (object) {
                        this.nativeRtmpProxyEnterRoom(this.mRtmpProxyInstance);
                    }
                    if (this.mHandler != null) {
                        this.mHandler.sendEmptyMessageDelayed(104, 2000L);
                    }
                }
                return;
            }
            if (this.mNotifyListener != null) {
                Bundle bundle = new Bundle();
                int n2 = event;
                switch (event) {
                    case -1324: {
                        bundle.putString("EVT_MSG", "Failed to connect all IPs, abort connection.");
                        break;
                    }
                    case -1307: {
                        bundle.putString("EVT_MSG", "failed to connect server for several times, abort connection");
                        break;
                    }
                    case 3008: {
                        bundle.putString("EVT_MSG", "No data is sent for more than 30s. Actively disconnect");
                        break;
                    }
                    case -1325: {
                        bundle.putString("EVT_MSG", "No internet. Please check if WiFi or mobile data is turned on");
                        break;
                    }
                    case 3009: {
                        bundle.putString("EVT_MSG", "Failed to connect server");
                        break;
                    }
                    case 1001: {
                        bundle.putString("EVT_MSG", "Already connected to rtmp server");
                        break;
                    }
                    case 3003: {
                        bundle.putString("EVT_MSG", "RTMP servers handshake failed");
                        break;
                    }
                    case 1101: {
                        bundle.putString("EVT_MSG", "Insufficient upstream bandwidth. Data transmission is not timely");
                        break;
                    }
                    case 1002: {
                        bundle.putString("EVT_MSG", "rtmp start push stream");
                        break;
                    }
                    case -2308: {
                        bundle.putString("EVT_MSG", "The server rejects the connection request. It may be that the push URL has been occupied or expired, or the anti-leech link is wrong.");
                        break;
                    }
                    case 1026: {
                        if (this.mRtmpProxyEnable) {
                            Object object = this.mRtmpMsgRecvThreadLock;
                            synchronized (object) {
                                this.nativeRtmpMsgRecvThreadStart(this.mRtmpMsgRecvThreadInstance);
                            }
                            object = this.mRtmpProxyLock;
                            synchronized (object) {
                                this.nativeRtmpProxyEnterRoom(this.mRtmpProxyInstance);
                            }
                            if (this.mHandler != null) {
                                this.mHandler.sendEmptyMessageDelayed(104, 2000L);
                            }
                        }
                        return;
                    }
                    case 1102: {
                        bundle.putString("EVT_MSG", "Enables network reconnection");
                        break;
                    }
                    default: {
                        bundle.putString("EVT_MSG", "UNKNOWN");
                    }
                }
                bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
                bundle.putLong("EVT_UTC_TIME", TXCTimeUtil.getUtcTimeTick());
                com.tencent.liteav.basic.util.i.a(this.mNotifyListener, n2, bundle);
            }
        }
    }

    private void reportNetStatus() {
        long l2 = TXCTimeUtil.getTimeTick();
        long l3 = l2 - this.mLastTimeStamp;
        UploadStats uploadStats = this.getUploadStats();
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        if (uploadStats != null) {
            if (this.mLastUploadStats != null) {
                l4 = this.getSpeed(this.mLastUploadStats.inVideoBytes, uploadStats.inVideoBytes, l3);
                l5 = this.getSpeed(this.mLastUploadStats.inAudioBytes, uploadStats.inAudioBytes, l3);
                l6 = this.getSpeed(this.mLastUploadStats.outVideoBytes, uploadStats.outVideoBytes, l3);
                l7 = this.getSpeed(this.mLastUploadStats.outAudioBytes, uploadStats.outAudioBytes, l3);
            }
            this.setStatusValue(7005, uploadStats.videoCacheLen);
            this.setStatusValue(7006, uploadStats.audioCacheLen);
            this.setStatusValue(7007, uploadStats.videoDropCount);
            this.setStatusValue(7008, uploadStats.audioDropCount);
            this.setStatusValue(7021, uploadStats.bandwidthEst);
            this.setStatusValue(7009, uploadStats.startTS);
            this.setStatusValue(7010, uploadStats.dnsTS);
            this.setStatusValue(7011, uploadStats.connTS);
            this.setStatusValue(7012, String.valueOf(uploadStats.serverIP));
            this.setStatusValue(7013, this.mQuicChannel ? 2L : 1L);
            this.setStatusValue(7014, uploadStats.connectionID);
            this.setStatusValue(7015, uploadStats.connectionStats);
            this.mUploadQualityReport.a(uploadStats.videoDropCount, uploadStats.audioDropCount);
            this.mUploadQualityReport.b(uploadStats.videoCacheLen, uploadStats.audioCacheLen);
        } else {
            this.setStatusValue(7005, 0L);
            this.setStatusValue(7006, 0L);
            this.setStatusValue(7007, 0L);
            this.setStatusValue(7008, 0L);
        }
        this.setStatusValue(7001, l4);
        this.setStatusValue(7002, l5);
        this.setStatusValue(7003, l6);
        this.setStatusValue(7004, l7);
        this.mLastTimeStamp = l2;
        this.mLastUploadStats = uploadStats;
        if (this.mHandler != null) {
            this.mHandler.sendEmptyMessageDelayed(103, 2000L);
        }
    }

    private Long getSpeed(long lastValue, long currValue, long ms) {
        long l2 = 0L;
        l2 = lastValue > currValue ? currValue : currValue - lastValue;
        long l3 = 0L;
        if (ms > 0L) {
            l3 = l2 * 8L * 1000L / (ms * 1024L);
        }
        return l3;
    }

    private boolean isQCloudStreamUrl(String url) {
        String string;
        if (url == null || url.length() == 0) {
            return false;
        }
        String string2 = "://";
        int n2 = url.indexOf(string2);
        return n2 != -1 && (string = url.substring(n2 + string2.length())) != null && string.startsWith("cloud.tencent.com");
    }

    private void parseProxyInfo(String url) {
        String string;
        if (url == null || url.length() == 0 || !url.startsWith("room")) {
            return;
        }
        this.mRtmpProxyParam.i = this.isQCloudStreamUrl(url);
        HashMap hashMap = this.getParamsFromUrl(url);
        if (hashMap == null) {
            return;
        }
        if (hashMap.containsKey("sdkappid")) {
            this.mRtmpProxyParam.a = Long.valueOf((String)hashMap.get("sdkappid"));
        }
        if (!(hashMap.containsKey("roomid") && hashMap.containsKey("userid") && hashMap.containsKey("roomsig"))) {
            return;
        }
        this.mRtmpProxyParam.d = Long.valueOf((String)hashMap.get("roomid"));
        this.mRtmpProxyParam.c = (String)hashMap.get("userid");
        if (hashMap.containsKey("bizbuf")) {
            try {
                string = (String)hashMap.get("bizbuf");
                this.mRtmpProxyParam.j = URLDecoder.decode(string, "UTF-8");
            }
            catch (Exception exception) {
                TXCLog.e(TAG, "decode bizbuf failed.", exception);
            }
        }
        try {
            Object object;
            string = (String)hashMap.get("roomsig");
            string = URLDecoder.decode(string, "UTF-8");
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject == null) {
                return;
            }
            this.mRtmpProxyParam.b = 0L;
            if (!jSONObject.has("Key")) {
                return;
            }
            this.mRtmpProxyParam.e = jSONObject.optString("Key");
            JSONObject jSONObject2 = jSONObject.optJSONObject("RtmpProxy");
            if (!(jSONObject2 == null || jSONObject2.has("Ip") && jSONObject2.has("Port") && jSONObject2.has("Type"))) {
                return;
            }
            JSONArray jSONArray = jSONObject.optJSONArray("AccessList");
            if (jSONArray != null && jSONArray.length() > 0) {
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    object = jSONArray.getJSONObject(i2);
                    if (object == null || !object.has("Ip") || !object.has("Port") || !object.has("Type")) continue;
                    String string2 = object.optString("Ip");
                    long l2 = object.optLong("Port");
                    long l3 = object.optLong("Type");
                    if (l3 != 2L) continue;
                    this.mRtmpProxyIPList.add(string2 + ":" + l2);
                }
            }
            if (this.mRtmpProxyParam.i) {
                if (jSONObject2 == null) {
                    return;
                }
                String string3 = url.substring(0, url.indexOf("?"));
                object = this.mRtmpProxyParam.a + "_" + this.mRtmpProxyParam.d + "_" + this.mRtmpProxyParam.c;
                this.mRtmpUrl = string3 + "/webrtc/" + (String)object + "?real_rtmp_ip=" + jSONObject2.optString("Ip") + "&real_rtmp_port=" + jSONObject2.optLong("Port") + "&tinyid=" + this.mRtmpProxyParam.b + "&srctinyid=0";
                this.getNextRtmpProxyIP();
            } else {
                this.mRtmpUrl = url;
                this.mQuicChannel = false;
            }
            this.mRtmpProxyEnable = true;
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "parse proxy info failed.", exception);
        }
    }

    private HashMap getParamsFromUrl(String url) {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray2 = url.split("[?]");
        if (stringArray2 == null || stringArray2.length < 2 || stringArray2[1] == null || stringArray2[1].length() == 0) {
            return hashMap;
        }
        for (String string : stringArray = stringArray2[1].split("[&]")) {
            String[] stringArray3;
            if (string.indexOf("=") == -1 || (stringArray3 = string.split("[=]")).length != 2) continue;
            String string2 = stringArray3[0];
            String string3 = stringArray3[1];
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    private boolean getNextRtmpProxyIP() {
        this.mRtmpProxyParam.f = 234L;
        this.mRtmpProxyParam.g = 80L;
        if (this.mRtmpProxyIPList != null && this.mRtmpProxyIPList.size() > 0) {
            String string;
            if (this.mRtmpProxyIPIndex >= this.mRtmpProxyIPList.size()) {
                this.mRtmpProxyIPIndex = 0;
                return false;
            }
            String string2 = this.mRtmpUrl;
            String[] stringArray = string2.split("://");
            if (stringArray.length < 2) {
                return false;
            }
            String string3 = stringArray[1].substring(stringArray[1].indexOf("/"));
            this.mRtmpProxyParam.h = string = this.mRtmpProxyIPList.get(this.mRtmpProxyIPIndex);
            this.mRtmpUrl = "room://" + string + string3;
            this.mQuicChannel = true;
            ++this.mRtmpProxyIPIndex;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rtmpProxySendHeartBeat() {
        int[] nArray = com.tencent.liteav.basic.util.i.a();
        long l2 = nArray[0] / 10;
        long l3 = nArray[1] / 10;
        long l4 = TXCStatus.c(this.getID(), 7004);
        long l5 = TXCStatus.c(this.getID(), 7003);
        long l6 = TXCStatus.c(this.getID(), 1001);
        long l7 = TXCStatus.c(this.getID(), 4001);
        long l8 = TXCStatus.c(this.getID(), 7006);
        long l9 = TXCStatus.c(this.getID(), 7005);
        long l10 = TXCStatus.c(this.getID(), 7008);
        long l11 = TXCStatus.c(this.getID(), 7007);
        Object object = this.mRtmpProxyLock;
        synchronized (object) {
            this.nativeRtmpProxySendHeartBeat(this.mRtmpProxyInstance, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSendRtmpProxyMsg(byte[] buffer) {
        Object object = this.mThreadLock;
        synchronized (object) {
            if (this.mUploaderInstance != 0L) {
                this.nativeSendRtmpProxyMsg(this.mUploaderInstance, buffer);
            }
        }
    }

    private void onRtmpProxyUserListPushed(RtmpProxyUserInfo[] userInfoList) {
        if (userInfoList == null) {
            return;
        }
        if (!this.mIsPushing) {
            return;
        }
        if (!this.mRtmpProxyEnable || this.mRtmpProxyParam == null) {
            return;
        }
        try {
            JSONArray jSONArray = new JSONArray();
            JSONArray jSONArray2 = new JSONArray();
            for (int i2 = 0; i2 < userInfoList.length; ++i2) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("userid", (Object)userInfoList[i2].account);
                jSONObject.put("playurl", (Object)userInfoList[i2].playUrl);
                if (userInfoList[i2].stmType == 0) {
                    jSONArray.put((Object)jSONObject);
                    continue;
                }
                jSONArray2.put((Object)jSONObject);
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("userlist", (Object)jSONArray);
            jSONObject.put("userlist_aux", (Object)jSONArray2);
            this.sendNotifyEvent(1020, jSONObject.toString());
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "build json object failed.", exception);
        }
    }

    private void onRtmpProxyRoomEvent(int eventID, int errorCode) {
        if (eventID == 1) {
            String string = String.format("Already in room\uff0c[%d]", errorCode);
            this.sendNotifyEvent(1018, string);
        } else if (eventID == 2) {
            String string = String.format("Not in the room\uff0c[%d]", errorCode);
            this.sendNotifyEvent(1019, string);
        }
    }

    private native long nativeInitUploader(String var1, String var2, boolean var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, boolean var11, int var12, HashMap<String, String> var13);

    private native void nativeOnThreadRun(long var1);

    private native void nativeUninitUploader(long var1);

    private native void nativeEnableDrop(long var1, boolean var3);

    private native void nativeSetSendStrategy(long var1, int var3, boolean var4);

    private native void nativeSetVideoDropParams(long var1, boolean var3, int var4, int var5);

    private native void nativeStopPush(long var1);

    private native void nativePushAAC(long var1, byte[] var3, long var4);

    private native void nativePushNAL(long var1, byte[] var3, int var4, long var5, long var7, long var9, boolean var11);

    private native UploadStats nativeGetStats(long var1);

    private native void nativeSendRtmpProxyMsg(long var1, byte[] var3);

    private native void nativeSendSeiMessage(long var1, int var3, byte[] var4);

    private native void nativeCacheJNIParams();

    private native void nativeReleaseJNIParams();

    private native long nativeInitRtmpProxyInstance(long var1, long var3, String var5, long var6, String var8, long var9, long var11, String var13, boolean var14, String var15);

    private native void nativeUninitRtmpProxyInstance(long var1);

    private native void nativeRtmpProxyEnterRoom(long var1);

    private native void nativeRtmpProxyLeaveRoom(long var1);

    private native void nativeRtmpProxySendHeartBeat(long var1, long var3, long var5, long var7, long var9, long var11, long var13, long var15, long var17, long var19, long var21);

    private native long nativeInitRtmpMsgRecvThreadInstance(long var1, long var3);

    private native void nativeUninitRtmpMsgRecvThreadInstance(long var1);

    private native void nativeRtmpMsgRecvThreadStart(long var1);

    private native void nativeRtmpMsgRecvThreadStop(long var1);

    static {
        com.tencent.liteav.basic.util.i.d();
    }

    public class RtmpProxyUserInfo {
        public String account = "";
        public String playUrl = "";
        public int stmType = 0;
    }

    public class a {
        public long a;
        public long b;
        public String c;
        public long d;
        public String e;
        public long f;
        public long g;
        public String h;
        public boolean i;
        public String j;

        public void a() {
            this.a = 0L;
            this.b = 0L;
            this.c = "";
            this.d = 0L;
            this.e = "";
            this.f = 0L;
            this.g = 0L;
            this.i = false;
            this.j = "";
        }
    }

    public class UploadStats {
        public long inVideoBytes;
        public long inAudioBytes;
        public long outVideoBytes;
        public long outAudioBytes;
        public long videoCacheLen;
        public long audioCacheLen;
        public long videoDropCount;
        public long audioDropCount;
        public long bandwidthEst;
        public long startTS;
        public long dnsTS;
        public long connTS;
        public String serverIP;
        public long channelType;
        public long dnsparseTimeCost;
        public long connectTimeCost;
        public long handshakeTimeCost;
        public String connectionID;
        public String connectionStats;
    }

    private class b {
        public String a = "";
        public boolean b = false;

        public b(String string, boolean bl) {
            this.a = string;
            this.b = bl;
        }
    }
}

