/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.sharp.jni;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Process;
import com.tencent.liteav.basic.a.b;
import com.tencent.rtmp.sharp.jni.QLog;
import com.tencent.rtmp.sharp.jni.TraeAudioManager;

public class TraeAudioSession
extends BroadcastReceiver {
    private long mSessionId;
    private ITraeAudioCallback mCallback;
    private Context mContext;
    private String _connectedDev;
    private boolean _canSwtich2Earphone;
    static int s_nSessionIdAllocator = 0;
    final String TRAE_ACTION_PHONE_STATE = "android.intent.action.PHONE_STATE";

    public static long requestSessionId() {
        return ((long)Process.myPid() << 32) + (long)(++s_nSessionIdAllocator);
    }

    public static void ExConnectDevice(Context ctx, String strDevice) {
        if (null == ctx || null == strDevice || strDevice.length() <= 0) {
            return;
        }
        Intent intent = new Intent();
        intent.setAction("com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_REQUEST");
        intent.putExtra("PARAM_SESSIONID", Long.MIN_VALUE);
        intent.putExtra("PARAM_OPERATION", "OPERATION_CONNECTDEVICE");
        intent.putExtra("CONNECTDEVICE_DEVICENAME", strDevice);
        b.a(ctx).a(intent);
    }

    public TraeAudioSession(Context ctx, ITraeAudioCallback cb) {
        block5: {
            this.mSessionId = Long.MIN_VALUE;
            this._connectedDev = "DEVICE_NONE";
            this._canSwtich2Earphone = true;
            this.TRAE_ACTION_PHONE_STATE = "android.intent.action.PHONE_STATE";
            this.mSessionId = TraeAudioSession.requestSessionId();
            this.mCallback = cb;
            this.mContext = ctx;
            if (null == ctx && QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "AudioSession | Invalid parameters: ctx = " + (null == ctx ? "null" : "{object}") + "; cb = " + (null == cb ? "null" : "{object}"));
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_RES");
            intentFilter.addAction("com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_NOTIFY");
            try {
                if (ctx != null) {
                    b.a(ctx).a(this, intentFilter);
                }
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block5;
                QLog.e("TRAE", 2, "registerReceiver Exception: " + exception.getMessage());
            }
        }
        this.registerAudioSession(this, true);
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "TraeAudioSession create, mSessionId: " + this.mSessionId);
        }
    }

    public void release() {
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "TraeAudioSession release, mSessionId: " + this.mSessionId);
        }
        if (null != this.mContext) {
            try {
                this.mContext.unregisterReceiver((BroadcastReceiver)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            b.a(this.mContext).a(this);
        }
        this.registerAudioSession(this, false);
        this.mContext = null;
        this.mCallback = null;
    }

    public void setCallback(ITraeAudioCallback cb) {
        this.mCallback = cb;
    }

    private int registerAudioSession(TraeAudioSession _traeAs, boolean bRegister) {
        if (null == this.mContext) {
            return -1;
        }
        return TraeAudioManager.registerAudioSession(_traeAs, bRegister, this.mSessionId, this.mContext);
    }

    public int startService(String deviceConfig) {
        if (null == deviceConfig || deviceConfig.length() <= 0) {
            deviceConfig = "internal_disable_dev_switch";
        }
        return TraeAudioManager.startService("OPERATION_STARTSERVICE", this.mSessionId, true, deviceConfig);
    }

    public int disableDeviceSwitch() {
        return TraeAudioManager.disableDeviceSwitch();
    }

    public int stopService() {
        return TraeAudioManager.stopService("OPERATION_STOPSERVICE", this.mSessionId, true);
    }

    public int getDeviceList() {
        return TraeAudioManager.getDeviceList("OPERATION_GETDEVICELIST", this.mSessionId, true);
    }

    public int getStreamType() {
        return TraeAudioManager.getStreamType("OPERATION_GETSTREAMTYPE", this.mSessionId, true);
    }

    public int connectDevice(String strDevice) {
        return TraeAudioManager.connectDevice("OPERATION_CONNECTDEVICE", this.mSessionId, true, strDevice);
    }

    public int connectHighestPriorityDevice() {
        return TraeAudioManager.connectHighestPriorityDevice("OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE", this.mSessionId, true);
    }

    public int EarAction(int earAction) {
        return TraeAudioManager.earAction("OPERATION_EARACTION", this.mSessionId, true, earAction);
    }

    public int isDeviceChangabled() {
        return TraeAudioManager.isDeviceChangabled("OPERATION_ISDEVICECHANGABLED", this.mSessionId, true);
    }

    public int getConnectedDevice() {
        return TraeAudioManager.getConnectedDevice("OPERATION_GETCONNECTEDDEVICE", this.mSessionId, true);
    }

    public int getConnectingDevice() {
        return TraeAudioManager.getConnectingDevice("OPERATION_GETCONNECTINGDEVICE", this.mSessionId, true);
    }

    public int voiceCallPreprocess(int modePolicy, int streamType) {
        return TraeAudioManager.voicecallPreprocess("OPERATION_VOICECALL_PREPROCESS", this.mSessionId, true, modePolicy, streamType);
    }

    public int voiceCallPostprocess() {
        return TraeAudioManager.voicecallPostprocess("OPERATION_VOICECALL_POSTROCESS", this.mSessionId, true);
    }

    public int voiceCallAudioParamChanged(int modePolicy, int streamType) {
        return TraeAudioManager.voiceCallAudioParamChanged("com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_REQUEST", this.mSessionId, true, modePolicy, streamType);
    }

    public int startRing(int dataSource, int rsId, Uri res, String strFilePath, boolean bLoop) {
        return TraeAudioManager.startRing("OPERATION_STARTRING", this.mSessionId, true, dataSource, rsId, res, strFilePath, bLoop, 1, "normal-ring", false);
    }

    public int startRing(int dataSource, int rsId, Uri res, String strFilePath, boolean bLoop, int loopCount, String userData) {
        return TraeAudioManager.startRing("OPERATION_STARTRING", this.mSessionId, true, dataSource, rsId, res, strFilePath, bLoop, loopCount, userData, false);
    }

    public int startRing(int dataSource, int rsId, Uri res, String strFilePath, boolean bLoop, int loopCount, String userData, boolean ringMode) {
        return TraeAudioManager.startRing("OPERATION_STARTRING", this.mSessionId, true, dataSource, rsId, res, strFilePath, bLoop, loopCount, userData, ringMode);
    }

    public int stopRing() {
        return TraeAudioManager.stopRing("OPERATION_STOPRING", this.mSessionId, true);
    }

    public int requestReleaseAudioFocus() {
        return TraeAudioManager.requestReleaseAudioFocus("OPERATION_REQUEST_RELEASE_AUDIO_FOCUS", this.mSessionId, true);
    }

    public int recoverAudioFocus() {
        return TraeAudioManager.recoverAudioFocus("OPERATION_RECOVER_AUDIO_FOCUS", this.mSessionId, true);
    }

    public void onReceiveCallback(Intent intent) {
        block9: {
            int n2 = 0;
            try {
                if (null == intent) {
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 2, "[ERROR] intent = null!!");
                    }
                    return;
                }
                long l2 = intent.getLongExtra("PARAM_SESSIONID", Long.MIN_VALUE);
                String string = intent.getStringExtra("PARAM_OPERATION");
                n2 = intent.getIntExtra("PARAM_RES_ERRCODE", 0);
                if ("com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_RES".equals(intent.getAction())) {
                    if (this.mSessionId != l2) {
                        return;
                    }
                    if ("OPERATION_VOICECALL_PREPROCESS".equals(string)) {
                        if (QLog.isColorLevel()) {
                            QLog.w("TRAE", 2, "AudioSession|[onReceiveCallback onVoicecallPreprocess] err:" + n2);
                        }
                        if (null != this.mCallback) {
                            this.mCallback.onVoicecallPreprocessRes(n2);
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block9;
                QLog.e("TRAE", 2, "AudioSession| nSessinId = " + this.mSessionId + " onReceive::intent:" + intent.toString() + " intent.getAction():" + intent.getAction() + " Exception:" + exception.getMessage());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReceive(Context context, Intent intent) {
        int n2 = 0;
        try {
            if (null == intent) {
                if (!QLog.isColorLevel()) return;
                QLog.w("TRAE", 2, "[ERROR] intent = null!!");
                return;
            }
            long l2 = intent.getLongExtra("PARAM_SESSIONID", Long.MIN_VALUE);
            String string = intent.getStringExtra("PARAM_OPERATION");
            n2 = intent.getIntExtra("PARAM_RES_ERRCODE", 0);
            if ("com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_NOTIFY".equals(intent.getAction())) {
                if ("NOTIFY_SERVICE_STATE".equals(string)) {
                    boolean bl = intent.getBooleanExtra("NOTIFY_SERVICE_STATE_DATE", false);
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 2, "AudioSession|[onServiceStateUpdate]" + (bl ? "on" : "off"));
                    }
                    if (null == this.mCallback) return;
                    this.mCallback.onServiceStateUpdate(bl);
                    return;
                } else if ("NOTIFY_DEVICELISTUPDATE".equals(string)) {
                    String[] stringArray = intent.getStringArrayExtra("EXTRA_DATA_AVAILABLEDEVICE_LIST");
                    String string2 = intent.getStringExtra("EXTRA_DATA_CONNECTEDDEVICE");
                    String string3 = intent.getStringExtra("EXTRA_DATA_PREV_CONNECTEDDEVICE");
                    String string4 = intent.getStringExtra("EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME");
                    String string5 = "\n";
                    boolean bl = true;
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        string5 = string5 + "AudioSession|    " + i2 + " " + stringArray[i2] + "\n";
                        if (!stringArray[i2].equals("DEVICE_WIREDHEADSET") && !stringArray[i2].equals("DEVICE_BLUETOOTHHEADSET")) continue;
                        bl = false;
                    }
                    string5 = string5 + "\n";
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 2, "AudioSession|[onDeviceListUpdate]  connected:" + string2 + " prevConnected:" + string3 + " bt:" + string4 + " Num:" + stringArray.length + string5);
                    }
                    this._canSwtich2Earphone = bl;
                    this._connectedDev = string2;
                    if (null == this.mCallback) return;
                    this.mCallback.onDeviceListUpdate(stringArray, string2, string3, string4);
                    return;
                } else if ("NOTIFY_DEVICECHANGABLE_UPDATE".equals(string)) {
                    boolean bl = intent.getBooleanExtra("NOTIFY_DEVICECHANGABLE_UPDATE_DATE", true);
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 2, "AudioSession|[onDeviceChangabledUpdate]" + bl);
                    }
                    if (null == this.mCallback) return;
                    this.mCallback.onDeviceChangabledUpdate(bl);
                    return;
                } else if ("NOTIFY_STREAMTYPE_UPDATE".equals(string)) {
                    int n3 = intent.getIntExtra("EXTRA_DATA_STREAMTYPE", -1);
                    if (0 != n2 && QLog.isColorLevel()) {
                        QLog.w("TRAE", 2, "AudioSession|[onStreamTypeUpdate] err:" + n2 + " st:" + n3);
                    }
                    if (null == this.mCallback) return;
                    this.mCallback.onStreamTypeUpdate(n3);
                    return;
                } else if ("NOTIFY_ROUTESWITCHSTART".equals(string)) {
                    String string6 = intent.getStringExtra("EXTRA_DATA_ROUTESWITCHSTART_FROM");
                    String string7 = intent.getStringExtra("EXTRA_DATA_ROUTESWITCHSTART_TO");
                    if (null == this.mCallback || string6 == null || string7 == null) return;
                    this.mCallback.onAudioRouteSwitchStart(string6, string7);
                    return;
                } else {
                    if (!"NOTIFY_ROUTESWITCHEND".equals(string)) return;
                    String string8 = intent.getStringExtra("EXTRA_DATA_ROUTESWITCHEND_DEV");
                    long l3 = intent.getLongExtra("EXTRA_DATA_ROUTESWITCHEND_TIME", -1L);
                    if (null == this.mCallback || string8 == null || l3 == -1L) return;
                    this.mCallback.onAudioRouteSwitchEnd(string8, l3);
                }
                return;
            } else {
                if (!"com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_RES".equals(intent.getAction())) return;
                if (this.mSessionId != l2) {
                    return;
                }
                if ("OPERATION_GETDEVICELIST".equals(string)) {
                    String[] stringArray = intent.getStringArrayExtra("EXTRA_DATA_AVAILABLEDEVICE_LIST");
                    String string9 = intent.getStringExtra("EXTRA_DATA_CONNECTEDDEVICE");
                    String string10 = intent.getStringExtra("EXTRA_DATA_PREV_CONNECTEDDEVICE");
                    String string11 = intent.getStringExtra("EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME");
                    String string12 = "\n";
                    boolean bl = true;
                    for (int i3 = 0; i3 < stringArray.length; ++i3) {
                        string12 = string12 + "AudioSession|    " + i3 + " " + stringArray[i3] + "\n";
                        if (!stringArray[i3].equals("DEVICE_WIREDHEADSET") && !stringArray[i3].equals("DEVICE_BLUETOOTHHEADSET")) continue;
                        bl = false;
                    }
                    string12 = string12 + "\n";
                    this._canSwtich2Earphone = bl;
                    this._connectedDev = string9;
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 2, "AudioSession|[onGetDeviceListRes] err:" + n2 + " connected:" + string9 + " prevConnected:" + string10 + " bt:" + string11 + " Num:" + stringArray.length + string12);
                    }
                    if (null == this.mCallback) return;
                    this.mCallback.onGetDeviceListRes(n2, stringArray, string9, string10, string11);
                    return;
                } else if ("OPERATION_CONNECTDEVICE".equals(string)) {
                    String string13 = intent.getStringExtra("CONNECTDEVICE_RESULT_DEVICENAME");
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 2, "AudioSession|[onConnectDeviceRes] err:" + n2 + " dev:" + string13);
                    }
                    if (null == this.mCallback) return;
                    this.mCallback.onConnectDeviceRes(n2, string13, n2 == 0);
                    return;
                } else {
                    if ("OPERATION_EARACTION".equals(string)) {
                        int n4 = intent.getIntExtra("EXTRA_EARACTION", -1);
                        if (QLog.isColorLevel()) {
                            QLog.w("TRAE", 2, "AudioSession|[onConnectDeviceRes] err:" + n2 + " earAction:" + n4);
                        }
                        if (null == this.mCallback) return;
                    }
                    if ("OPERATION_ISDEVICECHANGABLED".equals(string)) {
                        boolean bl = intent.getBooleanExtra("ISDEVICECHANGABLED_REULT_ISCHANGABLED", false);
                        if (QLog.isColorLevel()) {
                            QLog.w("TRAE", 2, "AudioSession|[onIsDeviceChangabledRes] err:" + n2 + " Changabled:" + (bl ? "Y" : "N"));
                        }
                        if (null == this.mCallback) return;
                        this.mCallback.onIsDeviceChangabledRes(n2, bl);
                        return;
                    } else if ("OPERATION_GETCONNECTEDDEVICE".equals(string)) {
                        String string14 = intent.getStringExtra("GETCONNECTEDDEVICE_REULT_LIST");
                        if (QLog.isColorLevel()) {
                            QLog.w("TRAE", 2, "AudioSession|[onGetConnectedDeviceRes] err:" + n2 + " dev:" + string14);
                        }
                        if (null == this.mCallback) return;
                        this.mCallback.onGetConnectedDeviceRes(n2, string14);
                        return;
                    } else if ("OPERATION_GETCONNECTINGDEVICE".equals(string)) {
                        String string15 = intent.getStringExtra("GETCONNECTINGDEVICE_REULT_LIST");
                        if (QLog.isColorLevel()) {
                            QLog.w("TRAE", 2, "AudioSession|[onGetConnectingDeviceRes] err:" + n2 + " dev:" + string15);
                        }
                        if (null == this.mCallback) return;
                        this.mCallback.onGetConnectingDeviceRes(n2, string15);
                        return;
                    } else if ("OPERATION_GETSTREAMTYPE".equals(string)) {
                        int n5 = intent.getIntExtra("EXTRA_DATA_STREAMTYPE", -1);
                        if (QLog.isColorLevel()) {
                            QLog.w("TRAE", 2, "AudioSession|[onGetStreamTypeRes] err:" + n2 + " st:" + n5);
                        }
                        if (null == this.mCallback) return;
                        this.mCallback.onGetStreamTypeRes(n2, n5);
                        return;
                    } else if ("NOTIFY_RING_COMPLETION".equals(string)) {
                        String string16 = intent.getStringExtra("PARAM_RING_USERDATA_STRING");
                        if (QLog.isColorLevel()) {
                            QLog.w("TRAE", 2, "AudioSession|[onRingCompletion] err:" + n2 + " userData:" + string16);
                        }
                        if (null == this.mCallback) return;
                        this.mCallback.onRingCompletion(n2, string16);
                        return;
                    } else {
                        if (!"OPERATION_VOICECALL_PREPROCESS".equals(string)) return;
                        if (QLog.isColorLevel()) {
                            QLog.w("TRAE", 2, "AudioSession|[onVoicecallPreprocess] err:" + n2);
                        }
                        if (null == this.mCallback) return;
                        this.mCallback.onVoicecallPreprocessRes(n2);
                    }
                }
            }
            return;
        }
        catch (Exception exception) {
            if (!QLog.isColorLevel()) return;
            QLog.e("TRAE", 2, "AudioSession| nSessinId = " + this.mSessionId + " onReceive::intent:" + intent.toString() + " intent.getAction():" + intent.getAction() + " Exception:" + exception.getMessage());
        }
    }

    public static interface ITraeAudioCallback {
        public void onServiceStateUpdate(boolean var1);

        public void onDeviceListUpdate(String[] var1, String var2, String var3, String var4);

        public void onDeviceChangabledUpdate(boolean var1);

        public void onStreamTypeUpdate(int var1);

        public void onGetDeviceListRes(int var1, String[] var2, String var3, String var4, String var5);

        public void onConnectDeviceRes(int var1, String var2, boolean var3);

        public void onIsDeviceChangabledRes(int var1, boolean var2);

        public void onGetConnectedDeviceRes(int var1, String var2);

        public void onGetConnectingDeviceRes(int var1, String var2);

        public void onGetStreamTypeRes(int var1, int var2);

        public void onRingCompletion(int var1, String var2);

        public void onVoicecallPreprocessRes(int var1);

        public void onAudioRouteSwitchStart(String var1, String var2);

        public void onAudioRouteSwitchEnd(String var1, long var2);
    }
}

