/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.audio.TXAudioEffectManagerImpl;
import com.tencent.liteav.audio.TXCAudioEncoderConfig;
import com.tencent.liteav.audio.TXCAudioSettings;
import com.tencent.liteav.audio.d;
import com.tencent.liteav.audio.e;
import com.tencent.liteav.audio.f;
import com.tencent.liteav.audio.g;
import com.tencent.liteav.audio.impl.Play.TXCMultAudioTrackPlayer;
import com.tencent.liteav.audio.impl.Record.TXCAudioSysRecord;
import com.tencent.liteav.audio.impl.TXCAudioEngineJNI;
import com.tencent.liteav.audio.impl.a;
import com.tencent.liteav.audio.impl.b;
import com.tencent.liteav.audio.impl.earmonitor.HuaweiAudioKit;
import com.tencent.liteav.audio.impl.earmonitor.TXSystemAudioKit;
import com.tencent.liteav.basic.c.c;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.module.StatusBucket;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class TXCAudioEngine
implements b,
com.tencent.liteav.audio.impl.earmonitor.a {
    private static final String TAG = "AudioEngine :TXCAudioEngine_java";
    private static final int EVT_AUDIO_DEVICE_ROLLBACK_TO_STABLE_SAMPLERATE = 10055;
    private static final int EVT_AUDIO_DEVICE_RESTART_WHEN_USING_STABLE_SAMPLERATE = 10056;
    private static final long SYSTEM_AUDIO_KIT_RESTART_INTERVAL = TimeUnit.SECONDS.toMillis(2L);
    static TXCAudioEngine sInstance = new TXCAudioEngine();
    private final ArrayList<WeakReference<com.tencent.liteav.basic.b.a>> mCallbackList = new ArrayList();
    private TXSystemAudioKit mAudioKit;
    protected boolean mDeviceIsRecording = false;
    protected boolean mIsCustomRecord = false;
    protected static Context mContext = null;
    private static boolean has_trae = false;
    private static WeakReference<f> mAudioCoreDataListener = null;
    protected static final HashMap<String, WeakReference<f>> mJitterDataListenerMap = new HashMap();
    private static final Object mJitterDataListenerMapLock = new Object();
    protected static final HashMap<String, WeakReference<d>> mJitterEventListenerMap = new HashMap();
    private static final Object mJitterEventListenerMapLock = new Object();
    private static volatile boolean has_init = false;
    private final Object mStartStopRemoteAudioMutex = new Object();
    protected boolean mIsCallComed = false;

    public static TXCAudioEngine getInstance() {
        return sInstance;
    }

    private TXCAudioEngine() {
    }

    public static synchronized void CreateInstance(Context context, String traeConfig, boolean enableAudioDeviceDSP) {
        TXCAudioEngine.CreateInstanceWithoutInitDevice(context, traeConfig, enableAudioDeviceDSP);
        TXCAudioEngineJNI.nativeInitAudioDevice();
    }

    public static synchronized void CreateInstanceWithoutInitDevice(Context context, String traeConfig, boolean enableAudioDeviceDSP) {
        TXCLog.i(TAG, "CreateInstance: ");
        mContext = context.getApplicationContext();
        if (has_init) {
            TXCLog.i(TAG, "CreateInstance already created~ ");
            return;
        }
        if (TXCAudioEngineJNI.nativeCheckTraeEngine(context)) {
            has_trae = true;
        }
        TXCAudioEngineJNI.nativeUseSysAudioDevice(!has_trae);
        TXCAudioEngineJNI.nativeSetAudioDeviceDSPEnabled(enableAudioDeviceDSP);
        if (has_trae) {
            TXCAudioEngineJNI.InitTraeEngineLibrary(context);
            TXCAudioEngineJNI.nativeSetAudioCompatibleConfig(traeConfig);
            TXCAudioEngineJNI.nativeInitBeforeEngineCreate(context, TXCAudioEngine.getAudioResourceDirectory(mContext));
            a.a().a(context.getApplicationContext());
            a.a().a(sInstance);
            if (!enableAudioDeviceDSP) {
                TXCAudioEngineJNI.nativeNewAudioSessionDuplicate(mContext);
            }
        } else {
            TXCMultAudioTrackPlayer.getInstance();
            TXCAudioSysRecord.getInstance();
        }
        has_init = true;
    }

    public static boolean hasTrae() {
        return has_trae;
    }

    public static synchronized void UninitInstance() {
        TXCLog.i(TAG, "uninit audio engine instance");
        TXCAudioEngineJNI.nativeUninitAudioDevice();
        has_init = false;
    }

    public static boolean enableAudioVolumeEvaluation(boolean enable, int interval) {
        TXCLog.i(TAG, "enableAudioVolumeEvaluation : " + enable + "interval:" + interval);
        TXCAudioEngineJNI.nativeEnableAudioVolumeEvaluation(enable, interval);
        return true;
    }

    public Context getAppContext() {
        return mContext;
    }

    public void setAudioQuality(int quality, int priority) {
        TXCAudioEngineJNI.nativeSetAudioQuality(quality, priority);
    }

    public void setAudioQuality(int sampleRate, int channel, int bitrate, int encodeMode, int systemVolumeType, int priority) {
        TXCAudioEngineJNI.nativeSetAudioQualityEx(sampleRate, channel, bitrate, encodeMode, systemVolumeType, priority);
    }

    public void setEncoderSampleRate(int sampleRate) {
        TXCAudioEngineJNI.nativeSetEncoderSampleRate(sampleRate);
    }

    public void setEncoderChannels(int channels) {
        TXCAudioEngineJNI.nativeSetEncoderChannels(channels);
    }

    public int getEncoderSampleRate() {
        return TXCAudioEngineJNI.nativeGetEncoderSampleRate();
    }

    public int getEncoderChannels() {
        return TXCAudioEngineJNI.nativeGetEncoderChannels();
    }

    public TXCAudioEncoderConfig getAudioEncoderConfig() {
        return TXCAudioEngineJNI.nativeGetEncoderConfig();
    }

    public int startLocalAudio(int audioFormat, boolean enableCustomCapture) {
        TXCLog.i(TAG, "startLocalAudio audioFormat:" + audioFormat);
        if (mContext == null) {
            TXCLog.i(TAG, "Please call CreateInstance fisrt!!!");
            return -901;
        }
        TXCAudioEngineJNI.InitTraeEngineLibrary(mContext);
        TXCAudioEngineJNI.nativeStartLocalAudio(audioFormat, enableCustomCapture);
        this.mDeviceIsRecording = true;
        return 0;
    }

    public int stopLocalAudio() {
        TXCLog.i(TAG, "stopLocalAudio");
        TXCAudioEngineJNI.nativeStopLocalAudio();
        this.mDeviceIsRecording = false;
        return 0;
    }

    public void pauseLocalAudio() {
        TXCAudioEngineJNI.nativePauseLocalAudio();
    }

    public void resumeLocalAudio() {
        TXCAudioEngineJNI.nativeResumeLocalAudio();
    }

    public void EnableMixMode(boolean enable) {
        TXCAudioEngineJNI.nativeEnableMixMode(enable);
    }

    public void enableEncodedDataPackWithTRAEHeaderCallback(boolean enable) {
        TXCAudioEngineJNI.nativeEnableEncodedDataPackWithTRAEHeaderCallback(enable);
    }

    public void enableEncodedDataCallback(boolean enable) {
        TXCAudioEngineJNI.nativeEnableEncodedDataCallback(enable);
    }

    public int pauseAudioCapture(boolean bSendMuteData) {
        TXCLog.i(TAG, "pauseAudioCapture: " + bSendMuteData);
        TXCAudioEngineJNI.pauseAudioCapture(bSendMuteData);
        return 0;
    }

    public int resumeAudioCapture() {
        TXCLog.i(TAG, "resumeRecord");
        TXCAudioEngineJNI.resumeAudioCapture();
        return 0;
    }

    public void setAudioFrameExtraData(byte[] extraData) {
        TXCAudioEngineJNI.nativeSetAudioFrameExtraData(extraData);
    }

    public void sendCustomPCMData(byte[] pcmBuffer, int samplerate, int channels) {
        TXCAudioEngineJNI.sendCustomPCMData(pcmBuffer, samplerate, channels);
    }

    public void sendCustomPCMData(com.tencent.liteav.basic.structs.a packet) {
        TXCAudioEngineJNI.sendCustomPCMData(packet);
    }

    public boolean setAudioCaptureDataListener(g listener) {
        TXCLog.i(TAG, "setRecordListener ");
        if (listener == null) {
            TXCAudioEngineJNI.setAudioCaptureDataListener(null);
        } else {
            TXCAudioEngineJNI.setAudioCaptureDataListener(new WeakReference<g>(listener));
        }
        return true;
    }

    public boolean muteLocalAudio(boolean isMute) {
        TXCLog.i(TAG, "setRecordMute: " + isMute);
        TXCAudioEngineJNI.nativeMuteLocalAudio(isMute);
        return true;
    }

    public boolean setReverbType(int reverbType) {
        TXCAudioEngineJNI.nativeSetRecordReverb(reverbType);
        return true;
    }

    public boolean setReverbParamType(int reverbParamType, float value) {
        TXCLog.i(TAG, "setReverbParamType: reverbParamType =" + reverbParamType + " value = " + value);
        TXCAudioEngineJNI.nativeSetRecordReverbParam(reverbParamType, value);
        return true;
    }

    public boolean setVoicePitch(double pitch) {
        TXCLog.i(TAG, "setVoicePitch: " + pitch);
        TXCAudioEngineJNI.nativeSetVoicePitch(pitch);
        return true;
    }

    public boolean setVoiceChangerType(TXAudioEffectManager.TXVoiceChangerType type) {
        TXCLog.i(TAG, "setVoiceChangerType " + type.getNativeValue());
        TXCAudioEngineJNI.nativeSetCaptureVoiceChanger(type.getNativeValue());
        return true;
    }

    public boolean setCaptureEqualizationType(int type) {
        TXCLog.i(TAG, "setCaptureEqualizationType " + type);
        TXCAudioEngineJNI.nativeSetCaptureEqualizationType(type);
        return true;
    }

    public boolean setCaptureEqualizationParam(int bandIndex, int bandGain) {
        TXCLog.i(TAG, "setCaptureEqualizationParam: bandIndex =" + bandIndex + " bandGain = " + bandGain);
        TXCAudioEngineJNI.nativeSetCaptureEqualizationParam(bandIndex, bandGain);
        return true;
    }

    public boolean setSoftwareCaptureVolume(float volume) {
        TXCLog.i(TAG, "setRecordVolume: " + volume);
        TXCAudioEngineJNI.nativeSetSoftwareCaptureVolume(volume);
        return true;
    }

    public boolean setMixingPlayoutVolume(float volume) {
        TXCLog.i(TAG, "setPlayoutVolume: " + volume);
        TXCAudioEngineJNI.nativeSetMixingPlayoutVolume(volume);
        return true;
    }

    public void enableSoftAEC(boolean enable, int level) {
        TXCLog.i(TAG, "enableSoftAEC: enable = " + enable + " level = " + level);
        if (!enable) {
            level = 0;
        }
        TXCAudioEngineJNI.nativeSetSoftAEC(level);
    }

    public void enableSoftANS(boolean enable, int level) {
        TXCLog.i(TAG, "enableSoftANS: enable = " + enable + " level = " + level);
        if (!enable) {
            level = 0;
        }
        TXCAudioEngineJNI.nativeSetSoftANS(level);
    }

    public void enableSoftAGC(boolean enable, int level) {
        TXCLog.i(TAG, "enableSoftAGC: enable = " + enable + " level = " + level);
        if (!enable) {
            level = 0;
        }
        TXCAudioEngineJNI.nativeSetSoftAGC(level);
    }

    public boolean setEncoderFECPercent(float fecRatio) {
        TXCAudioEngineJNI.nativeSetEncoderFECPercent(fecRatio);
        return true;
    }

    public boolean setAudioEncoderParam(int frameLenMs, int bitRate) {
        TXCAudioEngineJNI.nativeSetAudioEncoderParam(frameLenMs, bitRate);
        return true;
    }

    public boolean enableCaptureEOSMode(boolean enable) {
        TXCLog.i(TAG, "enableEosMode " + enable);
        TXCAudioEngineJNI.nativeEnableCaptureEOSMode(enable);
        return true;
    }

    public boolean isAudioDeviceCapturing() {
        boolean bl = TXCAudioEngineJNI.nativeIsAudioDeviceCapturing();
        TXCLog.i(TAG, "isRecording: " + bl);
        return bl;
    }

    public int getAECType() {
        return 2;
    }

    public int getSoftwareCaptureVolumeLevel() {
        return TXCAudioEngineJNI.nativeGetSoftwareCaptureVolumeLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRemoteAudio(String ID, boolean isRealTime) {
        Object object = this.mStartStopRemoteAudioMutex;
        synchronized (object) {
            TXCAudioEngineJNI.nativeStartRemoteAudio(sInstance, isRealTime, ID);
        }
        TXCAudioEngineJNI.nativeSetRemoteAudioJitterCycle(ID, c.a().a("Audio", "LIVE_JitterCycle"));
        TXCAudioEngineJNI.nativeSetRemoteAudioBlockThreshold(ID, c.a().a("Audio", "LoadingThreshold"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRemoteAudio(String ID) {
        if (ID == null) {
            return;
        }
        Object object = this.mStartStopRemoteAudioMutex;
        synchronized (object) {
            TXCAudioEngineJNI.nativeStopRemoteAudio(ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSetAudioEngineRemoteStreamDataListener(String ID, f listener) {
        if (ID == null) {
            return;
        }
        Object object = mJitterDataListenerMapLock;
        synchronized (object) {
            mJitterDataListenerMap.put(ID, new WeakReference<f>(listener));
        }
        TXCAudioEngineJNI.nativeSetAudioEngineRemoteStreamDataListener(ID, null != listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onAudioPlayPcmData(String jitterbuffer_id, byte[] data, long timestamp, int sampleRate, int channels, byte[] extraData) {
        f f2 = null;
        Object object = mJitterDataListenerMapLock;
        synchronized (object) {
            if (null != mJitterDataListenerMap.get(jitterbuffer_id)) {
                f2 = (f)mJitterDataListenerMap.get(jitterbuffer_id).get();
            }
        }
        if (null != f2) {
            f2.onAudioPlayPcmData(jitterbuffer_id, data, timestamp, sampleRate, channels, extraData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteAudioStreamEventListener(String ID, d listener) {
        if (ID == null) {
            return;
        }
        Object object = mJitterEventListenerMapLock;
        synchronized (object) {
            mJitterEventListenerMap.put(ID, new WeakReference<d>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onAudioJitterBufferNotify(String ID, int notifyNo, String notifyInfo) {
        d d2 = null;
        Object object = mJitterEventListenerMapLock;
        synchronized (object) {
            if (null != mJitterEventListenerMap.get(ID)) {
                d2 = (d)mJitterEventListenerMap.get(ID).get();
            }
        }
        if (d2 != null) {
            TXCLog.i(TAG, "onAudioJitterBufferNotify  cur state " + notifyNo);
            d2.onAudioJitterBufferNotify(ID, notifyNo, notifyInfo);
        }
    }

    public void setRemoteAudioCacheParams(String ID, boolean force_loading, int target_cache_duration, int min_cache_duration, int max_cache_duration) {
        TXCAudioEngineJNI.nativeSetRemoteAudioCacheParams(ID, force_loading, target_cache_duration, min_cache_duration, max_cache_duration);
    }

    public void muteRemoteAudio(String ID, boolean mute) {
        if (ID == null) {
            return;
        }
        TXCAudioEngineJNI.nativeMuteRemoteAudio(ID, mute);
    }

    public void muteRemoteAudioInSpeaker(String ID, boolean mute) {
        if (ID == null) {
            return;
        }
        TXCAudioEngineJNI.nativeMuteRemoteAudioInSpeaker(ID, mute);
    }

    public void setRemotePlayoutVolume(String ID, int volume) {
        if (ID == null) {
            return;
        }
        TXCAudioEngineJNI.nativeSetRemotePlayoutVolume(ID, volume);
    }

    public boolean isRemoteAudioPlaying(String ID) {
        if (ID == null) {
            return false;
        }
        return TXCAudioEngineJNI.nativeIsRemoteAudioPlaying(ID);
    }

    public int getRemotePlayoutVolumeLevel(String ID) {
        if (ID == null) {
            return 0;
        }
        return TXCAudioEngineJNI.nativeGetRemotePlayoutVolumeLevel(ID);
    }

    public int getPlaySampleRate() {
        return 48000;
    }

    public int getPlayChannels() {
        return 2;
    }

    public int getPlayAECType() {
        if (has_trae) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventCallback(WeakReference<com.tencent.liteav.basic.b.a> callback) {
        if (callback == null) {
            return;
        }
        ArrayList<WeakReference<com.tencent.liteav.basic.b.a>> arrayList = this.mCallbackList;
        synchronized (arrayList) {
            this.mCallbackList.add(callback);
            TXCAudioEngineJNI.nativeSetEventCallbackEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(String id, int code, String msg, String params) {
        this.handleAudioEvent(id, code, msg, params);
        ArrayList<com.tencent.liteav.basic.b.a> arrayList = new ArrayList<com.tencent.liteav.basic.b.a>();
        ArrayList<WeakReference<com.tencent.liteav.basic.b.a>> arrayList2 = this.mCallbackList;
        synchronized (arrayList2) {
            if (this.mCallbackList.size() <= 0) {
                return;
            }
            Iterator<WeakReference<com.tencent.liteav.basic.b.a>> object = this.mCallbackList.iterator();
            while (object.hasNext()) {
                WeakReference<com.tencent.liteav.basic.b.a> weakReference = object.next();
                com.tencent.liteav.basic.b.a a2 = (com.tencent.liteav.basic.b.a)weakReference.get();
                if (a2 != null) {
                    arrayList.add(a2);
                    continue;
                }
                object.remove();
            }
            if (this.mCallbackList.size() <= 0) {
                TXCAudioEngineJNI.nativeSetEventCallbackEnabled(false);
            }
        }
        for (com.tencent.liteav.basic.b.a a3 : arrayList) {
            a3.onEvent(id, code, msg, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWarning(String id, int code, String msg, String params) {
        this.handleAudioEvent(id, code, msg, params);
        ArrayList<com.tencent.liteav.basic.b.a> arrayList = new ArrayList<com.tencent.liteav.basic.b.a>();
        ArrayList<WeakReference<com.tencent.liteav.basic.b.a>> arrayList2 = this.mCallbackList;
        synchronized (arrayList2) {
            if (this.mCallbackList.size() <= 0) {
                return;
            }
            Iterator<WeakReference<com.tencent.liteav.basic.b.a>> object = this.mCallbackList.iterator();
            while (object.hasNext()) {
                WeakReference<com.tencent.liteav.basic.b.a> weakReference = object.next();
                com.tencent.liteav.basic.b.a a2 = (com.tencent.liteav.basic.b.a)weakReference.get();
                if (a2 != null) {
                    arrayList.add(a2);
                    continue;
                }
                object.remove();
            }
            if (this.mCallbackList.size() <= 0) {
                TXCAudioEngineJNI.nativeSetEventCallbackEnabled(false);
            }
        }
        for (com.tencent.liteav.basic.b.a a3 : arrayList) {
            a3.onWarning(id, code, msg, params);
        }
    }

    private void handleAudioEvent(String id, int code, String msg, String params) {
        if (code == 10055) {
            TXCAudioSettings.getInstance().setLong("timestamp_rollback_to_stable_samplerate", System.currentTimeMillis());
        } else if (code == 10056) {
            TXCAudioSettings.getInstance().setLong("timestamp_rollback_to_stable_samplerate", 0L);
            TXCLog.i(TAG, "audio device restart when using stable samplerate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(String id, int code, String msg, String params) {
        ArrayList<com.tencent.liteav.basic.b.a> arrayList = new ArrayList<com.tencent.liteav.basic.b.a>();
        ArrayList<WeakReference<com.tencent.liteav.basic.b.a>> arrayList2 = this.mCallbackList;
        synchronized (arrayList2) {
            if (this.mCallbackList.size() <= 0) {
                return;
            }
            Iterator<WeakReference<com.tencent.liteav.basic.b.a>> object = this.mCallbackList.iterator();
            while (object.hasNext()) {
                WeakReference<com.tencent.liteav.basic.b.a> weakReference = object.next();
                com.tencent.liteav.basic.b.a a2 = (com.tencent.liteav.basic.b.a)weakReference.get();
                if (a2 != null) {
                    arrayList.add(a2);
                    continue;
                }
                object.remove();
            }
            if (this.mCallbackList.size() <= 0) {
                TXCAudioEngineJNI.nativeSetEventCallbackEnabled(false);
            }
        }
        for (com.tencent.liteav.basic.b.a a3 : arrayList) {
            a3.onError(id, code, msg, params);
        }
    }

    public static void setPlayoutDataListener(f listener) {
        mAudioCoreDataListener = new WeakReference<f>(listener);
        TXCAudioEngineJNI.nativeSetPlayoutDataListener(null != listener);
    }

    public static void onCorePlayPcmData(byte[] data, long timestamp, int sampleRate, int channels) {
        f f2;
        if (mAudioCoreDataListener != null && (f2 = (f)mAudioCoreDataListener.get()) != null) {
            f2.onAudioPlayPcmData(null, data, timestamp, sampleRate, channels, null);
        }
    }

    public static int getMixingPlayoutVolumeLevel() {
        return TXCAudioEngineJNI.nativeGetMixingPlayoutVolumeLevel();
    }

    public StatusBucket getStatus(int periodTime) {
        return TXCAudioEngineJNI.getStatus(periodTime);
    }

    public static void setAudioRoute(int mode) {
        TXCLog.i(TAG, "setAudioRoute: " + mode);
        TXCAudioEngineJNI.nativeSetAudioRoute(mode);
    }

    public static void setSystemVolumeType(int volumeType) {
        TXCLog.i(TAG, "setSystemVolumeType: " + volumeType);
        TXCAudioEngineJNI.nativeSetSystemVolumeType(volumeType);
    }

    public static void enableAudioEarMonitoring(boolean enable) {
        TXCLog.i(TAG, "enableAudioEarMonitoring: " + enable);
        TXCAudioEngineJNI.nativeEnableAudioEarMonitoring(enable);
    }

    public static void setAudioEarMonitoringVolume(int volume) {
        TXCLog.i(TAG, "setAudioEarMonitoringVolume: " + volume);
        TXCAudioEngineJNI.nativeSetAudioEarMonitoringVolume(volume);
    }

    public int startLocalAudioDumping(int sampleRate, int bitsPerChannel, int contentType, String filePath) {
        return TXCAudioEngineJNI.nativeStartLocalAudioDumping(sampleRate, bitsPerChannel, contentType, filePath);
    }

    public void stopLocalAudioDumping() {
        TXCAudioEngineJNI.nativeStopLocalAudioDumping();
    }

    public void setAudioDumpingListener(TXCAudioEngineJNI.a listener) {
        TXCAudioEngineJNI.SetAudioDumpingListener(listener);
    }

    public void setCaptureDataCallbackFormat(int sampleRate, int channels, int lengthInSample) {
        TXCLog.i(TAG, "setCaptureDataCallbackFormat: sampleRate-" + sampleRate + " channels-" + channels + " length-" + lengthInSample);
        TXCAudioEngineJNI.nativeSetCaptureDataCallbackFormat(sampleRate, channels, lengthInSample);
    }

    public void setLocalProcessedDataCallbackFormat(int sampleRate, int channels, int lengthInSample) {
        TXCLog.i(TAG, "setLocalProcessedDataCallbackFormat: sampleRate-" + sampleRate + " channels-" + channels + " length-" + lengthInSample);
        TXCAudioEngineJNI.nativeSetLocalProcessedDataCallbackFormat(sampleRate, channels, lengthInSample);
    }

    public void setPlayoutDataCallbackFormat(int sampleRate, int channels, int lengthInSample) {
        TXCLog.i(TAG, "setPlayoutDataCallbackFormat: sampleRate-" + sampleRate + " channels-" + channels + " length-" + lengthInSample);
        TXCAudioEngineJNI.nativeSetPlayoutDataCallbackFormat(sampleRate, channels, lengthInSample);
    }

    public void setRemoteStreamDataCallbackFormat(String id, int sampleRate, int channels, int lengthInSample) {
        TXCLog.i(TAG, "setRemoteStreamDataCallbackFormat: id-" + id + " sampleRate-" + sampleRate + " channels-" + channels + " length-" + lengthInSample);
        TXCAudioEngineJNI.nativeSetRemoteStreamDataCallbackFormat(id, sampleRate, channels, lengthInSample);
    }

    public boolean IsDataCallbackFormatInvalid(int sampleRate, int channels, int lengthInSample) {
        return TXCAudioEngineJNI.nativeIsDataCallbackFormatInvalid(sampleRate, channels, lengthInSample);
    }

    public void clean() {
        TXCAudioEngineJNI.nativeClean();
    }

    public void forceCallbackMixedPlayAudioFrame(boolean enable) {
        TXCAudioEngineJNI.nativeForceCallbackMixedPlayAudioFrame(enable);
    }

    public void SetAudioCacheParams(int min_cache_time, int max_cache_time) {
        TXCAudioEngineJNI.nativeSetAudioCacheParams(min_cache_time, max_cache_time);
    }

    @Override
    public void onCallStateChanged(int state) {
        switch (state) {
            case 1: {
                TXCLog.i(TAG, "TelephonyManager.CALL_STATE_RINGING!");
                break;
            }
            case 2: {
                TXCLog.i(TAG, "TelephonyManager.CALL_STATE_OFFHOOK!");
                TXCAudioEngineJNI.pauseAudioCapture(true);
                TXAudioEffectManagerImpl.getInstance().interruptAllMusics();
                TXAudioEffectManagerImpl.getCacheInstance().interruptAllMusics();
                TXAudioEffectManagerImpl.getAutoCacheHolder().interruptAllMusics();
                this.mIsCallComed = true;
                break;
            }
            case 0: {
                TXCLog.i(TAG, "TelephonyManager.CALL_STATE_IDLE!");
                if (!this.mIsCallComed) break;
                this.mIsCallComed = false;
                TXCAudioEngineJNI.resumeAudioCapture();
                TXAudioEffectManagerImpl.getInstance().recoverAllMusics();
                TXAudioEffectManagerImpl.getCacheInstance().recoverAllMusics();
                TXAudioEffectManagerImpl.getAutoCacheHolder().recoverAllMusics();
            }
        }
    }

    public void enableAutoRestartDevice(boolean enable) {
        TXCAudioEngineJNI.nativeEnableAutoRestartDevice(enable);
    }

    public void enableInbandFEC(boolean enable) {
        TXCAudioEngineJNI.nativeEnableInbandFEC(enable);
    }

    public void setMaxSelectedPlayStreams(int maxStreams) {
        TXCAudioEngineJNI.nativeSetMaxSelectedPlayStreams(maxStreams);
    }

    public void setMixedAllDataListener(e listener) {
        TXCAudioEngineJNI.setMixedAllDataListener(listener);
    }

    public void enableDeviceAbnormalDetection(boolean enable) {
        TXCAudioEngineJNI.nativeEnableDeviceAbnormalDetection(enable);
    }

    public void setLocalAudioMuteAction(int enableVolumeEvaluation, int enableMuteCapturedAudioFrameAfterCallback) {
        TXCAudioEngineJNI.nativeSetLocalAudioMuteAction(enableVolumeEvaluation, enableMuteCapturedAudioFrameAfterCallback);
    }

    public static String buildTRAEConfig(Context context, Boolean enableOpenSL, boolean useLowLatencySampleRate, long lowLatencySampleRateBlockTime) {
        String string = "";
        string = string + "sharp {\n";
        string = string + "  os android\n";
        string = string + "  trae {\n";
        string = string + "    dev {\n";
        string = string + "        intf 2\n";
        if (enableOpenSL != null) {
            string = string + "  closeOpensl " + (enableOpenSL != false ? "n" : "y") + "\n";
        }
        long l2 = TXCAudioSettings.getInstance().getLong("timestamp_rollback_to_stable_samplerate", 0L);
        boolean bl = System.currentTimeMillis() - l2 < lowLatencySampleRateBlockTime;
        TXCLog.i(TAG, "low latency samplerate, enable: %b, isBlocked: %b, blockTime: %d", useLowLatencySampleRate, bl, lowLatencySampleRateBlockTime);
        if (!bl && useLowLatencySampleRate && TXCAudioEngine.getLowLatencySampleRate(context) == 48000) {
            string = string + "  traemodes 1|2\n";
            string = string + "  cap {\n";
            string = string + "    hw_sr 48000\n";
            string = string + "  }\n";
            string = string + "  play {\n";
            string = string + "    hw_sr 48000\n";
            string = string + "  }";
        }
        string = string + "    }\n";
        string = string + "  }\n";
        string = string + "}";
        return string;
    }

    private static int getLowLatencySampleRate(Context context) {
        AudioManager audioManager;
        if (Build.VERSION.SDK_INT >= 17 && (audioManager = (AudioManager)context.getSystemService("audio")) != null) {
            try {
                return Integer.parseInt(audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE"));
            }
            catch (NumberFormatException numberFormatException) {
                TXCLog.e(TAG, "can't parse low latency samplerate", numberFormatException);
            }
        }
        return -1;
    }

    public void setSystemAudioKitEnabled() {
        this.startSystemAudioKit();
    }

    private void startSystemAudioKit() {
        if (this.mAudioKit != null || mContext == null) {
            return;
        }
        this.mAudioKit = this.createManufacturerAudioKit(mContext);
        if (this.mAudioKit != null) {
            TXCAudioEngineJNI.nativeNotifySystemEarMonitoringInitializing();
            this.mAudioKit.initialize(mContext, this);
        } else {
            TXCAudioEngineJNI.nativeSetSystemEarMonitoring(null);
        }
    }

    @Override
    public void onAudioKitInitFinished(TXSystemAudioKit audioKit, boolean success) {
        if (this.mAudioKit != audioKit) {
            return;
        }
        TXCLog.i(TAG, "system audio kit init finished, ret: %b.", success);
        if (!success) {
            TXCAudioEngineJNI.nativeSetSystemEarMonitoring(null);
        }
    }

    @Override
    public void onEarMonitoringInitialized(TXSystemAudioKit audioKit, boolean success) {
        if (this.mAudioKit != audioKit) {
            return;
        }
        TXCLog.i(TAG, "onEarMonitoringInitialized result: %b", success);
        if (success) {
            TXCAudioEngineJNI.nativeSetSystemEarMonitoring(this.mAudioKit);
        } else {
            TXCAudioEngineJNI.nativeSetSystemEarMonitoring(null);
        }
    }

    @Override
    public void onAudioKitError(TXSystemAudioKit audioKit) {
        if (this.mAudioKit != audioKit) {
            return;
        }
        TXCLog.i(TAG, "onAudioKitError");
        if (this.mAudioKit != null) {
            this.mAudioKit.stopSystemEarMonitoring();
            this.mAudioKit.uninitialize();
            this.mAudioKit = null;
        }
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                TXCAudioEngine.this.startSystemAudioKit();
            }
        }, SYSTEM_AUDIO_KIT_RESTART_INTERVAL);
    }

    private TXSystemAudioKit createManufacturerAudioKit(Context context) {
        String string = com.tencent.liteav.basic.util.f.c;
        if (string.equalsIgnoreCase("huawei")) {
            return new HuaweiAudioKit();
        }
        return null;
    }

    private static String getAudioResourceDirectory(Context context) {
        String string = context.getFilesDir().getAbsolutePath();
        String string2 = string + File.separator + "liteav" + File.separator + "audiores";
        boolean bl = new File(string2).mkdirs();
        if (bl) {
            TXCLog.e(TAG, "create audio resource directory failed.");
        }
        return string2;
    }
}

