/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.content.Context;
import com.tencent.liteav.audio.TXCAudioEngine;
import com.tencent.liteav.audio.g;
import com.tencent.liteav.audio.impl.Record.TXCAudioSysRecord;
import com.tencent.liteav.audio.impl.Record.a;
import com.tencent.liteav.audio.impl.Record.c;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.h;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class TXCAudioUGCRecorder
implements c {
    private static final String TAG = "AudioCenter:TXCAudioUGCRecorder";
    private final int AAC_SAMPLE_NUM = 1024;
    private WeakReference<g> mWeakRecordListener;
    protected AtomicInteger mSampleRate = new AtomicInteger(48000);
    protected int mChannels = 1;
    protected int mBits = 16;
    protected int mAACFrameLength = 1024 * this.mChannels * this.mBits / 8;
    protected int mReverbType = 0;
    protected int mVoiceChangerType = 0;
    protected int mAECType = 0;
    protected Context mContext;
    protected boolean mIsEarphoneOn = false;
    private long mLastPTS = 0L;
    private float mVolume = 1.0f;
    private a mBGMRecorder = null;
    private boolean mEnableBGMRecord = false;
    private int mShouldClearAACDataCnt = 0;
    private boolean mCurBGMRecordFlag = false;
    private AtomicReference<Float> mSpeedRate = new AtomicReference<Float>(Float.valueOf(1.0f));
    private boolean mIsRunning = false;
    private boolean mIsPause = false;
    private boolean mIsMute = false;
    private final List<byte[]> mEncodedAudioList = new ArrayList<byte[]>();
    private static final TXCAudioUGCRecorder INSTANCE;

    public static TXCAudioUGCRecorder getInstance() {
        return INSTANCE;
    }

    private TXCAudioUGCRecorder() {
        TXCAudioSysRecord.getInstance();
        this.nativeClassInit();
    }

    public int startRecord(Context context) {
        TXCLog.i(TAG, "startRecord");
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
        this.updateAudioEffector();
        TXCAudioSysRecord.getInstance().setAudioRecordListener(this);
        this.nativeStartAudioRecord(this.mSampleRate.get(), this.mChannels, this.mBits);
        this.mIsRunning = true;
        this.mLastPTS = 0L;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopRecord() {
        TXCLog.i(TAG, "stopRecord");
        TXCAudioSysRecord.getInstance().setAudioRecordListener(null);
        if (this.mBGMRecorder != null) {
            this.mBGMRecorder.a();
            this.mBGMRecorder = null;
        }
        this.nativeStopAudioRecord();
        this.nativeEnableMixMode(false);
        this.nativeSetVolume(1.0f);
        List<byte[]> list = this.mEncodedAudioList;
        synchronized (list) {
            this.mEncodedAudioList.clear();
        }
        this.mIsRunning = false;
        this.mLastPTS = 0L;
        this.mIsPause = false;
        this.mIsMute = false;
        this.mShouldClearAACDataCnt = 0;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        TXCLog.i(TAG, "pause");
        TXCAudioEngine.getInstance().pauseLocalAudio();
        List<byte[]> list = this.mEncodedAudioList;
        synchronized (list) {
            this.mIsPause = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        TXCLog.i(TAG, "resume");
        TXCAudioEngine.getInstance().resumeLocalAudio();
        List<byte[]> list = this.mEncodedAudioList;
        synchronized (list) {
            this.mIsPause = false;
        }
        this.nativeEnableMixMode(this.mEnableBGMRecord);
        if (this.mIsMute || this.mEnableBGMRecord) {
            this.nativeSetVolume(0.0f);
        } else {
            this.nativeSetVolume(this.mVolume);
        }
    }

    public synchronized void setListener(g listener) {
        this.mWeakRecordListener = null == listener ? null : new WeakReference<g>(listener);
    }

    public g getListener() {
        if (this.mWeakRecordListener != null) {
            return (g)this.mWeakRecordListener.get();
        }
        return null;
    }

    public void setChannels(int channels) {
        TXCLog.i(TAG, "setChannels: " + channels);
        this.mChannels = channels;
    }

    public int getChannels() {
        return this.mChannels;
    }

    public void setSampleRate(int sampleRate) {
        TXCLog.i(TAG, "setSampleRate: " + sampleRate);
        this.mSampleRate.set(sampleRate);
    }

    public int getSampleRate() {
        return this.mSampleRate.get();
    }

    public synchronized void setReverbType(int reverbType) {
        TXCLog.i(TAG, "setReverbType: " + reverbType);
        this.mReverbType = reverbType;
        this.nativeSetReverbType(reverbType);
    }

    public void setAECType(int type, Context context) {
        TXCLog.i(TAG, "setAECType: " + type);
        this.mAECType = type;
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
    }

    public int getAECType() {
        return this.mAECType;
    }

    public void setMute(boolean isMute) {
        TXCLog.i(TAG, "setMute: " + isMute);
        this.mIsMute = isMute;
        if (isMute) {
            this.nativeSetVolume(0.0f);
        } else {
            this.nativeSetVolume(this.mVolume);
        }
    }

    public void enableBGMRecord(boolean enable) {
        TXCLog.i(TAG, "enableBGMRecord: " + enable);
        if (this.mEnableBGMRecord != enable && !enable) {
            this.mShouldClearAACDataCnt = 2;
        }
        this.mEnableBGMRecord = enable;
        this.updateAudioEffector();
    }

    public boolean isRecording() {
        return this.mIsRunning;
    }

    public boolean isPaused() {
        return this.mIsPause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEncodedData(byte[] encodedData) {
        List<byte[]> list = this.mEncodedAudioList;
        synchronized (list) {
            this.mEncodedAudioList.add(encodedData);
        }
    }

    public synchronized void setVolume(float volume) {
        TXCLog.i(TAG, "setVolume: " + volume);
        this.mVolume = volume;
        if (this.mIsMute) {
            this.nativeSetVolume(0.0f);
        } else {
            this.nativeSetVolume(volume);
        }
    }

    public synchronized boolean getIsMute() {
        return this.mIsMute;
    }

    public synchronized void setSpeedRate(float speedRate) {
        TXCLog.i(TAG, "setSpeedRate: " + speedRate);
        this.mSpeedRate.set(Float.valueOf(speedRate));
        this.nativeSetSpeedRate(this.mSpeedRate.get().floatValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearCache() {
        TXCLog.i(TAG, "clearCache");
        List<byte[]> list = this.mEncodedAudioList;
        synchronized (list) {
            this.mEncodedAudioList.clear();
        }
    }

    @Override
    public void onAudioRecordStart() {
        TXCLog.i(TAG, "sys audio record start");
    }

    @Override
    public void onAudioRecordStop() {
        TXCLog.i(TAG, "sys audio record stop");
    }

    @Override
    public void onAudioRecordError(int errcode, String errmsg) {
        TXCLog.e(TAG, "sys audio record error: " + errcode + ", " + errmsg);
        g g2 = this.getListener();
        if (g2 != null) {
            g2.onRecordError(errcode, errmsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAudioRecordPCM(byte[] data, int len, long timestampMS) {
        long l2 = timestampMS;
        if (this.mLastPTS >= timestampMS) {
            l2 = this.mLastPTS + 2L;
        }
        byte[] byArray = null;
        do {
            List<byte[]> list = this.mEncodedAudioList;
            synchronized (list) {
                if (!this.mEncodedAudioList.isEmpty() && !this.mIsPause) {
                    byArray = this.mEncodedAudioList.get(0);
                    this.mEncodedAudioList.remove(0);
                    if (this.mShouldClearAACDataCnt > 0) {
                        byArray = null;
                        --this.mShouldClearAACDataCnt;
                    }
                } else {
                    byArray = null;
                }
                if (byArray != null) {
                    this.mLastPTS = l2;
                    g g2 = this.getListener();
                    if (g2 != null) {
                        g2.onRecordEncData(byArray, l2, this.mSampleRate.get(), this.mChannels, this.mBits);
                    } else {
                        TXCLog.e(TAG, "onAudioRecordPCM listener is null");
                    }
                    int n2 = this.mSampleRate.get();
                    if (n2 > 0) {
                        l2 += (long)(1024000.0f * this.mSpeedRate.get().floatValue() / (float)n2);
                    }
                }
            }
        } while (byArray != null);
    }

    private synchronized void updateAudioEffector() {
        boolean bl = false;
        if (this.mEnableBGMRecord || this.mAECType == 1) {
            bl = true;
        }
        if (!bl) {
            this.nativeSetReverbType(this.mReverbType);
            this.nativeSetChangerType(this.mVoiceChangerType);
            if (this.mIsMute) {
                this.nativeSetVolume(0.0f);
            } else {
                this.nativeSetVolume(this.mVolume);
            }
        }
        if (bl) {
            this.nativeSetVolume(0.0f);
        }
        this.nativeEnableMixMode(bl);
        this.nativeSetSpeedRate(this.mSpeedRate.get().floatValue());
    }

    public synchronized void setChangerType(int type) {
        TXCLog.i(TAG, "setChangerType: " + type);
        this.mVoiceChangerType = type;
        this.nativeSetChangerType(type);
    }

    private native void nativeClassInit();

    private native void nativeEnableMixMode(boolean var1);

    private native void nativeStartAudioRecord(int var1, int var2, int var3);

    private native void nativeStopAudioRecord();

    private native void nativeSetReverbType(int var1);

    private native void nativeSetSpeedRate(float var1);

    private native void nativeSetVolume(float var1);

    private native void nativeSetChangerType(int var1);

    static {
        h.d();
        INSTANCE = new TXCAudioUGCRecorder();
    }
}

