/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.basic.structs;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class TXSVideoFrame {
    public ByteBuffer buffer;
    public byte[] data;
    public int width;
    public int height;
    public int frameType;
    public int rotation;
    public long pts;
    public int textureId;
    public Object eglContext;

    public void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public TXSVideoFrame clone() {
        TXSVideoFrame tXSVideoFrame = new TXSVideoFrame();
        tXSVideoFrame.width = this.width;
        tXSVideoFrame.height = this.height;
        tXSVideoFrame.frameType = this.frameType;
        tXSVideoFrame.rotation = this.rotation;
        tXSVideoFrame.pts = this.pts;
        tXSVideoFrame.data = this.data;
        tXSVideoFrame.textureId = this.textureId;
        tXSVideoFrame.eglContext = this.eglContext;
        tXSVideoFrame.nativeClone(this.buffer);
        return tXSVideoFrame;
    }

    public void loadYUVArray(byte[] data) {
        if (data == null || data.length < this.width * this.height * 3 / 2) {
            return;
        }
        if (this.buffer == null) {
            int n2 = this.height * 3 / 8;
            GLES20.glReadPixels((int)0, (int)0, (int)this.width, (int)n2, (int)6408, (int)5121, (Buffer)ByteBuffer.wrap(data));
        } else {
            this.nativeLoadArrayFromBuffer(data, this.width * this.height * 3 / 2);
        }
    }

    public void loadYUVBufferFromGL() {
        this.nativeLoadBufferFromGL(this.width, this.height);
    }

    public void loadNV21BufferFromI420Buffer() {
        this.nativeLoadNV21BufferFromI420Buffer(this.width, this.height);
    }

    public byte[] I420toNV21(byte[] input, byte[] output, int width, int height) {
        if (output == null) {
            output = new byte[input.length];
        }
        int n2 = width * height;
        int n3 = n2 / 4;
        int n4 = n2 + n3;
        System.arraycopy(input, 0, output, 0, n2);
        int n5 = n2;
        int n6 = n4;
        int n7 = n2;
        while (n5 < n4) {
            output[n7] = input[n6];
            output[n7 + 1] = input[n5];
            ++n5;
            ++n6;
            n7 += 2;
        }
        return output;
    }

    private native void nativeLoadNV21BufferFromI420Buffer(int var1, int var2);

    private native void nativeLoadArrayFromBuffer(byte[] var1, int var2);

    public native void release();

    public native void nativeClone(ByteBuffer var1);

    private native void nativeLoadBufferFromGL(int var1, int var2);

    private native void nativeLoadArrayFromGL(byte[] var1, int var2, int var3);
}

