/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.network;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import com.tencent.liteav.basic.b.b;
import com.tencent.liteav.basic.datareport.TXCDRApi;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.structs.TXSNALPacket;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.network.TXCFLVDownloader;
import com.tencent.liteav.network.TXCRTMPDownloader;
import com.tencent.liteav.network.TXIStreamDownloader;
import com.tencent.liteav.network.d;
import com.tencent.liteav.network.e;
import com.tencent.liteav.network.f;
import com.tencent.liteav.network.g;
import com.tencent.liteav.network.h;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class TXCStreamDownloader
extends com.tencent.liteav.basic.module.a
implements b,
TXIStreamDownloader.a,
d.a,
f,
g {
    public static final String TAG = "TXCStreamDownloader";
    private TXIStreamDownloader mDownloader = null;
    private g mListener = null;
    private byte[] mListenerLock = new byte[0];
    private b mNotifyListener = null;
    private boolean mDownloaderRunning = false;
    private String mOriginPlayUrl = "";
    private boolean mEnableNearestIP = false;
    private int mChannelType = 0;
    private boolean mEnableMessage = false;
    private boolean mEnableMetaData = false;
    private String mFlvSessionKey = "";
    private int mDownloadFormat = 1;
    private h mAccUrlFetcher;
    private Context mApplicationContext;
    private Handler mHandler = null;
    private long mLastTimeStamp = 0L;
    private DownloadStats mLastDownloadStats = null;
    private boolean mRecvFirstNal = false;
    private long mSwitchStartTime = 0L;
    private long mCurrentNalTs = 0L;
    private long mLastIFramelTs = 0L;
    private d mStreamSwitcher = null;
    private int mPayLoadType = 0;
    private Runnable mReportNetStatusRunnalbe = new Runnable(){

        @Override
        public void run() {
            TXCStreamDownloader.this.reportNetStatus();
        }
    };
    protected Map<String, String> mHeaders;

    @Override
    public void onNotifyEvent(int event, Bundle param) {
        b b2 = this.mNotifyListener;
        if (b2 != null) {
            Object object;
            Bundle bundle = new Bundle();
            int n2 = event;
            switch (event) {
                case 3003: {
                    bundle.putString("EVT_MSG", "RTMP handshake failed");
                    break;
                }
                case -2301: {
                    bundle.putString("EVT_MSG", "failed to connect server for several times, abort connection");
                    break;
                }
                case 3010: {
                    bundle.putString("EVT_MSG", "No video at this stream address");
                    break;
                }
                case 3007: {
                    bundle.putString("EVT_MSG", "Read data error");
                    break;
                }
                case 3006: {
                    bundle.putString("EVT_MSG", "Write data error");
                    break;
                }
                case -2302: {
                    bundle.putString("EVT_MSG", "Failed to get accelerated pull address");
                    break;
                }
                case 2001: {
                    bundle.putString("EVT_MSG", "connection SUCCESS");
                    break;
                }
                case 3002: {
                    bundle.putString("EVT_MSG", "Failed to connect server");
                    break;
                }
                case 2103: {
                    bundle.putString("EVT_MSG", "retry connecting stream server");
                    break;
                }
                case 2002: {
                    bundle.putString("EVT_MSG", "begin receiving stream");
                    break;
                }
                case -2308: {
                    bundle.putString("EVT_MSG", "The server rejected the connection request");
                    break;
                }
                case 2012: {
                    object = param.getByteArray("EVT_GET_MSG");
                    if (object == null || ((byte[])object).length <= 0) break;
                    bundle.putByteArray("EVT_GET_MSG", (byte[])object);
                    break;
                }
                case 2028: 
                case 2031: {
                    bundle = param;
                    break;
                }
                default: {
                    bundle.putString("EVT_MSG", "UNKNOWN event = " + event);
                }
            }
            object = "";
            if (param != null) {
                object = param.getString("EVT_MSG", "");
            }
            if (object != null && !((String)object).isEmpty()) {
                bundle.putString("EVT_MSG", (String)object);
            }
            bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
            bundle.putLong("EVT_UTC_TIME", TXCTimeUtil.getUtcTimeTick());
            b2.onNotifyEvent(n2, bundle);
            if (event == 3001 || event == 3002 || event == 3003 || event == 3004 || event == 3005 || event == 3006 || event == 3007 || event == 3008 || event == 3009 || event == 3010 || event == 2101 || event == 2102 || event == 2109 || event == 2110 || event == -2301 || event == -2304 || event == -2308 || event == -2309) {
                this.setStatusValue(7105, event);
                if (bundle != null) {
                    this.setStatusValue(7106, bundle.getString("EVT_MSG"));
                }
            }
        }
        if (event == 2001) {
            this.reportNetStatusInternal();
        }
    }

    private void tryResetRetryCount() {
        if (this.mDownloader != null) {
            this.mDownloader.connectRetryTimes = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPullAudio(com.tencent.liteav.basic.structs.a audio) {
        this.tryResetRetryCount();
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            if (this.mListener != null) {
                this.mListener.onPullAudio(audio);
            }
            if (this.mDownloader != null) {
                this.mDownloader.PushAudioFrame(audio.f, audio.h, audio.e, audio.g);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPullNAL(TXSNALPacket nal) {
        this.tryResetRetryCount();
        if (!this.mRecvFirstNal) {
            this.reportNetStatusInternal();
            this.mRecvFirstNal = true;
        }
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            this.mCurrentNalTs = nal.pts;
            if (nal.nalType == 0) {
                this.mLastIFramelTs = nal.pts;
            }
            if (this.mListener != null) {
                this.mListener.onPullNAL(nal);
            }
            if (this.mDownloader != null) {
                this.mDownloader.PushVideoFrame(nal.nalData, nal.nalType, nal.dts, nal.pts, nal.codecId);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void onRestartDownloader() {
        if (this.mHandler != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TXCStreamDownloader.this.stop();
                    TXCStreamDownloader.this.start(TXCStreamDownloader.this.mOriginPlayUrl, TXCStreamDownloader.this.mEnableNearestIP, TXCStreamDownloader.this.mChannelType, TXCStreamDownloader.this.mEnableMessage, TXCStreamDownloader.this.mEnableMetaData);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOldStreamStop() {
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            if (this.mStreamSwitcher != null) {
                this.mStreamSwitcher.b();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(g listener) {
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            this.mListener = listener;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyListener(b listener) {
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            this.mNotifyListener = listener;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setID(String id) {
        super.setID(id);
        if (this.mDownloader != null) {
            this.mDownloader.setUserID(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSwitchFinish(TXIStreamDownloader newStream, boolean success) {
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            int n2 = (int)(System.currentTimeMillis() - this.mSwitchStartTime);
            this.mSwitchStartTime = 0L;
            Bundle bundle = new Bundle();
            bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
            bundle.putLong("EVT_UTC_TIME", TXCTimeUtil.getUtcTimeTick());
            if (success) {
                this.mDownloader = newStream;
                this.mDownloader.setListener(this);
                this.mDownloader.setNotifyListener(this);
                this.mDownloader.setRestartListener(this);
                bundle.putInt("EVT_ID", 2015);
                bundle.putCharSequence("EVT_MSG", (CharSequence)"Switched resolution successfully");
                if (this.mNotifyListener != null) {
                    this.mNotifyListener.onNotifyEvent(2015, bundle);
                }
                TXCDRApi.txReportDAU(this.mApplicationContext, com.tencent.liteav.basic.datareport.a.bx, n2, "");
            } else {
                bundle.putInt("EVT_ID", -2307);
                bundle.putCharSequence("EVT_MSG", (CharSequence)"Failed to switch resolution");
                if (this.mNotifyListener != null) {
                    this.mNotifyListener.onNotifyEvent(-2307, bundle);
                }
                TXCDRApi.txReportDAU(this.mApplicationContext, com.tencent.liteav.basic.datareport.a.by);
            }
            this.mStreamSwitcher = null;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void onSEIMessage(byte[] sei) {
        b b2 = this.mNotifyListener;
        if (b2 != null) {
            Bundle bundle = new Bundle();
            bundle.putByteArray("EVT_GET_MSG", sei);
            b2.onNotifyEvent(2012, bundle);
        }
    }

    @Override
    public void onMetaDataMessage(HashMap<String, String> metadata) {
        b b2 = this.mNotifyListener;
        if (b2 != null) {
            Bundle bundle = new Bundle();
            bundle.putSerializable("EVT_GET_METADATA", metadata);
            b2.onNotifyEvent(2028, bundle);
        }
    }

    public TXCStreamDownloader(Context context, int format) {
        if (format == 0) {
            this.mDownloader = new TXCFLVDownloader(context);
            this.mDownloader.setFlvSessionKey(this.mFlvSessionKey);
        } else if (format == 1 || format == 4) {
            this.mDownloader = new TXCRTMPDownloader(context);
        }
        if (this.mDownloader != null) {
            this.mDownloader.setListener(this);
            this.mDownloader.setNotifyListener(this);
            this.mDownloader.setRestartListener(this);
            this.mDownloader.setMessageNotifyListener(this);
        }
        this.mDownloadFormat = format;
        this.mAccUrlFetcher = new h(context);
        this.mApplicationContext = context;
        if (this.mApplicationContext != null) {
            this.mHandler = new Handler(this.mApplicationContext.getMainLooper());
        }
    }

    public void setRetryTimes(int times) {
        if (this.mDownloader != null) {
            this.mDownloader.connectRetryLimit = times;
        }
    }

    public void setRetryInterval(int ms) {
        if (this.mDownloader != null) {
            this.mDownloader.connectRetryInterval = ms;
        }
    }

    public int start(final String url, boolean enableNearestIP, int channeyType, final boolean enableMessage, final boolean enableMetaData) {
        TXCLog.i(TAG, "start url:" + url + ",enableNearestIP:" + enableNearestIP + ",channeyType:" + channeyType + ",enableMessage:" + enableMessage + ",enableMetaData:" + enableMetaData);
        this.mDownloaderRunning = true;
        this.mRecvFirstNal = false;
        this.mOriginPlayUrl = url;
        this.mEnableNearestIP = enableNearestIP;
        this.mChannelType = channeyType;
        this.mEnableMessage = enableMessage;
        this.mEnableMetaData = enableMetaData;
        this.setStatusValue(7113, 0L);
        this.setStatusValue(7114, 0L);
        this.setStatusValue(7115, 0L);
        if (url.startsWith("room")) {
            this.setStatusValue(7113, 1L);
            this.setStatusValue(7112, 2L);
            this.setStatusValue(7116, url);
            if (this.mDownloader != null) {
                Vector<e> vector = new Vector<e>();
                vector.add(new e(url, true));
                this.mDownloader.setOriginUrl(url);
                this.mDownloader.setUserID(this.getID());
                this.mDownloader.startDownload(vector, false, false, enableMessage, enableMetaData);
            }
            if (this.mHandler != null) {
                this.mHandler.postDelayed(this.mReportNetStatusRunnalbe, 2000L);
            }
            return 0;
        }
        if (enableNearestIP && this.mDownloadFormat == 4) {
            int n2 = this.mAccUrlFetcher.a(url, channeyType, new h.a(){

                @Override
                public void a(int n2, String string, Vector<e> vector) {
                    if (n2 == 0 && vector != null && !vector.isEmpty()) {
                        if (TXCStreamDownloader.this.mDownloaderRunning) {
                            if (TXCStreamDownloader.this.mDownloader != null) {
                                int n3 = 0;
                                for (e e2 : vector) {
                                    if (e2 == null || !e2.b || e2.a == null || e2.a.length() <= 0) continue;
                                    ++n3;
                                }
                                TXCStreamDownloader.this.setStatusValue(7113, n3);
                                TXCStreamDownloader.this.setStatusValue(7112, 2L);
                                TXCStreamDownloader.this.mDownloader.setOriginUrl(url);
                                TXCStreamDownloader.this.mDownloader.startDownload(vector, true, true, enableMessage, enableMetaData);
                            }
                            if (TXCStreamDownloader.this.mHandler != null) {
                                TXCStreamDownloader.this.mHandler.postDelayed(TXCStreamDownloader.this.mReportNetStatusRunnalbe, 2000L);
                            }
                            String string2 = TXCStreamDownloader.this.mAccUrlFetcher.b();
                            TXCDRApi.txReportDAU(TXCStreamDownloader.this.mApplicationContext, com.tencent.liteav.basic.datareport.a.au, n2, string2);
                        } else {
                            TXCDRApi.txReportDAU(TXCStreamDownloader.this.mApplicationContext, com.tencent.liteav.basic.datareport.a.au, -4, "livePlayer have been stopped");
                        }
                    } else {
                        TXCStreamDownloader.this.onNotifyEvent(-2302, null);
                        TXCDRApi.txReportDAU(TXCStreamDownloader.this.mApplicationContext, com.tencent.liteav.basic.datareport.a.au, n2, string);
                        TXCLog.e(TXCStreamDownloader.TAG, "getAccelerateStreamPlayUrl failed, play stream with raw url");
                        if (TXCStreamDownloader.this.mDownloaderRunning) {
                            TXCStreamDownloader.this.onNotifyEvent(-2301, null);
                        }
                    }
                }
            });
            if (n2 != 0) {
                if (n2 == -1) {
                    TXCDRApi.txReportDAU(this.mApplicationContext, com.tencent.liteav.basic.datareport.a.au, n2, "invalid playUrl");
                } else if (n2 == -2) {
                    TXCDRApi.txReportDAU(this.mApplicationContext, com.tencent.liteav.basic.datareport.a.au, n2, "invalid streamID");
                } else if (n2 == -3) {
                    TXCDRApi.txReportDAU(this.mApplicationContext, com.tencent.liteav.basic.datareport.a.au, n2, "invalid signature");
                }
                TXCLog.e(TAG, "getAccelerateStreamPlayUrl failed, result = " + n2 + ", play stream with raw url");
                this.onNotifyEvent(-2302, null);
                this.onNotifyEvent(-2301, null);
            }
            return 0;
        }
        if (this.mDownloader != null) {
            this.setStatusValue(7112, 1L);
            Vector<e> vector = new Vector<e>();
            vector.add(new e(url, false));
            this.mDownloader.setOriginUrl(url);
            this.mDownloader.startDownload(vector, this.mDownloadFormat == 4, enableNearestIP, enableMessage, enableMetaData);
            if (this.mHandler != null) {
                this.mHandler.postDelayed(this.mReportNetStatusRunnalbe, 2000L);
            }
        }
        return 0;
    }

    private void playStreamWithRawUrl(String url, boolean enableMessage) {
        if (this.mDownloader != null) {
            if (url != null && (url.startsWith("http://") || url.startsWith("https://")) && url.contains(".flv")) {
                int n2 = this.mDownloader.connectRetryLimit;
                int n3 = this.mDownloader.connectRetryInterval;
                this.mDownloader = null;
                this.mDownloader = new TXCFLVDownloader(this.mApplicationContext);
                this.mDownloader.setFlvSessionKey(this.mFlvSessionKey);
                this.mDownloader.setListener(this);
                this.mDownloader.setNotifyListener(this);
                this.mDownloader.setRestartListener(this);
                this.mDownloader.connectRetryLimit = n2;
                this.mDownloader.connectRetryInterval = n3;
                this.mDownloader.setHeaders(this.mHeaders);
                this.mDownloader.setUserID(this.getID());
                this.mDownloader.setMessageNotifyListener(this);
                this.mDownloader.setPayloadType(this.mPayLoadType);
            }
            this.setStatusValue(7112, 1L);
            Vector<e> vector = new Vector<e>();
            vector.add(new e(url, false));
            this.mDownloader.setOriginUrl(url);
            this.mDownloader.startDownload(vector, false, false, enableMessage, enableMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.mDownloaderRunning = false;
        this.mRecvFirstNal = false;
        if (this.mDownloader != null) {
            this.mDownloader.stopDownload();
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mReportNetStatusRunnalbe);
        }
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            if (this.mStreamSwitcher != null) {
                this.mStreamSwitcher.a(null);
                this.mStreamSwitcher.a();
                this.mStreamSwitcher = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean switchStream(String url) {
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            if (this.mStreamSwitcher != null || this.mDownloader == null || !(this.mDownloader instanceof TXCFLVDownloader)) {
                TXCLog.w(TAG, "stream_switch stream is changing ignore this change");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            TXCFLVDownloader tXCFLVDownloader = new TXCFLVDownloader(this.mApplicationContext, (TXCFLVDownloader)this.mDownloader);
            tXCFLVDownloader.connectRetryLimit = this.mDownloader.connectRetryLimit;
            tXCFLVDownloader.connectRetryInterval = this.mDownloader.connectRetryInterval;
            tXCFLVDownloader.setHeaders(this.mHeaders);
            tXCFLVDownloader.setUserID(this.getID());
            tXCFLVDownloader.setFlvSessionKey(this.mFlvSessionKey);
            tXCFLVDownloader.setMessageNotifyListener(this);
            ((TXIStreamDownloader)tXCFLVDownloader).setPayloadType(this.mPayLoadType);
            this.mStreamSwitcher = new d(this);
            this.mStreamSwitcher.a(this);
            this.mStreamSwitcher.a(this.mDownloader, tXCFLVDownloader, this.mCurrentNalTs, this.mLastIFramelTs, url);
            this.mSwitchStartTime = System.currentTimeMillis();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    public void requestKeyFrame(String playUrl) {
        if (this.mDownloaderRunning && playUrl != null && playUrl.startsWith("room") && this.mDownloader != null) {
            this.mDownloader.requestKeyFrame(playUrl);
        }
    }

    private DownloadStats getDownloadStats() {
        if (this.mDownloader != null) {
            return this.mDownloader.getDownloadStats();
        }
        return null;
    }

    private a getRealTimeStreamInfo() {
        a a2 = null;
        if (this.mAccUrlFetcher != null && !TextUtils.isEmpty((CharSequence)this.mAccUrlFetcher.a())) {
            a2 = new a();
            a2.b = this.mAccUrlFetcher.a();
            a2.c = this.mAccUrlFetcher.b();
            a2.d = this.mAccUrlFetcher.c();
            a2.e = this.mAccUrlFetcher.d();
        }
        if (this.mDownloader != null && a2 != null) {
            a2.a = this.mDownloader.getCurrentStreamUrl();
            a2.f = this.mDownloader.isQuicChannel();
        }
        return a2;
    }

    private void reportNetStatus() {
        this.reportNetStatusInternal();
        this.mHandler.postDelayed(this.mReportNetStatusRunnalbe, 2000L);
    }

    private void reportNetStatusInternal() {
        long l2 = TXCTimeUtil.getTimeTick();
        long l3 = l2 - this.mLastTimeStamp;
        DownloadStats downloadStats = this.getDownloadStats();
        a a2 = this.getRealTimeStreamInfo();
        long l4 = 0L;
        long l5 = 0L;
        if (downloadStats != null) {
            if (this.mLastDownloadStats != null) {
                l4 = this.getSpeed(this.mLastDownloadStats.afterParseVideoBytes, downloadStats.afterParseVideoBytes, l3);
                l5 = this.getSpeed(this.mLastDownloadStats.afterParseAudioBytes, downloadStats.afterParseAudioBytes, l3);
            }
            if (l4 > 0L || l5 > 0L) {
                this.mDownloader.connectRetryTimes = 0;
            }
            this.setStatusValue(7101, l4);
            this.setStatusValue(7102, l5);
            this.setStatusValue(7103, downloadStats.firstVideoTS);
            this.setStatusValue(7104, downloadStats.firstAudioTS);
            this.setStatusValue(7120, downloadStats.videoGop);
            if (a2 != null) {
                this.setStatusValue(7105, a2.d);
                this.setStatusValue(7106, a2.e);
                this.setStatusValue(7111, a2.f ? 2L : 1L);
                this.setStatusValue(7116, a2.a);
                this.setStatusValue(7117, a2.b);
                this.setStatusValue(7118, a2.c);
            } else {
                this.setStatusValue(7105, downloadStats.errorCode);
                this.setStatusValue(7106, downloadStats.errorInfo);
                this.setStatusValue(7111, 1L);
            }
            this.setStatusValue(7107, downloadStats.startTS);
            this.setStatusValue(7108, downloadStats.dnsTS);
            this.setStatusValue(7109, downloadStats.connTS);
            this.setStatusValue(7110, String.valueOf(downloadStats.serverIP));
        }
        if (this.mDownloader != null) {
            int n2 = this.mDownloader.getConnectCountQuic();
            int n3 = this.mDownloader.getConnectCountTcp();
            this.setStatusValue(7114, ++n2);
            this.setStatusValue(7115, ++n3);
            this.setStatusValue(7119, this.mDownloader.getRealStreamUrl());
            this.setStatusValue(7121, String.valueOf(this.mDownloader.getFlvSessionKey()));
        }
        this.mLastTimeStamp = l2;
        this.mLastDownloadStats = downloadStats;
    }

    private Long getSpeed(long lastValue, long currValue, long ms) {
        long l2 = 0L;
        l2 = lastValue > currValue ? currValue : currValue - lastValue;
        long l3 = 0L;
        if (ms > 0L) {
            l3 = l2 * 8L * 1000L / (ms * 1024L);
        }
        return l3;
    }

    public void setHeaders(Map<String, String> headers) {
        this.mHeaders = headers;
        if (this.mDownloader != null) {
            this.mDownloader.setHeaders(this.mHeaders);
        }
    }

    public void setFlvSessionKey(String flvSessionKey) {
        this.mFlvSessionKey = flvSessionKey;
        if (this.mDownloader != null) {
            this.mDownloader.setFlvSessionKey(flvSessionKey);
        }
    }

    public void setPayloadType(int payloadType) {
        this.mPayLoadType = payloadType;
        if (this.mDownloader != null) {
            this.mDownloader.setPayloadType(this.mPayLoadType);
        }
    }

    public String getRTMPProxyUserId() {
        return this.nativeGetRTMPProxyUserId();
    }

    private native String nativeGetRTMPProxyUserId();

    static {
        com.tencent.liteav.basic.util.h.d();
    }

    public static class a {
        public String a;
        public String b;
        public String c;
        public int d;
        public String e;
        public boolean f;
    }

    public static class DownloadStats {
        public long beforeParseVideoBytes;
        public long beforeParseAudioBytes;
        public long afterParseVideoBytes;
        public long afterParseAudioBytes;
        public long videoGop;
        public long startTS;
        public long dnsTS;
        public long connTS;
        public long firstVideoTS;
        public long firstAudioTS;
        public String serverIP;
        public String flvSessionKey;
        public int errorCode;
        public String errorInfo;
    }
}

