/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtc.impl;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.tencent.liteav.TXCRenderAndDec;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.g;
import com.tencent.liteav.renderer.e;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.trtc.TRTCCloud;
import com.tencent.trtc.TRTCCloudListener;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;

public class TRTCRoomInfo {
    private static final String TAG = "TRTCRoomInfo";
    private static final String TRTC_INFO = "TRTC.Info";
    private static final String TOKEN = "TRTC.0x0.Token";
    public static final int STATE_BIG_VIDEO = 1;
    public static final int STATE_SMALL_VIDEO = 2;
    public static final int STATE_SUB_VIDEO = 4;
    public static final int STATE_AUDIO = 8;
    public static final int STATE_MUTE_MAIN_VIDEO = 16;
    public static final int STATE_MUTE_SUB_VIDEO = 32;
    public static final int STATE_MUTE_AUDIO = 64;
    public static final int NETWORK_STATUS_OFFLINE = 1;
    public static final int NETWORK_STATUS_RECONNECTING = 2;
    public static final int NETWORK_STATUS_ONLINE = 3;
    public int sdkAppId;
    public long enterTime;
    public long roomId;
    public String strRoomId;
    public String userId = "";
    public String tinyId;
    public byte[] token = null;
    public String userSig;
    public String privateMapKey;
    public int networkStatus = 1;
    public TRTCCloud.TRTCViewMargin debugMargin = new TRTCCloud.TRTCViewMargin(0.0f, 0.0f, 0.1f, 0.0f);
    public int localPixelFormat;
    public int localBufferType;
    public TRTCCloudListener.TRTCVideoRenderListener localListener;
    public boolean enableCustomPreprocessor = false;
    public TXCloudVideoView localView = null;
    private HashMap<String, UserInfo> userList = new HashMap();
    private HashMap<Long, Integer> recvFirstIFrameCntList = new HashMap();
    public boolean muteLocalVideo = false;
    public boolean muteLocalSubVideo = false;
    public TRTCRemoteMuteState muteRemoteVideo = TRTCRemoteMuteState.UNSET;
    public boolean muteLocalAudio = false;
    public TRTCRemoteMuteState muteRemoteAudio = TRTCRemoteMuteState.UNSET;
    public int localRenderRotation = 0;
    private boolean micHasStartd = false;
    private boolean hasExitedRoom = false;
    private int exitRoomCode = 0;
    public JSONArray decProperties = null;
    public boolean enableRestartDecoder = false;
    public g.a bigEncSize = new g.a();
    public g.a smallEncSize = new g.a();

    public void init(long roomId, String userId) {
        this.roomId = roomId;
        this.userId = userId;
    }

    public synchronized void clear() {
        this.roomId = 0L;
        this.userId = "";
        this.enterTime = 0L;
        this.tinyId = "";
        this.muteLocalVideo = false;
        this.muteLocalAudio = false;
        this.muteRemoteVideo = TRTCRemoteMuteState.UNSET;
        this.muteRemoteAudio = TRTCRemoteMuteState.UNSET;
        this.userList.clear();
        this.recvFirstIFrameCntList.clear();
        this.networkStatus = 1;
        this.decProperties = null;
        this.enableRestartDecoder = false;
        this.enableCustomPreprocessor = false;
        this.localListener = null;
    }

    public String getStrRoomId() {
        String string = TextUtils.isEmpty((CharSequence)this.strRoomId) ? String.valueOf(this.roomId) : this.strRoomId;
        return string;
    }

    public long getRoomId() {
        return this.roomId;
    }

    public void setRoomId(int roomId) {
        this.roomId = roomId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getTinyId() {
        return this.tinyId;
    }

    public void setTinyId(String tinyId) {
        this.tinyId = tinyId;
    }

    private String byteArrayToHexStr(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        char[] cArray = "0123456789ABCDEF".toCharArray();
        char[] cArray2 = new char[byteArray.length * 2];
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            int n2 = byteArray[i2] & 0xFF;
            cArray2[i2 * 2] = cArray[n2 >>> 4];
            cArray2[i2 * 2 + 1] = cArray[n2 & 0xF];
        }
        return new String(cArray2);
    }

    private byte[] hexStrToByteArray(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[str.length() / 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = str.substring(2 * i2, 2 * i2 + 2);
            byArray[i2] = (byte)Integer.parseInt(string, 16);
        }
        return byArray;
    }

    public void setToken(Context context, byte[] token) {
        this.token = token;
        try {
            SharedPreferences.Editor editor = context.getSharedPreferences(TRTC_INFO, 0).edit();
            if (this.token != null) {
                String string = this.byteArrayToHexStr(this.token);
                editor.putString(TOKEN, string);
            } else {
                editor.remove(TOKEN);
            }
            editor.commit();
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "set token failed.", exception);
        }
    }

    public byte[] getToken(Context context) {
        try {
            if (this.token == null) {
                SharedPreferences sharedPreferences = context.getSharedPreferences(TRTC_INFO, 0);
                String string = sharedPreferences.getString(TOKEN, "");
                this.token = this.hexStrToByteArray(string);
            }
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "get token failed.", exception);
        }
        return this.token;
    }

    public void store(Context context, String key, String value) {
        try {
            SharedPreferences.Editor editor = context.getSharedPreferences(TRTC_INFO, 0).edit();
            if (!TextUtils.isEmpty((CharSequence)value)) {
                editor.putString(key, value);
            } else {
                editor.remove(key);
            }
            editor.apply();
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "Store key/value failed. key:%s value:%s err:%s", key, value != null ? value : "null", exception.getMessage());
        }
    }

    public String query(Context context, String key) {
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences(TRTC_INFO, 0);
            return sharedPreferences.getString(key, "");
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "Query value failed.  key:%s err:%s", key, exception.getMessage());
            return "";
        }
    }

    public long getRoomElapsed() {
        return System.currentTimeMillis() - this.enterTime;
    }

    public synchronized void addUserInfo(String userId, UserInfo userInfo) {
        this.userList.put(userId, userInfo);
    }

    public synchronized void removeRenderInfo(String userId) {
        UserInfo userInfo = this.userList.get(userId);
        long l2 = (userInfo.tinyID << 4) + 2L;
        this.recvFirstIFrameCntList.remove(l2);
        l2 = (userInfo.tinyID << 4) + 7L;
        this.recvFirstIFrameCntList.remove(l2);
        this.userList.remove(userId);
    }

    public synchronized UserInfo getUser(String userId) {
        return this.userList.get(userId);
    }

    public synchronized String getUserIdByTinyId(long tinyid) {
        HashMap<String, UserInfo> hashMap = this.userList;
        for (Map.Entry<String, UserInfo> entry : hashMap.entrySet()) {
            UserInfo userInfo = entry.getValue();
            if (userInfo == null || userInfo.tinyID != tinyid) continue;
            return userInfo.userID;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachUser(UserAction action) {
        HashMap<String, UserInfo> hashMap = new HashMap<String, UserInfo>(this.userList.size());
        TRTCRoomInfo tRTCRoomInfo = this;
        synchronized (tRTCRoomInfo) {
            hashMap.putAll(this.userList);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (action == null || entry.getValue() == null) continue;
            action.accept((String)entry.getKey(), (UserInfo)entry.getValue());
        }
    }

    public synchronized void clearUserList() {
        this.userList.clear();
        this.recvFirstIFrameCntList.clear();
    }

    public synchronized int recvFirstIFrame(long tinyId, int streamType) {
        if (streamType != 7) {
            streamType = 2;
        }
        long l2 = (tinyId << 4) + (long)streamType;
        Integer n2 = this.recvFirstIFrameCntList.get(l2);
        this.recvFirstIFrameCntList.put(l2, n2 == null ? 1 : n2 + 1);
        return n2 == null ? 1 : n2 + 1;
    }

    public synchronized boolean hasRecvFirstIFrame(long tinyId, int streamType) {
        long l2;
        Integer n2;
        if (streamType != 7) {
            streamType = 2;
        }
        return (n2 = this.recvFirstIFrameCntList.get(l2 = (tinyId << 4) + (long)streamType)) != null && n2 > 0;
    }

    public void micStart(boolean start) {
        this.micHasStartd = start;
    }

    public synchronized boolean isMicStard() {
        return this.micHasStartd;
    }

    public synchronized void setRoomExit(boolean hasExit, int exitCode) {
        this.hasExitedRoom = hasExit;
        this.exitRoomCode = exitCode;
    }

    public synchronized boolean isRoomExit() {
        return this.hasExitedRoom;
    }

    public synchronized int getRoomExitCode() {
        return this.exitRoomCode;
    }

    public static boolean isMuteMainVideo(int state) {
        return (state & 0x10) != 0;
    }

    public static boolean isMuteSubVideo(int state) {
        return (state & 0x20) != 0;
    }

    public static boolean isMuteAudio(int state) {
        return (state & 0x40) != 0;
    }

    public static boolean hasMainVideo(int state) {
        return (state & 1) != 0;
    }

    public static boolean hasSmallVideo(int state) {
        return (state & 2) != 0;
    }

    public static boolean hasSubVideo(int state) {
        return (state & 4) != 0;
    }

    public static boolean hasAudio(int state) {
        return (state & 8) != 0;
    }

    public static interface UserAction {
        public void accept(String var1, UserInfo var2);
    }

    public static class UserInfo {
        public long tinyID;
        public String userID;
        public int terminalType;
        public RenderInfo mainRender = new RenderInfo();
        public RenderInfo subRender = new RenderInfo();
        public int streamType = 2;
        public TRTCCloud.TRTCViewMargin debugMargin = new TRTCCloud.TRTCViewMargin(0.0f, 0.0f, 0.1f, 0.0f);
        public int streamState;
        public boolean muteAudioInSpeaker = false;

        public UserInfo(long tinyID, String userID, int terminalType, int streamState) {
            this.tinyID = tinyID;
            this.userID = userID;
            this.terminalType = terminalType;
            this.streamState = streamState;
            this.mainRender.tinyID = tinyID;
            this.subRender.tinyID = tinyID;
        }
    }

    public static class RenderInfo
    implements SurfaceHolder.Callback {
        public long tinyID;
        public TXCRenderAndDec render = null;
        public Boolean startRenderView = false;
        public TXCloudVideoView view = null;
        public TRTCRemoteMuteState muteVideo = TRTCRemoteMuteState.UNSET;
        public TRTCRemoteMuteState muteAudio = TRTCRemoteMuteState.UNSET;
        public int mirrorType = 0;
        public int rotation = 0;
        public int renderMode = 0;
        public int lastVideoStreamStatus = 0;
        public int lastVideoStatusChangeOperation = 0;

        public void surfaceCreated(SurfaceHolder holder) {
            TXCLog.i("RenderInfo", "trtc_api startRemoteView surfaceCreated " + holder.getSurface() + ", " + this.tinyID + ", " + this.render);
            if (holder.getSurface().isValid()) {
                e e2;
                e e3 = e2 = this.render != null ? this.render.getVideoRender() : null;
                if (e2 != null) {
                    e2.a(holder.getSurface());
                }
            }
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            e e2;
            TXCLog.i("RenderInfo", "trtc_api startRemoteView surfaceChanged " + holder.getSurface() + " width " + width + ", height " + height + ", " + this.tinyID + ", " + this.render);
            e e3 = e2 = this.render != null ? this.render.getVideoRender() : null;
            if (e2 != null) {
                e2.d(width, height);
            }
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            e e2;
            TXCLog.i("RenderInfo", "trtc_api startRemoteView surfaceDestroyed " + holder.getSurface() + ", " + this.tinyID + ", " + this.render);
            e e3 = e2 = this.render != null ? this.render.getVideoRender() : null;
            if (e2 != null) {
                e2.a((Surface)null);
            }
        }

        public void stop() {
            try {
                if (this.view != null && this.view.getSurfaceView() != null && this.view.getSurfaceView().getHolder() != null) {
                    this.view.getSurfaceView().getHolder().removeCallback((SurfaceHolder.Callback)this);
                }
            }
            catch (Exception exception) {
                TXCLog.e(TRTCRoomInfo.TAG, "remove callback failed.", exception);
            }
        }
    }

    public static enum TRTCRemoteMuteState {
        UNSET,
        MUTE,
        UNMUTE;

    }
}

