/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videodecoder;

import android.graphics.SurfaceTexture;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.module.TXCEventRecorderProxy;
import com.tencent.liteav.basic.module.TXCKeyPointReportProxy;
import com.tencent.liteav.basic.module.TXCStatus;
import com.tencent.liteav.basic.structs.TXSNALPacket;
import com.tencent.liteav.basic.structs.TXSVideoFrame;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.videodecoder.TXCVideoFfmpegDecoder;
import com.tencent.liteav.videodecoder.b;
import com.tencent.liteav.videodecoder.f;
import com.tencent.liteav.videodecoder.g;
import com.tencent.liteav.videodecoder.h;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.json.JSONArray;

public class TXCVideoDecoder
implements com.tencent.liteav.basic.b.b,
h {
    private static final String TAG = "TXCVideoDecoder";
    private static final boolean NEW_DECODER = true;
    boolean mNeedSortFrame = true;
    boolean mHWDec = true;
    boolean mH265 = false;
    boolean mRecvFirstFrame = false;
    Surface mSurface;
    h mDecoderListener;
    private int mDecoderCacheNum;
    private ByteBuffer mSps;
    private ByteBuffer mPps;
    private String mUserId;
    private long mNativeContext;
    private boolean mRestarting = false;
    private int mStreamType = 0;
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    private boolean mEnableDecoderChange = false;
    private boolean mEnableRestartDecoder = false;
    private boolean mEnableLimitDecCache = false;
    private static long mDecodeFirstFrameTS = 0L;
    b mVideoDecoder;
    private JSONArray mDecFormat = null;
    private ArrayList<TXSNALPacket> mNALList = new ArrayList();
    private a mDecoderHandler;
    private WeakReference<com.tencent.liteav.basic.b.b> mNotifyListener;

    @Override
    public void onNotifyEvent(int event, Bundle param) {
        if (event == 2106 || event == -2304) {
            this.nativeNotifyHWDecoderError(this.mNativeContext);
        }
        com.tencent.liteav.basic.util.h.a(this.mNotifyListener, this.mUserId, event, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserId(String userId) {
        this.mUserId = userId;
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            this.nativeSetID(this.mNativeContext, this.mUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamType(int streamType) {
        this.mStreamType = streamType;
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            this.nativeSetStreamType(this.mNativeContext, this.mStreamType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableChange(boolean enable) {
        this.mEnableDecoderChange = enable;
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            this.nativeEnableDecodeChange(this.mNativeContext, this.mEnableDecoderChange);
        }
    }

    public void enableLimitDecCache(boolean enableLimit) {
        this.mEnableLimitDecCache = enableLimit;
        b b2 = this.mVideoDecoder;
        if (b2 != null) {
            b2.enableLimitDecCache(this.mEnableLimitDecCache);
        }
    }

    public void config(JSONArray format) {
        this.mDecFormat = format;
    }

    public void enableRestart(boolean enable) {
        this.mEnableRestartDecoder = enable;
    }

    public TXCVideoDecoder() {
        mDecodeFirstFrameTS = 0L;
    }

    public void setListener(h listener) {
        this.mDecoderListener = listener;
    }

    public boolean isHardwareDecode() {
        return this.mVideoDecoder != null;
    }

    public void setNotifyListener(com.tencent.liteav.basic.b.b listener) {
        this.mNotifyListener = new WeakReference<com.tencent.liteav.basic.b.b>(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setup(SurfaceTexture surfaceTexture, ByteBuffer sps, ByteBuffer pps, boolean needSortFrame) {
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            if (this.mSurface != null) {
                this.mSurface.release();
                this.mSurface = null;
            }
        }
        return this.setup(new Surface(surfaceTexture), sps, pps, needSortFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setup(Surface surface, ByteBuffer sps, ByteBuffer pps, boolean needSortFrame) {
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            this.mSurface = surface;
        }
        this.mSps = sps;
        this.mPps = pps;
        this.mNeedSortFrame = needSortFrame;
        return 0;
    }

    public void enableHWDec(boolean bHWDec) {
        this.mHWDec = bHWDec;
    }

    private void addOneNalToDecoder(TXSNALPacket nal) {
        boolean bl = nal.nalType == 0;
        Bundle bundle = new Bundle();
        bundle.putBoolean("iframe", bl);
        bundle.putByteArray("nal", nal.nalData);
        bundle.putLong("pts", nal.pts);
        bundle.putLong("dts", nal.dts);
        bundle.putInt("codecId", nal.codecId);
        Message message = new Message();
        message.what = 101;
        message.setData(bundle);
        a a2 = this.mDecoderHandler;
        if (a2 != null) {
            a2.sendMessage(message);
        }
        ++this.mDecoderCacheNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decNALByNewWay(TXSNALPacket nal) {
        if (this.mHWDec) {
            this.decodeFrame(nal.nalData, nal.pts, nal.dts, nal.rotation, nal.codecId, 0, 0, nal.nalType);
        } else {
            TXCVideoDecoder tXCVideoDecoder = this;
            synchronized (tXCVideoDecoder) {
                this.nativeDecodeFrame(this.mNativeContext, nal.nalData, nal.nalType, nal.pts, nal.dts, nal.rotation, nal.codecId);
            }
        }
    }

    private void decNALByOldWay(TXSNALPacket nal) {
        try {
            a a2;
            boolean bl;
            boolean bl2 = bl = nal.nalType == 0;
            if (!this.mRecvFirstFrame && !bl) {
                TXCLog.i(TAG, "play:decode: push nal ignore p frame when not got i frame");
                return;
            }
            if (!this.mRecvFirstFrame && bl) {
                TXCLog.w(TAG, "play:decode: push first i frame");
                this.mRecvFirstFrame = true;
            }
            if (!this.mRestarting && nal.codecId == 1 && !this.mHWDec) {
                TXCLog.w(TAG, "play:decode: hevc decode error  ");
                com.tencent.liteav.basic.util.h.a(this.mNotifyListener, -2304, "h265 Decoding failed");
                this.mRestarting = true;
            }
            if ((a2 = this.mDecoderHandler) != null) {
                if (!this.mNALList.isEmpty()) {
                    for (TXSNALPacket tXSNALPacket : this.mNALList) {
                        this.addOneNalToDecoder(tXSNALPacket);
                    }
                }
                this.mNALList.clear();
                this.addOneNalToDecoder(nal);
            } else {
                if (bl && !this.mNALList.isEmpty()) {
                    this.mNALList.clear();
                }
                this.mNALList.add(nal);
                if (!this.mRestarting) {
                    this.start();
                }
            }
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "decode NAL By Old way failed.", exception);
        }
    }

    public void pushNAL(TXSNALPacket nal) {
        this.decNALByNewWay(nal);
    }

    public synchronized int start() {
        if (this.mHWDec && this.mSurface == null) {
            TXCLog.i(TAG, "play:decode: start decoder error when not setup surface, id " + this.mUserId + "_" + this.mStreamType);
            return -1;
        }
        if (this.mNativeContext != 0L) {
            TXCLog.w(TAG, "play:decode: start decoder error when decoder is started, id " + this.mUserId + "_" + this.mStreamType);
            return -1;
        }
        String string = "[FirstFramePath][Video][Decoder] TXCVideoDecoder: start decode. instance:" + this + " userId:" + this.mUserId + " type:" + this.mStreamType;
        TXCLog.i(TAG, string);
        this.mNativeContext = this.nativeCreateContext(this.mHWDec, com.tencent.liteav.basic.a.b());
        this.nativeSetID(this.mNativeContext, this.mUserId);
        this.nativeSetStreamType(this.mNativeContext, this.mStreamType);
        this.nativeEnableDecodeChange(this.mNativeContext, this.mEnableDecoderChange);
        this.nativeEnableRestartDecoder(this.mNativeContext, this.mEnableRestartDecoder);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.mNativeContext == 0L) {
            TXCLog.w(TAG, "play:decode: stop decoder ignore when decoder is stopped, id " + this.mUserId + "_" + this.mStreamType);
            return;
        }
        TXCLog.w(TAG, "play:decode: stop decoder java id " + this.mUserId + "_" + this.mStreamType + " " + this.hashCode());
        this.nativeDestroyContext(this.mNativeContext);
        this.mNativeContext = 0L;
        this.mNALList.clear();
        this.mRecvFirstFrame = false;
        this.mDecoderCacheNum = 0;
        mDecodeFirstFrameTS = 0L;
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            if (this.mVideoDecoder != null) {
                this.mVideoDecoder.stop();
                this.mVideoDecoder.setListener(null);
                this.mVideoDecoder.setNotifyListener(null);
                this.mVideoDecoder = null;
            }
            if (this.mSurface != null) {
                this.mSurface.release();
                this.mSurface = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(boolean hwDec) {
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            this.mHWDec = hwDec;
            this.nativeReStart(this.mNativeContext, this.mHWDec);
        }
    }

    public int getDecoderCacheNum() {
        return this.mDecoderCacheNum + this.mNALList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDecodeFrame(TXSVideoFrame videoFrame, int width, int height, long pts, long dts, int rotation) {
        int n2;
        if (mDecodeFirstFrameTS == 0L) {
            mDecodeFirstFrameTS = TXCTimeUtil.getTimeTick();
            TXCLog.i(TAG, "[FirstFramePath][Video][Decoder] TXCVideoDecoder: decode first frame success. instance:" + this.hashCode() + " isHWAcc:true isH265:" + this.mH265 + " userId:" + this.mUserId + " type:" + this.mStreamType);
            TXCStatus.a(this.mUserId, 5005, this.mStreamType, mDecodeFirstFrameTS);
            n2 = this.mH265 ? 3 : 1;
            TXCStatus.a(this.mUserId, 5004, this.mStreamType, n2);
        }
        if (this.mDecoderListener != null) {
            this.mDecoderListener.onDecodeFrame(videoFrame, width, height, pts, dts, rotation);
        }
        if (this.mDecoderCacheNum > 0) {
            --this.mDecoderCacheNum;
        }
        if (videoFrame == null) {
            TXCVideoDecoder tXCVideoDecoder = this;
            synchronized (tXCVideoDecoder) {
                this.nativeNotifyPts(this.mNativeContext, pts, width, height);
            }
        }
        n2 = this.mVideoDecoder.GetDecodeCost();
        if (this.mHWDec) {
            TXCStatus.a(this.mUserId, 8004, this.mStreamType, n2);
        } else {
            TXCStatus.a(this.mUserId, 8003, this.mStreamType, n2);
        }
    }

    @Override
    public void onVideoSizeChange(int width, int height) {
        h h2 = this.mDecoderListener;
        if (h2 != null && (this.mVideoWidth != width || this.mVideoHeight != height)) {
            this.mVideoWidth = width;
            this.mVideoHeight = height;
            h2.onVideoSizeChange(this.mVideoWidth, this.mVideoHeight);
        }
    }

    @Override
    public void onDecoderChange(String mimeType, boolean isH265) {
        this.mH265 = isH265;
        this.mHWDec = true;
        TXCLog.i(TAG, "onDecoderChange " + mimeType + " , isH265 = " + isH265);
        this.reportDecoderEvent(this.mHWDec, isH265);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDecodeFailed(int code) {
        TXCStatus.a(this.mUserId, 5006, this.mStreamType, code);
        if (this.mDecoderListener != null) {
            this.mDecoderListener.onDecodeFailed(code);
        }
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            this.nativeDecCache(this.mNativeContext);
        }
    }

    public boolean isH265() {
        return this.mH265;
    }

    public long GetDecodeFirstFrameTS() {
        return mDecodeFirstFrameTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int startDecodeThread() {
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            if (this.mDecoderHandler != null) {
                TXCLog.e(TAG, "play:decode: start decoder error when decoder is started");
                return -1;
            }
            this.mDecoderCacheNum = 0;
            this.mRestarting = false;
            HandlerThread handlerThread = new HandlerThread("VDecoder");
            handlerThread.start();
            if (this.mHWDec) {
                handlerThread.setName("VideoWDec" + handlerThread.getId());
            } else {
                handlerThread.setName("VideoSWDec" + handlerThread.getId());
            }
            a a2 = new a(handlerThread.getLooper());
            a2.a(this.mH265, this.mHWDec, this.mSurface, this.mSps, this.mPps, this, this);
            TXCLog.w(TAG, "play:decode: start decode thread");
            Message message = Message.obtain();
            message.what = 100;
            message.obj = this.mNeedSortFrame;
            a2.sendMessage(message);
            this.mDecoderHandler = a2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDecodeThread() {
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            if (this.mDecoderHandler != null) {
                this.mDecoderHandler.sendEmptyMessage(102);
            }
            this.mDecoderHandler = null;
        }
    }

    private void notifyDecoderStartEvent(boolean hwDec, boolean isH265) {
        TXCEventRecorderProxy.a(this.mUserId, 4005, hwDec ? 1L : 0L, -1L, "", this.mStreamType);
        this.reportDecoderEvent(hwDec, isH265);
        TXCKeyPointReportProxy.a(this.mUserId, 40026, hwDec ? 1L : 2L, this.mStreamType);
    }

    private void reportDecoderEvent(boolean hwDec, boolean isH265) {
        Bundle bundle = new Bundle();
        bundle.putInt("EVT_ID", 2008);
        bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
        bundle.putLong("EVT_UTC_TIME", TXCTimeUtil.getUtcTimeTick());
        StringBuilder stringBuilder = new StringBuilder("Enables ");
        if (isH265) {
            stringBuilder.append("H265 ");
        } else {
            stringBuilder.append("H264 ");
        }
        if (hwDec) {
            stringBuilder.append("hardware ");
        } else {
            stringBuilder.append("software ");
        }
        stringBuilder.append("decoding");
        bundle.putCharSequence("EVT_MSG", (CharSequence)stringBuilder.toString());
        bundle.putInt("EVT_PARAM1", hwDec ? 1 : 2);
        com.tencent.liteav.basic.util.h.a(this.mNotifyListener, this.mUserId, 2008, bundle);
        TXCLog.i(TAG, "start video decoder:" + stringBuilder.toString());
    }

    private boolean hasSurface() {
        return this.mSurface != null;
    }

    private native long nativeCreateContext(boolean var1, Object var2);

    private native void nativeDestroyContext(long var1);

    private native void nativeNotifyHWDecoderError(long var1);

    private native void nativeSetID(long var1, String var3);

    private native void nativeSetStreamType(long var1, int var3);

    private native void nativeReStart(long var1, boolean var3);

    private native void nativeDecCache(long var1);

    private native void nativeNotifyPts(long var1, long var3, int var5, int var6);

    private native void nativeDecodeFrame(long var1, byte[] var3, int var4, long var5, long var7, int var9, int var10);

    private native void nativeEnableDecodeChange(long var1, boolean var3);

    private native void nativeEnableRestartDecoder(long var1, boolean var3);

    private void onDecodeDone(TXSVideoFrame videoFrame, int width, int height, long pts, long dts, int rotation, int frameType) {
        Object object;
        if (mDecodeFirstFrameTS == 0L) {
            mDecodeFirstFrameTS = TXCTimeUtil.getTimeTick();
            object = "[FirstFramePath][Video][Decoder] TXCVideoDecoder: decode first frame success. instance:" + this.hashCode() + " isHWAcc:false isH265:" + this.mH265 + " userId:" + this.mUserId + " type:" + this.mStreamType;
            TXCLog.i(TAG, (String)object);
            TXCStatus.a(this.mUserId, 5005, this.mStreamType, mDecodeFirstFrameTS);
            int n2 = this.mH265 ? 2 : 0;
            TXCStatus.a(this.mUserId, 5004, this.mStreamType, n2);
        }
        if ((object = this.mDecoderListener) != null) {
            videoFrame.width = width;
            videoFrame.height = height;
            videoFrame.rotation = rotation;
            videoFrame.pts = pts;
            videoFrame.frameType = frameType;
            object.onDecodeFrame(videoFrame, width, height, pts, dts, rotation);
            if (this.mVideoWidth != width || this.mVideoHeight != height) {
                this.mVideoWidth = width;
                this.mVideoHeight = height;
                object.onVideoSizeChange(this.mVideoWidth, this.mVideoHeight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeFrame(byte[] nal, long pts, long dts, int rotation, int codecId, int width, int height, int nalType) {
        TXSNALPacket tXSNALPacket = new TXSNALPacket();
        tXSNALPacket.nalData = nal;
        tXSNALPacket.pts = pts;
        tXSNALPacket.dts = dts;
        tXSNALPacket.rotation = rotation;
        tXSNALPacket.codecId = codecId;
        tXSNALPacket.nalType = nalType;
        TXCVideoDecoder tXCVideoDecoder = this;
        synchronized (tXCVideoDecoder) {
            if (this.mNativeContext != 0L && this.mVideoDecoder == null) {
                this.mH265 = codecId == 1;
                g g2 = new g();
                g2.a(width, height);
                g2.setListener(this);
                g2.setNotifyListener(new WeakReference<com.tencent.liteav.basic.b.b>(this));
                g2.a(this.mDecFormat);
                g2.config(this.mSurface);
                g2.enableLimitDecCache(this.mEnableLimitDecCache);
                g2.start(this.mSps, this.mPps, this.mNeedSortFrame, this.mH265);
                this.notifyDecoderStartEvent(true, this.mH265);
                this.mVideoDecoder = g2;
            }
            if (this.mVideoDecoder != null) {
                this.mVideoDecoder.decode(tXSNALPacket);
            }
        }
    }

    private synchronized void stopHWDecoder() {
        if (this.mVideoDecoder != null) {
            this.mVideoDecoder.stop();
            this.mVideoDecoder.setListener(null);
            this.mVideoDecoder.setNotifyListener(null);
            this.mVideoDecoder = null;
        }
    }

    private void onStartDecoder(boolean hwDec, boolean isH265) {
        this.mH265 = isH265;
        this.mHWDec = hwDec;
        this.notifyDecoderStartEvent(hwDec, this.mH265);
    }

    static {
        com.tencent.liteav.basic.util.h.d();
    }

    private static class a
    extends Handler {
        b a;
        h b;
        WeakReference<com.tencent.liteav.basic.b.b> c;
        boolean d;
        boolean e;
        Surface f;
        private ByteBuffer g;
        private ByteBuffer h;

        public a(Looper looper) {
            super(looper);
        }

        public void a(boolean bl, boolean bl2, Surface surface, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, h h2, com.tencent.liteav.basic.b.b b2) {
            this.e = bl;
            this.d = bl2;
            this.f = surface;
            this.g = byteBuffer;
            this.h = byteBuffer2;
            this.b = h2;
            this.c = new WeakReference<com.tencent.liteav.basic.b.b>(b2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    this.a((Boolean)msg.obj);
                    break;
                }
                case 101: {
                    try {
                        Bundle bundle = msg.getData();
                        byte[] byArray = bundle.getByteArray("nal");
                        long l2 = bundle.getLong("pts");
                        long l3 = bundle.getLong("dts");
                        int n2 = bundle.getInt("codecId");
                        this.a(byArray, l2, l3, n2);
                    }
                    catch (Exception exception) {
                        TXCLog.e(TXCVideoDecoder.TAG, "decode frame failed." + exception.getMessage());
                    }
                    break;
                }
                case 102: {
                    this.a();
                    break;
                }
                case 103: {
                    this.a(msg.arg1 == 1, msg.arg2 == 1);
                }
            }
        }

        private void a(byte[] byArray, long l2, long l3, int n2) {
            TXSNALPacket tXSNALPacket = new TXSNALPacket();
            tXSNALPacket.nalData = byArray;
            tXSNALPacket.pts = l2;
            tXSNALPacket.dts = l3;
            tXSNALPacket.codecId = n2;
            if (this.a != null) {
                this.a.decode(tXSNALPacket);
            }
        }

        private void a() {
            if (this.a != null) {
                this.a.stop();
                this.a.setListener(null);
                this.a.setNotifyListener(null);
                this.a = null;
            }
            Looper.myLooper().quit();
            TXCLog.w(TXCVideoDecoder.TAG, "play:decode: stop decode hwdec: " + this.d);
        }

        private void a(boolean bl, boolean bl2) {
            this.d = bl;
            TXCLog.w(TXCVideoDecoder.TAG, "play:decode: restart decode hwdec: " + this.d);
            if (this.a != null) {
                this.a.stop();
                this.a.setListener(null);
                this.a.setNotifyListener(null);
                this.a = null;
            }
            this.a(bl2);
        }

        private void a(boolean bl) {
            if (this.a != null) {
                TXCLog.i(TXCVideoDecoder.TAG, "play:decode: start decode ignore hwdec: " + this.d);
                return;
            }
            this.a = this.d ? new f() : new TXCVideoFfmpegDecoder();
            this.a.setListener(this.b);
            this.a.setNotifyListener(this.c);
            this.a.config(this.f);
            this.a.start(this.g, this.h, bl, this.e);
            TXCLog.w(TXCVideoDecoder.TAG, "play:decode: start decode hwdec: " + this.d + ", h265: " + this.e);
        }
    }
}

