/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.sharp.jni;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import com.tencent.liteav.basic.util.TXCBuild;
import com.tencent.liteav.basic.util.TXCCommonUtil;
import com.tencent.rtmp.sharp.jni.QLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MediaCodecEncoder {
    private static final String TAG = "MediaCodecEncoder";
    private Context mContext;
    private MediaCodec mAudioAACEncoder = null;
    private MediaFormat mAudioFormat = null;
    private MediaCodec.BufferInfo mAACEncBufferInfo = null;
    private ByteBuffer mInputBuffer = null;
    private ByteBuffer mOutputBuffer = null;
    private ByteBuffer[] mMediaInputBuffers;
    private ByteBuffer[] mMediaOutputBuffers;
    private ByteBuffer mEncInBuffer;
    private ByteBuffer mEncOutBuffer;
    private byte[] mTempBufEncIn;
    private byte[] mTempBufEncOut;
    private int mSampleRate = 48000;
    private int mChannels = 1;
    private int mBitrate = 32000;
    private int nMaxBitRate = 256000;
    private boolean mFormatChangeFlag = false;
    private File mRecFileDump = null;
    private FileOutputStream mRecFileOut = null;
    private static boolean mDumpEnable = false;

    public MediaCodecEncoder() {
        this.mContext = TXCCommonUtil.getAppContext();
        this.mEncInBuffer = ByteBuffer.allocateDirect(7680);
        this.mTempBufEncIn = new byte[7680];
        this.mEncOutBuffer = ByteBuffer.allocateDirect(this.nMaxBitRate * 2 / 8 / 50 + 100);
        this.mTempBufEncOut = new byte[this.nMaxBitRate * 2 / 8 / 50 + 100];
    }

    public MediaCodecEncoder(Context context) {
        this.mContext = context;
        this.mEncInBuffer = ByteBuffer.allocateDirect(7680);
        this.mTempBufEncIn = new byte[7680];
        this.mEncOutBuffer = ByteBuffer.allocateDirect(this.nMaxBitRate * 2 / 8 / 50 + 100);
        this.mTempBufEncOut = new byte[this.nMaxBitRate * 2 / 8 / 50 + 100];
    }

    private String getDumpFilePath(String filename) {
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "manufacture:" + TXCBuild.Manufacturer());
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "MODEL:" + TXCBuild.Model());
        }
        if (this.mContext == null) {
            return null;
        }
        File file = this.mContext.getExternalFilesDir(null);
        if (file == null) {
            return null;
        }
        String string = file.getPath() + "/MF-" + TXCBuild.Manufacturer() + "-M-" + TXCBuild.Model() + "-" + filename;
        File file2 = new File(string);
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "dump:" + string);
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "dump replace:" + string.replace(" ", "_"));
        }
        return string.replace(" ", "_");
    }

    private void addADTStoPacket(byte[] data, int packetLen) {
        int n2 = 2;
        int n3 = 3;
        if (this.mSampleRate == 48000) {
            n3 = 3;
        } else if (this.mSampleRate == 44100) {
            n3 = 4;
        } else if (this.mSampleRate == 32000) {
            n3 = 5;
        } else if (this.mSampleRate == 24000) {
            n3 = 6;
        } else if (this.mSampleRate == 16000) {
            n3 = 8;
        }
        int n4 = this.mChannels;
        data[0] = -1;
        data[1] = -7;
        data[2] = (byte)((n2 - 1 << 6) + (n3 << 2) + (n4 >> 2));
        data[3] = (byte)(((n4 & 3) << 6) + (packetLen >> 11));
        data[4] = (byte)((packetLen & 0x7FF) >> 3);
        data[5] = (byte)(((packetLen & 7) << 5) + 31);
        data[6] = -4;
    }

    @SuppressLint(value={"NewApi"})
    public int createAACEncoder(int sampleRate, int channels, int bitrate) {
        try {
            block9: {
                this.mAudioAACEncoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
                this.mAudioFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channels);
                this.mAudioFormat.setInteger("aac-profile", 2);
                this.mAudioFormat.setInteger("sample-rate", sampleRate);
                this.mAudioFormat.setInteger("channel-count", channels);
                this.mAudioFormat.setInteger("bitrate", bitrate);
                this.mAudioAACEncoder.configure(this.mAudioFormat, null, null, 1);
                if (this.mAudioAACEncoder != null) {
                    this.mAudioAACEncoder.start();
                    this.mAACEncBufferInfo = new MediaCodec.BufferInfo();
                    this.mSampleRate = sampleRate;
                    this.mChannels = channels;
                    this.mBitrate = bitrate;
                }
                if (mDumpEnable) {
                    this.mRecFileDump = new File(this.getDumpFilePath("jnirecord.aac"));
                    try {
                        this.mRecFileOut = new FileOutputStream(this.mRecFileDump);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (!QLog.isColorLevel()) break block9;
                        QLog.e(TAG, 2, "open jnirecord.aac file failed.");
                    }
                }
            }
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "createAACEncoder succeed!!! : (" + sampleRate + ", " + channels + ", " + bitrate + ")");
            }
            return 0;
        }
        catch (Exception exception) {
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "create AAC Encoder failed.");
            }
            if (QLog.isColorLevel()) {
                QLog.e(TAG, 2, "[ERROR] creating aac encode stream failed!!! : (" + sampleRate + ", " + channels + ", " + bitrate + ")");
            }
            return -1;
        }
    }

    @SuppressLint(value={"NewApi"})
    public int encodeAACFrame(int nLength) {
        if (this.mFormatChangeFlag) {
            this.mFormatChangeFlag = false;
            this.mAudioAACEncoder.stop();
            this.mAudioFormat.setInteger("bitrate", this.mBitrate);
            this.mAudioAACEncoder.configure(this.mAudioFormat, null, null, 1);
            this.mAudioAACEncoder.start();
        }
        this.mEncInBuffer.get(this.mTempBufEncIn, 0, nLength);
        int n2 = this.encodeInternalAACFrame(nLength);
        this.mEncOutBuffer.rewind();
        if (n2 > 0) {
            this.mEncOutBuffer.put(this.mTempBufEncOut, 0, n2);
            if (mDumpEnable && this.mRecFileOut != null) {
                try {
                    int n3 = n2 + 7;
                    byte[] byArray = new byte[n3];
                    this.addADTStoPacket(byArray, n3);
                    System.arraycopy(this.mTempBufEncOut, 0, byArray, 7, n2);
                    this.mRecFileOut.write(byArray, 0, n3);
                }
                catch (IOException iOException) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 2, "write file failed.");
                    }
                }
            }
        } else {
            n2 = 0;
        }
        return n2;
    }

    @SuppressLint(value={"NewApi"})
    public int encodeInternalAACFrame(int nLength) {
        int n2;
        block11: {
            n2 = 0;
            try {
                int n3;
                int n4 = this.mAudioAACEncoder.dequeueInputBuffer(2000L);
                if (n4 != -1) {
                    if (TXCBuild.VersionInt() >= 21) {
                        this.mInputBuffer = this.mAudioAACEncoder.getInputBuffer(n4);
                    } else {
                        this.mMediaInputBuffers = this.mAudioAACEncoder.getInputBuffers();
                        this.mInputBuffer = this.mMediaInputBuffers[n4];
                    }
                    this.mInputBuffer.clear();
                    this.mInputBuffer.put(this.mTempBufEncIn, 0, nLength);
                    this.mAudioAACEncoder.queueInputBuffer(n4, 0, nLength, 0L, 0);
                    this.mEncInBuffer.rewind();
                }
                if ((n3 = this.mAudioAACEncoder.dequeueOutputBuffer(this.mAACEncBufferInfo, 0L)) < 0) {
                    return n2;
                }
                int n5 = this.mAACEncBufferInfo.size;
                if (TXCBuild.VersionInt() >= 21) {
                    this.mOutputBuffer = this.mAudioAACEncoder.getOutputBuffer(n3);
                } else {
                    this.mMediaOutputBuffers = this.mAudioAACEncoder.getOutputBuffers();
                    this.mOutputBuffer = this.mMediaOutputBuffers[n3];
                }
                n2 = (this.mAACEncBufferInfo.flags & 2) == 2 ? 0 : this.mAACEncBufferInfo.size;
                try {
                    this.mOutputBuffer.position(this.mAACEncBufferInfo.offset);
                    this.mOutputBuffer.limit(this.mAACEncBufferInfo.offset + n5);
                    this.mOutputBuffer.get(this.mTempBufEncOut, 0, n2);
                    this.mOutputBuffer.position(0);
                    this.mAudioAACEncoder.releaseOutputBuffer(n3, false);
                    return n2;
                }
                catch (Exception exception) {
                    if (QLog.isColorLevel()) {
                        QLog.e(TAG, 2, "[ERROR] encoding aac stream failed!!!");
                    }
                }
            }
            catch (Exception exception) {
                n2 = 0;
                if (!QLog.isColorLevel()) break block11;
                QLog.e(TAG, 2, "encode failed." + exception.getMessage());
            }
        }
        return n2;
    }

    @SuppressLint(value={"NewApi"})
    public int releaseAACEncoder() {
        block5: {
            try {
                if (this.mAudioAACEncoder != null) {
                    this.mAudioAACEncoder.stop();
                    this.mAudioAACEncoder.release();
                    this.mAudioAACEncoder = null;
                    if (QLog.isColorLevel()) {
                        QLog.w(TAG, 2, "releaseAACEncoder, release aac encode stream succeed!!");
                    }
                    return 0;
                }
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block5;
                QLog.e(TAG, 2, "release aac encoder failed." + exception.getMessage());
            }
        }
        if (QLog.isColorLevel()) {
            QLog.e(TAG, 2, "[ERROR] releaseAACEncoder, release aac encode stream failed!!!");
        }
        return -1;
    }

    @SuppressLint(value={"NewApi"})
    public int setAACEncodeBitrate(int bitrate) {
        if (this.mAudioAACEncoder != null && this.mBitrate != bitrate) {
            this.mFormatChangeFlag = true;
            this.mBitrate = bitrate;
            if (QLog.isColorLevel()) {
                QLog.w(TAG, 2, "Set AAC bitrate = " + bitrate);
            }
        }
        return 0;
    }
}

