/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.multimedia.liteav.audiokit.interfaces;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.huawei.multimedia.liteav.audiokit.interfaces.AudioFeaturesKit;
import com.huawei.multimedia.liteav.audiokit.interfaces.HwAudioKaraokeFeatureKit;
import com.huawei.multimedia.liteav.audiokit.interfaces.IAudioKitCallback;
import com.tencent.liteav.basic.log.TXCLog;

public class FeatureKitManager {
    private static final String TAG = "HwAudioKit.FeatureKitManager";
    private static final Object SET_CALL_BACK_LOCK = new Object();
    private static final Object NEW_FEATUREMANAGER_LOCK = new Object();
    private static final Object BIND_SERVICE_LOCK = new Object();
    private static final Object UNBIND_SERVICE_LOCK = new Object();
    private static final String ENGINE_PACKAGE_NAME = "com.huawei.multimedia.audioengine";
    private static final int PACKAGE_INFO_FLAG = 0;
    private static FeatureKitManager sInstance = null;
    private IAudioKitCallback mCallBack = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static FeatureKitManager getInstance() {
        Object object = NEW_FEATUREMANAGER_LOCK;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new FeatureKitManager();
            }
            return sInstance;
        }
    }

    protected <T extends AudioFeaturesKit> T createFeatureKit(int type, Context context) {
        TXCLog.i(TAG, "createFeatureKit, type = %d", type);
        if (context == null) {
            return null;
        }
        switch (type) {
            case 1: {
                HwAudioKaraokeFeatureKit hwAudioKaraokeFeatureKit = new HwAudioKaraokeFeatureKit(context);
                hwAudioKaraokeFeatureKit.initialize(context);
                return (T)hwAudioKaraokeFeatureKit;
            }
        }
        TXCLog.i(TAG, "createFeatureKit, type error");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindService(Context context, ServiceConnection connection, String classeName) {
        Object object = BIND_SERVICE_LOCK;
        synchronized (object) {
            if (context == null) {
                return;
            }
            Intent intent = new Intent();
            intent.setClassName(ENGINE_PACKAGE_NAME, classeName);
            try {
                TXCLog.i(TAG, "bindService");
                context.bindService(intent, connection, 1);
            }
            catch (SecurityException securityException) {
                TXCLog.e(TAG, "bindService, SecurityException, %s", securityException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindService(Context context, ServiceConnection connectionService) {
        TXCLog.i(TAG, "unbindService");
        Object object = UNBIND_SERVICE_LOCK;
        synchronized (object) {
            if (context != null) {
                context.unbindService(connectionService);
            }
        }
    }

    protected boolean isAudioKitSupport(Context context) {
        if (context == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo;
            if (packageManager != null && (packageInfo = packageManager.getPackageInfo(ENGINE_PACKAGE_NAME, 0)) == null) {
                TXCLog.i(TAG, "packageInfo is null");
                return false;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            TXCLog.e(TAG, "isAudioKitSupport ,NameNotFoundException");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCallBack(int result) {
        TXCLog.i(TAG, "onCallBack, result = %d", result);
        Object object = SET_CALL_BACK_LOCK;
        synchronized (object) {
            if (this.getCallBack() != null) {
                this.getCallBack().onResult(result);
            }
        }
    }

    protected void setCallBack(IAudioKitCallback callBack) {
        this.mCallBack = callBack;
    }

    protected IAudioKitCallback getCallBack() {
        return this.mCallBack;
    }
}

