/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.audio.TXCAudioEngine;
import com.tencent.liteav.audio.c;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.h;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TXAudioEffectManagerImpl
implements TXAudioEffectManager {
    private static final String TAG = "AudioCenter:TXAudioEffectManager";
    private static final int OLD_BGM_PLAYER_ID_TYPE = 0;
    private static final int NEW_BGM_PLAYER_ID_TYPE = 1;
    private static final int EFFECT_PLAYER_ID_TYPE = 2;
    private final int mIdType;
    private final List<Long> mPlayingMusicIDList = new ArrayList<Long>();
    private static final HashMap<Long, TXAudioEffectManager.TXMusicPlayObserver> mMusicObserverMap = new HashMap();
    private static final Handler mMainHandler = new Handler(Looper.getMainLooper());
    private static final c sCopyrightedMediaProcessor = new c();
    private WeakReference<TXAudioEffectManagerListener> mAudioEffectManagerListener = null;

    public static TXAudioEffectManagerImpl getInstance() {
        return AudioEffectManagerHolder.INSTANCE;
    }

    public static TXAudioEffectManagerImpl getCacheInstance() {
        return AudioEffectManagerCacheHolder.INSTANCE;
    }

    public static TXAudioEffectManagerImpl getAutoCacheHolder() {
        return AudioEffectManagerAutoCacheHolder.INSTANCE;
    }

    private TXAudioEffectManagerImpl(int idType) {
        this.mIdType = idType;
    }

    @Override
    public void enableVoiceEarMonitor(boolean enable) {
        TXAudioEffectManagerListener tXAudioEffectManagerListener;
        TXCLog.i(TAG, "enableVoiceEarMonitor enable:" + enable);
        if (this.mAudioEffectManagerListener != null && (tXAudioEffectManagerListener = (TXAudioEffectManagerListener)this.mAudioEffectManagerListener.get()) != null) {
            tXAudioEffectManagerListener.onSwitchVoiceEarMonitor(enable);
        }
        TXCAudioEngine.enableAudioEarMonitoring(enable);
    }

    @Override
    public void setVoiceEarMonitorVolume(int volume) {
        TXCAudioEngine.setAudioEarMonitoringVolume(volume);
    }

    @Override
    public void setVoiceReverbType(TXAudioEffectManager.TXVoiceReverbType reverbType) {
        TXCLog.i(TAG, "setVoiceReverbType reverbType:" + (Object)((Object)reverbType));
        TXCAudioEngine.getInstance().setReverbType(reverbType.getNativeValue());
    }

    @Override
    public void setVoiceChangerType(TXAudioEffectManager.TXVoiceChangerType voiceChangerType) {
        TXCLog.i(TAG, "setVoiceChangerType voiceChangerType:" + (Object)((Object)voiceChangerType));
        TXCAudioEngine.getInstance().setVoiceChangerType(voiceChangerType);
    }

    @Override
    public void setVoiceCaptureVolume(int volume) {
        float f2 = (float)volume / 100.0f;
        TXCAudioEngine.getInstance().setSoftwareCaptureVolume(f2);
    }

    @Override
    public void setVoicePitch(double pitch) {
        TXCLog.i(TAG, "setVoicePitch pitch:" + pitch);
        TXCAudioEngine.getInstance().setVoicePitch(pitch);
    }

    public void setAudioPlayoutVolume(int volume) {
        float f2 = (float)volume / 100.0f;
        TXCAudioEngine.getInstance().setMixingPlayoutVolume(f2);
    }

    @Override
    public void setMusicObserver(final int id, final TXAudioEffectManager.TXMusicPlayObserver observer) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (null == observer) {
                    mMusicObserverMap.remove(TXAudioEffectManagerImpl.convertIdToInt64(TXAudioEffectManagerImpl.this.mIdType, id));
                } else {
                    mMusicObserverMap.put(TXAudioEffectManagerImpl.convertIdToInt64(TXAudioEffectManagerImpl.this.mIdType, id), observer);
                }
                TXCLog.i(TXAudioEffectManagerImpl.TAG, "setMusicObserver map count: %d", mMusicObserverMap.size());
            }
        };
        if (Looper.myLooper() == mMainHandler.getLooper()) {
            runnable.run();
        } else {
            mMainHandler.post(runnable);
        }
    }

    @Override
    public boolean startPlayMusic(TXAudioEffectManager.AudioMusicParam musicParam) {
        String string;
        if (musicParam == null || TextUtils.isEmpty((CharSequence)musicParam.path)) {
            TXCLog.e(TAG, "startPlayMusic failed. invalid param:" + musicParam);
            return false;
        }
        TXCLog.i(TAG, "startPlayMusic param:" + musicParam);
        long l2 = musicParam.startTimeMS;
        long l3 = musicParam.endTimeMS;
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (TextUtils.isEmpty((CharSequence)(string = sCopyrightedMediaProcessor.a(musicParam.path)))) {
            return false;
        }
        long l4 = TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, musicParam.id);
        if (!this.mPlayingMusicIDList.contains(l4)) {
            this.mPlayingMusicIDList.add(l4);
        }
        sCopyrightedMediaProcessor.a(l4, musicParam.path);
        this.nativeStartPlayRange(l4, l2, l3);
        return this.nativeStartPlay(l4, string, musicParam.loopCount, musicParam.publish, musicParam.isShortFile, false);
    }

    public boolean preloadMusic(TXAudioEffectManager.AudioMusicParam musicParam) {
        TXCLog.i("AudioBGMPlayer", "loadMusic");
        long l2 = Math.max(musicParam.startTimeMS, 0L);
        long l3 = Math.max(musicParam.endTimeMS, 0L);
        String string = sCopyrightedMediaProcessor.a(musicParam.path);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        long l4 = TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, musicParam.id);
        if (!this.mPlayingMusicIDList.contains(l4)) {
            this.mPlayingMusicIDList.add(l4);
        }
        this.nativeStartPlayRange(l4, l2, l3);
        return this.nativeStartPlay(l4, string, musicParam.loopCount, musicParam.publish, musicParam.isShortFile, true);
    }

    @Override
    public void stopPlayMusic(int id) {
        TXCLog.i(TAG, "stopPlayMusic id:" + id);
        long l2 = TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id);
        this.mPlayingMusicIDList.remove(l2);
        sCopyrightedMediaProcessor.f(l2, this.nativeGetCurrentPositionInMs(l2));
        this.nativeStopPlay(l2);
    }

    @Override
    public void pausePlayMusic(int id) {
        TXCLog.i(TAG, "pausePlayMusic id:" + id);
        long l2 = TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id);
        this.mPlayingMusicIDList.remove(l2);
        sCopyrightedMediaProcessor.b(l2, this.nativeGetCurrentPositionInMs(l2));
        this.nativePause(l2);
    }

    @Override
    public void resumePlayMusic(int id) {
        TXCLog.i(TAG, "resumePlayMusic id:" + id);
        long l2 = TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id);
        if (!this.mPlayingMusicIDList.contains(l2)) {
            this.mPlayingMusicIDList.add(l2);
        }
        sCopyrightedMediaProcessor.c(l2, this.nativeGetCurrentPositionInMs(l2));
        this.nativeResume(l2);
    }

    public void interruptAllMusics() {
        TXCLog.i(TAG, "interruptAllMusics");
        for (long l2 : this.mPlayingMusicIDList) {
            this.nativePause(l2);
        }
    }

    public void recoverAllMusics() {
        TXCLog.i(TAG, "recoverAllMusics");
        for (long l2 : this.mPlayingMusicIDList) {
            this.nativeResume(l2);
        }
    }

    public void stopAllMusics() {
        this.stopAllMusics(true);
    }

    public void stopAllMusics(boolean cleanObserver) {
        TXCLog.i(TAG, "stopAllMusics, cleanObserver:" + cleanObserver);
        for (long l2 : this.mPlayingMusicIDList) {
            this.nativeStopPlay(l2);
            final long l3 = l2;
            if (!cleanObserver) continue;
            mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    mMusicObserverMap.remove(l3);
                }
            });
        }
        this.mPlayingMusicIDList.clear();
    }

    public void setMusicVolume(int id, int volume) {
        TXCLog.i(TAG, "setMusicVolume " + volume);
        this.nativeSetVolume(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id), volume);
    }

    @Override
    public void setMusicPublishVolume(int id, int volume) {
        this.nativeSetPublishVolume(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id), volume);
    }

    @Override
    public void setMusicPlayoutVolume(int id, int volume) {
        this.nativeSetPlayoutVolume(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id), volume);
    }

    @Override
    public void setAllMusicVolume(int volume) {
        this.nativeSetAllVolume(volume);
    }

    @Override
    public void setMusicPitch(int id, float pitch) {
        this.nativeSetPitch(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id), pitch);
    }

    @Override
    public void setMusicSpeedRate(int id, float speedRate) {
        this.nativeSetSpeedRate(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id), speedRate);
    }

    public void setMusicPlayoutSpeedRate(int id, float speedRate) {
        this.nativeSetPlayoutSpeedRate(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id), speedRate);
    }

    public void setMusicChangerType(int id, int voiceChangerType) {
        TXCLog.i(TAG, "setMusicChangerType id:" + id + " voiceChangerType:" + voiceChangerType);
        this.nativeSetChangerType(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id), voiceChangerType);
    }

    public void setMusicReverbType(int id, int reverbType) {
        TXCLog.i(TAG, "setMusicReverbType id:" + id + " reverbType:" + reverbType);
        this.nativeSetReverbType(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id), reverbType);
    }

    @Override
    public long getMusicCurrentPosInMS(int id) {
        return this.nativeGetCurrentPositionInMs(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id));
    }

    public long getAvailableBGMBytes(int id) {
        return this.nativeGetAvailableBGMBytes(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id));
    }

    public void seekMusicToPosInBytes(int id, long posInBytes) {
        this.nativeSeekToPosition(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id), posInBytes);
    }

    @Override
    public void seekMusicToPosInMS(int id, int pts) {
        long l2 = TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id);
        sCopyrightedMediaProcessor.d(l2, pts);
        this.nativeSeekToTime(l2, pts);
    }

    public void setMuteDataDurationToPublish(int id, int millis) {
        TXCLog.i(TAG, "setMuteDataDurationToPublish id:" + id + " millis:" + millis);
        this.nativeSetMuteDataDurationToPublish(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id), millis);
    }

    @Override
    public long getMusicDurationInMS(String path) {
        if (TextUtils.isEmpty((CharSequence)(path = sCopyrightedMediaProcessor.a(path)))) {
            return -1L;
        }
        return TXAudioEffectManagerImpl.nativeGetDurationMSByPath(path);
    }

    public long getMusicDurationInMSById(int id) {
        return this.nativeGetDurationMS(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, id));
    }

    public static void onEffectFinish(final long id, final int errCode) {
        mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                TXCLog.i(TXAudioEffectManagerImpl.TAG, "onEffectFinish -> effect id = " + (int)id + ", errCode = " + errCode);
                if (mMusicObserverMap.get(id) != null) {
                    ((TXAudioEffectManager.TXMusicPlayObserver)mMusicObserverMap.get(id)).onComplete((int)id, errCode);
                }
                sCopyrightedMediaProcessor.f(id, TXAudioEffectManagerImpl.getAutoCacheHolder().nativeGetCurrentPositionInMs(id));
            }
        });
    }

    public static void onEffectStart(final long id, final int errCode) {
        mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                TXCLog.i(TXAudioEffectManagerImpl.TAG, "onEffectStart -> effect id = " + (int)id + ", errCode = " + errCode);
                if (mMusicObserverMap.get(id) != null) {
                    ((TXAudioEffectManager.TXMusicPlayObserver)mMusicObserverMap.get(id)).onStart((int)id, errCode);
                }
            }
        });
    }

    public static void onEffectProgress(final long id, final long curPtsMS, final long durationMS) {
        mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (mMusicObserverMap.get(id) != null) {
                    ((TXAudioEffectManager.TXMusicPlayObserver)mMusicObserverMap.get(id)).onPlayProgress((int)id, curPtsMS, durationMS);
                }
                sCopyrightedMediaProcessor.a(id, TXAudioEffectManagerImpl.getAutoCacheHolder().nativeGetCurrentPositionInMs(id));
            }
        });
    }

    public static void onEffectLoop(final long id, final long loopCountRemain) {
        mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                TXCLog.i(TXAudioEffectManagerImpl.TAG, "onEffectLoop -> id = " + (int)id + " loopCountRemain = " + loopCountRemain);
                sCopyrightedMediaProcessor.e(id, TXAudioEffectManagerImpl.getAutoCacheHolder().nativeGetCurrentPositionInMs(id));
            }
        });
    }

    private static long convertIdToInt64(int flag, int id) {
        long l2 = 0L;
        l2 = flag;
        l2 <<= 32;
        return l2 |= (long)id;
    }

    public void setAudioEffectManagerListener(TXAudioEffectManagerListener audioEffectManagerListener) {
        this.mAudioEffectManagerListener = new WeakReference<TXAudioEffectManagerListener>(audioEffectManagerListener);
    }

    private static native void nativeClassInit();

    private native boolean nativeStartPlay(long var1, String var3, int var4, boolean var5, boolean var6, boolean var7);

    private native void nativeStartPlayRange(long var1, long var3, long var5);

    private native void nativeStopPlay(long var1);

    private native void nativePause(long var1);

    private native void nativeResume(long var1);

    private native void nativeSetVolume(long var1, int var3);

    private native void nativeSetPlayoutVolume(long var1, int var3);

    private native void nativeSetPublishVolume(long var1, int var3);

    private native void nativeSetAllVolume(int var1);

    private native void nativeSetPitch(long var1, float var3);

    private native void nativeSetSpeedRate(long var1, float var3);

    private native void nativeSetPlayoutSpeedRate(long var1, float var3);

    private native void nativeSetChangerType(long var1, int var3);

    private native void nativeSetReverbType(long var1, int var3);

    private native void nativeSeekToTime(long var1, int var3);

    private native void nativeSeekToPosition(long var1, long var3);

    private native void nativeSetMuteDataDurationToPublish(long var1, int var3);

    private native long nativeGetCurrentPositionInMs(long var1);

    private static native long nativeGetDurationMSByPath(String var0);

    private native long nativeGetDurationMS(long var1);

    private native long nativeGetAvailableBGMBytes(long var1);

    static {
        h.d();
        TXAudioEffectManagerImpl.nativeClassInit();
    }

    public static interface TXAudioEffectManagerListener {
        public void onSwitchVoiceEarMonitor(boolean var1);
    }

    private static class AudioEffectManagerAutoCacheHolder {
        private static final TXAudioEffectManagerImpl INSTANCE = new TXAudioEffectManagerImpl(1);

        private AudioEffectManagerAutoCacheHolder() {
        }
    }

    private static class AudioEffectManagerCacheHolder {
        private static final TXAudioEffectManagerImpl INSTANCE = new TXAudioEffectManagerImpl(2);

        private AudioEffectManagerCacheHolder() {
        }
    }

    private static class AudioEffectManagerHolder {
        private static final TXAudioEffectManagerImpl INSTANCE = new TXAudioEffectManagerImpl(0);

        private AudioEffectManagerHolder() {
        }
    }
}

