/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.utils;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.opengl.EGL14;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCBuild;
import com.tencent.liteav.basic.util.e;
import com.tencent.liteav.videobase.a.a;
import com.tencent.liteav.videobase.utils.g;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.microedition.khronos.egl.EGL;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;

public class OpenGlUtils {
    private static final String TAG = "OpenGlUtils";

    public static Object getCurrentContext() {
        if (TXCBuild.VersionInt() >= 17) {
            return EGL14.eglGetCurrentContext();
        }
        EGL eGL = EGLContext.getEGL();
        return ((EGL10)eGL).eglGetCurrentContext();
    }

    public static void bindTexture(int target, int texture) {
        GLES20.glBindTexture((int)target, (int)texture);
        OpenGlUtils.checkGlError("bindTexture(" + texture + ")");
    }

    public static void bindFramebuffer(int target, int framebuffer) {
        GLES20.glBindFramebuffer((int)target, (int)framebuffer);
        OpenGlUtils.checkGlError("bindFramebuffer(" + framebuffer + ")");
    }

    public static void attachTextureToFrameBuffer(int textureId, int frameBufferId) {
        GLES20.glBindFramebuffer((int)36160, (int)frameBufferId);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)textureId, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    public static void detachTextureFromFrameBuffer(int frameBufferId) {
        GLES20.glBindFramebuffer((int)36160, (int)frameBufferId);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)0, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    public static void glViewport(int x2, int y2, int width, int height) {
        GLES20.glViewport((int)x2, (int)y2, (int)width, (int)height);
    }

    public static int generateTextureOES() {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        GLES20.glBindTexture((int)36197, (int)nArray[0]);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        return nArray[0];
    }

    public static int createTexture(int width, int height, int internalFormat, int format) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        TXCLog.d(TAG, "glGenTextures textureId: " + nArray[0]);
        GLES20.glBindTexture((int)3553, (int)nArray[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexImage2D((int)3553, (int)0, (int)internalFormat, (int)width, (int)height, (int)0, (int)format, (int)5121, null);
        return nArray[0];
    }

    public static int loadTexture(Bitmap img, int usedTexId, boolean recycle) {
        int[] nArray = new int[1];
        if (usedTexId == -1) {
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            TXCLog.d(TAG, "glGenTextures textureId: " + nArray[0]);
            OpenGlUtils.bindTexture(3553, nArray[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)img, (int)0);
        } else {
            OpenGlUtils.bindTexture(3553, usedTexId);
            GLUtils.texSubImage2D((int)3553, (int)0, (int)0, (int)0, (Bitmap)img);
            nArray[0] = usedTexId;
        }
        if (recycle) {
            img.recycle();
        }
        return nArray[0];
    }

    public static int loadTexture(int format, Buffer data, int width, int height, int usedTexId) {
        int[] nArray = new int[1];
        if (usedTexId == -1) {
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            TXCLog.d(TAG, "glGenTextures textureId: " + nArray[0]);
            OpenGlUtils.bindTexture(3553, nArray[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glTexImage2D((int)3553, (int)0, (int)format, (int)width, (int)height, (int)0, (int)format, (int)5121, (Buffer)data);
        } else {
            OpenGlUtils.bindTexture(3553, usedTexId);
            GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)format, (int)5121, (Buffer)data);
            nArray[0] = usedTexId;
        }
        return nArray[0];
    }

    public static int generateFrameBufferId() {
        int[] nArray = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])nArray, (int)0);
        return nArray[0];
    }

    public static void deleteTexture(int textureId) {
        if (textureId != -1) {
            GLES20.glDeleteTextures((int)1, (int[])new int[]{textureId}, (int)0);
            TXCLog.d(TAG, "delete textureId " + textureId);
        }
    }

    public static void deleteFrameBuffer(int frameBufferId) {
        if (frameBufferId != -1) {
            GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{frameBufferId}, (int)0);
            TXCLog.d(TAG, "delete frame buffer id: " + frameBufferId);
        }
    }

    public static void deleteShaderId(int shaderId) {
        if (shaderId != -1) {
            GLES20.glDeleteShader((int)shaderId);
        }
    }

    public static FloatBuffer createNormalCubeVerticesBuffer() {
        return (FloatBuffer)ByteBuffer.allocateDirect(a.c.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer().put(a.c).position(0);
    }

    public static FloatBuffer createTextureCoordsBuffer(g rotation, boolean flipHorizontal, boolean flipVertical) {
        float[] fArray = new float[a.d.length];
        OpenGlUtils.initTextureCoordsBuffer(fArray, rotation, flipHorizontal, flipVertical);
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(a.d.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(fArray).position(0);
        return floatBuffer;
    }

    public static void initTextureCoordsBuffer(float[] textureCoords, g rotation, boolean flipHorizontal, boolean flipVertical) {
        float[] fArray;
        switch (rotation) {
            case b: {
                fArray = a.f;
                break;
            }
            case c: {
                fArray = a.g;
                break;
            }
            case d: {
                fArray = a.e;
                break;
            }
            default: {
                fArray = a.d;
            }
        }
        System.arraycopy(fArray, 0, textureCoords, 0, fArray.length);
        if (flipHorizontal) {
            textureCoords[0] = OpenGlUtils.flip(textureCoords[0]);
            textureCoords[2] = OpenGlUtils.flip(textureCoords[2]);
            textureCoords[4] = OpenGlUtils.flip(textureCoords[4]);
            textureCoords[6] = OpenGlUtils.flip(textureCoords[6]);
        }
        if (flipVertical) {
            textureCoords[1] = OpenGlUtils.flip(textureCoords[1]);
            textureCoords[3] = OpenGlUtils.flip(textureCoords[3]);
            textureCoords[5] = OpenGlUtils.flip(textureCoords[5]);
            textureCoords[7] = OpenGlUtils.flip(textureCoords[7]);
        }
    }

    private static float flip(float i2) {
        return i2 == 0.0f ? 1.0f : 0.0f;
    }

    public static Point reverseMappingPoint(a.a scaleType, g rotation, Point scaledPoint, e scaledSize, e fromSize) {
        float f2;
        float f3 = (float)fromSize.a * 1.0f / (float)scaledSize.a;
        float f4 = (float)fromSize.b * 1.0f / (float)scaledSize.b;
        Matrix matrix = new Matrix();
        matrix.setTranslate((float)(-scaledSize.a) / 2.0f, (float)(-scaledSize.b) / 2.0f);
        if (scaleType == a.a.b) {
            f2 = Math.min(f3, f4);
            matrix.postScale(f2, f2);
        } else if (scaleType == a.a.c) {
            matrix.postScale(f3, f4);
        } else if (scaleType == a.a.a) {
            f2 = Math.max(f3, f4);
            matrix.postScale(f2, f2);
        }
        matrix.postRotate((float)(360 - rotation.a()));
        if (rotation == g.b || rotation == g.d) {
            matrix.postTranslate((float)fromSize.b / 2.0f, (float)fromSize.a / 2.0f);
        } else {
            matrix.postTranslate((float)fromSize.a / 2.0f, (float)fromSize.b / 2.0f);
        }
        float[] fArray = new float[2];
        matrix.mapPoints(fArray, new float[]{scaledPoint.x, scaledPoint.y});
        return new Point((int)fArray[0], (int)fArray[1]);
    }

    public static void checkGlError(String op) {
    }

    public static void loadYuv420DataToTextures(ByteBuffer yuvData, int uvFormat, int width, int height, int[] usedTexIds) {
        if (yuvData.isDirect()) {
            OpenGlUtils.loadYuv420ByteBufferToTextures(yuvData, uvFormat, width, height, usedTexIds);
        } else {
            OpenGlUtils.loadYuv420ByteArrayToTextures(yuvData.array(), uvFormat, width, height, usedTexIds);
        }
    }

    public static void convertYuvFormat(a.c srcFormatType, Object srcData, a.c destFormatType, Object destData, int width, int height) {
        int n2 = srcFormatType.a();
        int n3 = destFormatType.a();
        boolean bl = srcData instanceof ByteBuffer && destData instanceof ByteBuffer ? OpenGlUtils.convertYuvFormatBufferToBuffer(n2, (ByteBuffer)srcData, n3, (ByteBuffer)destData, width, height) : (srcData instanceof ByteBuffer && destData instanceof byte[] ? OpenGlUtils.convertYuvFormatBufferToArray(n2, (ByteBuffer)srcData, n3, (byte[])destData, width, height) : (srcData instanceof byte[] && destData instanceof ByteBuffer ? OpenGlUtils.convertYuvFormatArrayToBuffer(n2, (byte[])srcData, n3, (ByteBuffer)destData, width, height) : OpenGlUtils.convertYuvFormatArrayToArray(n2, (byte[])srcData, n3, (byte[])destData, width, height)));
        if (!bl) {
            throw new IllegalArgumentException("Do not support " + (Object)((Object)srcFormatType) + " to " + (Object)((Object)destFormatType));
        }
    }

    public static void readPixels(int x2, int y2, int width, int height, Object buffer) {
        GLES20.glFinish();
        if (buffer instanceof Buffer) {
            ((Buffer)buffer).position(0);
            GLES20.glReadPixels((int)x2, (int)y2, (int)width, (int)height, (int)6408, (int)5121, (Buffer)((Buffer)buffer));
        } else {
            if (!(buffer instanceof byte[])) {
                TXCLog.e(TAG, "read pixels failed due to unsupport object. " + buffer);
                return;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])buffer);
            GLES20.glReadPixels((int)x2, (int)y2, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
        }
        OpenGlUtils.checkGlError("glReadPixels");
    }

    public static native void copyDataFromByteBufferToByteBuffer(ByteBuffer var0, ByteBuffer var1, int var2);

    public static native void copyDataFromByteBufferToByteArray(ByteBuffer var0, byte[] var1, int var2);

    public static native void copyDataFromByteArrayToByteBuffer(byte[] var0, ByteBuffer var1, int var2);

    private static native void loadYuv420ByteArrayToTextures(byte[] var0, int var1, int var2, int var3, int[] var4);

    private static native void loadYuv420ByteBufferToTextures(ByteBuffer var0, int var1, int var2, int var3, int[] var4);

    private static native boolean convertYuvFormatBufferToBuffer(int var0, ByteBuffer var1, int var2, ByteBuffer var3, int var4, int var5);

    private static native boolean convertYuvFormatBufferToArray(int var0, ByteBuffer var1, int var2, byte[] var3, int var4, int var5);

    private static native boolean convertYuvFormatArrayToBuffer(int var0, byte[] var1, int var2, ByteBuffer var3, int var4, int var5);

    private static native boolean convertYuvFormatArrayToArray(int var0, byte[] var1, int var2, byte[] var3, int var4, int var5);
}

