/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoengine.decoder;

import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Looper;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.e;
import com.tencent.liteav.basic.util.f;
import com.tencent.liteav.videobase.a.a;
import com.tencent.liteav.videobase.c.d;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.c;
import com.tencent.liteav.videobase.frame.g;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.utils.b;
import com.tencent.liteav.videoengine.decoder.i;
import com.tencent.liteav.videoengine.decoder.j;
import com.tencent.liteav.videoengine.decoder.k;
import com.tencent.liteav.videoengine.decoder.l;
import com.tencent.liteav.videoengine.decoder.n;
import com.tencent.liteav.videoengine.decoder.o;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class h
implements SurfaceTexture.OnFrameAvailableListener,
n {
    @NonNull
    private final e a = new e();
    @NonNull
    private final PixelFrame b = new PixelFrame();
    @NonNull
    private final f c;
    @NonNull
    private final com.tencent.liteav.videobase.f.c d;
    private final boolean e;
    private final JSONArray f;
    private MediaCodec g = null;
    private o h;
    private final MediaCodec.BufferInfo i = new MediaCodec.BufferInfo();
    private final Deque<com.tencent.liteav.videobase.e.b> j = new LinkedList<com.tencent.liteav.videobase.e.b>();
    private boolean k = true;
    private com.tencent.liteav.videobase.c.c l;
    private int m = -1;
    private SurfaceTexture n;
    private Surface o;
    private c p;
    private g q;

    public h(@NonNull Looper looper, @NonNull e e2, boolean bl, @Nullable JSONArray jSONArray, @NonNull com.tencent.liteav.videobase.f.c c2) {
        this.e = bl;
        this.f = jSONArray;
        this.a.a = e2.a;
        this.a.b = e2.b;
        this.c = new f(looper);
        this.d = c2;
        TXCLog.i("HardwareVideoDecoder", "create decoder %s, useHevc: %b, params: %s", e2, bl, jSONArray);
    }

    @Override
    public void start(Object glContext, o listener) {
        this.a(com.tencent.liteav.videoengine.decoder.i.a(this, glContext, listener));
    }

    private void a(Object object, o o2) {
        TXCLog.i("HardwareVideoDecoder", "start internal");
        if (this.l != null) {
            TXCLog.w("HardwareVideoDecoder", "Decoder already started.");
            return;
        }
        this.h = o2;
        if (!this.a(object)) {
            return;
        }
        String string = this.e ? "video/hevc" : "video/avc";
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)string, (int)this.a.a, (int)this.a.b);
        com.tencent.liteav.videoengine.decoder.h.a(mediaFormat, this.f);
        try {
            this.g = MediaCodec.createDecoderByType((String)string);
            this.g.configure(mediaFormat, this.o, null, 0);
            this.g.setVideoScalingMode(1);
            this.g.start();
            TXCLog.i("HardwareVideoDecoder", "start MediaCodec success.");
            this.d.a(com.tencent.liteav.videobase.f.e.ab, "VideoDecode: start decoder success", "", new Object[0]);
        }
        catch (Exception exception) {
            TXCLog.e("HardwareVideoDecoder", "start MediaCodec failed.", exception);
            com.tencent.liteav.videobase.f.e e2 = com.tencent.liteav.videobase.f.e.ag;
            String string2 = "VideoDecode: start decoder failed";
            if (exception instanceof IllegalArgumentException) {
                e2 = com.tencent.liteav.videobase.f.e.ac;
                string2 = "VideoDecode: illegal argument, start decoder failed";
            } else if (exception instanceof IllegalStateException) {
                e2 = com.tencent.liteav.videobase.f.e.ad;
                string2 = "VideoDecode: illegal state, start decoder failed";
            }
            this.a(e2, string2, "exception: %s", exception.getMessage());
            return;
        }
        this.b.setPixelBufferType(a.b.d);
        this.b.setPixelFormatType(a.c.a);
        this.b.setWidth(this.a.a);
        this.b.setHeight(this.a.b);
        this.b.setGLContext(this.l.d());
        this.b.setTextureId(this.m);
        this.b.setMatrix(new float[16]);
    }

    private boolean a(Object object) {
        this.l = new com.tencent.liteav.videobase.c.c();
        try {
            this.l.a(object, null, 128, 128);
            this.l.a();
        }
        catch (d d2) {
            TXCLog.e("HardwareVideoDecoder", "create EGLCore failed.", d2);
            this.a(com.tencent.liteav.videobase.f.e.X, "VideoDecode: create EGLCore failed", "errorCode: %d", d2.a());
            return false;
        }
        this.m = OpenGlUtils.generateTextureOES();
        try {
            this.n = new SurfaceTexture(this.m);
            this.o = new Surface(this.n);
            this.n.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        }
        catch (Surface.OutOfResourcesException outOfResourcesException) {
            TXCLog.e("HardwareVideoDecoder", "create SurfaceTexture failed.", outOfResourcesException);
            this.a(com.tencent.liteav.videobase.f.e.ae, "VideoDecode: insufficient resource, start decoder failed", "error message: %s", outOfResourcesException.getMessage());
            return false;
        }
        this.p = new c();
        this.q = new g(this.a.a, this.a.b);
        TXCLog.i("HardwareVideoDecoder", "initialize gl components");
        return true;
    }

    private static void a(MediaFormat mediaFormat, JSONArray jSONArray) {
        if (jSONArray == null) {
            return;
        }
        try {
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                mediaFormat.setInteger(jSONObject.optString("key"), jSONObject.optInt("value"));
            }
        }
        catch (JSONException jSONException) {
            TXCLog.e("HardwareVideoDecoder", "set MediaCodec device related params failed.", jSONException);
        }
    }

    @Override
    public void decode(com.tencent.liteav.videobase.e.b frame) {
        this.a(com.tencent.liteav.videoengine.decoder.j.a(this, frame));
    }

    private void a(com.tencent.liteav.videobase.e.b b2) {
        if (this.g == null) {
            TXCLog.w("HardwareVideoDecoder", "MediaCodec is stopped.");
            return;
        }
        if (b2 != null) {
            this.j.addLast(b2);
        }
        try {
            while (this.k && this.a()) {
            }
            while (!this.j.isEmpty() && this.b(this.j.peekFirst())) {
                this.j.removeFirst();
            }
        }
        catch (Exception exception) {
            TXCLog.e("HardwareVideoDecoder", "decode failed.", exception);
            this.a(com.tencent.liteav.videobase.f.e.ao, "VideoDecode: decode error, restart decoder", "message: %s", exception.getMessage());
        }
    }

    private boolean a() {
        int n2 = this.g.dequeueOutputBuffer(this.i, TimeUnit.MILLISECONDS.toMicros(10L));
        if (n2 == -1) {
            return false;
        }
        if (n2 == -3) {
            TXCLog.i("HardwareVideoDecoder", "on output buffers changed");
            return false;
        }
        if (n2 == -2) {
            this.b();
            return true;
        }
        if (n2 >= 0) {
            this.k = false;
            this.g.releaseOutputBuffer(n2, true);
            if ((this.i.flags & 4) != 0) {
                TXCLog.i("HardwareVideoDecoder", "meet end of stream.");
            }
            return true;
        }
        TXCLog.d("HardwareVideoDecoder", "dequeueOutputBuffer get invalid index: %d", n2);
        return false;
    }

    private void b() {
        MediaFormat mediaFormat = this.g.getOutputFormat();
        TXCLog.i("HardwareVideoDecoder", "decode output format changed: " + mediaFormat);
        int n2 = Math.abs(mediaFormat.getInteger("crop-right") - mediaFormat.getInteger("crop-left")) + 1;
        int n3 = Math.abs(mediaFormat.getInteger("crop-bottom") - mediaFormat.getInteger("crop-top")) + 1;
        int n4 = mediaFormat.getInteger("width");
        int n5 = mediaFormat.getInteger("height");
        TXCLog.i("HardwareVideoDecoder", "cropWidth: %d, cropHeight: %d, frameWidth: %d, frameHeight: %d", n2, n3, n4, n5);
    }

    private boolean b(com.tencent.liteav.videobase.e.b b2) {
        if (b2 == null || b2.a.length == 0) {
            TXCLog.w("HardwareVideoDecoder", "receive empty buffer.");
            return true;
        }
        ByteBuffer[] byteBufferArray = this.g.getInputBuffers();
        if (com.tencent.liteav.videobase.utils.b.a(byteBufferArray)) {
            TXCLog.e("HardwareVideoDecoder", "get invalid input buffers.");
            return false;
        }
        int n2 = this.g.dequeueInputBuffer(10000L);
        if (n2 < 0) {
            return false;
        }
        byteBufferArray[n2].put(b2.a);
        this.g.queueInputBuffer(n2, 0, b2.a.length, b2.f, 0);
        return true;
    }

    @Override
    public void stop() {
        this.a(com.tencent.liteav.videoengine.decoder.k.a(this));
    }

    @Override
    public n.a getDecoderType() {
        return n.a.a;
    }

    private void c() {
        TXCLog.i("HardwareVideoDecoder", "stop internal");
        if (this.g != null) {
            try {
                this.g.stop();
            }
            catch (Exception exception) {
                TXCLog.e("HardwareVideoDecoder", "stop MediaCodec failed." + exception.getMessage());
            }
            finally {
                try {
                    this.g.release();
                }
                catch (Exception exception) {
                    TXCLog.e("HardwareVideoDecoder", "release MediaCodec failed.", exception);
                }
            }
            this.g = null;
        }
        this.d();
    }

    private void d() {
        TXCLog.i("HardwareVideoDecoder", "uninitialize gl components");
        if (!this.e()) {
            return;
        }
        if (this.p != null) {
            this.p.a();
            this.p.b();
            this.p = null;
        }
        if (this.q != null) {
            this.q.a();
            this.q = null;
        }
        if (this.o != null) {
            this.o.release();
            this.o = null;
        }
        if (this.n != null) {
            this.n.release();
            this.n = null;
        }
        OpenGlUtils.deleteTexture(this.m);
        this.m = -1;
        try {
            if (this.l != null) {
                this.l.b();
                this.l.e();
            }
        }
        catch (d d2) {
            TXCLog.e("HardwareVideoDecoder", "destroy EGLCore failed.", d2);
        }
        this.l = null;
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.a(com.tencent.liteav.videoengine.decoder.l.a(this, surfaceTexture));
    }

    private boolean e() {
        try {
            if (this.l != null) {
                this.l.a();
            }
            return true;
        }
        catch (d d2) {
            TXCLog.e("HardwareVideoDecoder", "makeCurrent failed.", d2);
            return false;
        }
    }

    private void a(com.tencent.liteav.videobase.f.e e2, String string, String string2, Object ... objectArray) {
        this.d.b(e2, string, string2, objectArray);
        if (this.h != null) {
            this.h.onDecodeFailed(e2);
        }
    }

    private void a(Runnable runnable) {
        if (Looper.myLooper() == this.c.getLooper()) {
            runnable.run();
        } else {
            this.c.post(runnable);
        }
    }

    static /* synthetic */ void a(h h2, SurfaceTexture surfaceTexture) {
        if (h2.n == null) {
            return;
        }
        h2.e();
        surfaceTexture.updateTexImage();
        surfaceTexture.getTransformMatrix(h2.b.getMatrix());
        c.a a2 = h2.p.a(h2.a.a, h2.a.b);
        h2.q.a(h2.b, a.a.b, a2);
        GLES20.glFinish();
        h2.k = true;
        PixelFrame pixelFrame = a2.c().a(h2.l.d());
        pixelFrame.setTimestamp(surfaceTexture.getTimestamp() / 1000L);
        h2.h.onDecodeFrame(pixelFrame, surfaceTexture.getTimestamp() / 1000L);
        pixelFrame.release();
        h2.p.a(a2);
    }

    static /* synthetic */ void a(h h2, com.tencent.liteav.videobase.e.b b2) {
        h2.a(b2);
    }

    static /* synthetic */ void a(h h2, Object object, o o2) {
        h2.a(object, o2);
    }

    static /* synthetic */ void a(h h2) {
        h2.c();
    }
}

