/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp;

import android.content.Context;
import android.util.Log;
import com.tencent.liteav.TXLiteAVExternalDecoderFactoryInterface;
import com.tencent.liteav.basic.datareport.TXCDRApi;
import com.tencent.liteav.basic.license.LicenceCheck;
import com.tencent.liteav.basic.license.f;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCCommonUtil;
import com.tencent.liteav.basic.util.h;
import com.tencent.liteav.p;
import com.tencent.rtmp.TXLiveBaseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class TXLiveBase {
    private static final String TAG = "TXLiveBase";
    private static TXLiveBaseListener listener = null;
    private static TXLiveBase instance = new TXLiveBase();
    private static boolean sHasLoadedLibrary;
    private static final String FILE_MD5_LITEAV_ARM = "___md5_libliteavsdk_arm_md5_____";
    private static final String FILE_MD5_SATURN_ARM = "___md5_libsaturn_arm_md5________";
    private static final String FILE_MD5_FFMPEG_ARM = "___md5_libtxffmpeg_arm_md5______";
    private static final String FILE_MD5_TRAE_ARM = "___md5_libtraeimp_arm_md5_______";
    private static final String FILE_MD5_LITEAV_V7A = "___md5_libliteavsdk_v7a_md5_____";
    private static final String FILE_MD5_SATURN_V7A = "___md5_libsaturn_v7a_md5________";
    private static final String FILE_MD5_FFMPEG_V7A = "___md5_libtxffmpeg_v7a_md5______";
    private static final String FILE_MD5_TRAE_V7A = "___md5_libtraeimp_v7a_md5_______";
    private static final String FILE_MD5_LITEAV_V64 = "___md5_libliteavsdk_v64_md5_____";
    private static final String FILE_MD5_SATURN_V64 = "___md5_libsaturn_v64_md5________";
    private static final String FILE_MD5_FFMPEG_V64 = "___md5_libtxffmpeg_v64_md5______";
    private static final String FILE_MD5_TRAE_V64 = "___md5_libtraeimp_v64_md5_______";

    private TXLiveBase() {
    }

    public static TXLiveBase getInstance() {
        return instance;
    }

    public void setLicence(Context context, String url, String key) {
        LicenceCheck.a().a(context, url, key);
    }

    public String getLicenceInfo(Context context) {
        f f2 = new f();
        LicenceCheck.a().a(f2, context);
        return f2.a;
    }

    public static void setListener(TXLiveBaseListener liveBaseListener) {
        TXCLog.setListener(new b());
        LicenceCheck.a().a(new a());
        listener = liveBaseListener;
    }

    public static int setGlobalEnv(String envConfig) {
        return TXCCommonUtil.setGlobalEnv(envConfig);
    }

    public static void setLogLevel(int logLevel) {
        TXCLog.setLevel(logLevel);
    }

    public static void setConsoleEnabled(boolean enabled) {
        TXCLog.setConsoleEnabled(enabled);
    }

    public static void setAppVersion(String verNum) {
        TXCDRApi.txSetAppVersion(verNum);
        TXCCommonUtil.setAppVersion(verNum);
    }

    public static void setLibraryPath(String path) {
        Log.i((String)TAG, (String)("setLibraryPath " + path));
        h.b(path);
    }

    public static boolean isLibraryPathValid(String path) {
        String string = TXLiveBase.getFileMD5(path, "libliteavsdk.so");
        String string2 = TXLiveBase.getFileMD5(path, "libsaturn.so");
        String string3 = TXLiveBase.getFileMD5(path, "libtxffmpeg.so");
        String string4 = TXLiveBase.getFileMD5(path, "libtraeimp-rtmp.so");
        Log.e((String)TAG, (String)("MD5-CHECK-V64 libliteavsdk = " + string + " FILE_MD5_LITEAV_V64 = " + FILE_MD5_LITEAV_V64));
        Log.e((String)TAG, (String)("MD5-CHECK-V64 libsaturn    = " + string2 + " FILE_MD5_SATURN_V64 = " + FILE_MD5_SATURN_V64));
        Log.e((String)TAG, (String)("MD5-CHECK-V64 libtxffmpeg  = " + string3 + " FILE_MD5_FFMPEG_V64 = " + FILE_MD5_FFMPEG_V64));
        Log.e((String)TAG, (String)("MD5-CHECK-V64 libtraeimpl  = " + string4 + " FILE_MD5_TRAE_V64   = " + FILE_MD5_TRAE_V64));
        if (string != null && string.equalsIgnoreCase(FILE_MD5_LITEAV_V64) && string2 != null && string2.equalsIgnoreCase(FILE_MD5_SATURN_V64) && string3 != null && string3.equalsIgnoreCase(FILE_MD5_FFMPEG_V64) && string4 != null && string4.equalsIgnoreCase(FILE_MD5_TRAE_V64)) {
            return true;
        }
        Log.e((String)TAG, (String)("MD5-CHECK-V7A libliteavsdk = " + string + " FILE_MD5_LITEAV_V7A = " + FILE_MD5_LITEAV_V7A));
        Log.e((String)TAG, (String)("MD5-CHECK-V7A libsaturn    = " + string2 + " FILE_MD5_SATURN_V7A = " + FILE_MD5_SATURN_V7A));
        Log.e((String)TAG, (String)("MD5-CHECK-V7A libtxffmpeg  = " + string3 + " FILE_MD5_FFMPEG_V7A = " + FILE_MD5_FFMPEG_V7A));
        Log.e((String)TAG, (String)("MD5-CHECK-V7A libtraeimpl  = " + string4 + " FILE_MD5_TRAE_V7A   = " + FILE_MD5_TRAE_V7A));
        if (string != null && string.equalsIgnoreCase(FILE_MD5_LITEAV_V7A) && string2 != null && string2.equalsIgnoreCase(FILE_MD5_SATURN_V7A) && string3 != null && string3.equalsIgnoreCase(FILE_MD5_FFMPEG_V7A) && string4 != null && string4.equalsIgnoreCase(FILE_MD5_TRAE_V7A)) {
            return true;
        }
        Log.e((String)TAG, (String)("MD5-CHECK-ARM libliteavsdk = " + string + " FILE_MD5_LITEAV_ARM = " + FILE_MD5_LITEAV_ARM));
        Log.e((String)TAG, (String)("MD5-CHECK-ARM libsaturn    = " + string2 + " FILE_MD5_SATURN_ARM = " + FILE_MD5_SATURN_ARM));
        Log.e((String)TAG, (String)("MD5-CHECK-ARM libtxffmpeg  = " + string3 + " FILE_MD5_FFMPEG_ARM = " + FILE_MD5_FFMPEG_ARM));
        Log.e((String)TAG, (String)("MD5-CHECK-ARM libtraeimpl  = " + string4 + " FILE_MD5_TRAE_ARM   = " + FILE_MD5_TRAE_ARM));
        return string != null && string.equalsIgnoreCase(FILE_MD5_LITEAV_ARM) && string2 != null && string2.equalsIgnoreCase(FILE_MD5_SATURN_ARM) && string3 != null && string3.equalsIgnoreCase(FILE_MD5_FFMPEG_ARM) && string4 != null && string4.equalsIgnoreCase(FILE_MD5_TRAE_ARM);
    }

    public static void setExternalDecoderFactory(TXLiteAVExternalDecoderFactoryInterface decoderFactory) {
        TXCLog.i(TAG, "setExternalDecoderFactory decoderFactory = " + decoderFactory);
        com.tencent.liteav.basic.a.a(decoderFactory);
    }

    public static String getSDKVersionStr() {
        return TXCCommonUtil.getSDKVersionStr();
    }

    public static void setPituLicencePath(String path) {
        TXCCommonUtil.setPituLicencePath(path);
    }

    public static String getPituSDKVersion() {
        return p.a();
    }

    public static void setAppID(String appID) {
        TXCCommonUtil.setAppID(appID);
    }

    private static String getFileMD5(String filePath, String fileName) {
        File file = new File(filePath, fileName);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        MessageDigest messageDigest = null;
        byte[] byArray = new byte[1024];
        int n2 = 0;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            FileInputStream fileInputStream = new FileInputStream(file);
            while ((n2 = fileInputStream.read(byArray, 0, 1024)) != -1) {
                messageDigest.update(byArray, 0, n2);
            }
            fileInputStream.close();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        BigInteger bigInteger = new BigInteger(1, messageDigest.digest());
        return bigInteger.toString(16);
    }

    public static void setUserId(String userId) {
        TXCCommonUtil.setUserId(userId);
    }

    public static int updateNetworkTime() {
        if (!sHasLoadedLibrary) {
            h.d();
            TXLiveBase.nativeClassInit();
            sHasLoadedLibrary = true;
        }
        return TXLiveBase.nativeUpdateNetworkTime();
    }

    public static long getNetworkTimestamp() {
        if (!sHasLoadedLibrary) {
            return 0L;
        }
        return TXLiveBase.nativeGetNetworkTimestamp();
    }

    public static void onUpdateNetworkTime(int errCode, String errMsg) {
        TXLiveBaseListener tXLiveBaseListener = listener;
        if (tXLiveBaseListener != null) {
            tXLiveBaseListener.onUpdateNetworkTime(errCode, errMsg);
        }
    }

    private static native void nativeClassInit();

    private static native int nativeUpdateNetworkTime();

    private static native long nativeGetNetworkTimestamp();

    public static boolean setExtID(String extKey, String extValue) {
        return TXCCommonUtil.setExtID(extKey, extValue);
    }

    private static class a
    implements LicenceCheck.a {
        private a() {
        }

        @Override
        public void a(int n2, String string) {
            TXLiveBaseListener tXLiveBaseListener = listener;
            if (tXLiveBaseListener != null) {
                tXLiveBaseListener.onLicenceLoaded(n2, string);
            }
        }
    }

    private static class b
    implements TXCLog.a {
        private b() {
        }

        @Override
        public void a(int n2, String string, String string2) {
            TXLiveBaseListener tXLiveBaseListener = listener;
            if (tXLiveBaseListener != null) {
                tXLiveBaseListener.onLog(n2, string, string2);
            }
        }
    }
}

