/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.basic.log;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.liteav.basic.util.TXCCommonUtil;
import com.tencent.liteav.basic.util.h;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

public class TXCLog {
    public static final int LOG_VERBOSE = 0;
    public static final int LOG_DEBUG = 1;
    public static final int LOG_INFO = 2;
    public static final int LOG_WARNING = 3;
    public static final int LOG_ERROR = 4;
    public static final int LOG_FATAL = 5;
    public static final int LOG_NONE = 6;
    public static final int LOG_ASYNC = 0;
    public static final int LOG_SYNC = 1;
    public static String mLogDir = "";
    private static String mLogCacheDir = "";
    private static boolean mEnableCompress = true;
    private static final Object mLogLock = new Object();
    private static boolean mHasInit = false;
    private static a mListener = null;
    private static int mLogLevel = 0;
    private static boolean mEnableConsole = true;
    private static boolean mEnableCallback = false;
    private static boolean mEnableLogToFile = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean init() {
        if (mHasInit) {
            return true;
        }
        Object object = mLogLock;
        synchronized (object) {
            if (mHasInit) {
                return true;
            }
            boolean bl = h.d();
            Context context = TXCCommonUtil.getAppContext();
            if (bl && context != null) {
                File file;
                if (TextUtils.isEmpty((CharSequence)mLogDir) && (file = context.getExternalFilesDir(null)) != null) {
                    mLogDir = file.getAbsolutePath() + "/log/liteav";
                }
                mLogCacheDir = context.getFilesDir().getAbsolutePath() + "/log/liteav";
                Log.i((String)"TXCLog", (String)("TXCLog init log file path : " + mLogDir + ", cache : " + mLogCacheDir));
                TXCLog.nativeLogInit();
                TXCLog.nativeLogSetLevel(mLogLevel);
                TXCLog.nativeLogSetConsole(mEnableConsole);
                TXCLog.nativeLogOpen(0, mLogDir, mLogCacheDir, "LiteAV", mEnableCompress);
                TXCLog.nativeEnableCallback(mEnableCallback);
                TXCLog.nativeLogToFileEnabled(mEnableLogToFile);
                mHasInit = true;
            }
        }
        return mHasInit;
    }

    public static void log(int level, String tag, String msg) {
        if (TXCLog.init()) {
            TXCLog.nativeLog(level, tag, "", 0, "", msg);
        }
        TXCLog.log_callback(level, tag, msg);
    }

    public static void setLevel(int level) {
        mLogLevel = level;
        if (mHasInit) {
            TXCLog.nativeLogSetLevel(mLogLevel);
        }
    }

    public static void setLogDirPath(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        if (!path.equalsIgnoreCase(mLogDir)) {
            mLogDir = path;
            if (mHasInit) {
                Log.i((String)"TXCLog", (String)("TXCLog setLogDirPath " + path));
                TXCLog.nativeLogClose();
                TXCLog.nativeLogOpen(0, mLogDir, mLogCacheDir, "LiteAV", mEnableCompress);
            }
        }
    }

    public static void sliceLogFile() {
        if (mHasInit) {
            Log.i((String)"TXCLog", (String)"TXCLog sliceLogFile");
            TXCLog.nativeLogOpen(0, mLogDir, mLogCacheDir, "LiteAV", mEnableCompress);
        }
    }

    public static void copyLogFile() {
        if (mHasInit) {
            Log.i((String)"TXCLog", (String)"TXCLog copyLogFile");
            TXCLog.nativeLogOpen(0, mLogDir, mLogCacheDir, "LiteAV", mEnableCompress);
        }
    }

    public static void setLogCompressEnabled(boolean enable) {
        if (mEnableCompress != enable) {
            mEnableCompress = enable;
            if (mHasInit) {
                TXCLog.nativeLogClose();
                TXCLog.nativeLogOpen(0, mLogDir, mLogCacheDir, "LiteAV", mEnableCompress);
            }
        }
    }

    public static void setConsoleEnabled(boolean enabled) {
        mEnableConsole = enabled;
        if (mHasInit) {
            TXCLog.nativeLogSetConsole(mEnableConsole);
        }
    }

    public static void setLogToFileEnabled(boolean enabled) {
        mEnableLogToFile = enabled;
        if (mHasInit) {
            TXCLog.nativeLogToFileEnabled(enabled);
        }
    }

    public static void setListener(a listener) {
        mListener = listener;
        boolean bl = mEnableCallback = mListener != null;
        if (mHasInit) {
            TXCLog.nativeEnableCallback(mEnableCallback);
        }
    }

    public static void v(String tag, String format, Object ... args) {
        TXCLog.log(0, tag, String.format(format, args));
    }

    public static void d(String tag, String format, Object ... args) {
        TXCLog.log(1, tag, String.format(format, args));
    }

    public static void i(String tag, String format, Object ... args) {
        TXCLog.log(2, tag, String.format(format, args));
    }

    public static void w(String tag, String format, Object ... args) {
        TXCLog.log(3, tag, String.format(format, args));
    }

    public static void e(String tag, String format, Object ... args) {
        TXCLog.log(4, tag, String.format(format, args));
    }

    public static void v(String tag, String msg) {
        TXCLog.log(0, tag, msg);
    }

    public static void d(String tag, String msg) {
        TXCLog.log(1, tag, msg);
    }

    public static void i(String tag, String msg) {
        TXCLog.log(2, tag, msg);
    }

    public static void w(String tag, String msg) {
        TXCLog.log(3, tag, msg);
    }

    public static void e(String tag, String msg) {
        TXCLog.log(4, tag, msg);
    }

    public static void e(String tag, String text, Throwable ex) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ex.printStackTrace(printWriter);
        for (Throwable throwable = ex.getCause(); throwable != null; throwable = throwable.getCause()) {
            throwable.printStackTrace(printWriter);
        }
        printWriter.close();
        TXCLog.e(tag, text + "\n" + ((Object)stringWriter).toString());
    }

    private static void log_callback(int level, String tag, String msg) {
        if (mListener != null) {
            mListener.a(level, tag, msg);
        }
    }

    private static native void nativeLogInit();

    private static native void nativeLog(int var0, String var1, String var2, int var3, String var4, String var5);

    private static native void nativeLogSetLevel(int var0);

    private static native void nativeLogSetConsole(boolean var0);

    private static native void nativeLogOpen(int var0, String var1, String var2, String var3, boolean var4);

    private static native void nativeLogClose();

    private static native void nativeEnableCallback(boolean var0);

    private static native void nativeLogToFileEnabled(boolean var0);

    public static interface a {
        public void a(int var1, String var2, String var3);
    }
}

