/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtc.impl;

import android.opengl.GLES20;
import android.os.HandlerThread;
import android.os.SystemClock;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.opengl.i;
import com.tencent.liteav.basic.opengl.j;
import com.tencent.liteav.basic.util.TXCBuild;
import com.tencent.liteav.basic.util.c;
import com.tencent.liteav.beauty.b.k;
import com.tencent.liteav.d;
import com.tencent.trtc.TRTCCloudDef;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class TRTCCustomTextureUtil {
    private static final String TAG = "TRTCCustomTextureUtil";
    private final c mFpsMeter;
    private i mGLThreadHandler = null;
    private HandlerThread mEGLThread = null;
    private Object mEGLContext = null;
    private long mLastGLThreadId;
    private j mRotateFilter;
    private k mI4202RGBAFilter = null;
    private d mCaptureAndEnc;
    private long mLastCaptureCalculateTS = 0L;
    private long mCaptureFrameCount = 0L;
    private long mLastCaptureFrameCount = 0L;
    private double mCurrentFps = 0.0;
    private int mGLSyncMode = 0;

    public TRTCCustomTextureUtil(d captureAndEnc, int glSyncMode) {
        this.mCaptureAndEnc = captureAndEnc;
        this.mFpsMeter = new c("send-custom-texture", (int)TimeUnit.SECONDS.toMillis(5L));
        this.mGLSyncMode = glSyncMode;
        this.apiLog("TRTCCustomTextureUtil: glMode:" + glSyncMode);
    }

    public void release() {
        this.stopThread();
    }

    public void sendCustomTexture(TRTCCloudDef.TRTCVideoFrame frame) {
        this.mFpsMeter.a();
        this.checkEGLContext(frame);
        this.sendCustomTextureInternal(frame);
        if (this.mLastCaptureCalculateTS == 0L) {
            this.mLastCaptureCalculateTS = SystemClock.elapsedRealtime();
            this.mLastCaptureFrameCount = 0L;
            this.mCaptureFrameCount = 0L;
        } else {
            ++this.mCaptureFrameCount;
        }
    }

    public double getCurrentFPS() {
        long l2 = SystemClock.elapsedRealtime();
        long l3 = l2 - this.mLastCaptureCalculateTS;
        if (l3 >= 1000L) {
            this.mCurrentFps = (double)(this.mCaptureFrameCount - this.mLastCaptureFrameCount) * 1000.0 / (double)l3;
            this.mLastCaptureFrameCount = this.mCaptureFrameCount;
            this.mLastCaptureCalculateTS = l2;
        }
        return this.mCurrentFps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCustomTextureInternal(final TRTCCloudDef.TRTCVideoFrame frame) {
        TRTCCustomTextureUtil tRTCCustomTextureUtil = this;
        synchronized (tRTCCustomTextureUtil) {
            if (this.mGLThreadHandler != null) {
                if (this.mGLSyncMode == 0) {
                    GLES20.glFinish();
                }
                final i i2 = this.mGLThreadHandler;
                this.mGLThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        i2.d();
                        if (i2.d) {
                            if (frame.texture != null) {
                                frame.texture.textureId = TRTCCustomTextureUtil.this.checkRotate(frame.texture.textureId, frame);
                                if (i2.e != null) {
                                    if (TRTCCustomTextureUtil.this.mGLSyncMode == 0) {
                                        TRTCCustomTextureUtil.this.mCaptureAndEnc.b(frame.texture.textureId, frame.width, frame.height, i2.e.f(), frame.timestamp);
                                    } else {
                                        TRTCCustomTextureUtil.this.mCaptureAndEnc.a(frame.texture.textureId, frame.width, frame.height, (Object)i2.e.f(), frame.timestamp);
                                    }
                                }
                            }
                        } else if (frame.texture != null) {
                            frame.texture.textureId = TRTCCustomTextureUtil.this.checkRotate(frame.texture.textureId, frame);
                            if (i2.g != null) {
                                if (TRTCCustomTextureUtil.this.mGLSyncMode == 0) {
                                    TRTCCustomTextureUtil.this.mCaptureAndEnc.b(frame.texture.textureId, frame.width, frame.height, i2.g.d(), frame.timestamp);
                                } else {
                                    TRTCCustomTextureUtil.this.mCaptureAndEnc.a(frame.texture.textureId, frame.width, frame.height, (Object)i2.g.d(), frame.timestamp);
                                }
                            }
                        } else {
                            k k2;
                            int n2 = 3;
                            if (frame.pixelFormat == 1) {
                                n2 = 1;
                            } else if (frame.pixelFormat == 4) {
                                n2 = 3;
                            }
                            if (TRTCCustomTextureUtil.this.mI4202RGBAFilter == null) {
                                k2 = new k(n2);
                                k2.a(true);
                                if (!k2.a()) {
                                    TXCLog.e(TRTCCustomTextureUtil.TAG, "mI4202RGBAFilter init failed!!, break init");
                                }
                                k2.a(frame.width, frame.height);
                                TRTCCustomTextureUtil.this.mI4202RGBAFilter = k2;
                            }
                            if ((k2 = TRTCCustomTextureUtil.this.mI4202RGBAFilter) != null) {
                                GLES20.glViewport((int)0, (int)0, (int)frame.width, (int)frame.height);
                                k2.a(frame.data);
                                int n3 = k2.r();
                                n3 = TRTCCustomTextureUtil.this.checkRotate(n3, frame);
                                if (i2.g != null) {
                                    if (TRTCCustomTextureUtil.this.mGLSyncMode == 0) {
                                        TRTCCustomTextureUtil.this.mCaptureAndEnc.b(n3, frame.width, frame.height, i2.g.d(), frame.timestamp);
                                    } else {
                                        TRTCCustomTextureUtil.this.mCaptureAndEnc.a(n3, frame.width, frame.height, (Object)i2.g.d(), frame.timestamp);
                                    }
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    private void checkEGLContext(TRTCCloudDef.TRTCVideoFrame frame) {
        if (frame == null) {
            return;
        }
        boolean bl = false;
        if (this.mLastGLThreadId == Thread.currentThread().getId()) {
            if (frame.texture != null) {
                if (frame.texture.eglContext10 != null) {
                    boolean bl2 = bl = !frame.texture.eglContext10.equals(this.mEGLContext);
                    if (bl) {
                        this.apiLog("CustomCapture egl10Context change!");
                    }
                }
                if (frame.texture.eglContext14 != null) {
                    boolean bl3 = bl = !frame.texture.eglContext14.equals(this.mEGLContext);
                    if (bl) {
                        this.apiLog("CustomCapture egl14Context change!");
                    }
                }
            }
        } else {
            bl = true;
            this.apiLog("CustomCapture eglContext's thread change!");
        }
        this.mLastGLThreadId = Thread.currentThread().getId();
        if (frame.texture != null) {
            this.mEGLContext = frame.texture.eglContext10 != null ? frame.texture.eglContext10 : frame.texture.eglContext14;
        }
        if (bl) {
            this.stopThread();
            this.startThread(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThread(TRTCCloudDef.TRTCVideoFrame frame) {
        if (frame == null) {
            return;
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        TRTCCustomTextureUtil tRTCCustomTextureUtil = this;
        synchronized (tRTCCustomTextureUtil) {
            if (this.mEGLThread == null) {
                this.mEGLThread = new HandlerThread("customCaptureGLThread");
                this.mEGLThread.start();
                this.mGLThreadHandler = new i(this.mEGLThread.getLooper());
                if (frame.texture == null) {
                    this.apiLog("CustomCapture buffer start egl10 thread");
                    this.mGLThreadHandler.d = false;
                    this.mGLThreadHandler.h = null;
                    this.mGLThreadHandler.a = 1280;
                    this.mGLThreadHandler.b = 720;
                    this.mGLThreadHandler.sendEmptyMessage(100);
                } else if (frame.texture.eglContext10 != null) {
                    this.apiLog("CustomCapture texture start egl10 thread");
                    this.mGLThreadHandler.d = false;
                    this.mGLThreadHandler.h = frame.texture.eglContext10;
                    this.mGLThreadHandler.a = 1280;
                    this.mGLThreadHandler.b = 720;
                    this.mGLThreadHandler.sendEmptyMessage(100);
                } else if (frame.texture.eglContext14 != null && TXCBuild.VersionInt() >= 17) {
                    this.apiLog("CustomCapture texture start egl14 thread");
                    this.mGLThreadHandler.d = true;
                    this.mGLThreadHandler.f = frame.texture.eglContext14;
                    this.mGLThreadHandler.a = 1280;
                    this.mGLThreadHandler.b = 720;
                    this.mGLThreadHandler.sendEmptyMessage(100);
                }
                this.mGLThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        TXCLog.i(TRTCCustomTextureUtil.TAG, "GLContext create finished!");
                        countDownLatch.countDown();
                    }
                });
            } else {
                countDownLatch.countDown();
            }
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private synchronized void stopThread() {
        if (this.mGLThreadHandler != null) {
            final j j2 = this.mRotateFilter;
            this.mRotateFilter = null;
            final k k2 = this.mI4202RGBAFilter;
            this.mI4202RGBAFilter = null;
            this.mGLThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (j2 != null) {
                        j2.d();
                    }
                    if (k2 != null) {
                        k2.d();
                    }
                    if (TRTCCustomTextureUtil.this.mCaptureAndEnc != null) {
                        TRTCCustomTextureUtil.this.apiLog("CustomCapture release");
                        TRTCCustomTextureUtil.this.mCaptureAndEnc.s();
                    }
                }
            });
            i.a(this.mGLThreadHandler, this.mEGLThread);
            this.apiLog("CustomCapture destroy egl thread");
        }
        this.mGLThreadHandler = null;
        this.mEGLThread = null;
    }

    private void apiLog(String api) {
        TXCLog.i(TAG, "trtc_api " + api);
    }

    private int checkRotate(int textureId, TRTCCloudDef.TRTCVideoFrame frame) {
        if (frame == null || frame.rotation == 0) {
            return textureId;
        }
        int n2 = frame.rotation * 90;
        if (this.mRotateFilter == null) {
            j j2 = new j();
            j2.a();
            j2.a(true);
            j2.a(frame.width, frame.height);
            this.mRotateFilter = j2;
        }
        int n3 = textureId;
        j j3 = this.mRotateFilter;
        if (j3 != null) {
            GLES20.glViewport((int)0, (int)0, (int)frame.width, (int)frame.height);
            int n4 = (720 - n2) % 360;
            j3.a(frame.width, frame.height);
            j3.a(frame.width, frame.height, n4, null, (float)frame.width / (float)frame.height, false, false);
            j3.b(n3);
            n3 = j3.l();
            int n5 = n4 == 90 || n4 == 270 ? frame.height : frame.width;
            int n6 = n4 == 90 || n4 == 270 ? frame.width : frame.height;
            frame.width = n5;
            frame.height = n6;
        }
        return n3;
    }
}

