/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.sharp.jni;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import com.tencent.liteav.basic.util.TXCBuild;
import com.tencent.rtmp.sharp.jni.QLog;
import java.nio.ByteBuffer;

public class MediaCodecDecoder {
    private static final String TAG = "MediaCodecDecoder";
    private MediaCodec mAudioAACDecoder = null;
    private int mChannels = 2;
    private int mSampleRate = 44100;
    ByteBuffer mInputBuffer = null;
    ByteBuffer mOutputBuffer = null;
    private MediaCodec.BufferInfo mAACDecBufferInfo = null;
    private ByteBuffer mDecInBuffer = ByteBuffer.allocateDirect(16384);
    private ByteBuffer mDecOutBuffer = ByteBuffer.allocateDirect(16384);
    private byte[] mTempBufDec = new byte[16384];

    @SuppressLint(value={"NewApi"})
    public int createAACDecoder(int sampleRate, int channels) {
        try {
            this.mAudioAACDecoder = MediaCodec.createDecoderByType((String)"audio/mp4a-latm");
            MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channels);
            mediaFormat.setInteger("sample-rate", sampleRate);
            mediaFormat.setInteger("channel-count", channels);
            mediaFormat.setInteger("aac-profile", 2);
            byte[] byArray = new byte[]{17, -112};
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            mediaFormat.setByteBuffer("csd-0", byteBuffer);
            this.mAudioAACDecoder.configure(mediaFormat, null, null, 0);
            if (this.mAudioAACDecoder != null) {
                this.mAudioAACDecoder.start();
                this.mAACDecBufferInfo = new MediaCodec.BufferInfo();
                if (QLog.isColorLevel()) {
                    QLog.w(TAG, 2, "createAACDecoder succeed!!! : (" + sampleRate + ", " + channels + ")");
                }
            }
            return 0;
        }
        catch (Exception exception) {
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 2, "Error when creating aac decode stream");
            }
            return -1;
        }
    }

    public int decodeAACFrame(int nLength) {
        this.mDecInBuffer.get(this.mTempBufDec, 0, nLength);
        int n2 = this.decodeInternalAACFrame(nLength);
        this.mDecOutBuffer.rewind();
        if (n2 > 0) {
            this.mDecOutBuffer.put(this.mTempBufDec, 0, n2);
        } else {
            n2 = 0;
        }
        return n2;
    }

    @SuppressLint(value={"NewApi"})
    public int decodeInternalAACFrame(int nLength) {
        while (true) {
            int n2 = 0;
            try {
                int n3 = 0;
                n3 = this.mAudioAACDecoder.dequeueInputBuffer(200L);
                if (n3 >= 0) {
                    this.mInputBuffer = TXCBuild.VersionInt() >= 21 ? this.mAudioAACDecoder.getInputBuffer(n3) : this.mAudioAACDecoder.getInputBuffers()[n3];
                    this.mInputBuffer.clear();
                    this.mInputBuffer.put(this.mTempBufDec, 0, nLength);
                    this.mDecInBuffer.rewind();
                    this.mAudioAACDecoder.queueInputBuffer(n3, 0, nLength, 0L, 0);
                }
                int n4 = this.mAudioAACDecoder.dequeueOutputBuffer(this.mAACDecBufferInfo, 10000L);
                n2 = 0;
                if (n4 < 0) break;
                this.mOutputBuffer = TXCBuild.VersionInt() >= 21 ? this.mAudioAACDecoder.getOutputBuffer(n4) : this.mAudioAACDecoder.getOutputBuffers()[n4];
                n2 = this.mAACDecBufferInfo.size;
                try {
                    this.mOutputBuffer.limit(n2);
                    this.mOutputBuffer.get(this.mTempBufDec, 0, n2);
                    this.mOutputBuffer.position(0);
                    this.mAudioAACDecoder.releaseOutputBuffer(n4, false);
                    return n2;
                }
                catch (Exception exception) {
                    if (!QLog.isColorLevel()) continue;
                    QLog.e("TRAE", 2, "Error when decoding aac stream");
                }
            }
            catch (Exception exception) {
                n2 = 0;
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, "decode failed.");
                }
                return n2;
            }
        }
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    public int releaseAACDecoder() {
        block5: {
            try {
                if (this.mAudioAACDecoder != null) {
                    this.mAudioAACDecoder.stop();
                    this.mAudioAACDecoder.release();
                    this.mAudioAACDecoder = null;
                    if (QLog.isColorLevel()) {
                        QLog.w(TAG, 2, "releaseAACDecoder, release aac decode stream succeed!!");
                    }
                    return 0;
                }
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block5;
                QLog.e("TRAE", 2, "release aac decoder failed.");
            }
        }
        if (QLog.isColorLevel()) {
            QLog.e("TRAE", 2, "releaseAACDecoder, Error when releasing aac decode stream");
        }
        return -1;
    }
}

