/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCCommonUtil;

public class TXCAudioSettings {
    private static final String TAG = "TXCAudioSettings";
    public static final String TIMESTAMP_ROLLBACK_TO_STABLE_SAMPLERATE = "timestamp_rollback_to_stable_samplerate";
    private static final String AUDIO_SETTINGS = "txc_audio_settings";
    private final SharedPreferences mSharedPreferences;

    public static TXCAudioSettings getInstance() {
        return a.a;
    }

    private TXCAudioSettings() {
        Context context = TXCCommonUtil.getAppContext();
        if (context != null) {
            this.mSharedPreferences = context.getSharedPreferences(AUDIO_SETTINGS, 0);
        } else {
            this.mSharedPreferences = null;
            TXCLog.e(TAG, "context is null, getSharedPreferences failed.");
        }
    }

    public void setLong(String key, long value) {
        this.set(key, value);
    }

    public long getLong(String key, long defaultValue) {
        return (Long)this.get(key, defaultValue);
    }

    @SuppressLint(value={"ApplySharedPref"})
    private void set(String key, Object value) {
        if (this.mSharedPreferences == null) {
            TXCLog.e(TAG, "getSharedPreferences is null");
            return;
        }
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        if (value instanceof Integer) {
            editor.putInt(key, ((Integer)value).intValue());
        } else if (value instanceof String) {
            editor.putString(key, value.toString());
        } else if (value instanceof Boolean) {
            editor.putBoolean(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            editor.putLong(key, ((Long)value).longValue());
        } else if (value instanceof Float) {
            editor.putFloat(key, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            editor.putLong(key, Double.doubleToRawLongBits((Double)value));
        }
        editor.commit();
    }

    private Object get(String key, Object defaultValue) {
        if (this.mSharedPreferences == null) {
            TXCLog.e(TAG, "getSharedPreferences is null");
            return defaultValue;
        }
        try {
            if (defaultValue instanceof String) {
                return this.mSharedPreferences.getString(key, defaultValue.toString());
            }
            if (defaultValue instanceof Integer) {
                return this.mSharedPreferences.getInt(key, ((Integer)defaultValue).intValue());
            }
            if (defaultValue instanceof Boolean) {
                return this.mSharedPreferences.getBoolean(key, ((Boolean)defaultValue).booleanValue());
            }
            if (defaultValue instanceof Long) {
                return this.mSharedPreferences.getLong(key, ((Long)defaultValue).longValue());
            }
            if (defaultValue instanceof Float) {
                return Float.valueOf(this.mSharedPreferences.getFloat(key, ((Float)defaultValue).floatValue()));
            }
            if (defaultValue instanceof Double) {
                return Double.longBitsToDouble(this.mSharedPreferences.getLong(key, Double.doubleToLongBits((Double)defaultValue)));
            }
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "get value from sharedpreference failed for key: %s", key, exception);
            return defaultValue;
        }
        return defaultValue;
    }

    private static class a {
        private static final TXCAudioSettings a = new TXCAudioSettings();
    }
}

