/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.basic.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.DhcpInfo;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCBuild;
import com.tencent.liteav.basic.util.d;
import com.tencent.liteav.basic.util.h;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class TXCCommonUtil {
    private static final String TAG = "TXCCommonUtil";
    private static String mAppID = "";
    private static String mStrAppVersion = "";
    public static String pituLicencePath = "YTFaceSDK.licence";
    private static Context sApplicationContext = null;
    private static String mUserId = "";
    private static Map<String, String> mExtIDMap = null;

    public static int[] getSDKVersion() {
        String string = TXCCommonUtil.nativeGetSDKVersion();
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                nArray[i2] = Integer.parseInt(stringArray[i2]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                TXCLog.e(TAG, "parse version failed.", numberFormatException);
                nArray[i2] = 0;
            }
        }
        return nArray;
    }

    public static String getSDKVersionStr() {
        return TXCCommonUtil.nativeGetSDKVersion();
    }

    public static int getSDKID() {
        return TXCCommonUtil.nativeGetSDKID();
    }

    public static String getConfigCenterKey() {
        return TXCCommonUtil.nativeGetConfigCenterKey();
    }

    public static String getFileExtension(String filename) {
        int n2;
        String string = null;
        if (filename != null && filename.length() > 0 && (n2 = filename.lastIndexOf(46)) > -1 && n2 < filename.length() - 1) {
            string = filename.substring(n2 + 1);
        }
        return string;
    }

    public static void setAppContext(Context context) {
        if (context == null) {
            return;
        }
        sApplicationContext = context.getApplicationContext();
    }

    public static Context getAppContext() {
        return sApplicationContext;
    }

    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getStreamIDByStreamUrl(String strStreamUrl) {
        if (strStreamUrl == null || strStreamUrl.length() == 0) {
            return null;
        }
        String string = strStreamUrl;
        int n2 = string.indexOf("?");
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        n2 = string.lastIndexOf("/");
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        n2 = string.indexOf(".");
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    public static String getAppNameByStreamUrl(String strStreamUrl) {
        if (strStreamUrl == null || strStreamUrl.length() == 0) {
            return null;
        }
        String string = strStreamUrl;
        int n2 = string.indexOf("?");
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        n2 = string.lastIndexOf("/");
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        n2 = string.lastIndexOf("/");
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    public static void setAppVersion(String appVersion) {
        mStrAppVersion = appVersion;
    }

    public static void setPituLicencePath(String path) {
        pituLicencePath = path;
    }

    public static String getAppVersion() {
        return mStrAppVersion;
    }

    public static void setAppID(String appID) {
        mAppID = appID;
    }

    public static String getAppID() {
        return mAppID;
    }

    public static String getUserId() {
        return mUserId;
    }

    public static void setUserId(String userId) {
        mUserId = userId;
    }

    public static String getMD5(String sourceStr) {
        try {
            String string = "";
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(sourceStr.getBytes());
            byte[] byArray = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer("");
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                int n2 = byArray[i2];
                if (n2 < 0) {
                    n2 += 256;
                }
                if (n2 < 16) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toHexString(n2));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return sourceStr;
        }
    }

    public static byte[] getMD5(byte[] src) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(src);
            return messageDigest.digest();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void saveString(String key, String toSave) {
        Context context = sApplicationContext;
        if (context == null) {
            return;
        }
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences("TXCCommonConfig", 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(key, toSave);
            editor.commit();
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "save string failed", exception);
        }
    }

    public static String loadString(String key) {
        Context context = sApplicationContext;
        if (context == null) {
            return "";
        }
        String string = "";
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences("TXCCommonConfig", 0);
            string = sharedPreferences.getString(key, "");
        }
        catch (Exception exception) {
            string = "";
            TXCLog.e(TAG, "load string failed.", exception);
        }
        return string;
    }

    public static void saveUInt64(String key, long value) {
        Context context = sApplicationContext;
        if (context == null) {
            return;
        }
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences("TXCCommonConfig", 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putLong(key, value);
            editor.commit();
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "save uint64 failed.", exception);
        }
    }

    public static long loadUInt64(String key) {
        Context context = sApplicationContext;
        if (context == null) {
            return 0L;
        }
        long l2 = 0L;
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences("TXCCommonConfig", 0);
            l2 = sharedPreferences.getLong(key, 0L);
        }
        catch (Exception exception) {
            l2 = 0L;
            TXCLog.e(TAG, "load uint64 failed.", exception);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(ArrayList<String> files, String zipFileName) {
        File file = new File(zipFileName);
        InputStream inputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            zipOutputStream.setComment("LiteAV log");
            for (String string : files) {
                File file2 = new File(string);
                try {
                    if (file2.length() == 0L || file2.length() > 0x800000L) continue;
                    inputStream = new FileInputStream(file2);
                    zipOutputStream.putNextEntry(new ZipEntry(file2.getName()));
                    byte[] byArray = new byte[8192];
                    int n2 = 0;
                    while ((n2 = inputStream.read(byArray)) != -1) {
                        zipOutputStream.write(byArray, 0, n2);
                    }
                }
                catch (Exception exception) {
                    TXCLog.e(TAG, "zip failed.", exception);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            TXCLog.w(TAG, "zip log error");
        }
        finally {
            try {
                zipOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String getLogUploadPath() {
        if (sApplicationContext == null) {
            return "";
        }
        File file = sApplicationContext.getExternalFilesDir(null);
        if (file == null) {
            return "";
        }
        String string = file.getAbsolutePath() + "/log/liteav";
        return string;
    }

    public static int getGateway() {
        if (sApplicationContext == null) {
            return 0;
        }
        int n2 = 0;
        try {
            WifiManager wifiManager = (WifiManager)sApplicationContext.getSystemService("wifi");
            DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
            n2 = dhcpInfo.gateway;
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "getGateway error ", exception);
            n2 = 0;
        }
        return n2;
    }

    public static boolean equals(Object a2, Object b2) {
        return a2 == b2 || a2 != null && a2.equals(b2);
    }

    public static String getAppPackageName() {
        return h.c(sApplicationContext);
    }

    public static String getAppFilePath() {
        File file;
        String string = "/sdcard/liteav";
        if (sApplicationContext != null) {
            string = sApplicationContext.getFilesDir().getAbsolutePath();
        }
        if (!(file = new File(string)).exists()) {
            file.mkdirs();
        }
        return string;
    }

    public static String tryEncodeUrl(String url) {
        try {
            if (TXCCommonUtil.isUrlEncoded(url)) {
                TXCLog.w(TAG, "URL has been encoded");
                return url;
            }
            byte[] byArray = url.getBytes("UTF-8");
            StringBuilder stringBuilder = new StringBuilder(byArray.length);
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                int n2;
                int n3 = n2 = byArray[i2] < 0 ? byArray[i2] + 256 : byArray[i2];
                if (n2 <= 32 || n2 >= 127 || n2 == 34 || n2 == 37 || n2 == 60 || n2 == 62 || n2 == 91 || n2 == 125 || n2 == 92 || n2 == 93 || n2 == 94 || n2 == 96 || n2 == 123 || n2 == 124) {
                    stringBuilder.append(String.format("%%%02X", n2));
                    continue;
                }
                stringBuilder.append((char)n2);
            }
            url = stringBuilder.toString();
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "tryEncodeUrl failed.", exception);
        }
        return url;
    }

    public static boolean isUrlEncoded(String url) {
        if (url == null) {
            return true;
        }
        try {
            String string = URLDecoder.decode(url, "UTF-8");
            string = string.replace("+", " ");
            String string2 = url.replace("+", " ");
            return !string2.equals(string);
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "isUrlEncoded error : ", exception);
            return false;
        }
    }

    public static int setGlobalEnv(String envConfig) {
        return TXCCommonUtil.nativeSetGlobalEnv(envConfig);
    }

    public static int setSocks5Proxy(String host, int port, String username, String password) {
        return TXCCommonUtil.nativeSetSocks5Proxy(host, port, username, password);
    }

    public static String getCurEnvServerConfigUrl() {
        return TXCCommonUtil.nativeGetCurEnvServerConfigUrl();
    }

    public static String getCurEnvProxyDomain() {
        return TXCCommonUtil.nativeGetCurEnvProxyDomain();
    }

    public static int getCurEnvProxySDKAppId() {
        return TXCCommonUtil.nativeGetCurEnvProxySDKAppId();
    }

    private static native String nativeGetSDKVersion();

    private static native int nativeGetSDKID();

    private static native String nativeGetConfigCenterKey();

    private static native String nativeGetCurEnvServerConfigUrl();

    private static native String nativeGetCurEnvProxyDomain();

    private static native int nativeGetCurEnvProxySDKAppId();

    private static native int nativeSetGlobalEnv(String var0);

    private static native int nativeSetSocks5Proxy(String var0, int var1, String var2, String var3);

    public static final String getDeviceInfo() {
        try {
            return TXCBuild.Brand() + "_" + TXCBuild.Model() + "_" + TXCBuild.Version();
        }
        catch (Exception exception) {
            return "unknown_device";
        }
    }

    public static ClassLoader getClassLoader() {
        return TXCCommonUtil.class.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzip(String zipFilePath, String unzipPath) {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            fileInputStream = new FileInputStream(zipFilePath);
            zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File file = new File(unzipPath, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                d.a((InputStream)zipInputStream, file.getAbsolutePath());
                zipInputStream.closeEntry();
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                TXCLog.e(TAG, "unzip " + zipFilePath + " failed.", throwable);
            }
            catch (Throwable throwable2) {
                d.a(fileInputStream);
                d.a(zipInputStream);
                throw throwable2;
            }
            d.a(fileInputStream);
            d.a(zipInputStream);
        }
        d.a(fileInputStream);
        d.a(zipInputStream);
        return bl;
    }

    public static Map<String, String> getExtIDMap() {
        return mExtIDMap;
    }

    public static boolean setExtID(String extKey, String extValue) {
        TXCLog.i(TAG, "setExtID: [" + extKey + " : " + extValue + "]");
        String[] stringArray = new String[]{"businessId", "buildModel", "buildBrand", "buildManufacturer", "buildHardware", "buildVersion", "buildVersionRelease", "buildVersionInt", "buildVersionSDKInt", "buildVersionIncremental", "buildBoard"};
        if (!Arrays.asList(stringArray).contains(extKey)) {
            return false;
        }
        if (extKey.equals("buildModel")) {
            TXCBuild.SetModel(extValue);
            return true;
        }
        if (extKey.equals("buildBrand")) {
            TXCBuild.SetBrand(extValue);
            return true;
        }
        if (extKey.equals("buildManufacturer")) {
            TXCBuild.SetManufacturer(extValue);
            return true;
        }
        if (extKey.equals("buildHardware")) {
            TXCBuild.SetHardware(extValue);
            return true;
        }
        if (extKey.equals("buildVersion") || extKey.equals("buildVersionRelease")) {
            TXCBuild.SetVersion(extValue);
            return true;
        }
        if (extKey.equals("buildVersionIncremental")) {
            TXCBuild.SetVersionIncremental(extValue);
            return true;
        }
        if (extKey.equals("buildVersionInt") || extKey.equals("buildVersionSDKInt")) {
            try {
                TXCBuild.SetVersionInt(Integer.parseInt(extValue));
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        if (extKey.equals("buildBoard")) {
            TXCBuild.SetBoard(extValue);
            return true;
        }
        if (mExtIDMap == null) {
            mExtIDMap = new ConcurrentHashMap<String, String>();
        }
        mExtIDMap.put(extKey, extValue);
        return true;
    }

    public static boolean equalURL(String url1, String url2) {
        try {
            if (TextUtils.equals((CharSequence)url1, (CharSequence)url2) || TextUtils.equals((CharSequence)URLDecoder.decode(url1, "UTF-8"), (CharSequence)url2) || TextUtils.equals((CharSequence)url1, (CharSequence)URLDecoder.decode(url2, "UTF-8"))) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    static {
        h.d();
    }
}

