/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.renderer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.FrameLayout;

public class TXCFocusIndicatorView
extends View {
    private Paint mPaint;
    private int mSize = 0;
    private int mFocusAreaStroke = 2;
    private ScaleAnimation mScaleAnimation;
    private static final int FOCUS_AREA_STROKE = 1;
    private Runnable mHideRunnable = new Runnable(){

        @Override
        public void run() {
            TXCFocusIndicatorView.this.setVisibility(8);
        }
    };

    public TXCFocusIndicatorView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public TXCFocusIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public TXCFocusIndicatorView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        this.mPaint = new Paint();
        this.mFocusAreaStroke = (int)(1.0f * this.getContext().getResources().getDisplayMetrics().density + 0.5f);
        this.mScaleAnimation = new ScaleAnimation(1.3f, 1.0f, 1.3f, 1.0f, 1, 0.5f, 1, 0.5f);
        this.mScaleAnimation.setDuration(200L);
    }

    public void show(int left, int right, int size) {
        this.removeCallbacks(this.mHideRunnable);
        this.mScaleAnimation.cancel();
        this.mSize = size;
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.getLayoutParams();
        layoutParams.setMargins(left, right, 0, 0);
        layoutParams.width = this.mSize;
        layoutParams.height = this.mSize;
        this.setVisibility(0);
        this.requestLayout();
        this.mScaleAnimation.reset();
        this.startAnimation((Animation)this.mScaleAnimation);
        this.postDelayed(this.mHideRunnable, 1000L);
    }

    protected void onDraw(Canvas canvas) {
        canvas.save();
        int n2 = this.mFocusAreaStroke / 2;
        Rect rect = new Rect(n2, n2, this.mSize - n2, this.mSize - n2);
        this.mPaint.setColor(-1);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)(n2 * 2));
        canvas.drawRect(rect, this.mPaint);
        canvas.restore();
        super.onDraw(canvas);
    }
}

