/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.live2.impl;

import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.f;
import com.tencent.liteav.basic.util.h;
import com.tencent.liteav.p;
import com.tencent.live2.V2TXLiveDef;
import com.tencent.live2.V2TXLivePlayer;
import com.tencent.live2.V2TXLivePlayerObserver;
import com.tencent.live2.a.a;
import com.tencent.live2.impl.V2TXLiveUtils;
import com.tencent.live2.impl.a;
import com.tencent.rtmp.ui.TXCloudVideoView;
import java.util.HashMap;
import java.util.Map;

public class V2TXLivePlayerImpl
extends V2TXLivePlayer {
    private static final String TAG = "V2-TXLivePlayerImpl";
    private a.b mAsyncState = a.b.a;
    private f mMainHandler = new f(Looper.getMainLooper());
    private Context mContext;
    private V2TXLivePlayer mInnerPlayer;
    private V2TXLivePlayerObserver mPlayerObserver;
    private Object mView;
    private V2TXLiveDef.V2TXLiveRotation mRenderRotation;
    private V2TXLiveDef.V2TXLiveFillMode mRenderFillMode;
    private V2TXLiveDef.V2TXLivePixelFormat mPixelFormat;
    private V2TXLiveDef.V2TXLiveBufferType mBufferType;
    private boolean mEnableCustomRendering;
    private boolean mIsPauseAudio;
    private boolean mIsPauseVideo;
    private float mCacheMinTime;
    private float mCacheMaxTime;
    private int mVolumeIntervals = -1;
    private int mPlayoutVolume = -1;
    private boolean mEnableDebugView;
    private int mSEIPayLoadType;
    private boolean mEnableReceiveSEI;
    private HashMap<String, Object> mPropertyMap;
    private Surface mSurface;
    private a.a mSurfaceSize;

    private void setupParams() {
        V2TXLivePlayer v2TXLivePlayer = this.mInnerPlayer;
        if (v2TXLivePlayer == null) {
            return;
        }
        v2TXLivePlayer.setObserver(this.mPlayerObserver);
        v2TXLivePlayer.enableObserveVideoFrame(this.mEnableCustomRendering, this.mPixelFormat, this.mBufferType);
        v2TXLivePlayer.enableReceiveSeiMessage(this.mEnableReceiveSEI, this.mSEIPayLoadType);
        if (this.mView != null) {
            if (this.mView instanceof TXCloudVideoView) {
                v2TXLivePlayer.setRenderView((TXCloudVideoView)((Object)this.mView));
            } else if (this.mView instanceof TextureView) {
                v2TXLivePlayer.setRenderView((TextureView)this.mView);
            } else if (this.mView instanceof SurfaceView) {
                v2TXLivePlayer.setRenderView((SurfaceView)this.mView);
            }
        }
        if (this.mRenderFillMode != null) {
            v2TXLivePlayer.setRenderFillMode(this.mRenderFillMode);
        }
        if (this.mRenderRotation != null) {
            v2TXLivePlayer.setRenderRotation(this.mRenderRotation);
        }
        if (this.mIsPauseAudio) {
            v2TXLivePlayer.pauseAudio();
        } else {
            v2TXLivePlayer.resumeAudio();
        }
        if (this.mIsPauseVideo) {
            v2TXLivePlayer.pauseVideo();
        } else {
            v2TXLivePlayer.resumeVideo();
        }
        if (this.mCacheMinTime > 0.0f && this.mCacheMaxTime > 0.0f) {
            v2TXLivePlayer.setCacheParams(this.mCacheMinTime, this.mCacheMaxTime);
        }
        if (this.mPlayoutVolume > 0) {
            v2TXLivePlayer.setPlayoutVolume(this.mPlayoutVolume);
        }
        if (this.mVolumeIntervals > 0) {
            v2TXLivePlayer.enableVolumeEvaluation(this.mVolumeIntervals);
        }
        v2TXLivePlayer.showDebugView(this.mEnableDebugView);
        if (this.mSurface != null) {
            v2TXLivePlayer.setProperty("setSurface", this.mSurface);
        }
        if (this.mSurfaceSize != null) {
            v2TXLivePlayer.setProperty("setSurfaceSize", this.mSurfaceSize);
        }
        for (Map.Entry<String, Object> entry : this.mPropertyMap.entrySet()) {
            this.mInnerPlayer.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private void runOnMainThreadAsync(Runnable runnable) {
        this.mMainHandler.post(runnable);
    }

    public V2TXLivePlayerImpl(Context context) {
        this.apiLog("create: context-" + context);
        this.mContext = context.getApplicationContext();
        this.mPropertyMap = new HashMap();
    }

    @Override
    public void setObserver(final V2TXLivePlayerObserver observer) {
        this.apiLog("setObserver: observer-" + observer);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mPlayerObserver = observer;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.setObserver(observer);
                }
            }
        });
    }

    @Override
    public int setProperty(final String key, final Object value) {
        this.apiLog("setProperty: key-" + key + " value-" + value);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                switch (key) {
                    case "setSurface": {
                        if (value == null) {
                            V2TXLivePlayerImpl.this.mSurface = null;
                            break;
                        }
                        if (!(value instanceof Surface)) break;
                        V2TXLivePlayerImpl.this.mSurface = (Surface)value;
                        break;
                    }
                    case "setSurfaceSize": {
                        if (value == null) {
                            V2TXLivePlayerImpl.this.mSurfaceSize = null;
                            break;
                        }
                        if (!(value instanceof a.a)) break;
                        V2TXLivePlayerImpl.this.mSurfaceSize = (a.a)value;
                        break;
                    }
                    case "setPlayURLType": 
                    case "enableRecvSEIMessage": 
                    case "setLEBEnvironment": 
                    case "setFramework": {
                        V2TXLivePlayerImpl.this.mPropertyMap.put(key, value);
                    }
                }
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.setProperty(key, value);
                }
            }
        });
        return 0;
    }

    @Override
    public int enableReceiveSeiMessage(final boolean enable, final int payloadType) {
        this.apiLog("enableReceiveSeiMessage: enable-" + enable + ", payloadType-" + payloadType);
        if (payloadType != 5 && payloadType != 242) {
            this.apiError("enableReceiveSeiMessage payloadType invalid " + payloadType);
            return -2;
        }
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mEnableReceiveSEI = enable;
                V2TXLivePlayerImpl.this.mSEIPayLoadType = payloadType;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.enableReceiveSeiMessage(enable, payloadType);
                }
            }
        });
        return 0;
    }

    @Override
    public int setRenderView(final TXCloudVideoView view) {
        this.apiLog("setTXCloudVideoView: view-" + (view != null ? ((Object)((Object)view)).hashCode() + "" : "null"));
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mView = (Object)view;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.setRenderView(view);
                }
            }
        });
        return 0;
    }

    @Override
    public int setRenderView(final TextureView view) {
        this.apiLog("setTextureView: view-" + (view != null ? view.hashCode() + "" : "null"));
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mView = view;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.setRenderView(view);
                }
            }
        });
        return 0;
    }

    @Override
    public int setRenderView(final SurfaceView view) {
        this.apiLog("setSurfaceView: view-" + (view != null ? view.hashCode() + "" : "null"));
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mView = view;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.setRenderView(view);
                }
            }
        });
        return 0;
    }

    @Override
    public int setRenderRotation(final V2TXLiveDef.V2TXLiveRotation rotation) {
        this.apiLog("setRenderRotation: rotation-" + (Object)((Object)rotation));
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mRenderRotation = rotation;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.setRenderRotation(rotation);
                }
            }
        });
        return 0;
    }

    @Override
    public int setRenderFillMode(final V2TXLiveDef.V2TXLiveFillMode mode) {
        this.apiLog("setRenderFillMode: mode-" + (Object)((Object)mode));
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mRenderFillMode = mode;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.setRenderFillMode(mode);
                }
            }
        });
        return 0;
    }

    @Override
    public int startPlay(final String url) {
        int n2;
        this.apiLog("startPlay url:" + url);
        if (TextUtils.isEmpty((CharSequence)url)) {
            TXCLog.e(TAG, "start play fail, url invalid:" + url);
            return -2;
        }
        final a.c c2 = V2TXLiveUtils.parsePlayerType(url);
        if (c2 == a.c.b || c2 == a.c.a) {
            boolean bl = p.b(url);
            if (!bl) {
                this.apiError("start play fail. invalid param. [url:" + url + "]");
                return -2;
            }
        } else if (c2 != a.c.d && (n2 = a.a(url)) != 0) {
            return n2;
        }
        this.mAsyncState = a.b.b;
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null && V2TXLivePlayerImpl.this.mInnerPlayer.isPlaying() == 1) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.stopPlay();
                }
                V2TXLivePlayerImpl.this.mInnerPlayer = p.a(V2TXLivePlayerImpl.this.mContext, V2TXLivePlayerImpl.this, c2);
                V2TXLivePlayerImpl.this.setupParams();
                V2TXLivePlayerImpl.this.mInnerPlayer.startPlay(url);
                V2TXLivePlayerImpl.this.mAsyncState = a.b.a;
            }
        });
        return 0;
    }

    @Override
    public int stopPlay() {
        this.apiLog("stopPlay");
        this.mAsyncState = a.b.c;
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mAsyncState = a.b.a;
                    V2TXLivePlayerImpl.this.mInnerPlayer.stopPlay();
                    V2TXLivePlayerImpl.this.mInnerPlayer = null;
                }
            }
        });
        return 0;
    }

    @Override
    public int isPlaying() {
        if (this.mAsyncState == a.b.a) {
            return this.mInnerPlayer != null ? this.mInnerPlayer.isPlaying() : 0;
        }
        if (this.mAsyncState == a.b.b) {
            return 1;
        }
        if (this.mAsyncState == a.b.c) {
            return 0;
        }
        return 0;
    }

    @Override
    public int pauseAudio() {
        this.apiLog("pauseAudio: ");
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mIsPauseAudio = true;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.pauseAudio();
                }
            }
        });
        return 0;
    }

    @Override
    public int resumeAudio() {
        this.apiLog("resumeAudio: ");
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mIsPauseAudio = false;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.resumeAudio();
                }
            }
        });
        return 0;
    }

    @Override
    public int pauseVideo() {
        this.apiLog("pauseVideo: ");
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mIsPauseVideo = true;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.pauseVideo();
                }
            }
        });
        return 0;
    }

    @Override
    public int resumeVideo() {
        this.apiLog("resumeVideo: ");
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mIsPauseVideo = false;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.resumeVideo();
                }
            }
        });
        return 0;
    }

    @Override
    public int setPlayoutVolume(final int volume) {
        this.apiLog("setPlayoutVolume: volume-" + volume);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mPlayoutVolume = volume;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.setPlayoutVolume(volume);
                }
            }
        });
        return 0;
    }

    @Override
    public int setCacheParams(final float minTime, final float maxTime) {
        this.apiLog("setCacheParams: minTime-" + minTime + " maxTime-" + maxTime);
        if (minTime <= 0.0f || maxTime <= 0.0f) {
            this.apiError("set cache param failed, invalid cache params.");
            return -2;
        }
        if (this.isPlaying() == 1) {
            this.apiError("set cache param failed, cant's set param when playing.");
            return -3;
        }
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mCacheMaxTime = maxTime;
                V2TXLivePlayerImpl.this.mCacheMinTime = minTime;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.setCacheParams(minTime, maxTime);
                }
            }
        });
        return 0;
    }

    @Override
    public int enableVolumeEvaluation(final int intervalMs) {
        this.apiLog("enableVolumeEvaluation: intervalMs-" + intervalMs);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mVolumeIntervals = intervalMs;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.enableVolumeEvaluation(intervalMs);
                }
            }
        });
        return 0;
    }

    @Override
    public int snapshot() {
        if (this.isPlaying() == 0) {
            this.apiError("snapshot: snapshot is not allowed before the player starts playing.");
            return -3;
        }
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.snapshot();
                }
            }
        });
        return 0;
    }

    @Override
    public int enableObserveVideoFrame(final boolean enable, final V2TXLiveDef.V2TXLivePixelFormat pixelFormat, final V2TXLiveDef.V2TXLiveBufferType bufferType) {
        this.apiLog("enableCustomRendering: enable-" + enable + " pixelFormat-" + (Object)((Object)pixelFormat) + " bufferType-" + (Object)((Object)bufferType));
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mEnableCustomRendering = enable;
                V2TXLivePlayerImpl.this.mPixelFormat = pixelFormat;
                V2TXLivePlayerImpl.this.mBufferType = bufferType;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.enableObserveVideoFrame(enable, pixelFormat, bufferType);
                }
            }
        });
        return 0;
    }

    @Override
    public void showDebugView(final boolean enable) {
        this.apiLog("showDebugView: enable-" + enable);
        this.runOnMainThreadAsync(new Runnable(){

            @Override
            public void run() {
                V2TXLivePlayerImpl.this.mEnableDebugView = enable;
                if (V2TXLivePlayerImpl.this.mInnerPlayer != null) {
                    V2TXLivePlayerImpl.this.mInnerPlayer.showDebugView(enable);
                }
            }
        });
    }

    private void apiLog(String msg) {
        TXCLog.i(TAG, "v2_api_player(" + this.hashCode() + ") " + msg);
    }

    private void apiError(String msg) {
        TXCLog.e(TAG, "v2_api_player(" + this.hashCode() + ") " + msg);
    }

    static {
        h.d();
    }
}

