/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.live2.leb;

import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.videobase.e.b;
import com.tencent.liteav.videobase.e.c;
import com.tencent.liteav.videobase.e.d;
import java.util.HashMap;

public class TXLEBPlayerJNI {
    private static final String TAG = "TXLEBPlayerJNI";
    public static final int NET_STATE_CONNECTING = 0;
    public static final int NET_STATE_CONNECTED = 1;
    public static final int NET_STATE_DISCONNECTED = 2;
    public static final int NET_STATE_CONNECT_FAILED = 3;
    public static final String ENVIRONMENT_DEFAULT = "default";
    public static final String ENVIRONMENT_GDPR = "GDPR";
    public static final String ENVIRONMENT_CN = "CN";
    private String mUserId;
    private String mEnvironment = "default";
    private boolean mEnableReceiveVideo = true;
    private boolean mEnableReceiveAudio = true;
    private boolean mEnableEncryption;
    private boolean mEnableAAC = true;
    private boolean mEnableH265;
    private boolean mEnableFlexFec;
    private int mSEIPayLoadType = 0;
    private boolean mEnableReceiveSEI = false;
    private Callback mCallback;
    private long mNativeHandle = 0L;

    protected void setUserId(String uid) {
        this.mUserId = uid;
    }

    protected void enableReceiveVideo(boolean enable) {
        this.mEnableReceiveVideo = enable;
    }

    protected void enableReceiveAudio(boolean enable) {
        this.mEnableReceiveAudio = enable;
    }

    protected void enableEncryption(boolean enable) {
        this.mEnableEncryption = enable;
    }

    protected void enableAAC(boolean enable) {
        this.mEnableAAC = enable;
    }

    protected void enableH265(boolean enable) {
        this.mEnableH265 = enable;
    }

    protected void enableFlexFec(boolean enable) {
        this.mEnableFlexFec = enable;
    }

    protected void enableReceiveSeiMessage(boolean enable, int payloadType) {
        this.mSEIPayLoadType = payloadType;
        this.mEnableReceiveSEI = enable;
        if (this.mNativeHandle != 0L) {
            this.nativeEnableReceiveSeiMessage(this.mNativeHandle, enable, payloadType);
        }
    }

    protected void setLEBEnvironment(String env) {
        this.mEnvironment = env;
    }

    public void start(String url) {
        this.apiLog("start: " + url);
        if (this.mNativeHandle != 0L) {
            return;
        }
        Configuration configuration = new Configuration();
        configuration.url = url;
        configuration.enableReceiveVideo = this.mEnableReceiveVideo;
        configuration.enableReceiveAudio = this.mEnableReceiveAudio;
        configuration.enableEncryption = this.mEnableEncryption;
        configuration.enableAAC = this.mEnableAAC;
        configuration.enableH265 = this.mEnableH265;
        configuration.enableFlexFec = this.mEnableFlexFec;
        configuration.enableReceiveSeiMessage = this.mEnableReceiveSEI;
        configuration.seiPayloadType = this.mSEIPayLoadType;
        configuration.environment = this.mEnvironment;
        switch (this.mEnvironment) {
            case "default": {
                configuration.environment = ENVIRONMENT_DEFAULT;
                break;
            }
            case "GDPR": {
                configuration.environment = ENVIRONMENT_GDPR;
                break;
            }
            case "CN": {
                configuration.environment = ENVIRONMENT_CN;
            }
        }
        this.mNativeHandle = this.nativeStart(this.mUserId, configuration);
    }

    public void notifyRenderFramePTS(long pts) {
        this.nativeNotifyRenderFramePTS(this.mNativeHandle, pts);
    }

    public void requestUpdateStatistics() {
        this.nativeRequestUpdateStatistics(this.mNativeHandle);
    }

    public void stop() {
        this.apiLog("stop");
        this.nativeStop(this.mNativeHandle);
        this.mNativeHandle = 0L;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    private void onReceiveVideoFrame(byte[] data, long pts, long dts, boolean isH265) {
        Callback callback = this.mCallback;
        if (callback == null) {
            return;
        }
        b b2 = new b();
        b2.a = data;
        b2.e = dts;
        b2.f = pts;
        b2.c = isH265 ? d.i : d.b;
        b2.b = c.a;
        callback.onEncodedVideo(b2);
    }

    private void onError(int error) {
        this.apiError("onError: " + error);
        Callback callback = this.mCallback;
        if (callback == null) {
            return;
        }
        callback.onError(error);
    }

    private void onNetState(int state, HashMap<String, String> map) {
        this.apiLog("onNetState: " + state);
        Callback callback = this.mCallback;
        if (callback == null) {
            return;
        }
        callback.onNetState(state, map);
    }

    private void onReceiveSEIMessage(byte[] data) {
        Callback callback = this.mCallback;
        if (callback == null) {
            return;
        }
        callback.onReceiveSEIMessage(data);
    }

    private int onRequestVideoDecodeCacheNum() {
        Callback callback = this.mCallback;
        if (callback == null) {
            return 0;
        }
        return callback.onRequestVideoDecodeCacheNum();
    }

    private void onSetHWDecoderMaxCache(int maxCacheForHighRes, int maxCahceForLowRes) {
        Callback callback = this.mCallback;
        if (callback == null) {
            return;
        }
        callback.onSetHWDecoderMaxCache(maxCacheForHighRes, maxCahceForLowRes);
    }

    private void OnNotifyVideoBlockBegin() {
        Callback callback = this.mCallback;
        if (callback == null) {
            return;
        }
        callback.OnNotifyVideoBlockBegin();
    }

    private void OnNotifyVideoBlockEnd() {
        Callback callback = this.mCallback;
        if (callback == null) {
            return;
        }
        callback.OnNotifyVideoBlockEnd();
    }

    private native long nativeStart(String var1, Configuration var2);

    private native void nativeRequestUpdateStatistics(long var1);

    private native void nativeStop(long var1);

    private native void nativeNotifyRenderFramePTS(long var1, long var3);

    private native void nativeEnableReceiveSeiMessage(long var1, boolean var3, int var4);

    private void apiLog(String log) {
        TXCLog.i(TAG, "v2_api_leb_player_jni(" + this + ") " + log);
    }

    private void apiError(String log) {
        TXCLog.e(TAG, "v2_api_leb_player_jni(" + this + ") " + log);
    }

    private void apiWarn(String log) {
        TXCLog.w(TAG, "v2_api_leb_player_jni(" + this + ") " + log);
    }

    public static final class Configuration {
        String url;
        String environment;
        boolean enableReceiveVideo = true;
        boolean enableReceiveAudio = true;
        boolean enableEncryption;
        boolean enableAAC = true;
        boolean enableH265;
        boolean enableFlexFec;
        boolean enableReceiveSeiMessage;
        int seiPayloadType;
    }

    public static interface Callback {
        public void onEncodedVideo(b var1);

        public void onError(int var1);

        public void onNetState(int var1, HashMap<String, String> var2);

        public int onRequestVideoDecodeCacheNum();

        public void onSetHWDecoderMaxCache(int var1, int var2);

        public void onReceiveSEIMessage(byte[] var1);

        public void OnNotifyVideoBlockBegin();

        public void OnNotifyVideoBlockEnd();
    }
}

